/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import java.util.Arrays;
import java.util.Map;

public class CountRegressionMCVSSetting {
    String[] predictorFields = null;
    String[] weightFields = null;
    boolean countOnce = true;
    boolean combine = true;
    public int unitLenThreshold;
    public int[] lengthInRegion;
    public float overlappedProportion;
    public float pValueInRegion;
    public int unitSizeThreshold;
    public int[] variantInRegion;
    public boolean scanBySize;
    String adjustMethod;

    public String[] getPredictorFields() {
        return this.predictorFields;
    }

    public String[] getWeightFields() {
        return this.weightFields;
    }

    public boolean isCountOnce() {
        return this.countOnce;
    }

    public CountRegressionMCVSSetting(String[] predictorFields, String[] weightFields, boolean combine, boolean countOnce, int unitLenThreshold, int[] lengthInRegion, float overlappedProportion, float pValueInRegion, int unitSizeThreshold, int[] variantInRegion, boolean scanBySize, String adjustMethod) {
        this.predictorFields = predictorFields;
        this.weightFields = weightFields;
        this.countOnce = countOnce;
        this.combine = combine;
        this.unitLenThreshold = unitLenThreshold;
        this.lengthInRegion = lengthInRegion;
        this.overlappedProportion = overlappedProportion;
        this.pValueInRegion = pValueInRegion;
        this.unitSizeThreshold = unitSizeThreshold;
        this.variantInRegion = variantInRegion;
        this.scanBySize = scanBySize;
        this.adjustMethod = adjustMethod;
    }

    public String getAdjustMethod() {
        return this.adjustMethod;
    }

    public String toString() {
        return "Value{predictor=" + Arrays.toString(this.predictorFields) + ", weight=" + Arrays.toString(this.weightFields) + ", combine=" + (this.combine ? "y" : "n") + ", countOnce=" + (this.countOnce ? "y" : "n") + ", lengthThreshold=" + this.unitLenThreshold + ", scanRegionLength=" + Arrays.toString(this.lengthInRegion) + ", variantSizeThreshold=" + this.unitSizeThreshold + ", scanRegionSize=" + Arrays.toString(this.variantInRegion) + ", pValueInRegion=" + this.pValueInRegion + ", overlappedProportion=" + this.overlappedProportion + ", adjustMethod=" + this.adjustMethod + '}';
    }

    public static class Converter
    implements IDynamicConverter<CountRegressionMCVSSetting> {
        @Override
        public CountRegressionMCVSSetting convert(String name, Map<String, String> options) {
            int i;
            String correctFormat = "Positional argument of --mcvs follows keyword argument: <field1>,<field2> [weight=<field3>,<field4>][adjustMethod=predict/subtract] [combine=y/n][countOnce=y/n]";
            String[] predictorFieldNames = null;
            String[] weightFieldNames = null;
            boolean removeDupSub = true;
            boolean composite = true;
            String adjustMethodName = "cut";
            String predictorFieldOption = options.get("predictor");
            String weightFieldOption = options.get("weight");
            String countOnceOption = options.get("countOnce");
            String compositeOption = options.get("combine");
            String adjustMethodOption = options.get("adjustMethod");
            int unitLenThreshold = 10000;
            int[] lengthInRegion = new int[]{1500, 2000, 2500, 3000};
            float overlappedProportion = 0.6f;
            float pValueInRegion = 0.25f;
            int unitSizeThreshold = 50;
            int[] variantInRegion = new int[]{10, 20, 30, 40, 50};
            boolean scanBySize = true;
            String[] tmp = null;
            String unitLenThresholdOption = options.get("lengthThreshold");
            String lengthInRegionOption = options.get("scanRegionLength");
            String overlappedProportionOption = options.get("overlappedProportion");
            String pValueInRegionOption = options.get("pValueInRegion");
            String unitSizeThresholdOption = options.get("sizeThreshold");
            String variantInRegionOption = options.get("scanRegionSize");
            String scanBySizeOption = options.get("scanBySize");
            if (predictorFieldOption != null) {
                predictorFieldNames = predictorFieldOption.trim().length() == 0 ? new String[]{} : predictorFieldOption.split(",");
            }
            if (weightFieldOption != null) {
                weightFieldNames = weightFieldOption.trim().length() == 0 ? new String[]{} : weightFieldOption.split(",");
            }
            if (adjustMethodOption != null) {
                adjustMethodName = adjustMethodOption;
            }
            if (unitLenThresholdOption != null) {
                unitLenThreshold = Integer.parseInt(unitLenThresholdOption);
            }
            if (lengthInRegionOption != null) {
                if (lengthInRegionOption.trim().length() != 0) {
                    tmp = lengthInRegionOption.split(",");
                }
                if (tmp != null) {
                    lengthInRegion = new int[tmp.length];
                    for (i = 0; i < tmp.length; ++i) {
                        lengthInRegion[i] = Integer.parseInt(tmp[i]);
                    }
                }
            }
            if (variantInRegionOption != null) {
                if (variantInRegionOption.trim().length() != 0) {
                    tmp = variantInRegionOption.split(",");
                }
                if (tmp != null) {
                    variantInRegion = new int[tmp.length];
                    for (i = 0; i < tmp.length; ++i) {
                        variantInRegion[i] = Integer.parseInt(tmp[i]);
                    }
                }
            }
            if (pValueInRegionOption != null) {
                pValueInRegion = Float.parseFloat(pValueInRegionOption);
            }
            if (overlappedProportionOption != null) {
                overlappedProportion = Float.parseFloat(overlappedProportionOption);
            }
            if (unitSizeThresholdOption != null) {
                unitSizeThreshold = Integer.parseInt(unitSizeThresholdOption);
            }
            if (countOnceOption != null && countOnceOption.toUpperCase().startsWith("Y")) {
                removeDupSub = true;
                countOnceOption = countOnceOption.toUpperCase();
            } else if (countOnceOption != null && countOnceOption.toUpperCase().startsWith("N")) {
                removeDupSub = false;
                countOnceOption = countOnceOption.toUpperCase();
            }
            if (compositeOption != null && compositeOption.toUpperCase().startsWith("Y")) {
                composite = true;
                compositeOption = compositeOption.toUpperCase();
            } else if (compositeOption != null && compositeOption.toUpperCase().startsWith("N")) {
                composite = false;
                compositeOption = compositeOption.toUpperCase();
            }
            if (scanBySizeOption != null && scanBySizeOption.toUpperCase().startsWith("Y")) {
                scanBySize = true;
                scanBySizeOption = scanBySizeOption.toUpperCase();
            } else if (scanBySizeOption != null && scanBySizeOption.toUpperCase().startsWith("N")) {
                scanBySize = false;
                scanBySizeOption = scanBySizeOption.toUpperCase();
            }
            if (predictorFieldNames == null) {
                throw new ParameterException(correctFormat);
            }
            if (weightFieldNames == null) {
                throw new ParameterException(correctFormat);
            }
            if (!compositeOption.toUpperCase().startsWith("N") && !compositeOption.toUpperCase().startsWith("Y")) {
                throw new ParameterException("Invalid value of " + compositeOption + " for combine of --mcvs");
            }
            if (!countOnceOption.toUpperCase().startsWith("N") && !countOnceOption.toUpperCase().startsWith("Y")) {
                throw new ParameterException("Invalid value of " + countOnceOption + " for combine of --mcvs");
            }
            if (!scanBySizeOption.toUpperCase().startsWith("N") && !scanBySizeOption.toUpperCase().startsWith("Y")) {
                throw new ParameterException("Invalid value of " + scanBySizeOption + " for combine of --mcvs");
            }
            return new CountRegressionMCVSSetting(predictorFieldNames, weightFieldNames, composite, removeDupSub, unitLenThreshold, lengthInRegion, overlappedProportion, pValueInRegion, unitSizeThreshold, variantInRegion, scanBySize, adjustMethodName);
        }
    }
}

