/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import java.util.Arrays;
import java.util.Map;

public class CountRegressionRunnerSetting {
    String[] predictorFields = null;
    String[] weightFields = null;
    String adjustMethod;
    boolean countOnce = true;
    boolean combine = true;
    boolean controlPredictor = true;
    double freqRatio;

    public String[] getPredictorFields() {
        return this.predictorFields;
    }

    public boolean isCombine() {
        return this.combine;
    }

    public String[] getWeightFields() {
        return this.weightFields;
    }

    public String getAdjustMethod() {
        return this.adjustMethod;
    }

    public boolean isControlPredictor() {
        return this.controlPredictor;
    }

    public double getFreqRatio() {
        return this.freqRatio;
    }

    public boolean isCountOnce() {
        return this.countOnce;
    }

    public CountRegressionRunnerSetting(String[] predictorFields, String[] weightFields, String adjustMethod, boolean combine, boolean countOnce, boolean controlPredictor, double freqRatio) {
        this.predictorFields = predictorFields;
        this.weightFields = weightFields;
        this.adjustMethod = adjustMethod;
        this.countOnce = countOnce;
        this.combine = combine;
        this.controlPredictor = controlPredictor;
        this.freqRatio = freqRatio;
    }

    public String toString() {
        return "Value{predictor=" + Arrays.toString(this.predictorFields) + ", weight=" + Arrays.toString(this.weightFields) + ", adjustMethod=" + this.adjustMethod + ", freqRatio=" + this.freqRatio + ", combineWeight='" + (this.combine ? "y" : "n") + ", countOnce='" + (this.countOnce ? "y" : "n") + '\'' + ", controlPredictor='" + (this.controlPredictor ? "y" : "n") + '\'' + '}';
    }

    public static class Converter
    implements IDynamicConverter<CountRegressionRunnerSetting> {
        @Override
        public CountRegressionRunnerSetting convert(String name, Map<String, String> options) {
            String correctFormat = "Positional argument of --runner follows keyword argument: <field1>,<field2> [weight=<field3>,<field4>][referenceAdjust=full/cut][controlPredictor=y/n] [combineWeight=y/n][countOnce=y/n]";
            String[] predictorFieldNames = null;
            String[] weightFieldNames = null;
            String adjustMethodName = "full";
            boolean removeDupSub = true;
            boolean composite = true;
            boolean controlPredictor = true;
            double freqRatio = 3.0;
            String predictorFieldOption = options.get("predictor");
            String weightFieldOption = options.get("weight");
            String adjustMethodOption = options.get("adjustMethod");
            String countOnceOption = options.get("countOnce");
            String combineWeightOption = options.get("combineWeight");
            String includeControlPredictorOption = options.get("controlPredictor");
            String freqRatioOption = options.get("freqRatio");
            if (predictorFieldOption != null) {
                predictorFieldNames = predictorFieldOption.trim().isEmpty() ? new String[]{} : predictorFieldOption.split(",");
            }
            if (weightFieldOption != null) {
                weightFieldNames = weightFieldOption.trim().isEmpty() ? new String[]{} : weightFieldOption.split(",");
            }
            if (adjustMethodOption != null) {
                adjustMethodName = adjustMethodOption;
            }
            if (freqRatioOption != null) {
                freqRatio = Double.parseDouble(freqRatioOption);
            }
            if (countOnceOption != null && countOnceOption.toUpperCase().startsWith("Y")) {
                countOnceOption = countOnceOption.toUpperCase();
            } else if (countOnceOption != null && countOnceOption.toUpperCase().startsWith("N")) {
                removeDupSub = false;
                countOnceOption = countOnceOption.toUpperCase();
            }
            if (combineWeightOption != null && combineWeightOption.toUpperCase().startsWith("Y")) {
                combineWeightOption = combineWeightOption.toUpperCase();
            } else if (combineWeightOption != null && combineWeightOption.toUpperCase().startsWith("N")) {
                composite = false;
                combineWeightOption = combineWeightOption.toUpperCase();
            }
            if (includeControlPredictorOption != null && includeControlPredictorOption.toUpperCase().startsWith("Y")) {
                includeControlPredictorOption = includeControlPredictorOption.toUpperCase();
            } else if (includeControlPredictorOption != null && includeControlPredictorOption.toUpperCase().startsWith("N")) {
                controlPredictor = false;
                includeControlPredictorOption = includeControlPredictorOption.toUpperCase();
            }
            if (predictorFieldNames == null) {
                throw new ParameterException(correctFormat);
            }
            if (weightFieldNames == null) {
                throw new ParameterException(correctFormat);
            }
            if (!combineWeightOption.toUpperCase().startsWith("N") && !combineWeightOption.toUpperCase().startsWith("Y")) {
                throw new ParameterException("Invalid value of " + combineWeightOption + " for combineWeight of --runner");
            }
            if (!countOnceOption.toUpperCase().startsWith("N") && !countOnceOption.toUpperCase().startsWith("Y")) {
                throw new ParameterException("Invalid value of " + countOnceOption + " for countOnce of --runner");
            }
            if (!includeControlPredictorOption.toUpperCase().startsWith("N") && !includeControlPredictorOption.toUpperCase().startsWith("Y")) {
                throw new ParameterException("Invalid value of " + includeControlPredictorOption + " for controlPredictor of --runner");
            }
            if (!adjustMethodOption.toLowerCase().startsWith("full") && !adjustMethodOption.toLowerCase().startsWith("cut")) {
                throw new ParameterException("Invalid value of " + adjustMethodOption + " for adjustMethod of --runner");
            }
            return new CountRegressionRunnerSetting(predictorFieldNames, weightFieldNames, adjustMethodName, composite, removeDupSub, controlPredictor, freqRatio);
        }
    }
}

