/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.io.file.LiveFile;
import java.util.Arrays;
import java.util.Map;

public class CountRegressioniRunnerSetting {
    String[] predictorFields = null;
    String[] weightFields = null;
    String adjustMethod;
    boolean countOnce = true;
    boolean combine = true;
    LiveFile interactionUnitFile = null;
    double scoreFilterThreshold = 0.0;

    public String[] getPredictorFields() {
        return this.predictorFields;
    }

    public boolean isCombine() {
        return this.combine;
    }

    public String[] getWeightFields() {
        return this.weightFields;
    }

    public String getAdjustMethod() {
        return this.adjustMethod;
    }

    public boolean iscountOnce() {
        return this.countOnce;
    }

    public CountRegressioniRunnerSetting(String[] predictorFields, String[] weightFields, String adjustMethod, boolean combine, boolean countOnce) {
        this.predictorFields = predictorFields;
        this.weightFields = weightFields;
        this.adjustMethod = adjustMethod;
        this.countOnce = countOnce;
        this.combine = combine;
    }

    public String toString() {
        return "Value{predictor=" + Arrays.toString(this.predictorFields) + ", weight=" + Arrays.toString(this.weightFields) + ", adjustMethod=" + this.adjustMethod + ", combine='" + (this.combine ? "y" : "n") + ", countOnce='" + (this.countOnce ? "y" : "n") + '\'' + '}';
    }

    public static class Converter
    implements IDynamicConverter<CountRegressioniRunnerSetting> {
        @Override
        public CountRegressioniRunnerSetting convert(String name, Map<String, String> options) {
            String correctFormat = "Positional argument of --runner follows keyword argument: <field1>,<field2> [weight=<field3>,<field4>][adjustMethod=predict/subtract] [combine=y/n][countOnce=y/n]";
            String[] predictorFieldNames = null;
            String[] weightFieldNames = null;
            String adjustMethodName = "predictor";
            boolean removeDupSub = true;
            boolean composite = true;
            String predictorFieldOption = options.get("predictor");
            String weightFieldOption = options.get("weight");
            String adjustMethodOption = options.get("adjustMethod");
            String countOnceOption = options.get("countOnce");
            String compositeOption = options.get("combine");
            if (predictorFieldOption != null) {
                predictorFieldNames = predictorFieldOption.trim().length() == 0 ? new String[]{} : predictorFieldOption.split(",");
            }
            if (weightFieldOption != null) {
                weightFieldNames = weightFieldOption.trim().length() == 0 ? new String[]{} : weightFieldOption.split(",");
            }
            if (adjustMethodOption != null) {
                adjustMethodName = adjustMethodOption;
            }
            if (countOnceOption != null && countOnceOption.toUpperCase().startsWith("Y")) {
                removeDupSub = true;
                countOnceOption = countOnceOption.toUpperCase();
            }
            if (compositeOption != null && compositeOption.toUpperCase().startsWith("Y")) {
                composite = true;
                compositeOption = compositeOption.toUpperCase();
            }
            if (predictorFieldNames == null) {
                throw new ParameterException(correctFormat);
            }
            if (weightFieldNames == null) {
                throw new ParameterException(correctFormat);
            }
            if (!compositeOption.startsWith("N") && !compositeOption.startsWith("Y")) {
                throw new ParameterException("Invalid value of " + compositeOption + " for combine of --runner");
            }
            if (!countOnceOption.startsWith("N") && !countOnceOption.startsWith("Y")) {
                throw new ParameterException("Invalid value of " + countOnceOption + " for combine of --runner");
            }
            return new CountRegressioniRunnerSetting(predictorFieldNames, weightFieldNames, adjustMethodName, composite, removeDupSub);
        }
    }
}

