/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype.IGenotypeController;
import edu.sysu.pmglab.runtimecompiler.JavaCompiler;
import java.util.Map;
import java.util.function.BiFunction;

public enum CustomGtyFilter implements IDynamicConverter<IGenotypeController>
{
    INSTANCE;


    @Override
    public IGenotypeController convert(String name, Map<String, String> params) {
        boolean passed;
        final String keyword = params.get("keyword");
        final String rule = params.get("rule");
        if (params.get("default").equalsIgnoreCase("RETAIN")) {
            passed = true;
        } else if (params.get("default").equalsIgnoreCase("DISCARD")) {
            passed = false;
        } else {
            throw new ParameterException("Invalid parameter: \"" + name + "\" expects 'RETAIN' or 'DISCARD' for sub-option 'default'");
        }
        return new IGenotypeController(){
            final BiFunction<Bytes, Genotype, Boolean> filter;
            {
                this.filter = JavaCompiler.eval(rule, JavaCompiler.Param.of(keyword, Bytes.class), JavaCompiler.Param.of("genotype", Genotype.class), JavaCompiler.Param.of(Boolean.class));
            }

            @Override
            public String getKeyWord() {
                return keyword;
            }

            @Override
            public boolean execute(Bytes keyword2, Genotype genotype) {
                try {
                    return this.filter.apply(keyword2, genotype);
                }
                catch (Error | Exception e) {
                    return passed;
                }
            }

            public String toString() {
                return rule;
            }
        };
    }
}

