/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.variant.IVariantController;
import edu.sysu.pmglab.runtimecompiler.JavaCompiler;
import java.util.Map;
import java.util.function.Function;

public enum CustomInfoFilter implements IDynamicConverter<IVariantController>
{
    INSTANCE;


    @Override
    public IVariantController convert(String name, Map<String, String> params) {
        boolean passed;
        final String keyword = params.get("keyword");
        final String rule = params.get("rule");
        if (params.get("default").equalsIgnoreCase("RETAIN")) {
            passed = true;
        } else if (params.get("default").equalsIgnoreCase("DISCARD")) {
            passed = false;
        } else {
            throw new ParameterException("Invalid parameter: \"" + name + "\" expects 'RETAIN' or 'DISCARD' for sub-option 'default'");
        }
        return new IVariantController(){
            final Function<Bytes, Boolean> filter;
            {
                this.filter = JavaCompiler.eval(rule, JavaCompiler.Param.of(keyword, Bytes.class), JavaCompiler.Param.of(Boolean.class));
            }

            @Override
            public String getKeyWord() {
                return keyword;
            }

            @Override
            public boolean filter(Variant variant) {
                Map INFO = (Map)variant.getProperty("VCF@INFO");
                try {
                    return INFO == null || this.filter.apply((Bytes)INFO.get(keyword)) != false;
                }
                catch (Error | Exception e) {
                    return passed;
                }
            }

            public String toString() {
                return rule;
            }
        };
    }
}

