/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.annotation.database.DataBaseFactory;
import edu.sysu.pmglab.annotation.database.DatabaseDescription;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.toolkit.annotator.Database;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.kgga.command.setting.AFGRESetting;
import edu.sysu.pmglab.kgga.command.setting.CountRegressionRunnerSetting;
import edu.sysu.pmglab.text.Utility;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public enum DatabaseFieldValidator {
    INSTANCE;


    /*
     * WARNING - void declaration
     */
    public static void checkingMissingFieldsInDatabase(CommandOptions options) throws Exception {
        HashSet<Object> missingFieldSet;
        List databaseDescriptions = (List)options.value("--variant-annotation-database");
        HashSet<String> allFieldSet = new HashSet<String>();
        if (databaseDescriptions != null && !databaseDescriptions.isEmpty()) {
            for (DatabaseDescription databaseDescription : databaseDescriptions) {
                Database<?, Variant> database = DataBaseFactory.instanceOf(databaseDescription);
                IFieldCollection groupMetas = database.getAllFields();
                Iterable<FieldGroupMeta> allFieldGroups = groupMetas.getAllFieldGroups();
                Iterator iterator2 = allFieldGroups.iterator();
                while (iterator2.hasNext()) {
                    FieldGroupMeta fieldGroup = (FieldGroupMeta)iterator2.next();
                    for (FieldMeta field : fieldGroup) {
                        allFieldSet.add(field.fullName());
                    }
                }
            }
        }
        if (options.passed("--afgre")) {
            AFGRESetting afgreOptions = (AFGRESetting)options.value("--afgre");
            String[] scorerWeighting = afgreOptions.fields;
            missingFieldSet = new HashSet<Object>();
            for (String string : scorerWeighting) {
                void var10_20;
                if (DatabaseFieldValidator.countOrSubstring(string, "@") == 2) {
                    int index = string.indexOf("@");
                    String string2 = string.substring(index + 2);
                }
                if (allFieldSet.contains(var10_20)) continue;
                missingFieldSet.add(var10_20);
            }
            if (!missingFieldSet.isEmpty()) {
                throw new ParameterException("The fields " + missingFieldSet + " specified by '--afgre' is unavailable in corresponding database!");
            }
        }
        if (options.getParser().contains("--runner") && options.passed("--runner")) {
            void var10_24;
            String str;
            void var10_22;
            CountRegressionRunnerSetting setting = (CountRegressionRunnerSetting)options.value("--runner");
            String[] scores4Weighting = setting.predictorFields;
            missingFieldSet = new HashSet();
            ArrayList<String> similarFields = new ArrayList<String>();
            String[] stringArray = scores4Weighting;
            int n = stringArray.length;
            boolean bl = false;
            while (var10_22 < n) {
                str = stringArray[var10_22];
                if (!str.isEmpty() && !allFieldSet.contains(str)) {
                    missingFieldSet.add(str);
                    similarFields.addAll(Utility.top3Matches(allFieldSet, str));
                }
                ++var10_22;
            }
            stringArray = scores4Weighting = setting.getWeightFields();
            n = stringArray.length;
            boolean bl2 = false;
            while (var10_24 < n) {
                str = stringArray[var10_24];
                if (!str.isEmpty() && !str.equalsIgnoreCase("@AFGRE")) {
                    if (DatabaseFieldValidator.countOrSubstring(str, "@") == 2) {
                        int index = str.indexOf("@");
                        str = str.substring(index + 2);
                    }
                    if (!allFieldSet.contains(str)) {
                        missingFieldSet.add(str);
                        similarFields.addAll(Utility.top3Matches(allFieldSet, str));
                    }
                }
                ++var10_24;
            }
            if (!missingFieldSet.isEmpty()) {
                throw new ParameterException("The fields " + missingFieldSet + " specified by '--runner' is unavailable in the database!\nThe available similar fields are : " + similarFields);
            }
        }
    }

    public static int countOrSubstring(String source2, String substring) {
        if (source2 == null || substring == null || source2.isEmpty() || substring.isEmpty()) {
            return 0;
        }
        int count = 0;
        int i = source2.indexOf(substring);
        while (i >= 0) {
            ++count;
            i = source2.indexOf(substring, i + substring.length());
        }
        return count;
    }
}

