/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.commandParser.converter.IConverter;
import edu.sysu.pmglab.commandParser.exception.CommandParserException;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.utils.Assert;
import gnu.trove.map.hash.THashMap;
import java.util.Map;

public class DynamicParameter
implements IConverter<Map<String, String>> {
    final Param[] argLists;

    public DynamicParameter(String ... argLists) {
        LinkedSet keywords = new LinkedSet();
        this.argLists = new Param[argLists.length];
        int i = 0;
        for (String arg : argLists) {
            this.argLists[i] = new Param(arg);
            if (!keywords.add(this.argLists[i].keyword)) {
                throw new CommandParserException("duplicate argument '" + this.argLists[i].keyword + "' in function definition");
            }
            if (i >= 1 && this.argLists[i - 1].defaultValue != null && this.argLists[i].defaultValue == null) {
                throw new CommandParserException("non-default argument follows default argument: " + arg);
            }
            ++i;
        }
    }

    @Override
    public Map<String, String> convert(String name, String ... params) {
        boolean containsEquals = false;
        int firstEqualIndex = -1;
        for (int paramIndex = 0; paramIndex < params.length; ++paramIndex) {
            String param = params[paramIndex];
            int index = param.indexOf("=");
            if (index != -1) {
                containsEquals = true;
                if (firstEqualIndex != -1) continue;
                firstEqualIndex = paramIndex;
                continue;
            }
            if (!containsEquals) continue;
            throw new ParameterException("Invalid parameter " + name + ": positional argument follows keyword argument: " + param);
        }
        THashMap<String, String> values2 = new THashMap<String, String>();
        if (firstEqualIndex == -1) {
            int i;
            int l = Math.min(params.length, this.argLists.length);
            for (i = 0; i < l; ++i) {
                values2.put(this.argLists[i].keyword, params[i]);
            }
            if (values2.size() < this.argLists.length) {
                l = this.argLists.length;
                for (i = values2.size(); i < l; ++i) {
                    if (this.argLists[i].defaultValue == null) {
                        throw new ParameterException("Invalid parameter " + name + ": missing required positional argument: '" + this.argLists[i].keyword + "'");
                    }
                    values2.put(this.argLists[i].keyword, this.argLists[i].defaultValue);
                }
            }
            if (values2.size() < params.length) {
                throw new ParameterException("Invalid parameter " + name + ": too many arguments");
            }
        } else if (firstEqualIndex == 0) {
            for (String string : params) {
                int index = string.indexOf("=");
                String keyword = string.substring(0, index);
                if (values2.containsKey(keyword)) {
                    throw new ParameterException("Invalid parameter " + name + ":  keyword argument repeated '" + keyword + "'");
                }
                values2.put(keyword, string.substring(index + 1));
            }
            for (Param param : this.argLists) {
                if (values2.containsKey(param.keyword)) continue;
                if (param.defaultValue == null) {
                    throw new ParameterException("Invalid parameter " + name + ": missing required positional argument '" + param.keyword + "'");
                }
                values2.put(param.keyword, param.defaultValue);
            }
        } else {
            int i;
            if (this.argLists.length < firstEqualIndex) {
                throw new ParameterException("Invalid parameter " + name + ": too many arguments");
            }
            for (i = 0; i < firstEqualIndex; ++i) {
                String param = params[i];
                String keyword = this.argLists[i].keyword;
                if (values2.containsKey(keyword)) {
                    throw new ParameterException("Invalid parameter " + name + ":  keyword argument repeated '" + keyword + "'");
                }
                values2.put(keyword, param);
            }
            for (i = firstEqualIndex; i < params.length; ++i) {
                String param = params[i];
                int index = param.indexOf("=");
                String string = param.substring(0, index);
                if (values2.containsKey(string)) {
                    throw new ParameterException("Invalid parameter " + name + ":  keyword argument repeated '" + string + "'");
                }
                values2.put(string, param.substring(index + 1));
            }
            for (Param param : this.argLists) {
                if (values2.containsKey(param.keyword)) continue;
                if (param.defaultValue == null) {
                    throw new ParameterException("Invalid parameter " + name + ": missing required positional argument '" + param.keyword + "'");
                }
                values2.put(param.keyword, param.defaultValue);
            }
        }
        return values2;
    }

    public static void main(String[] args) {
        DynamicParameter parameter = new DynamicParameter("a", "b", "c", "d=5");
        System.out.println(parameter.convert("test", new String[]{"1", "2", "c=2", "h=2"}));
    }

    static class Param {
        final String keyword;
        final String defaultValue;

        public Param(String arg) {
            Assert.that(arg != null && arg.length() > 0);
            int index = arg.indexOf("=");
            if (index == -1) {
                this.keyword = arg;
                this.defaultValue = null;
            } else {
                this.keyword = arg.substring(0, index);
                this.defaultValue = arg.substring(index + 1);
            }
        }

        public String toString() {
            if (this.defaultValue == null) {
                return this.keyword;
            }
            return this.keyword + "=" + this.defaultValue;
        }
    }
}

