/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.io.file.LiveFile;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

public class GeneSetAssocSetting {
    LiveFile path = null;
    String separator;
    float threshold = 0.5f;
    boolean hasHeader = true;
    String[] weightFields = null;
    boolean combine = true;
    int idIndex = 0;
    int urlIndex = 1;
    int geneStartIndex = 2;

    public boolean isCombine() {
        return this.combine;
    }

    public String[] getWeightFields() {
        return this.weightFields;
    }

    public LiveFile getPath() {
        return this.path;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public GeneSetAssocSetting(LiveFile path, String separator, float threshold, boolean hasHeader, String[] weightFields, boolean combine, int idIndex, int urlIndex, int geneStartIndex) {
        this.path = path;
        this.separator = separator;
        this.threshold = threshold;
        this.hasHeader = hasHeader;
        this.weightFields = weightFields;
        this.combine = combine;
        this.idIndex = idIndex;
        this.urlIndex = urlIndex;
        this.geneStartIndex = geneStartIndex;
    }

    public int getIdIndex() {
        return this.idIndex;
    }

    public int getUrlIndex() {
        return this.urlIndex;
    }

    public int getGeneStartIndex() {
        return this.geneStartIndex;
    }

    public String toString() {
        return "Value{, weight=" + Arrays.toString(this.weightFields) + ", combineWeight='" + (this.combine ? "y" : "n") + ", interaction Unit File=" + this.path + ", score Filter Threshold=" + this.threshold + ", hasHead='" + (this.hasHeader ? "y" : "n") + ", separator='" + this.separator + ", idIndex=" + this.idIndex + ", urlIndex=" + this.urlIndex + ", geneStartIndex=" + this.geneStartIndex + '}';
    }

    public static class Converter
    implements IDynamicConverter<GeneSetAssocSetting> {
        @Override
        public GeneSetAssocSetting convert(String name, Map<String, String> options) {
            String correctFormat = "Positional argument of --gene-set-assoc follows keyword argument: [weight=<field3>,<field4>][combineWeight=y/n]";
            String path = null;
            float threshold = 0.5f;
            boolean hasHeader = true;
            String[] weightFieldNames = null;
            boolean composite = true;
            String weightFieldOption = options.get("weight");
            String combineWeightOption = options.get("combineWeight");
            String fileOption = options.get("file");
            String thresholdOption = options.get("threshold");
            String hasHeaderOption = options.get("hasHead");
            String separator = options.get("sep");
            String idIndexOption = options.get("idIndex");
            int idIndex = Integer.parseInt(idIndexOption);
            int urlIndex = Integer.parseInt(options.get("urlIndex"));
            int geneStartIndex = Integer.parseInt(options.get("geneStartIndex"));
            if (weightFieldOption != null) {
                weightFieldNames = weightFieldOption.trim().isEmpty() ? new String[]{} : weightFieldOption.split(",");
            }
            composite = combineWeightOption != null && combineWeightOption.toUpperCase().startsWith("Y");
            if (thresholdOption != null && !thresholdOption.isEmpty()) {
                if (Float.parseFloat(thresholdOption) >= 1.0f || Float.parseFloat(thresholdOption) <= 0.0f) {
                    throw new ParameterException("The threshold should be between 0 and 1 for --gene-set-assoc.");
                }
                threshold = Float.parseFloat(thresholdOption);
            }
            if (fileOption == null) {
                throw new ParameterException("File should not be null in IRunner");
            }
            Object file = new File(fileOption);
            if (!((File)file).exists() || !((File)file).isFile()) {
                throw new IllegalArgumentException("The file at the given path of --gene-set-assoc does not exist or is not a valid file: " + fileOption);
            }
            path = fileOption;
            if (hasHeaderOption != null && hasHeaderOption.toUpperCase().startsWith("Y")) {
                hasHeaderOption = hasHeaderOption.toUpperCase();
            } else if (hasHeaderOption != null && hasHeaderOption.toUpperCase().startsWith("N")) {
                hasHeader = false;
                hasHeaderOption = hasHeaderOption.toUpperCase();
            }
            if (!(separator.equals("TAB") || separator.equals("COMMA") || separator.equals("SEMICOLON") || separator.equals("BLANK"))) {
                throw new ParameterException("Invalid separator: " + separator + ". Supported separators are TAB, COMMA, SEMICOLON, and BLANK.");
            }
            switch (separator) {
                case "TAB": {
                    separator = "\t";
                    break;
                }
                case "COMMA": {
                    separator = ",";
                    break;
                }
                case "SEMICOLON": {
                    separator = ";";
                    break;
                }
                case "BLANK": {
                    separator = " ";
                }
            }
            if (!hasHeaderOption.toUpperCase().startsWith("N") && !hasHeaderOption.toUpperCase().startsWith("Y")) {
                throw new ParameterException("Invalid value of " + hasHeaderOption + " for combine in --gene-set-assoc");
            }
            try {
                return new GeneSetAssocSetting(LiveFile.of(path), separator, threshold, hasHeader, weightFieldNames, composite, idIndex, urlIndex, geneStartIndex);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

