/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalTree;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.RefGenomeVersion;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.text.reader.CustomSeparator;
import edu.sysu.pmglab.io.text.reader.ISeparator;
import edu.sysu.pmglab.io.text.reader.Separator;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.io.ConsecutiveSeparator;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import edu.sysu.pmglab.kgga.io.InputType;
import gnu.trove.map.hash.THashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;

public class GwasSumFileOption {
    public List<LiveFile> inputFiles;
    public LiveFile tmpActiveInputFile;
    public String[] cp12Cols;
    public String[] pbsCols;
    public String freqA1Col = null;
    public String r2Col = null;
    public String[] r12Cols = null;
    public String[] sampleSizeCols;
    public ISeparator separator = Separator.UNIVERSAL;
    public double genomicControl = Double.NaN;
    public final RefGenomeVersion refG;
    public int betaType = 1;
    public float prevalence = Float.NaN;
    public String missingLabel = ".";
    public Map<Chromosome, IntIntervalTree<Void>> excludedRegions = new THashMap<Chromosome, IntIntervalTree<Void>>();
    public InputType type;

    public GwasSumFileOption(List<LiveFile> inputFiles, InputType type, String[] r12Cols, String[] cp12Cols, String[] pbsCols, RefGenomeVersion refG, String freqA1Col, String r2Col, String[] sampleSizeCols, String missingLabel, ISeparator separator, int betaType, float prevalence, Map<Chromosome, IntIntervalTree<Void>> excludedRegions, double genomicControl) {
        this.inputFiles = inputFiles;
        this.r12Cols = r12Cols;
        this.cp12Cols = cp12Cols;
        this.pbsCols = pbsCols;
        this.refG = refG;
        this.freqA1Col = freqA1Col;
        this.r2Col = r2Col;
        this.sampleSizeCols = sampleSizeCols;
        this.separator = separator;
        this.betaType = betaType;
        this.prevalence = prevalence;
        this.excludedRegions = excludedRegions;
        this.type = type;
        this.genomicControl = genomicControl;
        this.missingLabel = missingLabel;
    }

    public GwasSumFileOption(List<LiveFile> inputFiles, InputType type, String[] r12Cols, String[] pbsStrCols, RefGenomeVersion refG, String freqA1StrCol, String r2Col, String[] sampleSizeStrCols, int betaType, float prevalence, Map<Chromosome, IntIntervalTree<Void>> excludedRegions) {
        this.inputFiles = inputFiles;
        this.pbsCols = pbsStrCols;
        this.r12Cols = r12Cols;
        this.refG = refG;
        this.freqA1Col = this.freqA1Col = freqA1StrCol;
        this.sampleSizeCols = sampleSizeStrCols;
        this.betaType = betaType;
        this.prevalence = prevalence;
        this.excludedRegions = excludedRegions;
        this.type = type;
    }

    public String uniqueCode() {
        StringBuilder sb = new StringBuilder();
        if (this.r12Cols != null) {
            for (String name : this.r12Cols) {
                sb.append(name);
                sb.append(",");
            }
        }
        if (this.cp12Cols != null) {
            for (String name : this.cp12Cols) {
                sb.append(name);
                sb.append(",");
            }
        }
        if (this.pbsCols != null) {
            for (String name : this.pbsCols) {
                sb.append(name);
                sb.append(",");
            }
        }
        if (this.sampleSizeCols != null) {
            for (String name : this.sampleSizeCols) {
                sb.append(name);
                sb.append(",");
            }
        }
        sb.append(this.r2Col);
        sb.append(",");
        sb.append(this.freqA1Col);
        sb.append(",");
        sb.append(this.separator.toString());
        sb.append(",");
        sb.append(this.refG.toString());
        sb.append(",");
        sb.append(this.betaType);
        sb.append(",");
        sb.append(this.prevalence);
        sb.append(",");
        sb.append(this.genomicControl);
        sb.append(",");
        sb.append(this.excludedRegions == null ? "." : this.excludedRegions.toString());
        for (LiveFile liveFile : this.inputFiles) {
            sb.append(liveFile.hashCode());
        }
        return ITrack.digest(sb.toString());
    }

    public boolean equals(Object obj) {
        return this.inputFiles.equals(obj);
    }

    public static class Converter
    implements IDynamicConverter<GwasSumFileOption> {
        @Override
        public GwasSumFileOption convert(String name, Map<String, String> options) {
            String[] r12Cols;
            InputType type;
            RefGenomeVersion refG;
            String filePath = options.get("file");
            String cp12ColsOption = options.get("cp12Cols");
            String r12ColsOption = options.get("r12Cols");
            String pbsColsOption = options.get("pbsCols");
            String sepOption = options.get("sep");
            String freqA1ColOption = options.get("freqA1Col");
            String r2ColOption = options.get("r2Col");
            String sampleSizeColOption = options.get("sampleSizeCols");
            String refGOption = options.get("refG").toLowerCase();
            String betaTypeOption = options.get("betaType");
            String prevalenceOption = options.get("prevalence");
            String excludeOption = options.get("exclude");
            String inputTypeOption = options.get("type").toUpperCase();
            String genomicControlOption = options.get("genomicControl");
            String missingLabelOption = options.get("missingTag");
            switch (refGOption) {
                case "hg18": {
                    refG = RefGenomeVersion.hg18;
                    break;
                }
                case "hg19": {
                    refG = RefGenomeVersion.hg19;
                    break;
                }
                case "hg38": {
                    refG = RefGenomeVersion.hg38;
                    break;
                }
                case "unknown": {
                    refG = RefGenomeVersion.hg38;
                    break;
                }
                default: {
                    throw new ParameterException("Invalid parameter \"" + name + "\": cannot get reference genome from --sum-file " + filePath);
                }
            }
            THashMap<Chromosome, IntIntervalTree<Void>> excludedRegions = null;
            if (excludeOption != null && !excludeOption.trim().isEmpty()) {
                excludedRegions = new THashMap<Chromosome, IntIntervalTree<Void>>();
                THashMap excludedRegionsBuilder = new THashMap();
                CustomSeparator sep1 = new CustomSeparator("{}:{}");
                for (String region : excludeOption.split(";")) {
                    List<Object> results;
                    if (!region.contains(":")) {
                        results = new List();
                        results.add(new Bytes(region));
                        results.add(new Bytes("0~2147483647"));
                    } else {
                        results = sep1.accept(region);
                    }
                    Chromosome chromosome = Chromosome.get(((Bytes)results.get(0)).toString());
                    if (!excludedRegionsBuilder.containsKey(chromosome)) {
                        excludedRegionsBuilder.put(chromosome, new IntIntervalTree.Builder());
                    }
                    for (String posPair : ((Bytes)results.get(1)).toString().split(",")) {
                        if (posPair.contains("~")) {
                            IntInterval interval = (IntInterval)FieldType.intInterval.char2Object(posPair);
                            ((IntIntervalTree.Builder)excludedRegionsBuilder.get(chromosome)).add(interval, null);
                            continue;
                        }
                        int pos = (Integer)FieldType.varInt32.char2Object(posPair);
                        ((IntIntervalTree.Builder)excludedRegionsBuilder.get(chromosome)).add(pos, pos, null);
                    }
                }
                for (Chromosome chromosome : excludedRegionsBuilder.keySet()) {
                    excludedRegions.put(chromosome, ((IntIntervalTree.Builder)excludedRegionsBuilder.get(chromosome)).build());
                }
            }
            int betaType = -1;
            if (betaTypeOption != null && !betaTypeOption.trim().isEmpty()) {
                betaType = Integer.parseInt(betaTypeOption);
                String message = "Specifies the type of effect sizes:\\n\" +\n                                \"0 means coefficients of linear regression for a quantitative phenotype beta;\\n\" +\n                                \"1 means coefficients of logistic regression or the logarithms of odds ratio for a qualitative phenotype;\\n\" +\n                                \"2 means the odds ratio for a binary phenotype\",\n                        format = \"--betaType <0/1/2> ";
                if (betaType < 0 || betaType > 2) {
                    throw new ParameterException(message);
                }
                if (pbsColsOption.toLowerCase().contains(",or") && betaType != 2) {
                    String msg = "It seems your betaType=" + betaType + " does not match the beta name! Please check it.";
                    SetupApplication.GlobalLogger.warn(msg);
                }
            }
            List<LiveFile> inputFiles = new List<LiveFile>();
            Bytes line = InputOutputFileSet.collectFiles(filePath, inputFiles);
            if ("AUTO".equals(inputTypeOption)) {
                if (FileUtils.withExtension(filePath, "gtb")) {
                    type = InputType.GTB;
                } else if (FileUtils.withExtension(filePath, "vcf", "vcf.gz", "vcf.bgz")) {
                    type = InputType.VCF;
                } else {
                    type = InputType.TSV;
                    if (!cp12ColsOption.isEmpty() && !r12ColsOption.isEmpty()) {
                        try {
                            throw new Exception("Error: cp12Cols and r12Cols are mutually exclusive in the --sum-file option for " + filePath + ".");
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (cp12ColsOption.isEmpty() && r12ColsOption.isEmpty()) {
                        try {
                            throw new Exception("Error: cp12Cols or r12Cols should be specified in the --sum-file option for " + filePath + ".");
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            } else {
                try {
                    type = InputType.valueOf(inputTypeOption);
                }
                catch (NoSuchElementException e) {
                    throw new ParameterException("Invalid parameter \"" + name + "\": cannot get file type from " + inputTypeOption);
                }
            }
            GwasSumFileOption fileMeta = null;
            float prevalence = Float.NaN;
            if (prevalenceOption != null && !prevalenceOption.trim().isEmpty()) {
                prevalence = Float.parseFloat(prevalenceOption);
            }
            String[] cp12Cols = cp12ColsOption.isEmpty() ? null : cp12ColsOption.split(",");
            String[] pbsCols = pbsColsOption.split(",");
            String[] stringArray = r12Cols = r12ColsOption.isEmpty() ? null : r12ColsOption.split(",");
            if (pbsCols.length > 1) {
                if (!Float.isNaN(prevalence)) {
                    if (betaType == 0) {
                        String message = "The specified prevalence (" + prevalence + ") indicates that the input GWAS " + filePath + " is a binary trait. But the beta type 0 indicates that it is a quantitative trait!";
                        throw new ParameterException(message);
                    }
                } else if (betaType > 0) {
                    prevalence = 0.01f;
                    String message = "The specified beta-type " + betaType + " indicates that the input GWAS " + filePath + " is a binary trait. The prevalence is set as " + prevalence + " by default, which may effect heritability estimate (if available).";
                    SetupApplication.GlobalLogger.warn(message);
                }
            }
            if (type == InputType.VCF) {
                if (pbsColsOption.isEmpty()) {
                    pbsColsOption = "LP,ES,SE";
                    pbsCols = pbsColsOption.split(",");
                }
                if (sampleSizeColOption.isEmpty()) {
                    sampleSizeColOption = "NC,SS";
                }
                String[] sampleSizeCols = sampleSizeColOption.split(",");
                if (betaType > 0 && sampleSizeCols.length == 1) {
                    throw new ParameterException("The GWAS summary data are for binary phenotype and the sample sizes of both groups are required for heritability estimate!");
                }
                if (freqA1ColOption.isEmpty()) {
                    freqA1ColOption = "AF";
                }
                fileMeta = new GwasSumFileOption(inputFiles, type, null, pbsCols, refG, freqA1ColOption, r2ColOption, sampleSizeCols, betaType, prevalence, excludedRegions);
            } else if (type == InputType.TSV || type == InputType.GTB) {
                int i;
                int j;
                ConsecutiveSeparator separator = new ConsecutiveSeparator(sepOption);
                List<Bytes> cells = separator.accept(line);
                int size = cells.size();
                int[] cp12ColIndexes = null;
                if (type == InputType.TSV) {
                    if (cp12Cols != null) {
                        cp12ColIndexes = new int[cp12Cols.length];
                        Arrays.fill(cp12ColIndexes, -1);
                        for (int j2 = 0; j2 < cp12Cols.length; ++j2) {
                            for (int i2 = 0; i2 < size; ++i2) {
                                if (!cells.fastGet(i2).toString().equals(cp12Cols[j2])) continue;
                                cp12ColIndexes[j2] = i2;
                                break;
                            }
                            if (cp12ColIndexes[j2] >= 0) continue;
                            throw new ParameterException("The \"" + cp12Cols[j2] + "\" does not exist in " + filePath + "!.\nRe-specify the column names of chromosome, positions, effective (alternative, a1) allele, base (reference, a2) allele, in the input GWAS summary file by option by --sum-file cp12Cols=.");
                        }
                    } else if (r12Cols != null) {
                        int[] r12ColIndexes = new int[r12Cols.length];
                        Arrays.fill(r12ColIndexes, -1);
                        for (j = 0; j < r12Cols.length; ++j) {
                            for (i = 0; i < size; ++i) {
                                if (!cells.fastGet(i).toString().equals(r12Cols[j])) continue;
                                r12ColIndexes[j] = i;
                                break;
                            }
                            if (r12ColIndexes[j] >= 0) continue;
                            throw new ParameterException("The \"" + r12Cols[j] + "\" does not exist in " + filePath + "!.\nRe-specify the column names of rsID, effective (alternative, a1) allele, base (reference, a2) allele, in the input GWAS summary file by option by --sum-file r12Cols=.");
                        }
                    }
                }
                int[] pbsColIndexes = new int[pbsCols.length];
                Arrays.fill(pbsColIndexes, -1);
                for (j = 0; j < pbsCols.length; ++j) {
                    for (i = 0; i < size; ++i) {
                        if (!cells.fastGet(i).toString().equals(pbsCols[j])) continue;
                        pbsColIndexes[j] = i;
                        break;
                    }
                    if (pbsColIndexes[j] >= 0) continue;
                    throw new ParameterException("The \"" + pbsCols[j] + "\" does not exist in " + filePath + "!.\nRe-specify the column names of p-values, effect size, standard errors of effect size, in the input GWAS summary file by --sum-file pbsCols=.");
                }
                int freqA1ColIndex = -1;
                if (freqA1ColOption != null && !freqA1ColOption.trim().isEmpty()) {
                    for (i = 0; i < size; ++i) {
                        if (!cells.fastGet(i).toString().equals(freqA1ColOption)) continue;
                        freqA1ColIndex = i;
                        break;
                    }
                    if (freqA1ColIndex < 0) {
                        throw new ParameterException("The \"" + freqA1ColOption + "\" does not exist in " + filePath + "!.");
                    }
                }
                String[] sampleSizeCols = null;
                int[] sampleSizeColIndexes = null;
                if (sampleSizeColOption != null && !sampleSizeColOption.trim().isEmpty()) {
                    sampleSizeCols = sampleSizeColOption.split(",");
                    sampleSizeColIndexes = new int[sampleSizeCols.length];
                    Arrays.fill(sampleSizeColIndexes, -1);
                    for (int j3 = 0; j3 < sampleSizeCols.length; ++j3) {
                        for (int i3 = 0; i3 < size; ++i3) {
                            if (!cells.fastGet(i3).toString().equals(sampleSizeCols[j3])) continue;
                            sampleSizeColIndexes[j3] = i3;
                            break;
                        }
                        if (sampleSizeColIndexes[j3] >= 0) continue;
                        throw new ParameterException("The \"" + sampleSizeCols[j3] + "\" does not exist in " + filePath + "!.");
                    }
                    if (betaType <= 0 || sampleSizeCols.length == 1) {
                        // empty if block
                    }
                }
                double genomicControl = Double.NaN;
                if (genomicControlOption != null && !genomicControlOption.trim().isEmpty()) {
                    genomicControl = Double.parseDouble(genomicControlOption);
                }
                String missingTag = ".";
                if (!missingLabelOption.isEmpty()) {
                    missingTag = missingLabelOption;
                }
                fileMeta = new GwasSumFileOption(inputFiles, type, r12Cols, cp12Cols, pbsCols, refG, freqA1ColOption, r2ColOption, sampleSizeCols, missingTag, separator, betaType, prevalence, excludedRegions, genomicControl);
            }
            return fileMeta;
        }
    }
}

