/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.io.file.LiveFile;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

public class IRunnerCountRegressionSetting {
    String[] predictorFields = null;
    String[] weightFields = null;
    LiveFile interactionUnitFile = null;
    double scoreFilterThreshold = 0.0;
    boolean countOnce = true;
    boolean combine = true;

    public String[] getPredictorFields() {
        return this.predictorFields;
    }

    public String[] getWeightFields() {
        return this.weightFields;
    }

    public LiveFile getInteractionUnitFile() {
        return this.interactionUnitFile;
    }

    public double getScoreFilterThreshold() {
        return this.scoreFilterThreshold;
    }

    public boolean isCountOnce() {
        return this.countOnce;
    }

    public boolean isCombine() {
        return this.combine;
    }

    public IRunnerCountRegressionSetting(String interactionUnitFile, double scoreFilterThreshold, String[] predictorFieldNames, String[] weightFieldNames, boolean countOnce, boolean combine) throws IOException {
        this.interactionUnitFile = LiveFile.of(interactionUnitFile);
        this.scoreFilterThreshold = scoreFilterThreshold;
        this.predictorFields = predictorFieldNames;
        this.weightFields = weightFieldNames;
        this.countOnce = countOnce;
        this.combine = combine;
    }

    public String toString() {
        return "Value{predictor=" + Arrays.toString(this.predictorFields) + ", weight=" + Arrays.toString(this.weightFields) + ", combine='" + (this.combine ? "y" : "n") + '\'' + ", countOnce='" + (this.countOnce ? "y" : "n") + '\'' + ", interaction Unit File=" + this.interactionUnitFile.getPath() + ", score Filter Threshold=" + this.scoreFilterThreshold + '}';
    }

    public static class Converter
    implements IDynamicConverter<IRunnerCountRegressionSetting> {
        @Override
        public IRunnerCountRegressionSetting convert(String name, Map<String, String> options) {
            String correctFormat = "Positional argument of --irunner follows keyword argument: predictor=<field1>,<field2> [weight=<field3>,<field4>] [file=path] [threshold=float] [combine=y/n] [countOnce=y/n]";
            String path = null;
            float threshold = 0.5f;
            String[] predictorFieldNames = null;
            String[] weightFieldNames = null;
            boolean countOnce = true;
            boolean combine = true;
            String fileOption = options.get("interactionUnitFile");
            String thresholdOption = options.get("threshold");
            String predictorFieldOption = options.get("predictor");
            String weightFieldOption = options.get("weight");
            String countOnceOption = options.get("countOnce");
            String combineOption = options.get("combine");
            if (thresholdOption == null) {
                throw new ParameterException("Threshold should not be null in IRunner.");
            }
            if (Float.parseFloat(thresholdOption) >= 1.0f || Float.parseFloat(thresholdOption) <= 0.0f) {
                throw new ParameterException("The threshold should be between 0 and 1.");
            }
            threshold = Float.parseFloat(thresholdOption);
            if (fileOption == null) {
                throw new ParameterException("File should not be null in IRunner");
            }
            path = fileOption;
            if (predictorFieldOption != null) {
                predictorFieldNames = predictorFieldOption.trim().length() == 0 ? new String[]{} : predictorFieldOption.split(",");
            }
            if (weightFieldOption != null) {
                weightFieldNames = weightFieldOption.trim().length() == 0 ? new String[]{} : weightFieldOption.split(",");
            }
            if (countOnceOption.toUpperCase().startsWith("Y")) {
                countOnce = true;
                countOnceOption = countOnceOption.toUpperCase();
            } else if (countOnceOption.toUpperCase().startsWith("N")) {
                countOnce = false;
                countOnceOption = countOnceOption.toUpperCase();
            }
            if (combineOption.toUpperCase().startsWith("Y")) {
                combine = true;
                combineOption = countOnceOption.toUpperCase();
            } else if (combineOption.toUpperCase().startsWith("N")) {
                combine = false;
                combineOption = countOnceOption.toUpperCase();
            }
            if (predictorFieldNames == null) {
                throw new ParameterException(correctFormat);
            }
            if (weightFieldNames == null) {
                throw new ParameterException(correctFormat);
            }
            if (!countOnceOption.toUpperCase().startsWith("N") && !countOnceOption.toUpperCase().startsWith("Y")) {
                throw new ParameterException("Invalid value of " + countOnceOption + " for combine of -irunner");
            }
            if (!combineOption.toUpperCase().startsWith("N") && !combineOption.toUpperCase().startsWith("Y")) {
                throw new ParameterException("Invalid value of " + combineOption + " for combine of -irunner");
            }
            try {
                return new IRunnerCountRegressionSetting(path, threshold, predictorFieldNames, weightFieldNames, countOnce, combine);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

