/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.io.file.LiveFile;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class InteractionSetting {
    LiveFile interactionUnitFile = null;
    double scoreFilterThreshold = 0.0;
    String separator = ",";
    boolean hasHeader = true;

    public String getSeparator() {
        return this.separator;
    }

    public boolean isHasHeader() {
        return this.hasHeader;
    }

    public LiveFile getInteractionUnitFile() {
        return this.interactionUnitFile;
    }

    public double getScoreFilterThreshold() {
        return this.scoreFilterThreshold;
    }

    public InteractionSetting(String interactionUnitFile, double scoreFilterThreshold, boolean hasHeader, String separator) throws IOException {
        this.interactionUnitFile = LiveFile.of(interactionUnitFile);
        this.scoreFilterThreshold = scoreFilterThreshold;
        this.hasHeader = hasHeader;
        this.separator = separator;
    }

    public String toString() {
        return "Value{, interaction Unit File=" + this.interactionUnitFile.getPath() + ", score Filter Threshold=" + this.scoreFilterThreshold + ", hasHead='" + (this.hasHeader ? "y" : "n") + ", separator='" + this.separator + '}';
    }

    public static class Converter
    implements IDynamicConverter<InteractionSetting> {
        @Override
        public InteractionSetting convert(String name, Map<String, String> options) {
            String correctFormat = "Positional argument of --interaction follows keyword argument: file=path threshold=float";
            String path = null;
            float threshold = 0.5f;
            boolean hasHeader = true;
            String fileOption = options.get("file");
            String thresholdOption = options.get("threshold");
            String hasHeaderOption = options.get("hasHead");
            String separator = options.get("sep");
            if (thresholdOption == null) {
                throw new ParameterException("Threshold should not be null in IRunner.");
            }
            if (Float.parseFloat(thresholdOption) >= 1.0f || Float.parseFloat(thresholdOption) <= 0.0f) {
                throw new ParameterException("The threshold should be between 0 and 1.");
            }
            threshold = Float.parseFloat(thresholdOption);
            if (fileOption == null) {
                throw new ParameterException("File should not be null in IRunner");
            }
            Object file = new File(fileOption);
            if (!((File)file).exists() || !((File)file).isFile()) {
                throw new IllegalArgumentException("The file at the given path does not exist or is not a valid file: " + fileOption);
            }
            path = fileOption;
            if (hasHeaderOption != null && hasHeaderOption.toUpperCase().startsWith("Y")) {
                hasHeaderOption = hasHeaderOption.toUpperCase();
            } else if (hasHeaderOption != null && hasHeaderOption.toUpperCase().startsWith("N")) {
                hasHeader = false;
                hasHeaderOption = hasHeaderOption.toUpperCase();
            }
            if (!(separator.equals("TAB") || separator.equals("COMMA") || separator.equals("SEMICOLON") || separator.equals("BLANK"))) {
                throw new ParameterException("Invalid separator: " + separator + ". Supported separators are TAB, COMMA, SEMICOLON, and BLANK.");
            }
            switch (separator) {
                case "TAB": {
                    separator = "\t";
                    break;
                }
                case "COMMA": {
                    separator = ",";
                    break;
                }
                case "SEMICOLON": {
                    separator = ";";
                    break;
                }
                case "BLANK": {
                    separator = " ";
                }
            }
            if (!hasHeaderOption.toUpperCase().startsWith("N") && !hasHeaderOption.toUpperCase().startsWith("Y")) {
                throw new ParameterException("Invalid value of " + hasHeaderOption + " for combine of --runner");
            }
            try {
                return new InteractionSetting(path, threshold, hasHeader, separator);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

