/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.container.list.IntList;
import java.util.Map;
import java.util.Objects;
import java.util.Random;

public class LeadOptionsSet {
    int epoch;
    int crossFold;
    int variantSampleTimes;
    IntList variantSampleSize;
    String functionScore;
    boolean infer;
    boolean downSample;
    boolean ignoreGty;
    int permutNum;
    long seed;

    public LeadOptionsSet(int epoch, int crossFold, int variantSampleTimes, IntList variantSampleSize, String functionScore, boolean infer, boolean downSample, boolean ignoreGty, int permutNum, long seed) {
        this.epoch = epoch;
        this.crossFold = crossFold;
        this.variantSampleTimes = variantSampleTimes;
        this.variantSampleSize = variantSampleSize;
        this.functionScore = functionScore;
        this.infer = infer;
        this.downSample = downSample;
        this.ignoreGty = ignoreGty;
        this.permutNum = permutNum;
        this.seed = seed;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeadOptionsSet that = (LeadOptionsSet)o;
        return this.epoch == that.epoch && this.crossFold == that.crossFold && this.variantSampleTimes == that.variantSampleTimes && this.infer == that.infer && this.downSample == that.downSample && this.ignoreGty == that.ignoreGty && this.permutNum == that.permutNum && this.seed == that.seed && Objects.equals(this.variantSampleSize, that.variantSampleSize) && Objects.equals(this.functionScore, that.functionScore);
    }

    public int hashCode() {
        return Objects.hash(this.epoch, this.crossFold, this.variantSampleTimes, this.variantSampleSize, this.functionScore, this.infer, this.downSample, this.ignoreGty, this.permutNum, this.seed);
    }

    public int getEpoch() {
        return this.epoch;
    }

    public int getCrossFold() {
        return this.crossFold;
    }

    public int getVariantSampleTimes() {
        return this.variantSampleTimes;
    }

    public IntList getVariantSampleSize() {
        return this.variantSampleSize;
    }

    public String getFunctionScore() {
        return this.functionScore;
    }

    public boolean isInfer() {
        return this.infer;
    }

    public boolean isDownSample() {
        return this.downSample;
    }

    public boolean isIgnoreGty() {
        return this.ignoreGty;
    }

    public int getPermutNum() {
        return this.permutNum;
    }

    public long getSeed() {
        return this.seed;
    }

    private static int getPositiveIntParam(String paramName) {
        try {
            int value = Integer.parseInt(paramName);
            if (value <= 0) {
                throw new IllegalArgumentException(paramName + " must be positive, got: " + value);
            }
            return value;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(paramName + " must be a valid integer");
        }
    }

    public static class Converter
    implements IDynamicConverter<LeadOptionsSet> {
        @Override
        public LeadOptionsSet convert(String name, Map<String, String> options) {
            int epoch = LeadOptionsSet.getPositiveIntParam(options.get("maxEpoch"));
            int crossFold = LeadOptionsSet.getPositiveIntParam(options.get("crossFold"));
            int variantSampleTimes = LeadOptionsSet.getPositiveIntParam(options.get("baggingNumber"));
            String functionScore = options.get("functionScore");
            String inferString = options.get("impute");
            String downSampleString = options.get("downSample");
            String ignoreGtyString = options.get("ignoreGty");
            boolean infer = inferString.toUpperCase().startsWith("Y");
            boolean downSample = downSampleString.toUpperCase().startsWith("Y");
            boolean ignoreGty = ignoreGtyString.toUpperCase().startsWith("Y");
            String permutNumString = options.get("permutNumber");
            String seedString = options.get("seed");
            long seed = new Random().nextInt(Integer.MAX_VALUE);
            if (seedString != null && !seedString.isEmpty()) {
                try {
                    seed = Long.parseLong(seedString);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Invalid seed: " + options.get("seed"));
                }
            }
            int permutNum = 0;
            if (permutNumString != null && !permutNumString.isEmpty()) {
                try {
                    permutNum = Integer.parseInt(permutNumString);
                    if (permutNum <= 0) {
                        throw new NumberFormatException("permutNum must be positive!");
                    }
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Invalid permutNum: " + options.get("permutNum"));
                }
            }
            IntList variantSampleSize = new IntList();
            String size = options.get("variantSampleSize");
            if (!ignoreGty) {
                if (size.contains(",")) {
                    for (String once : size.split(",")) {
                        variantSampleSize.add(LeadOptionsSet.getPositiveIntParam(once));
                    }
                } else if (size.contains(":")) {
                    String[] split = size.split(":");
                    if (split.length == 2) {
                        int start = LeadOptionsSet.getPositiveIntParam(split[0]);
                        int end = LeadOptionsSet.getPositiveIntParam(split[1]);
                        for (int i = start; i < end; ++i) {
                            variantSampleSize.add(i);
                        }
                    } else if (split.length == 3) {
                        int start = LeadOptionsSet.getPositiveIntParam(split[0]);
                        int end = LeadOptionsSet.getPositiveIntParam(split[1]);
                        int step = LeadOptionsSet.getPositiveIntParam(split[2]);
                        for (int i = start; i < end; i += step) {
                            variantSampleSize.add(i);
                        }
                    }
                } else {
                    variantSampleSize.add(LeadOptionsSet.getPositiveIntParam(size));
                }
            }
            return new LeadOptionsSet(epoch, crossFold, variantSampleTimes, variantSampleSize, functionScore, infer, downSample, ignoreGty, permutNum, seed);
        }
    }
}

