/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.DoubleList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.ReaderStream;
import edu.sysu.pmglab.io.text.reader.CustomSeparator;
import edu.sysu.pmglab.kgga.command.setting.OrderSeparator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public class PhenoFilesSet {
    public LiveFile predictingGtyFile;
    public boolean needPredict;
    public String phenotypeName;
    public int phenotypeNameIndex = -1;
    public String[] covariableNames;
    public int[] covariableNameIndexes;
    public boolean compositeSubjectID;
    public String missingLabel;
    public IndexableSet<String> trainUIDs = new LinkedSet<String>();
    public DoubleList trainPhenotypes = new DoubleList();
    public double[][] trainCovariables;
    public IndexableSet<String> testUIDs = new LinkedSet<String>();
    public DoubleList testPhenotypes = new DoubleList();
    public double[][] testCovariables;
    public IndexableSet<String> predictUIDs = new LinkedSet<String>();
    public double[][] predictCovariables;

    public PhenoFilesSet(String phenotypeName, String[] covariableNames, boolean composite, String missingLabel) {
        this.phenotypeName = phenotypeName;
        this.covariableNames = covariableNames;
        this.compositeSubjectID = composite;
        this.missingLabel = missingLabel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhenoFilesSet that = (PhenoFilesSet)o;
        return this.phenotypeNameIndex == that.phenotypeNameIndex && this.compositeSubjectID == that.compositeSubjectID && Objects.equals(this.predictingGtyFile, that.predictingGtyFile) && Objects.equals(this.phenotypeName, that.phenotypeName) && Objects.deepEquals(this.covariableNames, that.covariableNames) && Objects.deepEquals(this.covariableNameIndexes, that.covariableNameIndexes) && Objects.equals(this.missingLabel, that.missingLabel) && Objects.equals(this.trainUIDs, that.trainUIDs) && Objects.equals(this.trainPhenotypes, that.trainPhenotypes) && Objects.equals(this.testUIDs, that.testUIDs) && Objects.equals(this.testPhenotypes, that.testPhenotypes) && Objects.equals(this.predictUIDs, that.predictUIDs);
    }

    public int hashCode() {
        return Objects.hash(this.predictingGtyFile, this.phenotypeName, this.phenotypeNameIndex, Arrays.hashCode(this.covariableNames), Arrays.hashCode(this.covariableNameIndexes), this.compositeSubjectID, this.missingLabel, this.trainUIDs, this.trainPhenotypes, this.testUIDs, this.testPhenotypes, this.predictUIDs);
    }

    private static int findColumnIndex(List<Bytes> cells, String columnName, LiveFile file) {
        for (int i = 0; i < cells.size(); ++i) {
            if (!cells.fastGet(i).toString().equals(columnName)) continue;
            return i;
        }
        throw new ParameterException("Column \"" + columnName + "\" does not exist in " + file + "!");
    }

    public static class Converter
    implements IDynamicConverter<PhenoFilesSet> {
        private static final int IID_COLUMN_INDEX = 1;

        @Override
        public PhenoFilesSet convert(String name, Map<String, String> options) {
            int i2;
            String trainingSampleFile = options.get("trainingSample");
            String testingSampleFile = options.get("testingSample");
            String predictingSampleFile = options.get("predictingSample");
            String predictingGtyFile = options.get("predictingGtyFile");
            String phenotypeNameOption = options.get("pheno");
            String covariableNamesOption = options.get("covar");
            String compositeOption = options.get("composite").toUpperCase();
            String missingLabel = options.get("missing");
            String[] covariableNames = null;
            if (covariableNamesOption != null && !covariableNamesOption.trim().isEmpty()) {
                covariableNames = covariableNamesOption.split(",");
            }
            boolean composite = compositeOption.toUpperCase().startsWith("Y");
            PhenoFilesSet phenoFilesSet = new PhenoFilesSet(phenotypeNameOption, covariableNames, composite, missingLabel);
            phenoFilesSet.needPredict = !predictingSampleFile.isEmpty();
            DoubleList[] trainCovariables = null;
            DoubleList[] testCovariables = null;
            DoubleList[] predictCovariables = null;
            if (covariableNames != null) {
                trainCovariables = new DoubleList[covariableNames.length];
                testCovariables = new DoubleList[covariableNames.length];
                if (phenoFilesSet.needPredict) {
                    predictCovariables = new DoubleList[covariableNames.length];
                }
            }
            try {
                LiveFile trainingSample = LiveFile.of(trainingSampleFile);
                this.processSampleFile(trainingSample, phenoFilesSet, "train", trainCovariables);
            }
            catch (IOException e) {
                throw new RuntimeException("Training-Sample-File is not found: " + trainingSampleFile);
            }
            try {
                LiveFile testingSample = LiveFile.of(testingSampleFile);
                this.processSampleFile(testingSample, phenoFilesSet, "test", testCovariables);
            }
            catch (IOException e) {
                throw new RuntimeException("Testing-Sample-File is not found: " + testingSampleFile);
            }
            if (phenoFilesSet.needPredict) {
                try {
                    LiveFile predictingSample = LiveFile.of(predictingSampleFile);
                    this.processSampleFile(predictingSample, phenoFilesSet, "predict", predictCovariables);
                }
                catch (IOException e) {
                    throw new RuntimeException("Predicting-Sample-File is not found: " + predictingSampleFile);
                }
            }
            if (phenoFilesSet.needPredict) {
                try {
                    LiveFile predictingGty;
                    phenoFilesSet.predictingGtyFile = predictingGty = LiveFile.of(predictingGtyFile);
                }
                catch (IOException e) {
                    throw new RuntimeException("Predicting-Gty-File is not found: " + predictingGtyFile);
                }
            }
            if (Arrays.stream(phenoFilesSet.trainPhenotypes.toArray()).anyMatch(i -> (int)i == 2)) {
                for (i2 = 0; i2 < phenoFilesSet.trainPhenotypes.size(); ++i2) {
                    phenoFilesSet.trainPhenotypes.fastSet(i2, phenoFilesSet.trainPhenotypes.fastGet(i2) - 1.0);
                }
            }
            if (Arrays.stream(phenoFilesSet.testPhenotypes.toArray()).anyMatch(i -> (int)i == 2)) {
                for (i2 = 0; i2 < phenoFilesSet.testPhenotypes.size(); ++i2) {
                    phenoFilesSet.testPhenotypes.fastSet(i2, phenoFilesSet.testPhenotypes.fastGet(i2) - 1.0);
                }
            }
            if (phenoFilesSet.covariableNames != null && trainCovariables != null) {
                phenoFilesSet.trainCovariables = (double[][])Arrays.stream(trainCovariables).map(DoubleList::toArray).toArray(x$0 -> new double[x$0][]);
                phenoFilesSet.testCovariables = (double[][])Arrays.stream(testCovariables).map(DoubleList::toArray).toArray(x$0 -> new double[x$0][]);
                if (phenoFilesSet.needPredict && predictCovariables != null) {
                    phenoFilesSet.predictCovariables = (double[][])Arrays.stream(predictCovariables).map(DoubleList::toArray).toArray(x$0 -> new double[x$0][]);
                }
            }
            return phenoFilesSet;
        }

        private void processSampleFile(LiveFile sampleFile, PhenoFilesSet phenoFilesSet, String flag, DoubleList[] covariables) {
            try (ReaderStream fs = sampleFile.openAsText();){
                Bytes line;
                int i;
                Bytes header = fs.readline();
                CustomSeparator separator = new CustomSeparator(new OrderSeparator());
                List<Bytes> cells = separator.accept(header);
                phenoFilesSet.phenotypeNameIndex = phenoFilesSet.phenotypeName != null && !phenoFilesSet.phenotypeName.trim().isEmpty() ? PhenoFilesSet.findColumnIndex(cells, phenoFilesSet.phenotypeName, sampleFile) : 5;
                if (phenoFilesSet.covariableNames != null) {
                    phenoFilesSet.covariableNameIndexes = new int[phenoFilesSet.covariableNames.length];
                    for (i = 0; i < phenoFilesSet.covariableNames.length; ++i) {
                        phenoFilesSet.covariableNameIndexes[i] = PhenoFilesSet.findColumnIndex(cells, phenoFilesSet.covariableNames[i], sampleFile);
                    }
                }
                if (phenoFilesSet.covariableNames != null) {
                    for (i = 0; i < phenoFilesSet.covariableNameIndexes.length; ++i) {
                        covariables[i] = new DoubleList();
                    }
                }
                if (!cells.get(0).toString().equalsIgnoreCase("FID")) {
                    this.addSampleData(cells, phenoFilesSet, flag, covariables);
                }
                while ((line = fs.readline()) != null) {
                    if (line.trim().length() == 0) {
                        break;
                    }
                    List<Bytes> row = separator.accept(line);
                    this.addSampleData(row, phenoFilesSet, flag, covariables);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void addSampleData(List<Bytes> row, PhenoFilesSet phenoFilesSet, String flag, DoubleList[] covariables) {
            switch (flag) {
                case "train": {
                    phenoFilesSet.trainUIDs.add(row.fastGet(1).toString());
                    phenoFilesSet.trainPhenotypes.add(row.fastGet(phenoFilesSet.phenotypeNameIndex).toDouble());
                    if (phenoFilesSet.covariableNames == null) break;
                    for (int i = 0; i < phenoFilesSet.covariableNameIndexes.length; ++i) {
                        covariables[i].add(row.fastGet(phenoFilesSet.covariableNameIndexes[i]).toDouble());
                    }
                    break;
                }
                case "test": {
                    phenoFilesSet.testUIDs.add(row.fastGet(1).toString());
                    phenoFilesSet.testPhenotypes.add(row.fastGet(phenoFilesSet.phenotypeNameIndex).toDouble());
                    if (phenoFilesSet.covariableNames == null) break;
                    for (int i = 0; i < phenoFilesSet.covariableNameIndexes.length; ++i) {
                        covariables[i].add(row.fastGet(phenoFilesSet.covariableNameIndexes[i]).toDouble());
                    }
                    break;
                }
                case "predict": {
                    phenoFilesSet.predictUIDs.add(row.fastGet(1).toString());
                    if (phenoFilesSet.covariableNames == null) break;
                    for (int i = 0; i < phenoFilesSet.covariableNameIndexes.length; ++i) {
                        covariables[i].add(row.fastGet(phenoFilesSet.covariableNameIndexes[i]).toDouble());
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown flag: " + flag);
                }
            }
        }
    }
}

