/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import java.util.Map;
import java.util.Objects;

public class PhenotypeCausalSetting {
    final double causalEffect;
    final double causalHeritability;
    final double pleiotropyIVProportion;
    final double directPleiotropyHeritability;
    final double randPleiotropyHeritability;

    public PhenotypeCausalSetting() {
        this.causalEffect = 0.5;
        this.causalHeritability = 0.05;
        this.pleiotropyIVProportion = 0.0;
        this.directPleiotropyHeritability = 0.0;
        this.randPleiotropyHeritability = 0.0;
    }

    public PhenotypeCausalSetting(double causalEffect, double causalHeritability, double pleiotropyIVProportion, double directPleiotropyHeritability, double randPleiotropyHeritability) {
        this.causalEffect = causalEffect;
        this.causalHeritability = causalHeritability;
        this.pleiotropyIVProportion = pleiotropyIVProportion;
        this.directPleiotropyHeritability = directPleiotropyHeritability;
        this.randPleiotropyHeritability = randPleiotropyHeritability;
    }

    public double getCausalEffect() {
        return this.causalEffect;
    }

    public double getCausalHeritability() {
        return this.causalHeritability;
    }

    public double getPleiotropyIVProportion() {
        return this.pleiotropyIVProportion;
    }

    public double getDirectPleiotropyHeritability() {
        return this.directPleiotropyHeritability;
    }

    public double getRandPleiotropyHeritability() {
        return this.randPleiotropyHeritability;
    }

    public String toString() {
        return "PhenotypeCausalSetting{causalEffect=" + this.causalEffect + ", causalHeritability=" + this.causalHeritability + ", pleiotropyIVProportion=" + this.pleiotropyIVProportion + ", pleiotropyHeritability=" + this.directPleiotropyHeritability + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhenotypeCausalSetting that = (PhenotypeCausalSetting)o;
        return Double.compare(that.causalEffect, this.causalEffect) == 0 && Double.compare(that.causalHeritability, this.causalHeritability) == 0 && Double.compare(that.pleiotropyIVProportion, this.pleiotropyIVProportion) == 0 && Double.compare(that.directPleiotropyHeritability, this.directPleiotropyHeritability) == 0 && Double.compare(that.randPleiotropyHeritability, this.randPleiotropyHeritability) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.causalEffect, this.causalHeritability, this.pleiotropyIVProportion, this.directPleiotropyHeritability);
    }

    public static class Converter
    implements IDynamicConverter<PhenotypeCausalSetting> {
        @Override
        public PhenotypeCausalSetting convert(String name, Map<String, String> options) {
            String correctFormat = "Argument of " + name + " follows keyword-value format: \n    causalEffect=<value>\n    causalHeritability=<value>\n    pleiotropyIVProportion=<value>\n    directPleiotropyHeritability=<value>";
            double causalEffect = 0.5;
            double causalHeritability = 0.05;
            double pleiotropyIVProportion = 0.0;
            double directPleiotropyHeritability = 0.0;
            double randPleiotropyHeritability = 0.0;
            if (options.containsKey("causalEffect")) {
                try {
                    causalEffect = Double.parseDouble(options.get("causalEffect"));
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new ParameterException("The value for 'causalEffect' is not a valid number. " + correctFormat);
                }
            }
            if (options.containsKey("causalHeritability")) {
                try {
                    causalHeritability = Double.parseDouble(options.get("causalHeritability"));
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new ParameterException("The value for 'causalHeritability' is not a valid number. " + correctFormat);
                }
            }
            if (options.containsKey("pleiotropyIVProportion")) {
                try {
                    pleiotropyIVProportion = Double.parseDouble(options.get("pleiotropyIVProportion"));
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new ParameterException("The value for 'pleiotropyIVProportion' is not a valid number. " + correctFormat);
                }
            }
            if (options.containsKey("directPleiotropyHeritability")) {
                try {
                    directPleiotropyHeritability = Double.parseDouble(options.get("directPleiotropyHeritability"));
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new ParameterException("The value for 'directPleiotropyHeritability' is not a valid number. " + correctFormat);
                }
            }
            if (options.containsKey("randPleiotropyHeritability")) {
                try {
                    randPleiotropyHeritability = Double.parseDouble(options.get("randPleiotropyHeritability"));
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new ParameterException("The value for 'randPleiotropyHeritability' is not a valid number. " + correctFormat);
                }
            }
            if (causalEffect == 0.0 && causalHeritability != 0.0 || causalEffect != 0.0 && causalHeritability == 0.0) {
                throw new ParameterException("The values for 'causalEffect' and 'causalHeritability' must be specified together and be either both zero or both non-zero.");
            }
            if (pleiotropyIVProportion == 0.0 && (directPleiotropyHeritability != 0.0 || randPleiotropyHeritability != 0.0) || pleiotropyIVProportion != 0.0 && directPleiotropyHeritability == 0.0 && randPleiotropyHeritability == 0.0) {
                throw new ParameterException("The values for 'pleiotropyIVProportion' and 'directPleiotropyHeritability' or 'randPleiotropyHeritability' must be specified together and be either both zero or both non-zero.");
            }
            if (pleiotropyIVProportion < 0.0 || pleiotropyIVProportion > 1.0) {
                throw new ParameterException("The value for 'pleiotropyIVProportion' must be between 0 and 1.");
            }
            if (directPleiotropyHeritability < 0.0 || directPleiotropyHeritability > 1.0) {
                throw new ParameterException("The value for 'directPleiotropyHeritability' must be between 0 and 1.");
            }
            return new PhenotypeCausalSetting(causalEffect, causalHeritability, pleiotropyIVProportion, directPleiotropyHeritability, randPleiotropyHeritability);
        }
    }
}

