/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import java.util.Map;
import java.util.Objects;

public class PhenotypeGeneSetting {
    int maxDrivers;
    double heritability;
    double prevalence;

    public PhenotypeGeneSetting() {
        this.maxDrivers = 200;
        this.heritability = 0.15;
        this.prevalence = Double.NaN;
    }

    public PhenotypeGeneSetting(int maxDrivers, double heritability, double prevalence) {
        this.maxDrivers = maxDrivers;
        this.heritability = heritability;
        this.prevalence = prevalence;
    }

    public int getMaxDrivers() {
        return this.maxDrivers;
    }

    public double getHeritability() {
        return this.heritability;
    }

    public double getPrevalence() {
        return this.prevalence;
    }

    public String toString() {
        return "PhenotypeGeneSetting{maxDriverNum=" + this.maxDrivers + ", heritability=" + this.heritability + ", prevalence=" + this.prevalence + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhenotypeGeneSetting that = (PhenotypeGeneSetting)o;
        return this.maxDrivers == that.maxDrivers && Double.compare(that.heritability, this.heritability) == 0 && Double.compare(that.prevalence, this.prevalence) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.maxDrivers, this.heritability, this.prevalence);
    }

    public static class Converter
    implements IDynamicConverter<PhenotypeGeneSetting> {
        @Override
        public PhenotypeGeneSetting convert(String name, Map<String, String> options) {
            String correctFormat = "Argument of " + name + " follows keyword-value format: maxDriverNum=<integer> heritability=<value> prevalence=<value>";
            int maxDrivers = 200;
            double heritability = 0.15;
            double prevalence = 0.01;
            if (options.containsKey("maxDriverNum")) {
                try {
                    maxDrivers = Integer.parseInt(options.get("maxDriverNum"));
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new ParameterException("The value for 'maxDriverNum' is not a valid integer. " + correctFormat);
                }
            }
            if (options.containsKey("heritability")) {
                try {
                    heritability = Double.parseDouble(options.get("heritability"));
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new ParameterException("The value for 'heritability' is not a valid number. " + correctFormat);
                }
            }
            if (options.containsKey("prevalence")) {
                try {
                    String valS = options.get("prevalence").trim();
                    prevalence = valS.equals("NaN") || valS.isEmpty() ? Double.NaN : Double.parseDouble(valS);
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new ParameterException("The value for 'prevalence' is not a valid number. " + correctFormat);
                }
            }
            return new PhenotypeGeneSetting(maxDrivers, heritability, prevalence);
        }
    }
}

