/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import java.util.Map;
import java.util.Objects;

public class PhenotypeVariantSetting {
    String qtlPattern;
    double heritability;
    double prevalence;
    double confounding;

    public PhenotypeVariantSetting() {
        this.qtlPattern = "50:1&50:2&50:3";
        this.heritability = 0.25;
        this.prevalence = Double.NaN;
        this.confounding = 0.0;
    }

    public PhenotypeVariantSetting(String qtlPattern, double heritability, double prevalence, double confounding) {
        this.qtlPattern = qtlPattern;
        this.heritability = heritability;
        this.prevalence = prevalence;
        this.confounding = confounding;
    }

    public String getQtlPattern() {
        return this.qtlPattern;
    }

    public double getHeritability() {
        return this.heritability;
    }

    public double getPrevalence() {
        return this.prevalence;
    }

    public double getConfounding() {
        return this.confounding;
    }

    public String toString() {
        return "PhenotypeVariantSetting{qtlPattern='" + this.qtlPattern + '\'' + ", heritability=" + this.heritability + ", prevalence=" + this.prevalence + ", confounding=" + this.confounding + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhenotypeVariantSetting that = (PhenotypeVariantSetting)o;
        return Double.compare(that.heritability, this.heritability) == 0 && Double.compare(that.prevalence, this.prevalence) == 0 && Double.compare(that.confounding, this.confounding) == 0 && Objects.equals(this.qtlPattern, that.qtlPattern);
    }

    public int hashCode() {
        return Objects.hash(this.qtlPattern, this.heritability, this.prevalence, this.confounding);
    }

    public static class Converter
    implements IDynamicConverter<PhenotypeVariantSetting> {
        @Override
        public PhenotypeVariantSetting convert(String name, Map<String, String> options) {
            String val;
            String correctFormat = "Argument of " + name + " follows keyword-value format: qtlPattern=<pattern> heritability=<value> prevalence=<value> confounding=<value>";
            String qtlPattern = "50:1&50:2&50:3";
            double heritability = 0.25;
            double prevalence = 0.01;
            double confounding = 0.0;
            if (options.containsKey("qtlPattern") && ((qtlPattern = options.get("qtlPattern")) == null || qtlPattern.trim().isEmpty())) {
                throw new ParameterException("The value for 'qtlPattern' cannot be empty.");
            }
            if (options.containsKey("heritability")) {
                try {
                    heritability = Double.parseDouble(options.get("heritability"));
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new ParameterException("The value for 'heritability' is not a valid number. " + correctFormat);
                }
            }
            if (options.containsKey("prevalence")) {
                try {
                    val = options.get("prevalence").trim();
                    prevalence = val.isEmpty() ? Double.NaN : Double.parseDouble(val);
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new ParameterException("The value for 'prevalence' is not a valid number. " + correctFormat);
                }
            }
            if (options.containsKey("confounding")) {
                try {
                    val = options.get("confounding").trim();
                    if (val.isEmpty()) {
                        prevalence = Double.NaN;
                    } else {
                        confounding = Double.parseDouble(val);
                    }
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new ParameterException("The value for 'confounding' is not a valid number. " + correctFormat);
                }
            }
            return new PhenotypeVariantSetting(qtlPattern, heritability, prevalence, confounding);
        }
    }
}

