/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import java.util.Arrays;
import java.util.Map;

public class PubMedFieldsSet {
    String field;
    String[] keywords;

    private PubMedFieldsSet(String[] keywords, String field) {
        this.keywords = keywords;
        this.field = field;
    }

    public String getField() {
        return this.field;
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public String toString() {
        return "Value{keywords=" + Arrays.toString(this.keywords) + ", field=" + this.field + "}";
    }

    public static class Converter
    implements IDynamicConverter<PubMedFieldsSet> {
        @Override
        public PubMedFieldsSet convert(String name, Map<String, String> options) {
            String fieldName = null;
            String[] keywords = null;
            String fieldNameOption = options.get("field");
            String keywordsOption = options.get("keywords");
            if (fieldNameOption != null && !(fieldName = fieldNameOption).equals("Title/Abstract") && !fieldName.equals("Text+Word")) {
                throw new ParameterException("Invalid field name in --pubmed-mining! Positional argument of --pubmed-mining follows keyword argument: <keyword1,keyword2,...> [field='Title/Abstract'/'Text+Word']");
            }
            if (keywordsOption != null) {
                keywords = keywordsOption.split(",");
            }
            return new PubMedFieldsSet(keywords, fieldName);
        }
    }
}

