/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.commandParser.validator.IValidator;
import edu.sysu.pmglab.pyserve.PyConnection;
import edu.sysu.pmglab.pyserve.PyServeException;
import java.net.InetSocketAddress;

public enum PyConnectValidator implements IValidator<InetSocketAddress>
{
    INSTANCE;


    @Override
    public void validate(String name, InetSocketAddress address) throws ParameterException {
        try {
            PyConnection conn = new PyConnection(address.getHostName(), address.getPort());
            conn.close();
        }
        catch (Error | Exception e) {
            throw new ParameterException("Unable to connect to PyServe on " + address + ", please check if PyServe is started on the corresponding port.\nIf PyServe service is not available on your device, you can install it with the following steps:\n1. Install Docker service, please refer to official guide at https://docs.docker.com/desktop/\n2. Write the following text file (named Dockerfile):\n    FROM continuumio/miniconda3\n    RUN conda install jupyter -y --quiet && mkdir -p /opt/notebooks\n    COPY ./pyserve.py /pyserve.py\n    EXPOSE 6400 6401\n    CMD nohup jupyter notebook --notebook-dir=/opt/notebooks --ip='*' --port=6401 --NotebookApp.token='' --NotebookApp.password='' --no-browser --allow-root & python /pyserve.py\n3. Build the Docker image named 'pyserve' using the following command: \n    docker build -t pyserve -f Dockerfile .\n4. Start the PyServe service using the following command: \n    docker run --rm -p 6400:6400 -p 6401:6401 -m 8g -d pyserve\nHere, port 6400 on the local machine is mapped to the PyServe service within the Docker container, and port 6401 is mapped to Jupyter within the Docker container (you can access Jupyter in your browser at 127.0.0.1:6401), '-m 8g' specifies the memory allocation for the Docker container.", e);
        }
    }

    public static void main(String[] args) throws PyServeException {
        INSTANCE.validate("-py", new InetSocketAddress(6400));
        PyConnection connection = new PyConnection(6400);
        connection.exec("import numpy as np");
        connection.exec("seq = np.array([1, 2, 3, 4, 5, 6])");
        connection.exec("mean = seq.mean()");
        connection.exec("std = seq.std()");
        System.out.println(connection.getValue("mean"));
        System.out.println(connection.getValue("std"));
    }
}

