/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.commandParser.validator.IValidator;
import java.net.InetSocketAddress;
import org.rosuda.REngine.Rserve.RConnection;

public enum RConnectValidator implements IValidator<InetSocketAddress>
{
    INSTANCE;


    @Override
    public void validate(String name, InetSocketAddress address) throws ParameterException {
        try {
            RConnection connection = new RConnection(address.getHostName(), address.getPort());
            connection.close();
        }
        catch (Error | Exception e) {
            throw new ParameterException("Unable to connect to RServe on " + address + ", please check if RServe is started on the corresponding port.\nIf RServe service is not available on your device, you can install it with the following steps:\n1. Install Docker service, please refer to official guide at https://docs.docker.com/desktop/\n2. Write the following text file (named Dockerfile):\n    FROM rocker/rstudio\n    ENV USER=\"rstudio\"\n    RUN Rscript -e \"install.packages('distributions3');\"\n    RUN Rscript -e \"install.packages('countreg', repos='http://R-Forge.R-project.org');\"\n    RUN Rscript -e \"install.packages('Rserve');\"\n    EXPOSE 6311 8787\n    CMD nohup /usr/lib/rstudio-server/bin/rserver --server-daemonize 0 --auth-none 1 & R -e \"Rserve::run.Rserve(remote=TRUE)\"\n3. Build the Docker image named 'rserve' using the following command: \n    docker build -t rserve -f Dockerfile .\n4. Start the RServe service using the following command: \n    docker run --rm -p 6300:6311 -p 6301:8787 -m 8g -d rserve\nHere, port 6300 on the local machine is mapped to the RServe service within the Docker container, and port 6301 is mapped to RStudio within the Docker container (you can access RStudio in your browser at 127.0.0.1:6301), '-m 8g' specifies the memory allocation for the Docker container.", e);
        }
    }
}

