/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import java.util.Map;
import java.util.Objects;

public class SamplingGroupSetting {
    int groupNum;
    float overlapping;

    public SamplingGroupSetting() {
        this.groupNum = 1;
        this.overlapping = 0.0f;
    }

    public SamplingGroupSetting(int groupNum, float overlapping) {
        this.groupNum = groupNum;
        this.overlapping = overlapping;
    }

    public int getGroupNum() {
        return this.groupNum;
    }

    public float getOverlapping() {
        return this.overlapping;
    }

    public boolean isValidGroupNum() {
        return this.groupNum > 0;
    }

    public boolean isValidOverlapping() {
        return this.overlapping >= 0.0f && this.overlapping <= 1.0f;
    }

    public String toString() {
        return "SamplingGroupSetting{groupNum=" + this.groupNum + ", overlapping=" + this.overlapping + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamplingGroupSetting that = (SamplingGroupSetting)o;
        return this.groupNum == that.groupNum && Float.compare(that.overlapping, this.overlapping) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.groupNum, Float.valueOf(this.overlapping));
    }

    public static class Converter
    implements IDynamicConverter<SamplingGroupSetting> {
        @Override
        public SamplingGroupSetting convert(String name, Map<String, String> options) {
            float overlapping;
            int groupNum;
            block9: {
                String correctFormat;
                block8: {
                    correctFormat = "Argument of " + name + " follows keyword-value format: groupNum=<int> overlapping=<float>";
                    groupNum = 1;
                    overlapping = 0.0f;
                    if (options.containsKey("groupNum")) {
                        try {
                            groupNum = Integer.parseInt(options.get("groupNum"));
                            if (groupNum <= 0) {
                                throw new ParameterException("The value for 'groupNum' must be positive. " + correctFormat);
                            }
                            break block8;
                        }
                        catch (NumberFormatException e) {
                            throw new ParameterException("The value for 'groupNum' is not a valid integer. " + correctFormat);
                        }
                    }
                    throw new ParameterException("Missing required parameter 'groupNum'. " + correctFormat);
                }
                if (options.containsKey("overlapping")) {
                    try {
                        overlapping = Float.parseFloat(options.get("overlapping"));
                        if (overlapping < 0.0f || overlapping > 1.0f) {
                            throw new ParameterException("The value for 'overlapping' must be between 0 and 1 (inclusive). " + correctFormat);
                        }
                        break block9;
                    }
                    catch (NumberFormatException e) {
                        throw new ParameterException("The value for 'overlapping' is not a valid float. " + correctFormat);
                    }
                }
                throw new ParameterException("Missing required parameter 'overlapping'. " + correctFormat);
            }
            return new SamplingGroupSetting(groupNum, overlapping);
        }
    }
}

