/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import java.util.Map;
import java.util.Objects;

public class SamplingSetting {
    int sampleSize;
    Float caseProportion;

    public SamplingSetting() {
        this.sampleSize = 6000;
        this.caseProportion = null;
    }

    public SamplingSetting(int sampleSize, Float caseProportion) {
        this.sampleSize = sampleSize;
        this.caseProportion = caseProportion;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public Float getCaseProportion() {
        return this.caseProportion;
    }

    public boolean isBinaryTrait() {
        return this.caseProportion != null;
    }

    public boolean isQuantitativeTrait() {
        return this.caseProportion == null;
    }

    public Integer getCaseSampleSize() {
        if (this.caseProportion == null) {
            return 0;
        }
        return Math.round((float)this.sampleSize * this.caseProportion.floatValue());
    }

    public Integer getControlSampleSize() {
        if (this.caseProportion == null) {
            return 0;
        }
        return this.sampleSize - this.getCaseSampleSize();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SamplingSetting{").append("sampleSize=").append(this.sampleSize).append(", caseProportion=").append(this.caseProportion);
        if (this.isBinaryTrait()) {
            sb.append(", caseSampleSize=").append(this.getCaseSampleSize()).append(", controlSampleSize=").append(this.getControlSampleSize());
        } else {
            sb.append(", traitType=quantitative");
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamplingSetting that = (SamplingSetting)o;
        return this.sampleSize == that.sampleSize && Objects.equals(this.caseProportion, that.caseProportion);
    }

    public int hashCode() {
        return Objects.hash(this.sampleSize, this.caseProportion);
    }

    public static class Converter
    implements IDynamicConverter<SamplingSetting> {
        @Override
        public SamplingSetting convert(String name, Map<String, String> options) {
            String casePropStr;
            String correctFormat = "Argument of " + name + " follows keyword-value format: sampleSize=<int> [caseProportion=<float>]";
            int sampleSize = 6000;
            Float caseProportion = null;
            if (options.containsKey("sampleSize")) {
                try {
                    sampleSize = Integer.parseInt(options.get("sampleSize"));
                    if (sampleSize <= 0) {
                        throw new ParameterException("The value for 'sampleSize' must be positive. " + correctFormat);
                    }
                }
                catch (NumberFormatException e) {
                    throw new ParameterException("The value for 'sampleSize' is not a valid integer. " + correctFormat);
                }
            }
            if (options.containsKey("caseProportion") && (casePropStr = options.get("caseProportion")) != null && !casePropStr.trim().isEmpty()) {
                try {
                    caseProportion = Float.valueOf(Float.parseFloat(casePropStr));
                    if (caseProportion.floatValue() <= 0.0f || caseProportion.floatValue() >= 1.0f) {
                        throw new ParameterException("The value for 'caseProportion' must be between 0 and 1 (exclusive). " + correctFormat);
                    }
                }
                catch (NumberFormatException e) {
                    throw new ParameterException("The value for 'caseProportion' is not a valid float. " + correctFormat);
                }
            }
            return new SamplingSetting(sampleSize, caseProportion);
        }
    }
}

