/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import java.util.Map;
import java.util.Objects;

public class SpatialGeneSetting {
    int chipSize;
    String hotLocations;
    int maxHotExpressionGenes;
    double dropoutRate;
    int numChips;

    public SpatialGeneSetting() {
        this.chipSize = 100;
        this.hotLocations = "50:50&10:50";
        this.maxHotExpressionGenes = 500;
        this.dropoutRate = 0.5;
        this.numChips = 10;
    }

    public SpatialGeneSetting(int chipSize, String hotLocations, int maxHotExpressionGenes, double dropoutRate, int numChips) {
        this.chipSize = chipSize;
        this.hotLocations = hotLocations;
        this.maxHotExpressionGenes = maxHotExpressionGenes;
        this.dropoutRate = dropoutRate;
        this.numChips = numChips;
    }

    public int getChipSize() {
        return this.chipSize;
    }

    public String getHotLocations() {
        return this.hotLocations;
    }

    public int getMaxHotExpressionGenes() {
        return this.maxHotExpressionGenes;
    }

    public double getDropoutRate() {
        return this.dropoutRate;
    }

    public int getNumChips() {
        return this.numChips;
    }

    public String toString() {
        return "SpatialGeneSetting{chipSize=" + this.chipSize + ", hotLocations='" + this.hotLocations + '\'' + ", maxHotExpressionGeneNum=" + this.maxHotExpressionGenes + ", dropoutRate=" + this.dropoutRate + ", chipNum=" + this.numChips + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpatialGeneSetting that = (SpatialGeneSetting)o;
        return this.chipSize == that.chipSize && this.maxHotExpressionGenes == that.maxHotExpressionGenes && Double.compare(that.dropoutRate, this.dropoutRate) == 0 && this.numChips == that.numChips && Objects.equals(this.hotLocations, that.hotLocations);
    }

    public int hashCode() {
        return Objects.hash(this.chipSize, this.hotLocations, this.maxHotExpressionGenes, this.dropoutRate, this.numChips);
    }

    public static class Converter
    implements IDynamicConverter<SpatialGeneSetting> {
        @Override
        public SpatialGeneSetting convert(String name, Map<String, String> options) {
            String correctFormat = "Argument of " + name + " follows keyword-value format: chipSize=<int> hotLocations=<loc1&loc2> maxHotExpressionGeneNum=<int> dropoutRate=<value> chipNum=<int>";
            int chipSize = 100;
            String hotLocations = "50:50&10:50";
            int maxHotExpressionGenes = 500;
            double dropoutRate = 0.5;
            int numChips = 10;
            if (options.containsKey("chipSize")) {
                try {
                    chipSize = Integer.parseInt(options.get("chipSize"));
                }
                catch (NumberFormatException e) {
                    throw new ParameterException("The value for 'chipSize' is not a valid integer. " + correctFormat);
                }
            }
            if (options.containsKey("hotLocations") && ((hotLocations = options.get("hotLocations")) == null || hotLocations.trim().isEmpty())) {
                throw new ParameterException("The value for 'hotLocations' cannot be empty.");
            }
            if (options.containsKey("maxHotExpressionGeneNum")) {
                try {
                    maxHotExpressionGenes = Integer.parseInt(options.get("maxHotExpressionGeneNum"));
                }
                catch (NumberFormatException e) {
                    throw new ParameterException("The value for 'maxHotExpressionGeneNum' is not a valid integer. " + correctFormat);
                }
            }
            if (options.containsKey("dropoutRate")) {
                try {
                    dropoutRate = Double.parseDouble(options.get("dropoutRate"));
                }
                catch (NumberFormatException e) {
                    throw new ParameterException("The value for 'dropoutRate' is not a valid number. " + correctFormat);
                }
            }
            if (options.containsKey("chipNum")) {
                try {
                    numChips = Integer.parseInt(options.get("chipNum"));
                }
                catch (NumberFormatException e) {
                    throw new ParameterException("The value for 'chipNum' is not a valid integer. " + correctFormat);
                }
            }
            return new SpatialGeneSetting(chipSize, hotLocations, maxHotExpressionGenes, dropoutRate, numChips);
        }
    }
}

