/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import java.util.Map;
import java.util.Objects;

public class TimingGeneModelSetting {
    double peakTime;
    double scaleWidth;
    double amplitude;

    public TimingGeneModelSetting() {
        this.peakTime = 20.0;
        this.scaleWidth = 20.0;
        this.amplitude = 10.0;
    }

    public TimingGeneModelSetting(double peakTime, double scaleWidth, double amplitude) {
        this.peakTime = peakTime;
        this.scaleWidth = scaleWidth;
        this.amplitude = amplitude;
    }

    public double getPeakTime() {
        return this.peakTime;
    }

    public double getScaleWidth() {
        return this.scaleWidth;
    }

    public double getAmplitude() {
        return this.amplitude;
    }

    public String toString() {
        return "TimingGeneModelSetting{peakTime=" + this.peakTime + ", scaleWidth=" + this.scaleWidth + ", amplitude=" + this.amplitude + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimingGeneModelSetting that = (TimingGeneModelSetting)o;
        return Double.compare(that.peakTime, this.peakTime) == 0 && Double.compare(that.scaleWidth, this.scaleWidth) == 0 && Double.compare(that.amplitude, this.amplitude) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.peakTime, this.scaleWidth, this.amplitude);
    }

    public static class Converter
    implements IDynamicConverter<TimingGeneModelSetting> {
        @Override
        public TimingGeneModelSetting convert(String name, Map<String, String> options) {
            String correctFormat = "Argument of " + name + " follows keyword-value format: peakTime=<value> scaleWidth=<value> amplitude=<value>";
            double peakTime = 20.0;
            double scaleWidth = 20.0;
            double amplitude = 10.0;
            if (options.containsKey("peakTime")) {
                try {
                    peakTime = Double.parseDouble(options.get("peakTime"));
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new ParameterException("The value for 'peakTime' is not a valid number. " + correctFormat);
                }
            }
            if (options.containsKey("scaleWidth")) {
                try {
                    scaleWidth = Double.parseDouble(options.get("scaleWidth"));
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new ParameterException("The value for 'scaleWidth' is not a valid number. " + correctFormat);
                }
            }
            if (options.containsKey("amplitude")) {
                try {
                    amplitude = Double.parseDouble(options.get("amplitude"));
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new ParameterException("The value for 'amplitude' is not a valid number. " + correctFormat);
                }
            }
            return new TimingGeneModelSetting(peakTime, scaleWidth, amplitude);
        }
    }
}

