/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import java.util.Map;
import java.util.Objects;

public class TimingGeneSetting {
    int startAge;
    int endAge;
    double ageInterval;
    int sampleSizePerAge;
    int maxTimeGenes;
    int sampleNum;

    public TimingGeneSetting() {
        this.startAge = 0;
        this.endAge = 60;
        this.ageInterval = 1.0;
        this.sampleSizePerAge = 10;
        this.maxTimeGenes = 500;
        this.sampleNum = 1;
    }

    public TimingGeneSetting(int startAge, int endAge, double ageInterval, int sampleSizePerAge, int maxTimeGenes, int sampleNum) {
        this.startAge = startAge;
        this.endAge = endAge;
        this.ageInterval = ageInterval;
        this.sampleSizePerAge = sampleSizePerAge;
        this.maxTimeGenes = maxTimeGenes;
        this.sampleNum = sampleNum;
    }

    public int getStartAge() {
        return this.startAge;
    }

    public int getEndAge() {
        return this.endAge;
    }

    public double getAgeInterval() {
        return this.ageInterval;
    }

    public int getSampleSizePerAge() {
        return this.sampleSizePerAge;
    }

    public int getMaxTimeGenes() {
        return this.maxTimeGenes;
    }

    public int getSampleNum() {
        return this.sampleNum;
    }

    public String toString() {
        return "TimingGeneSetting{startAge=" + this.startAge + ", endAge=" + this.endAge + ", ageInterval=" + this.ageInterval + ", sampleSizePerAge=" + this.sampleSizePerAge + ", maxTimeGenes=" + this.maxTimeGenes + ", sampleNum=" + this.sampleNum + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimingGeneSetting that = (TimingGeneSetting)o;
        return this.startAge == that.startAge && this.endAge == that.endAge && Double.compare(that.ageInterval, this.ageInterval) == 0 && this.sampleSizePerAge == that.sampleSizePerAge && this.maxTimeGenes == that.maxTimeGenes && this.sampleNum == that.sampleNum;
    }

    public int hashCode() {
        return Objects.hash(this.startAge, this.endAge, this.ageInterval, this.sampleSizePerAge, this.maxTimeGenes, this.sampleNum);
    }

    public static class Converter
    implements IDynamicConverter<TimingGeneSetting> {
        @Override
        public TimingGeneSetting convert(String name, Map<String, String> options) {
            String correctFormat = "Argument of " + name + " follows keyword-value format: startAge=<int> endAge=<int> ageInterval=<value> sampleSizePerAge=<int> maxTimeGenes=<int>,sampleNum=<int>";
            int startAge = 0;
            int endAge = 60;
            double ageInterval = 1.0;
            int sampleSizePerAge = 10;
            int maxTimeGenes = 500;
            int sampleNum = 1;
            if (options.containsKey("startAge")) {
                try {
                    startAge = Integer.parseInt(options.get("startAge"));
                }
                catch (NumberFormatException e) {
                    throw new ParameterException("The value for 'startAge' is not a valid integer. " + correctFormat);
                }
            }
            if (options.containsKey("endAge")) {
                try {
                    endAge = Integer.parseInt(options.get("endAge"));
                }
                catch (NumberFormatException e) {
                    throw new ParameterException("The value for 'endAge' is not a valid integer. " + correctFormat);
                }
            }
            if (options.containsKey("ageInterval")) {
                try {
                    ageInterval = Double.parseDouble(options.get("ageInterval"));
                }
                catch (NumberFormatException e) {
                    throw new ParameterException("The value for 'ageInterval' is not a valid number. " + correctFormat);
                }
            }
            if (options.containsKey("sampleSizePerAge")) {
                try {
                    sampleSizePerAge = Integer.parseInt(options.get("sampleSizePerAge"));
                }
                catch (NumberFormatException e) {
                    throw new ParameterException("The value for 'sampleSizePerAge' is not a valid integer. " + correctFormat);
                }
            }
            if (options.containsKey("maxTimingGenes")) {
                try {
                    maxTimeGenes = Integer.parseInt(options.get("maxTimingGenes"));
                }
                catch (NumberFormatException e) {
                    throw new ParameterException("The value for 'maxTimingGenes' is not a valid integer. " + correctFormat);
                }
            }
            if (options.containsKey("sampleNum")) {
                try {
                    sampleNum = Integer.parseInt(options.get("sampleNum"));
                }
                catch (NumberFormatException e) {
                    throw new ParameterException("The value for 'sampleNum' is not a valid integer. " + correctFormat);
                }
            }
            return new TimingGeneSetting(startAge, endAge, ageInterval, sampleSizePerAge, maxTimeGenes, sampleNum);
        }
    }
}

