/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.kgga.io.InputType;
import java.io.File;
import java.util.Map;

public class ToolOptionsSet {
    InputType inputGTYType;
    String appPath;
    String options;

    private ToolOptionsSet(InputType inputGTYType, String options, String appPath) {
        this.options = options;
        this.appPath = appPath;
        this.inputGTYType = inputGTYType;
    }

    public String getAppPath() {
        return this.appPath;
    }

    public String getOptions() {
        return this.options;
    }

    public InputType getInputGTYType() {
        return this.inputGTYType;
    }

    public String toString() {
        return "Value{options=" + this.options + ", path=" + this.appPath + "}";
    }

    public static class Converter
    implements IDynamicConverter<ToolOptionsSet> {
        @Override
        public ToolOptionsSet convert(String name, Map<String, String> options) {
            File filePath;
            String gtyTypeOption = options.get("gtyFormat").trim();
            String appPathOption = options.get("path");
            String plinkOption = options.get("options");
            if (appPathOption != null && !(filePath = new File(appPathOption)).exists()) {
                throw new ParameterException("The plink application by --plink path " + appPathOption + " does not exits.\nPlease download it from  https://www.cog-genomics.org/plink/2.0/ and put it under " + filePath.getParentFile());
            }
            if (plinkOption != null) {
                plinkOption = plinkOption.trim();
            }
            return new ToolOptionsSet(InputType.valueOf(gtyTypeOption), plinkOption, appPathOption);
        }
    }
}

