/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalTree;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.RefGenomeVersion;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.text.reader.CustomSeparator;
import edu.sysu.pmglab.kgga.io.InputType;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.NoSuchElementException;

public class VariantFileMeta {
    public List<LiveFile> inputFiles;
    public final InputType type;
    public final RefGenomeVersion refG;
    public GTBManager finalGTBManager = null;
    public String finalFileName = null;
    private IndexableSet<String> individualUIDs;
    public Map<Chromosome, IntIntervalTree<Void>> excludedRegions;
    public Map<Chromosome, IntIntervalTree<Void>> includedRegions;

    private VariantFileMeta(List<LiveFile> inputFiles, InputType type, RefGenomeVersion refG, String finalFileName) {
        this.inputFiles = inputFiles.asUnmodifiable();
        this.type = type;
        this.refG = refG;
        File file = new File(finalFileName);
        file = FileUtils.changeExtension(file, ".gtb", ".vcf", ".gz", ".bgz", ".vcf.gz", ".vcf.bgz");
        this.finalFileName = file.getName();
    }

    public VariantFileMeta noInputFileClone(LiveFile inputFile) throws IOException {
        VariantFileMeta meta = new VariantFileMeta(inputFile, this.type, this.refG, null, this.includedRegions, this.excludedRegions);
        if (this.type == InputType.GTB) {
            meta.finalGTBManager = new GTBManager(inputFile);
            meta.individualUIDs = meta.finalGTBManager.getIndividuals();
        }
        return meta;
    }

    public VariantFileMeta(GTBManager finalGTBManager, InputType type, RefGenomeVersion refG, String finalFileName, Map<Chromosome, IntIntervalTree<Void>> includedRegions, Map<Chromosome, IntIntervalTree<Void>> excludedRegions) {
        this.finalGTBManager = finalGTBManager;
        this.individualUIDs = finalGTBManager.getIndividuals();
        this.type = type;
        this.refG = refG;
        File file = new File(finalFileName);
        file = FileUtils.changeExtension(file, ".gtb", ".vcf", ".gz", ".bgz", ".vcf.gz", ".vcf.bgz");
        this.finalFileName = file.getName();
        this.includedRegions = includedRegions;
        this.excludedRegions = excludedRegions;
    }

    public VariantFileMeta(GTBManager finalGTBManager, InputType type, RefGenomeVersion refG) {
        this.finalGTBManager = finalGTBManager;
        this.individualUIDs = finalGTBManager.getIndividuals();
        this.type = type;
        this.refG = refG;
    }

    public VariantFileMeta(LiveFile inputFiles, InputType type, RefGenomeVersion refG, String finalFileName, Map<Chromosome, IntIntervalTree<Void>> includedRegions, Map<Chromosome, IntIntervalTree<Void>> excludedRegions) throws IOException {
        this.inputFiles = List.wrap(new LiveFile[]{inputFiles}).asUnmodifiable();
        this.type = type;
        this.refG = refG;
        this.includedRegions = includedRegions;
        this.excludedRegions = excludedRegions;
        if (finalFileName != null) {
            File file = new File(finalFileName);
            file = FileUtils.changeExtension(file, ".gtb", ".vcf", ".gz", ".bgz", ".vcf.gz", ".vcf.bgz");
            this.finalFileName = file.getName();
            if (finalFileName.endsWith(".gtb")) {
                this.finalGTBManager = new GTBManager(finalFileName);
            }
        }
    }

    public VariantFileMeta(String inputFilePath, InputType type, RefGenomeVersion refG) throws IOException {
        LiveFile inputFile = LiveFile.of(inputFilePath);
        this.inputFiles = List.wrap(new LiveFile[]{inputFile}).asUnmodifiable();
        this.type = type;
        this.refG = refG;
        File file = new File(inputFile.getName());
        file = FileUtils.changeExtension(file, ".gtb", ".vcf", ".gz", ".bgz", ".vcf.gz", ".vcf.bgz");
        this.finalFileName = file.getName();
    }

    public VariantFileMeta(File inputFiles, InputType type, RefGenomeVersion refG) throws IOException {
        this.inputFiles = List.wrap(new LiveFile[]{LiveFile.of(inputFiles)}).asUnmodifiable();
        this.type = type;
        this.refG = refG;
    }

    public int hashCode() {
        String region = this.excludedRegions == null ? "." : this.excludedRegions.toString();
        region = region + (this.includedRegions == null ? "." : this.includedRegions.toString());
        if (this.inputFiles != null) {
            return this.inputFiles.hashCode() + this.refG.toString().hashCode() + region.hashCode();
        }
        return this.finalGTBManager.hashCode() + this.refG.toString().hashCode() + region.hashCode();
    }

    public boolean equals(Object obj) {
        return this.inputFiles.equals(obj);
    }

    public VariantFileMeta set(GTBManager manager) {
        if (this.finalGTBManager != null) {
            throw new IllegalStateException();
        }
        this.finalGTBManager = manager;
        this.individualUIDs = this.finalGTBManager.getIndividuals();
        return this;
    }

    public GTBManager getGTB() {
        return this.finalGTBManager;
    }

    public IndexableSet<String> getIndividualUIDs() {
        return this.individualUIDs;
    }

    public static class Converter
    implements IDynamicConverter<VariantFileMeta> {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public VariantFileMeta convert(String name, Map<String, String> options) {
            InputType type;
            String fileName = options.get("file");
            String inputTypeOption = options.get("type").toUpperCase();
            String refGStr = options.get("refG").toLowerCase();
            String excludeOption = options.get("exclude");
            String includeOption = options.get("include");
            if ("AUTO".equals(inputTypeOption)) {
                if (FileUtils.withExtension(fileName, "gtb")) {
                    type = InputType.GTB;
                } else if (FileUtils.withExtension(fileName, "vcf", "vcf.gz", "vcf.bgz")) {
                    type = InputType.VCF;
                } else {
                    if (!FileUtils.withExtension(fileName, "maf", "maf.gz", "maf.bgz")) throw new ParameterException("Invalid parameter \"" + name + "\": cannot get file type from " + inputTypeOption);
                    type = InputType.MAF;
                }
            } else {
                try {
                    type = InputType.valueOf(inputTypeOption);
                }
                catch (NoSuchElementException e) {
                    throw new ParameterException("Invalid parameter \"" + name + "\": cannot get file type from " + inputTypeOption);
                }
            }
            RefGenomeVersion refG = RefGenomeVersion.valueOf(refGStr);
            Map<Chromosome, IntIntervalTree<Void>> excludedRegions = null;
            if (excludeOption != null && !excludeOption.trim().isEmpty()) {
                excludedRegions = this.parseRegions(excludeOption);
            }
            Map<Chromosome, IntIntervalTree<Void>> includedRegions = null;
            if (includeOption != null && !includeOption.trim().isEmpty()) {
                includedRegions = this.parseRegions(includeOption);
            }
            try {
                if (!fileName.contains("*")) return new VariantFileMeta(LiveFile.of(fileName), type, refG, fileName, includedRegions, excludedRegions);
                List<LiveFile> paths = new List<LiveFile>();
                for (Chromosome chromosome : Chromosome.values()) {
                    try {
                        String filePath = fileName.replace("*", chromosome.getName());
                        if (!LiveFile.exists(filePath)) continue;
                        paths.add(LiveFile.of(filePath));
                    }
                    catch (IOException iOException) {}
                }
                if (!paths.isEmpty()) return new VariantFileMeta(paths, type, refG, fileName.replace("*", "ALL"));
                throw new ParameterException("Invalid parameter \"" + name + "\": cannot access any file matched '" + fileName + "'");
            }
            catch (IOException e) {
                throw new ParameterException("Invalid parameter \"" + name + "\": cannot get file object from " + options.get("file"));
            }
        }

        private Map<Chromosome, IntIntervalTree<Void>> parseRegions(String excludeOption) {
            THashMap<Chromosome, IntIntervalTree<Void>> excludedRegions = new THashMap<Chromosome, IntIntervalTree<Void>>();
            THashMap excludedRegionsBuilder = new THashMap();
            CustomSeparator sep1 = new CustomSeparator("{}:{}");
            for (String region : excludeOption.split(";")) {
                List<Object> results;
                if (!region.contains(":")) {
                    results = new List();
                    results.add(new Bytes(region));
                    results.add(new Bytes("0~2147483647"));
                } else {
                    results = sep1.accept(region);
                }
                Chromosome chromosome = Chromosome.get(((Bytes)results.get(0)).toString());
                if (!excludedRegionsBuilder.containsKey(chromosome)) {
                    excludedRegionsBuilder.put(chromosome, new IntIntervalTree.Builder());
                }
                for (String posPair : ((Bytes)results.get(1)).toString().split(",")) {
                    if (posPair.contains("~")) {
                        IntInterval interval = (IntInterval)FieldType.intInterval.char2Object(posPair);
                        ((IntIntervalTree.Builder)excludedRegionsBuilder.get(chromosome)).add(interval, null);
                        continue;
                    }
                    int pos = (Integer)FieldType.varInt32.char2Object(posPair);
                    ((IntIntervalTree.Builder)excludedRegionsBuilder.get(chromosome)).add(pos, pos, null);
                }
            }
            for (Chromosome chromosome : excludedRegionsBuilder.keySet()) {
                excludedRegions.put(chromosome, ((IntIntervalTree.Builder)excludedRegionsBuilder.get(chromosome)).build());
            }
            return excludedRegions;
        }
    }
}

