/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import java.util.Map;
import java.util.Objects;

public class XqtlGeneSetting {
    int maxNum;
    double effectScale;
    double heritability;

    public XqtlGeneSetting() {
        this.maxNum = 5;
        this.effectScale = 0.5;
        this.heritability = 0.25;
    }

    public XqtlGeneSetting(int maxNum, double effectScale, double heritability) {
        this.maxNum = maxNum;
        this.effectScale = effectScale;
        this.heritability = heritability;
    }

    public int getMaxNum() {
        return this.maxNum;
    }

    public double getEffectScale() {
        return this.effectScale;
    }

    public double getHeritability() {
        return this.heritability;
    }

    public String toString() {
        return "XqtlGeneSetting{maxQTLNum=" + this.maxNum + ", effectScale=" + this.effectScale + ", heritability=" + this.heritability + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XqtlGeneSetting that = (XqtlGeneSetting)o;
        return this.maxNum == that.maxNum && Double.compare(that.effectScale, this.effectScale) == 0 && Double.compare(that.heritability, this.heritability) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.maxNum, this.effectScale, this.heritability);
    }

    public static class Converter
    implements IDynamicConverter<XqtlGeneSetting> {
        @Override
        public XqtlGeneSetting convert(String name, Map<String, String> options) {
            String correctFormat = "Argument of " + name + " follows keyword-value format: maxQTLNum=<integer> effectScale=<value> heritability=<value>";
            int maxNum = 5;
            double effectScale = 0.5;
            double heritability = 0.25;
            if (options.containsKey("maxQTLNum")) {
                try {
                    maxNum = Integer.parseInt(options.get("maxQTLNum"));
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new ParameterException("The value for 'maxQTLNum' is not a valid integer. " + correctFormat);
                }
            }
            if (options.containsKey("effectScale")) {
                try {
                    effectScale = Double.parseDouble(options.get("effectScale"));
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new ParameterException("The value for 'effectScale' is not a valid number. " + correctFormat);
                }
            }
            if (options.containsKey("heritability")) {
                try {
                    heritability = Double.parseDouble(options.get("heritability"));
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new ParameterException("The value for 'heritability' is not a valid number. " + correctFormat);
                }
            }
            return new XqtlGeneSetting(maxNum, effectScale, heritability);
        }
    }
}

