/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import cern.colt.list.DoubleArrayList;
import edu.sysu.pmglab.ccf.CCFReader;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.ReaderOption;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.indexer.intvalue.CCFIntIndexer;
import edu.sysu.pmglab.ccf.indexer.intvalue.RefinedIntBuckets;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.converter.Variant2Variant;
import edu.sysu.pmglab.ccf.toolkit.input.GTBInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputOutputListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.array.FloatArray;
import edu.sysu.pmglab.container.interval.FloatInterval;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.list.ShortList;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.ThreadQueue;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReader;
import edu.sysu.pmglab.gtb.GTBWriter;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationOptions;
import edu.sysu.pmglab.kgga.command.setting.AFGRESetting;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import edu.sysu.pmglab.progressbar.ProgressBar;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class AFGRETask
implements ITask {
    final File outputFile;
    File weightDatabasePath;
    boolean updatedRefGeneSet;
    String[] scoredFields;
    int[] priorConstants;
    String[] freqFields4Filtration;
    int threadNum;
    AnnotationOptions annotationOptions;

    public AFGRETask(AnnotationOptions annotationOptions, File outputDir, File weightDatabasePath, boolean updatedRefGeneSet, AFGRESetting afgre, String[] freqFields4Filtration, boolean makeDir, int threadNum) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.weightDatabasePath = weightDatabasePath;
        this.updatedRefGeneSet = updatedRefGeneSet;
        this.scoredFields = afgre.getFields();
        this.priorConstants = afgre.getCs();
        this.freqFields4Filtration = freqFields4Filtration;
        this.outputFile = FileUtils.getSubFile(outputDir, InputOutputFileSet.getAnnotationFileName());
        this.threadNum = threadNum;
        this.annotationOptions = annotationOptions;
    }

    private DoubleArrayList[] extractWeightScores() throws IOException {
        IRecord record;
        DoubleArrayList[] scoresForWeight = new DoubleArrayList[this.scoredFields.length];
        for (int i = 0; i < scoresForWeight.length; ++i) {
            scoresForWeight[i] = new DoubleArrayList();
        }
        CCFReader reader1 = new CCFReader(new CCFTable(this.weightDatabasePath));
        reader1.getReaderOption().addFields(this.scoredFields);
        float[][] values1 = new float[this.scoredFields.length][];
        while ((record = reader1.read()) != null) {
            for (int j = 0; j < this.scoredFields.length; ++j) {
                values1[j] = (float[])record.get(this.scoredFields[j]);
                int unit = values1[j].length / (this.priorConstants.length + 1);
                for (int i = 0; i < unit; ++i) {
                    if (Float.isNaN(values1[j][i])) continue;
                    scoresForWeight[j].add(values1[j][i]);
                }
            }
        }
        reader1.close();
        for (DoubleArrayList doubleArrayList : scoresForWeight) {
            doubleArrayList.sort();
        }
        return scoresForWeight;
    }

    public void generateCombinedAFGREIndividualScores(Status status, Context context) throws IOException {
        boolean needRedo;
        ITrack track = context.getTracker();
        File inputFile = (File)context.cast("AnnotationBaseVariantSet");
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        if (updatedVariantSet == null) {
            updatedVariantSet = false;
        }
        String[] scoreFieldNames = new String[this.scoredFields.length];
        FieldMeta[] mutationWeightScales = new FieldMeta[this.priorConstants.length * this.scoredFields.length];
        THashMap<String, String[]> groupedAFGREFieldMap = new THashMap<String, String[]>();
        for (int t = 0; t < this.priorConstants.length; ++t) {
            String[] fieldNames = new String[this.scoredFields.length];
            for (int j = 0; j < this.scoredFields.length; ++j) {
                int index0 = this.scoredFields[j].indexOf("@");
                scoreFieldNames[j] = this.scoredFields[j].substring(index0 + 1);
                mutationWeightScales[t + j * this.priorConstants.length] = FieldMeta.of("AFGRE@C" + this.priorConstants[t] + scoreFieldNames[j], FieldType.float32);
                fieldNames[j] = mutationWeightScales[t + j * this.priorConstants.length].fullName();
            }
            groupedAFGREFieldMap.put("scale" + this.priorConstants[t], fieldNames);
        }
        context.put("GroupedAFGREFieldMapForCombine", groupedAFGREFieldMap);
        String code = this.digest(inputFile, this.outputFile);
        boolean contain = track.contains(code);
        boolean bl = needRedo = updatedVariantSet != false || this.updatedRefGeneSet || !this.outputFile.exists() || !contain;
        if (needRedo) {
            SetupApplication.GlobalLogger.info("Recalibrate variant scores by AFGREs ...");
            CCFIntIndexer<Chromosome> chromIndexers = GTBIndexer.setInput(this.weightDatabasePath, "Basic@Chromosome").getChromosomeFrom(record -> (Chromosome)record.get(0)).getPositionFrom(record -> 0).build(this.threadNum);
            GTBManager manager = new GTBManager(inputFile);
            CCFIntIndexer<Chromosome> chromosomeTree = manager.getIndexer(true, null);
            ThreadQueue threadPool = new ThreadQueue(this.threadNum);
            ProgressBar progressBar = new ProgressBar.Builder().setTextRenderer("Processed", "variants").setInitialMax(manager.numOfVariants()).build();
            FloatInterval mafCut = this.annotationOptions.dbMaf;
            FloatInterval altFreqCut = this.annotationOptions.dbAf;
            boolean[] includeFreqCutZero = new boolean[]{false, false};
            boolean needFilterByFreq = false;
            if (mafCut != null && mafCut.start() == 0.0f) {
                includeFreqCutZero[0] = true;
            }
            if (altFreqCut != null && altFreqCut.start() == 0.0f) {
                includeFreqCutZero[1] = true;
            }
            if (this.freqFields4Filtration != null) {
                needFilterByFreq = true;
            }
            List<File> chromosomeFiles = new List<File>();
            for (Chromosome curChromosome : chromosomeTree.getTags()) {
                IRecord record2;
                RefinedIntBuckets buckets = chromosomeTree.getTag(curChromosome);
                if (buckets == null) continue;
                GTBReader readerRoot = new GTBReader(manager);
                readerRoot.limit(buckets.getRecordIndexRange());
                readerRoot.seek(0L);
                List<String> neededFields = new List<String>();
                neededFields.add("Basic@SymbolID");
                neededFields.add("Basic@GeneSubRegionTypeID");
                neededFields.addAll(this.scoredFields);
                ReaderOption readerOption = (ReaderOption)new ReaderOption(this.weightDatabasePath, new String[0]).addFields(neededFields);
                CCFReader reader = new CCFReader(readerOption);
                RefinedIntBuckets databaseIndexer = chromIndexers.getTag(curChromosome);
                if (databaseIndexer == null) continue;
                reader.limit(databaseIndexer.getMinPointer(), databaseIndexer.getMaxPointer() + 1L);
                THashMap<String, FloatArray[]> geneRegionValues = new THashMap<String, FloatArray[]>();
                while ((record2 = reader.read()) != null) {
                    String geneRegion = record2.get("Basic@SymbolID") + "#" + record2.get("Basic@GeneSubRegionTypeID");
                    FloatArray[] values2 = new FloatArray[this.scoredFields.length];
                    for (int j = 0; j < this.scoredFields.length; ++j) {
                        values2[j] = (FloatArray)record2.get(this.scoredFields[j]);
                    }
                    if (geneRegionValues.containsKey(geneRegion)) {
                        SetupApplication.GlobalLogger.warn("The gene-region ID ({}) is not unique!", (Object)geneRegion);
                        continue;
                    }
                    geneRegionValues.put(geneRegion, values2);
                }
                reader.close();
                List<GTBReader> partReaders = readerRoot.part(this.threadNum);
                this.threadNum = partReaders.size();
                GTBWriter writer = GTBWriter.setOutput(new File(this.outputFile + "_chr" + curChromosome + ".gtb")).addFields(manager.getAllFields()).addFields(List.wrap(mutationWeightScales)).instance(this.threadNum).addMeta(readerRoot.getManager().getMeta());
                int k = 0;
                while (k < this.threadNum) {
                    boolean finalNeedFilterByFreq = needFilterByFreq;
                    int finalK = k++;
                    threadPool.addTask((status1, context1) -> {
                        try {
                            Variant var;
                            GTBReader partReader = (GTBReader)partReaders.get(finalK);
                            int scoreNum = this.scoredFields.length;
                            float[][] weights = new float[scoreNum][this.priorConstants.length];
                            int nonNANum = 0;
                            block2: while ((var = partReader.read()) != null) {
                                int i;
                                progressBar.step(1L);
                                IntList geneIDs = (IntList)var.getProperty("GeneFeature@HitGenes");
                                ShortList regionTypeIDs = (ShortList)var.getProperty("GeneFeature@HitGeneRegionTypes");
                                if (geneIDs == null || geneIDs.isEmpty()) continue;
                                if (finalNeedFilterByFreq) {
                                    boolean invalid = false;
                                    for (String freqFieldName : this.freqFields4Filtration) {
                                        float curFreq = ((Float)var.getProperty(freqFieldName)).floatValue();
                                        if (Float.isNaN(curFreq)) {
                                            if (includeFreqCutZero[0] || includeFreqCutZero[1]) continue;
                                            invalid = true;
                                            break;
                                        }
                                        if (mafCut != null && !mafCut.contains(curFreq, true)) {
                                            invalid = true;
                                            break;
                                        }
                                        if (altFreqCut == null || altFreqCut.contains(curFreq, true)) continue;
                                        invalid = true;
                                        break;
                                    }
                                    if (invalid) continue;
                                }
                                nonNANum = 0;
                                for (i = 0; i < scoreNum; ++i) {
                                    Arrays.fill(weights[i], Float.NaN);
                                }
                                int size1 = geneIDs.size();
                                for (i = 0; i < size1; ++i) {
                                    String label = geneIDs.fastGet(i) + "#" + regionTypeIDs.fastGet(i);
                                    FloatArray[] scoreWeightMatrix = (FloatArray[])geneRegionValues.get(label);
                                    if (scoreWeightMatrix == null) continue;
                                    for (int j = 0; j < scoreNum; ++j) {
                                        float varScore;
                                        String fieldName = this.scoredFields[j];
                                        FloatArray scoreWeights = scoreWeightMatrix[j];
                                        if (scoreWeights == null || scoreWeights.length() == 0 || Float.isNaN(varScore = ((Float)var.getProperty(fieldName)).floatValue())) continue;
                                        int unit = scoreWeights.length() / (this.priorConstants.length + 1);
                                        double diff = 1.0;
                                        int index = Arrays.binarySearch(scoreWeights.getData(), 0, unit, varScore);
                                        if (index < 0) {
                                            if ((index = -index - 1) >= unit) {
                                                index = unit - 1;
                                            }
                                            diff = scoreWeights.get(index) == 0.0f ? 100000.0 : (double)(varScore / scoreWeights.get(index));
                                        }
                                        while (index < unit - 2 && scoreWeights.get(index + 1) <= varScore) {
                                            ++index;
                                        }
                                        for (int t = 0; t < this.priorConstants.length; ++t) {
                                            if (Float.isNaN(weights[j][t])) {
                                                weights[j][t] = 0.0f;
                                            }
                                            weights[j][t] = scoreWeights.get(index + (t + 1) * unit);
                                            float[] fArray = weights[j];
                                            int n = t;
                                            fArray[n] = fArray[n] * varScore;
                                            weights[j][t] = (float)((double)weights[j][t] * diff);
                                            if (!(weights[j][t] > 1.0f)) continue;
                                            weights[j][t] = 1.0f;
                                        }
                                        ++nonNANum;
                                    }
                                    if (nonNANum > 0) {
                                        for (int t = 0; t < this.priorConstants.length; ++t) {
                                            for (int j = 0; j < scoreNum; ++j) {
                                                float weight = Float.NaN;
                                                if (!Float.isNaN(weights[j][t])) {
                                                    weight = weights[j][t];
                                                }
                                                var.setProperty("AFGRE@C" + this.priorConstants[t] + scoreFieldNames[j], Float.valueOf(weight));
                                            }
                                        }
                                    } else {
                                        for (FieldMeta mutationWeightScale : mutationWeightScales) {
                                            var.setProperty(mutationWeightScale.fullName(), Float.valueOf(Float.NaN));
                                        }
                                    }
                                    writer.write(finalK, var);
                                    continue block2;
                                }
                            }
                            partReader.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                }
                threadPool.await();
                partReaders.close();
                writer.close();
                chromosomeFiles.add(writer.getFile());
            }
            threadPool.close();
            progressBar.close();
            Processor.setInputs(chromosomeFiles.apply(file -> {
                try {
                    return new GTBInputOption((File)file);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            })).setOutput(new GTBOutputOption(this.outputFile).addFields(manager.getAllFields()).addFields(List.wrap(mutationWeightScales)), (inputs, output) -> {
                output.addFields(((GTBInputOption)inputs.fastGet(0)).getAllFields());
                output.addMeta(((GTBInputOption)inputs.fastGet(0)).getMeta());
            }).bridge(new Variant2Variant()).setListener(new InputOutputListener()).submit(this.threadNum);
            for (File file2 : chromosomeFiles) {
                file2.delete();
            }
            SetupApplication.GlobalLogger.info("{} variants are prioritized by AFGRE.", (Object)manager.numOfVariants());
            code = this.digest(inputFile, this.outputFile);
            track.add(this.getClass().getName(), code);
            context.put("UpdatedBaseVariantSet", true);
        } else {
            SetupApplication.GlobalLogger.info("{} variants are prioritized by AFGRE.", (Object)new GTBManager(this.outputFile).numOfVariants());
            context.put("UpdatedBaseVariantSet", false);
        }
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        this.generateCombinedAFGREIndividualScores(status, context);
        context.put("AnnotationBaseVariantSet", this.outputFile);
    }

    public String digest(File inputFile, File outputFile) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int priorConstant : this.priorConstants) {
            sb.append(priorConstant);
            sb.append(",");
        }
        for (String str : this.scoredFields) {
            sb.append(str);
            sb.append(",");
        }
        sb.append(inputFile.getCanonicalPath()).append("|").append(inputFile.length()).append("|").append(inputFile.lastModified()).append("|").append(outputFile.getCanonicalPath()).append("|").append(outputFile.length()).append("|").append(outputFile.lastModified()).append("|").append(this.weightDatabasePath.getCanonicalPath()).append("|").append(this.weightDatabasePath.length()).append("|").append(this.weightDatabasePath.lastModified()).append("|");
        return ITrack.digest(sb.toString());
    }

    public static void main(String[] args) throws IOException {
    }
}

