/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.annotator.SequentialDatabase;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.toolkit.GTBAnnotator;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.TaskTracker;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import java.io.File;
import java.io.IOException;
import java.util.Optional;

public class AdjustPopulationAlleleFreqTask
implements ITask {
    File outputFile;
    final FieldMeta AdjustedAlleleFreqMeta = FieldMeta.of("GTYSUM", "ADJ_FREQ", FieldType.float32);
    final FieldMeta AdjustedAlleleCountCase = FieldMeta.of("GTYSUM", "ADJ_ALT_CASE", FieldType.float32);
    final FieldMeta AlleleCountCaseDataBase = FieldMeta.of("GTYSUM", "DATA_BASE_CASE", FieldType.float32);
    final List<String> selectedFreqFields;
    final boolean accurate = false;
    List<String> selectedACFields;
    List<String> selectedANFields;
    GeneralIOOptions generalIOOptions;

    public AdjustPopulationAlleleFreqTask(File outputDir, boolean makeDir, List<String> selectedFreqFields) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFile = FileUtils.getSubFile(outputDir, InputOutputFileSet.getAnnotationFileName());
        this.selectedFreqFields = selectedFreqFields;
    }

    public AdjustPopulationAlleleFreqTask(GeneralIOOptions generalIOOptions, File outputDir, boolean makeDir, List<String> selectedFreqFields) {
        this.generalIOOptions = generalIOOptions;
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFile = FileUtils.getSubFile(outputDir, InputOutputFileSet.getAnnotationFileName());
        this.selectedFreqFields = selectedFreqFields;
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        if (updatedVariantSet == null) {
            updatedVariantSet = false;
        }
        GTBManager inputManager = new GTBManager((File)context.cast("AnnotationBaseVariantSet"));
        final String COUNT_ALT_CONTROL = (String)context.cast("ControlMutationCount");
        final String COUNT_ALT_CASE = (String)context.cast("CaseMutationCount");
        context.put("AdjustedFreq", "GTYSUM@ADJ_FREQ");
        context.put("AdjustedAC", "GTYSUM@ADJ_ALT_CASE");
        context.put("DataBaseAC", "GTYSUM@DATA_BASE_CASE");
        TaskTracker.TaskResult completeTaskResult = new TaskTracker.TaskResult(this.getClass().getName(), String.valueOf(inputManager.hashCode()), this.digest());
        Optional<File> outputPathOpt = SetupApplication.GlobalTaskTracker.checkTask(completeTaskResult);
        outputPathOpt.ifPresent(file -> {
            this.outputFile = file;
        });
        boolean contain = outputPathOpt.isPresent();
        if (updatedVariantSet.booleanValue() || !this.outputFile.exists() || !contain) {
            final double thetaVariance = (Double)context.cast("ThetaVariance");
            final int controlNum = (Integer)context.cast("ControlSubjectNum");
            final int caseNum = (Integer)context.cast("CaseSubjectNum");
            GTBAnnotator.setInput(new GTBReaderOption(inputManager.getFile())).setOutput(this.outputFile).addMeta(inputManager.getMeta()).addDatabase(new SequentialDatabase<Variant>(){
                final FieldGroupMeta fields;
                {
                    this.fields = new FieldGroupMeta("GTYSUM").addField(AdjustPopulationAlleleFreqTask.this.AdjustedAlleleFreqMeta).addField(AdjustPopulationAlleleFreqTask.this.AdjustedAlleleCountCase).addField(AdjustPopulationAlleleFreqTask.this.AlleleCountCaseDataBase).asUnmodifiable();
                }

                @Override
                public IFieldCollection getAllFields() {
                    return this.fields;
                }

                public int getACorANInDatabase(Variant variant, List<String> selectedFields) {
                    if (variant == null || selectedFields == null || selectedFields.isEmpty()) {
                        return Integer.parseInt(null);
                    }
                    int ac_an = 0;
                    for (String meta : selectedFields) {
                        Object value = variant.getProperty(meta);
                        if (!(value instanceof Number)) continue;
                        int tmp = ((Number)value).intValue();
                        ac_an += tmp;
                    }
                    return ac_an;
                }

                public float getAccurateAdjustedAF(int acDatabase, int anDatabase, int acControl, int anControl, double thetaVariance2, float caseAF) {
                    if (acDatabase == 0 || anDatabase == 0 || acControl == 0 || anControl == 0) {
                        return 0.0f;
                    }
                    float controlAF = (float)acControl / (float)anControl;
                    float popAF = (float)acDatabase / (float)anDatabase;
                    double mixedAF = (float)(2 * anControl) / ((float)(anControl + anDatabase) * controlAF) + (float)(2 * anDatabase) / ((float)(anControl + anDatabase) * popAF);
                    double betaInter = Math.log(caseAF * (1.0f - controlAF) / (controlAF * (1.0f - caseAF)));
                    double betaMix = Math.log((double)caseAF * (1.0 - mixedAF) / (mixedAF * (double)(1.0f - caseAF)));
                    double theta = betaMix - betaInter;
                    double tau = Math.pow(theta, 2.0) / (Math.pow(theta, 2.0) + thetaVariance2);
                    double adjustedRatio = Math.exp((1.0 - tau) * betaMix + tau * betaInter);
                    return (float)((double)caseAF / (adjustedRatio + (1.0 - adjustedRatio) * (double)caseAF));
                }

                public float getPopAF(Variant variant, List<String> selectedFreqField) {
                    if (variant == null || selectedFreqField == null || selectedFreqField.isEmpty()) {
                        return Float.NaN;
                    }
                    float afSum = 0.0f;
                    int count = 0;
                    for (String meta : selectedFreqField) {
                        float tmpAF;
                        Object value = variant.getProperty(meta);
                        if (!(value instanceof Number) || Float.isNaN(tmpAF = ((Number)value).floatValue())) continue;
                        afSum += tmpAF;
                        ++count;
                    }
                    if (count == 0) {
                        return Float.NaN;
                    }
                    return afSum / (float)count;
                }

                public float getAdjustedAF(float caseAF, float controlAF, float popAF, double thetaVariance2) {
                    if (controlAF == 0.0f || popAF == 0.0f) {
                        return 0.0f;
                    }
                    if (caseAF == 0.0f || Float.isNaN(caseAF)) {
                        return popAF;
                    }
                    double mixedAF = (controlAF + popAF) / 2.0f;
                    double betaInter = Math.log(caseAF * (1.0f - controlAF) / (controlAF * (1.0f - caseAF)));
                    double betaMix = Math.log((double)caseAF * (1.0 - mixedAF) / (mixedAF * (double)(1.0f - caseAF)));
                    double theta = betaMix - betaInter;
                    double tau = Math.pow(theta, 2.0) / (Math.pow(theta, 2.0) + thetaVariance2);
                    double adjustedRatio = Math.exp((1.0 - tau) * betaMix + tau * betaInter);
                    return (float)((double)caseAF / (adjustedRatio + (1.0 - adjustedRatio) * (double)caseAF));
                }

                @Override
                public boolean annotate(List<BoxRecord> resources, long pointer, Variant variant) {
                    int caseCount = variant.getProperty(COUNT_ALT_CASE) == null ? 0 : ((Number)variant.getProperty(COUNT_ALT_CASE)).intValue();
                    int controlCount = variant.getProperty(COUNT_ALT_CONTROL) == null ? 0 : ((Number)variant.getProperty(COUNT_ALT_CONTROL)).intValue();
                    float tmpPopAf = this.getPopAF(variant, AdjustPopulationAlleleFreqTask.this.selectedFreqFields);
                    float caseAF = (float)caseCount / (float)(caseNum * 2);
                    float controlAF = (float)controlCount / (float)(controlNum * 2);
                    float popAF = Float.isNaN(tmpPopAf) ? 0.0f : tmpPopAf;
                    variant.setProperty(AdjustPopulationAlleleFreqTask.this.AlleleCountCaseDataBase.fullName(), Float.valueOf(popAF * (float)caseNum * 2.0f));
                    if (controlAF == 0.0f) {
                        variant.setProperty(AdjustPopulationAlleleFreqTask.this.AdjustedAlleleFreqMeta.fullName(), Float.valueOf(popAF));
                        variant.setProperty(AdjustPopulationAlleleFreqTask.this.AdjustedAlleleCountCase.fullName(), Float.valueOf(popAF * (float)caseNum * 2.0f));
                        return true;
                    }
                    if (popAF == 0.0f) {
                        variant.setProperty(AdjustPopulationAlleleFreqTask.this.AdjustedAlleleFreqMeta.fullName(), Float.valueOf(controlAF));
                        variant.setProperty(AdjustPopulationAlleleFreqTask.this.AdjustedAlleleCountCase.fullName(), Float.valueOf(controlAF * (float)caseNum * 2.0f));
                        return true;
                    }
                    float adjustedAF = this.getAdjustedAF(caseAF, controlAF, popAF, thetaVariance);
                    variant.setProperty(AdjustPopulationAlleleFreqTask.this.AdjustedAlleleFreqMeta.fullName(), Float.valueOf(adjustedAF));
                    variant.setProperty(AdjustPopulationAlleleFreqTask.this.AdjustedAlleleCountCase.fullName(), Float.valueOf(adjustedAF * (float)caseNum * 2.0f));
                    return true;
                }
            }).submit(this.generalIOOptions.threads);
            completeTaskResult.setOutputPath(this.outputFile);
            SetupApplication.GlobalTaskTracker.recordTaskCompletion(completeTaskResult);
            context.put("UpdatedBaseVariantSet", true);
        } else {
            context.put("UpdatedBaseVariantSet", false);
        }
        context.put("AnnotationBaseVariantSet", this.outputFile);
    }

    private String digest() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.selectedFreqFields.toString(","));
        return ITrack.digest(sb.toString());
    }
}

