/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.loader.OptionCodec;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.CCFOptions;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.annotator.PointerDatabase;
import edu.sysu.pmglab.ccf.toolkit.listener.AnnotationListener;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.toolkit.GTBAnnotator;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.IReaderStream;
import edu.sysu.pmglab.io.reader.ReaderStream;
import edu.sysu.pmglab.io.writer.ChannelAppendStream;
import edu.sysu.pmglab.io.writer.IWriterStream;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.TaskTracker;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.io.GlobalPedIndividuals;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import edu.sysu.pmglab.progressbar.ProgressBar;
import edu.sysu.pmglab.progressbar.unit.DataLengthUnit;
import edu.sysu.pmglab.stat.GenotypeCounter;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class AppendMutationSubjectIDTask
implements ITask {
    File outputFile;
    final FieldMeta COUNT_ALT_CASE_SubID = FieldMeta.of("GTYSUM@COUNT_ALT_CASE_SubID", FieldType.int32List);
    final FieldMeta COUNT_ALT_CASE = FieldMeta.of("GTYSUM@COUNT_ALT_CASE", FieldType.varInt32);
    GeneralIOOptions generalIOOptions;
    boolean adjustAF;
    final FieldMeta COUNT_ALT_CONTROL_SubID = FieldMeta.of("GTYSUM@COUNT_ALT_CONTROL_SubID", FieldType.int32List);
    final FieldMeta COUNT_ALT_CONTROL = FieldMeta.of("GTYSUM@COUNT_ALT_CONTROL", FieldType.varInt32);
    final FieldMeta SWITCH_FLAG = FieldMeta.of("GTYSUM@SWITCH_FLAG", FieldType.bool);
    List<String> selectedFreqFields;
    boolean accurate = false;
    List<String> selectedACFields = new List();
    List<String> selectedANFields = new List();
    private static ThreadLocal<BetaCalculator> betaCalculatorThreadLocal = null;
    private static AtomicInteger integer = new AtomicInteger(0);
    boolean useMAFAllele = true;

    public static void calculateTheta(float caseAF, float controlAF, float popAF, AtomicReference<Double> variance) {
        BetaCalculator betaCalculator = betaCalculatorThreadLocal.get();
        if (controlAF * popAF == 0.0f || Float.isNaN(popAF * controlAF) || caseAF == 0.0f || caseAF == 1.0f || controlAF == 1.0f) {
            integer.getAndAdd(1);
            return;
        }
        double mixedAF = (controlAF + popAF) / 2.0f;
        double betaInter = Math.log(caseAF * (1.0f - controlAF) / (controlAF * (1.0f - caseAF)));
        double betaMix = Math.log((double)caseAF * (1.0 - mixedAF) / (mixedAF * (double)(1.0f - caseAF)));
        if (Double.isInfinite(betaInter) || Double.isInfinite(betaMix)) {
            integer.getAndAdd(1);
            return;
        }
        betaCalculator.setTheta(betaMix - betaInter);
        betaCalculator.calculateThetaVariance(variance);
    }

    public static void calculateTheta(float caseAF, int acDatabase, int anDatabase, int acControl, int anControl, AtomicReference<Double> variance) {
        BetaCalculator betaCalculator = betaCalculatorThreadLocal.get();
        if (acDatabase == 0 || anDatabase == 0 || acControl == 0 || anControl == 0) {
            return;
        }
        float controlAF = (float)acControl / (float)anControl;
        float popAF = (float)acDatabase / (float)anDatabase;
        double mixedAF = (float)(2 * anControl) / ((float)(anControl + anDatabase) * controlAF) + (float)(2 * anDatabase) / ((float)(anControl + anDatabase) * popAF);
        double betaInter = Math.log(caseAF * (1.0f - controlAF) / (controlAF * (1.0f - caseAF)));
        double betaMix = Math.log((double)caseAF * (1.0 - mixedAF) / (mixedAF * (double)(1.0f - caseAF)));
        betaCalculator.setTheta(betaMix - betaInter);
        betaCalculator.calculateThetaVariance(variance);
    }

    public AppendMutationSubjectIDTask(GeneralIOOptions generalIOOptions, File outputDir, boolean makeDir) {
        this.generalIOOptions = generalIOOptions;
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFile = FileUtils.getSubFile(outputDir, InputOutputFileSet.getAnnotationFileName());
    }

    public AppendMutationSubjectIDTask(GeneralIOOptions generalIOOptions, File outputDir, boolean makeDir, boolean adjustAF, List<String> selectedFreqFields) {
        this(generalIOOptions, outputDir, makeDir);
        this.adjustAF = adjustAF;
        this.selectedFreqFields = selectedFreqFields;
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        GTBManager inputManager = new GTBManager((File)context.cast("AnnotationBaseVariantSet"));
        context.put("CaseMutationCount", "GTYSUM@COUNT_ALT_CASE");
        context.put("CaseMutationCountSubID", "GTYSUM@COUNT_ALT_CASE_SubID");
        context.put("ControlMutationCount", "GTYSUM@COUNT_ALT_CONTROL");
        context.put("ControlMutationCountSubID", "GTYSUM@COUNT_ALT_CONTROL_SubID");
        betaCalculatorThreadLocal = ThreadLocal.withInitial(BetaCalculator::new);
        final AtomicReference<Double> thetaVariance = new AtomicReference<Double>(0.0);
        int subjectNum = GlobalPedIndividuals.size();
        IntList controlIDsInGTB = new IntList();
        for (int i = 0; i < subjectNum; ++i) {
            double phenotype = (Double)GlobalPedIndividuals.get(i, "phenotype");
            int affectedStatus = (int)phenotype;
            if (affectedStatus != 1) continue;
            controlIDsInGTB.add(i);
        }
        context.put("ControlSubjectNum", controlIDsInGTB.size());
        final int caseNum = (Integer)context.cast("CaseSubjectNum");
        final int controlNum = controlIDsInGTB.size();
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        if (updatedVariantSet == null) {
            updatedVariantSet = false;
        }
        TaskTracker.TaskResult completeTaskResult = new TaskTracker.TaskResult(this.getClass().getName(), String.valueOf(inputManager.hashCode()), this.digest());
        Optional<File> outputPathOpt = SetupApplication.GlobalTaskTracker.checkTask(completeTaskResult);
        outputPathOpt.ifPresent(file -> {
            this.outputFile = file;
        });
        if (updatedVariantSet.booleanValue() || !this.outputFile.exists() || !outputPathOpt.isPresent()) {
            final Set<String> filePathIDs = inputManager.getMeta().get("SOURCE@FILE_ID").apply(meta -> (String)meta.getValue()).toSet();
            GTBAnnotator annotator = GTBAnnotator.setInput(new GTBReaderOption(inputManager, false, true)).setOutput(this.outputFile).addMeta(inputManager.getMeta()).addDatabase(new PointerDatabase<Variant>(){
                final FieldGroupMeta fields;
                final Map<String, IntList> caseMapper;
                final Map<String, IntList> controlMapper;
                {
                    this.fields = new FieldGroupMeta("GTYSUM").addField(AppendMutationSubjectIDTask.this.COUNT_ALT_CASE_SubID).addField(AppendMutationSubjectIDTask.this.COUNT_ALT_CASE).addField(AppendMutationSubjectIDTask.this.COUNT_ALT_CONTROL_SubID).addField(AppendMutationSubjectIDTask.this.COUNT_ALT_CONTROL).addField(AppendMutationSubjectIDTask.this.SWITCH_FLAG).asUnmodifiable();
                    this.caseMapper = new THashMap<String, IntList>();
                    this.controlMapper = new THashMap<String, IntList>();
                    for (String filePath : filePathIDs) {
                        IntList caseIDMapper = new IntList();
                        IntList controlIDMapper = new IntList();
                        GTBManager gtbManager = new GTBManager(filePath);
                        for (String subject : GlobalPedIndividuals.uniqueIDs()) {
                            double phenotype = (Double)GlobalPedIndividuals.get(GlobalPedIndividuals.indexOfIndividual(subject), "phenotype");
                            int affectedStatus = (int)phenotype;
                            if (affectedStatus == 2) {
                                caseIDMapper.add(gtbManager.getIndividuals().indexOf(subject));
                            }
                            if (affectedStatus != 1) continue;
                            controlIDMapper.add(gtbManager.getIndividuals().indexOf(subject));
                        }
                        this.caseMapper.put(filePath, caseIDMapper);
                        this.controlMapper.put(filePath, controlIDMapper);
                        this.addTable(filePath, new GTBReaderOption(gtbManager, true, false));
                    }
                }

                @Override
                public Object getSource(Variant variant) {
                    return variant.getProperty("SOURCE@FILE_ID");
                }

                @Override
                public long getPointer(Variant variant) {
                    return (Long)variant.getProperty("SOURCE@FILE_POINTER");
                }

                @Override
                public IFieldCollection getAllFields() {
                    return this.fields;
                }

                public float getPopAF(Variant variant, List<String> selectedFreqField) {
                    float af = 0.0f;
                    int count = 0;
                    for (String meta : selectedFreqField) {
                        float tmpAF = ((Float)variant.getProperty(meta)).floatValue();
                        af += Double.isNaN(tmpAF) ? 0.0f : tmpAF;
                        count += Double.isNaN(tmpAF) ? 0 : 1;
                    }
                    return count > 0 ? af / (float)count : 0.0f;
                }

                public int getACorANInDatabase(Variant variant, List<String> selectedFields) {
                    if (variant == null || selectedFields == null || selectedFields.isEmpty()) {
                        return Integer.parseInt(null);
                    }
                    int ac_an = 0;
                    for (String meta : selectedFields) {
                        Object value = variant.getProperty(meta);
                        if (!(value instanceof Number)) continue;
                        int tmp = ((Number)value).intValue();
                        ac_an += tmp;
                    }
                    return ac_an;
                }

                @Override
                public boolean annotate(List<BoxRecord> databaseRecords, long pointer, Variant variant) {
                    if (databaseRecords == null || databaseRecords.isEmpty()) {
                        return false;
                    }
                    BoxRecord databaseRecord = databaseRecords.get(0);
                    int currentAltIndex = 1;
                    IndexableSet originAlleles = (IndexableSet)databaseRecord.get("ALLELE");
                    if (variant.numOfAlleles() == 2 && originAlleles.size() > 2) {
                        if (((String)originAlleles.valueOf(0)).length() == variant.alleleOfIndex(0).length()) {
                            currentAltIndex = originAlleles.indexOf(variant.alleleOfIndex(1));
                        } else {
                            ByteStream container = ByteStream.getThreadInstance();
                            container.writeChar(variant.alleleOfIndex(1));
                            container.writeChar(((String)originAlleles.valueOf(0)).substring(variant.alleleOfIndex(0).length()));
                            currentAltIndex = originAlleles.indexOf(container.toBytes(false).toString());
                        }
                    }
                    boolean[] switchFlag = new boolean[]{false};
                    IGenotypes genotypes = IGenotypes.load((Bytes)databaseRecord.get(null, "GT"));
                    int[][] gtyCodes = genotypes.getGenotypeCodes();
                    String fileID = (String)variant.getProperty("SOURCE@FILE_ID");
                    IntList caseIDMapper = this.caseMapper.get(fileID);
                    IntList caseSubIDs = new IntList();
                    int[] caseAllCounts = AppendMutationSubjectIDTask.this.useMAFAllele ? GenotypeCounter.countByAltIndexByMAF(gtyCodes, currentAltIndex, caseIDMapper, caseSubIDs, switchFlag) : GenotypeCounter.countByAltIndex(gtyCodes, currentAltIndex, caseIDMapper, caseSubIDs);
                    variant.setProperty(AppendMutationSubjectIDTask.this.COUNT_ALT_CASE.fullName(), caseAllCounts[1]);
                    variant.setProperty(AppendMutationSubjectIDTask.this.COUNT_ALT_CASE_SubID.fullName(), caseSubIDs);
                    variant.setProperty(AppendMutationSubjectIDTask.this.SWITCH_FLAG.fullName(), switchFlag[0]);
                    IntList controlIDMapper = this.controlMapper.get(fileID);
                    IntList controlSubIDs = new IntList();
                    int[] controlAllCounts = AppendMutationSubjectIDTask.this.useMAFAllele ? GenotypeCounter.countByAltIndexByMAF(gtyCodes, currentAltIndex, controlIDMapper, controlSubIDs, switchFlag) : GenotypeCounter.countByAltIndex(gtyCodes, currentAltIndex, controlIDMapper, controlSubIDs);
                    variant.setProperty(AppendMutationSubjectIDTask.this.COUNT_ALT_CONTROL.fullName(), controlAllCounts[1]);
                    variant.setProperty(AppendMutationSubjectIDTask.this.COUNT_ALT_CONTROL_SubID.fullName(), controlSubIDs);
                    if (AppendMutationSubjectIDTask.this.adjustAF) {
                        int caseAlt = caseAllCounts[1];
                        int controlAlt = controlAllCounts[1];
                        float controlAF = (float)controlAlt / (float)(controlNum * 2);
                        float caseAF = (float)caseAlt / (float)(caseNum * 2);
                        float popAF = this.getPopAF(variant, AppendMutationSubjectIDTask.this.selectedFreqFields);
                        if (!AppendMutationSubjectIDTask.this.accurate) {
                            AppendMutationSubjectIDTask.calculateTheta(caseAF, controlAF, popAF, thetaVariance);
                        } else {
                            int AC_database = this.getACorANInDatabase(variant, AppendMutationSubjectIDTask.this.selectedACFields);
                            int AN_database = this.getACorANInDatabase(variant, AppendMutationSubjectIDTask.this.selectedANFields);
                            int AN_control = controlNum * 2;
                            AppendMutationSubjectIDTask.calculateTheta(caseAF, AC_database, AN_database, controlAlt, AN_control, thetaVariance);
                        }
                    }
                    return true;
                }
            }).setListener(new AnnotationListener<Variant>());
            annotator.submit(this.generalIOOptions.threads);
            if (this.adjustAF) {
                CCFOptions options = new CCFOptions().add(CCFMetaItem.of("ThetaVariance", String.valueOf(thetaVariance.get()))).add(CCFMetaItem.of("BetaCalculatorCount", String.valueOf(AppendMutationSubjectIDTask.betaCalculatorThreadLocal.get().count.get()))).add(CCFMetaItem.of("BetaCalculatorThetaSquareSum", String.valueOf(AppendMutationSubjectIDTask.betaCalculatorThreadLocal.get().thetaSquareSum.get()))).add(CCFMetaItem.of("BetaCalculatorThetaSum", String.valueOf(AppendMutationSubjectIDTask.betaCalculatorThreadLocal.get().thetaSum.get())));
                ChannelAppendStream appender = new ChannelAppendStream(this.outputFile);
                OptionCodec.saveTo(options, (IWriterStream)appender);
                appender.close();
            }
            SetupApplication.GlobalLogger.info("{} variants are obtained mutation counts.", (Object)inputManager.numOfVariants());
            completeTaskResult.setOutputPath(this.outputFile);
            SetupApplication.GlobalTaskTracker.recordTaskCompletion(completeTaskResult);
            context.put("UpdatedBaseVariantSet", true);
        } else {
            context.put("UpdatedBaseVariantSet", false);
        }
        if (this.adjustAF) {
            GTBReaderOption option = new GTBReaderOption(this.outputFile);
            String str = (String)option.getGTBManager().getOption("ThetaVariance");
            if (str != null) {
                context.put("ThetaVariance", Double.parseDouble(str));
                SetupApplication.GlobalLogger.info("Theta variance is {}", (Object)str);
            }
            if ((str = (String)option.getGTBManager().getOption("BetaCalculatorCount")) != null) {
                context.put("BetaCalculatorCount", Integer.parseInt(str));
            }
            if ((str = (String)option.getGTBManager().getOption("BetaCalculatorThetaSquareSum")) != null) {
                context.put("BetaCalculatorThetaSquareSum", Double.parseDouble(str));
            }
            if ((str = (String)option.getGTBManager().getOption("BetaCalculatorThetaSum")) != null) {
                context.put("BetaCalculatorThetaSum", Double.parseDouble(str));
            }
        }
        context.put("AnnotationBaseVariantSet", this.outputFile);
    }

    private String digest() {
        String stringBuilder = "AppendSubjectID";
        return stringBuilder;
    }

    public static void main(String[] args) throws IOException {
        int length;
        ReaderStream r2 = LiveFile.of("c").openAsText();
        ProgressBar b1 = new ProgressBar.Builder().setTextRenderer("Processed", DataLengthUnit.B).build();
        byte[] cache = new byte[8192];
        while ((length = r2.read(cache)) != -1) {
            b1.step(length);
        }
        b1.close();
        ((IReaderStream)r2).close();
    }

    private static class BetaCalculator {
        public AtomicReference<Double> thetaSum;
        public AtomicReference<Double> thetaSquareSum;
        public AtomicInteger count;

        public BetaCalculator() {
            this.thetaSum = new AtomicReference<Double>(0.0);
            this.thetaSquareSum = new AtomicReference<Double>(0.0);
            this.count = new AtomicInteger(0);
        }

        public BetaCalculator(Double thetaSum, Double thetaSquareSum, Integer count) {
            this.thetaSum = new AtomicReference<Double>(thetaSum);
            this.thetaSquareSum = new AtomicReference<Double>(thetaSquareSum);
            this.count = new AtomicInteger(count);
        }

        public void setTheta(double theta) {
            this.count.getAndAdd(1);
            this.thetaSum.getAndUpdate(current -> current + theta);
            this.thetaSquareSum.getAndUpdate(current -> current + theta * theta);
        }

        public void calculateThetaVariance(AtomicReference<Double> variance) {
            variance.getAndSet(this.getThetaSquareSum() / (double)this.getCount() - Math.pow(this.getThetaSum() / (double)this.getCount(), 2.0));
        }

        public int getCount() {
            return this.count.get();
        }

        public double getThetaSquareSum() {
            return this.thetaSquareSum.get();
        }

        public double getThetaSum() {
            return this.thetaSum.get();
        }
    }
}

