/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import edu.sysu.pmglab.annotation.GwasSumDatabase;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.IReaderOption;
import edu.sysu.pmglab.ccf.ReaderOption;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.Query;
import edu.sysu.pmglab.ccf.toolkit.annotator.DatabaseBatch;
import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.ccf.toolkit.input.GTBInputOption;
import edu.sysu.pmglab.ccf.toolkit.input.TextInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.AnnotationListener;
import edu.sysu.pmglab.ccf.toolkit.listener.SortListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.entry.TLongObjectEntry;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalTree;
import edu.sysu.pmglab.container.list.DoubleList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.genome.coordinate.RefGenomeVersion;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.gtb.toolkit.GTBAnnotator;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.gtb.toolkit.GTBSorter;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.VCFFormatParser;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.file.Channel;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.reader.IHeaderParser;
import edu.sysu.pmglab.io.text.reader.ISeparator;
import edu.sysu.pmglab.io.text.reader.TextReader;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.TaskTracker;
import edu.sysu.pmglab.kgga.command.Utility;
import edu.sysu.pmglab.kgga.command.setting.GlobalAnnotationGenomeVersion;
import edu.sysu.pmglab.kgga.command.setting.GwasSumFileOption;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import edu.sysu.pmglab.kgga.io.InputType;
import edu.sysu.pmglab.stat.Summary;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

public class AppendVariants2RootVariantSetTask
implements ITask {
    File outputAnnotFile;
    List<GwasSumFileOption> summaryFiles;
    int threadNum;
    boolean filterVariantWithAnyNA = false;

    public AppendVariants2RootVariantSetTask(List<GwasSumFileOption> summaryFiles, File outputDir, boolean makeDir, int threadNum, boolean filterVariantWithAnyNA) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputAnnotFile = FileUtils.getSubFile(outputDir, InputOutputFileSet.getAnnotationFileName());
        this.summaryFiles = summaryFiles;
        this.threadNum = threadNum;
        this.filterVariantWithAnyNA = filterVariantWithAnyNA;
    }

    public AppendVariants2RootVariantSetTask(List<GwasSumFileOption> summaryFiles, File outputDir, boolean makeDir, int threadNum) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputAnnotFile = FileUtils.getSubFile(outputDir, InputOutputFileSet.getAnnotationFileName());
        this.summaryFiles = summaryFiles;
        this.threadNum = threadNum;
    }

    public AppendVariants2RootVariantSetTask(GwasSumFileOption summaryFile, File outputDir, boolean makeDir, int threadNum) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputAnnotFile = FileUtils.getSubFile(outputDir, InputOutputFileSet.getAnnotationFileName());
        this.summaryFiles = List.wrap(new GwasSumFileOption[]{summaryFile});
        this.threadNum = threadNum;
    }

    public void convertTSVSumFile2GTB(GwasSumFileOption gwasSumFileOption, File gwasSummaryGTB) {
        boolean useGeneratedGC;
        boolean useCustomizedGC;
        String r2ColIndex;
        String[] sampleSizeColIndex;
        LiveFile summaryFile = gwasSumFileOption.tmpActiveInputFile;
        final String groupName = summaryFile.getName();
        String[] cp12ColIndexes = gwasSumFileOption.cp12Cols;
        String[] pbsColIndexes = gwasSumFileOption.pbsCols;
        LinkedSet optionalFields = new LinkedSet();
        String freqA1ColIndex = gwasSumFileOption.freqA1Col;
        if (freqA1ColIndex != null && !freqA1ColIndex.isEmpty()) {
            ((AbstractCollection)optionalFields).add(FieldMeta.of("A1F", FieldType.float32));
        }
        if ((sampleSizeColIndex = gwasSumFileOption.sampleSizeCols) != null) {
            ((AbstractCollection)optionalFields).add(FieldMeta.of("N", FieldType.float64List));
        }
        if ((r2ColIndex = gwasSumFileOption.r2Col) != null && !r2ColIndex.isEmpty()) {
            ((AbstractCollection)optionalFields).add(FieldMeta.of("R2", FieldType.float32));
        }
        ISeparator separator = gwasSumFileOption.separator;
        RefGenomeVersion summaryGenomeVersion = gwasSumFileOption.refG;
        Map<Chromosome, IntIntervalTree<Void>> excludedRegions = gwasSumFileOption.excludedRegions;
        boolean excludeVariants = excludedRegions != null && !excludedRegions.isEmpty();
        String missingValueLabel = gwasSumFileOption.missingLabel;
        double genomicControl = gwasSumFileOption.genomicControl;
        DoubleArrayList chiSquareList = new DoubleArrayList();
        if (!Double.isNaN(genomicControl) && genomicControl == -1.0) {
            useCustomizedGC = false;
            useGeneratedGC = true;
        } else {
            useGeneratedGC = false;
            useCustomizedGC = !Double.isNaN(genomicControl);
        }
        try {
            GTBSorter sorter;
            LiftOver liftOver = summaryGenomeVersion.to(GlobalAnnotationGenomeVersion.refGenomeVersion);
            String orgChrom = groupName + "@" + (Object)((Object)summaryGenomeVersion) + "_CHROM";
            String orgPos = groupName + "@" + (Object)((Object)summaryGenomeVersion) + "_POS";
            FieldGroupMeta outputFields = new FieldGroupMeta(groupName).addField(liftOver == LiftOver.ITSELF ? null : FieldMeta.of(orgChrom, FieldType.chromosome)).addField(liftOver == LiftOver.ITSELF ? null : FieldMeta.of(orgPos, FieldType.varInt32)).addField("P", FieldType.float64);
            if (pbsColIndexes.length > 1) {
                outputFields.addField("Beta", FieldType.float64);
            }
            if (pbsColIndexes.length > 2) {
                outputFields.addField("SE", FieldType.float64);
            }
            outputFields.addFields((Iterable)optionalFields);
            Variant.addPropertyKeys(outputFields);
            String[] headStartLine = new String[1];
            boolean hasSign = edu.sysu.pmglab.text.Utility.hasSignLineHead(summaryFile, headStartLine);
            IHeaderParser headerParser = hasSign ? IHeaderParser.BEGIN_WITH_1_NUMBER_SIGN : IHeaderParser.beginWith(headStartLine[0], false);
            Processor.setInput(new TextInputOption(summaryFile).setSeparator(separator).setHeaderParser(headerParser)).setOutput(new GTBOutputOption(gwasSummaryGTB).addFields(outputFields)).bridge(record -> {
                int position;
                String valStr;
                Chromosome chromosome = Chromosome.get(record.get(cp12ColIndexes[0]).toString());
                if (chromosome == Chromosome.UNKNOWN) {
                    return null;
                }
                try {
                    valStr = String.valueOf(record.get(cp12ColIndexes[1])).trim();
                    if (valStr.equals(missingValueLabel)) {
                        return null;
                    }
                    position = Integer.parseInt(valStr);
                }
                catch (Exception ex) {
                    SetupApplication.GlobalLogger.error("{} at line: {}", (Object)ex, record);
                    ex.printStackTrace();
                    return null;
                }
                if (excludeVariants && excludedRegions.containsKey(chromosome) && ((IntIntervalTree)excludedRegions.get(chromosome)).contains(position)) {
                    return null;
                }
                Coordinate coordinate = liftOver.convert(new Coordinate(chromosome, position));
                if (coordinate == null) {
                    return null;
                }
                Variant variant = new Variant(coordinate);
                double p = record.get(pbsColIndexes[0]).toDouble();
                if (Double.isNaN(p)) {
                    return null;
                }
                if (useCustomizedGC) {
                    p = Summary.adjustPValueByGC(p, genomicControl);
                } else if (useGeneratedGC) {
                    chiSquareList.add(Summary.pValue2ChiSquare(p));
                }
                variant.setProperty(groupName + "@P", p);
                if (liftOver != LiftOver.ITSELF) {
                    variant.setProperty(orgChrom, chromosome);
                    variant.setProperty(orgPos, position);
                }
                String[] alleles = new String[2];
                alleles[1] = cp12ColIndexes.length > 2 ? (record.get(cp12ColIndexes[2]) == null ? "." : record.get(cp12ColIndexes[2]).toString()) : ".";
                alleles[0] = cp12ColIndexes.length > 3 ? (record.get(cp12ColIndexes[3]) == null ? "." : record.get(cp12ColIndexes[3]).toString()) : ".";
                if (cp12ColIndexes.length > 2) {
                    variant.addAlleles(alleles);
                }
                if (pbsColIndexes.length > 1) {
                    if (record.get(pbsColIndexes[1]) == null) {
                        variant.setProperty(groupName + "@Beta", Double.NaN);
                    } else {
                        valStr = String.valueOf(record.get(pbsColIndexes[1])).trim();
                        if (valStr.equals(missingValueLabel)) {
                            return null;
                        }
                        variant.setProperty(groupName + "@Beta", Double.parseDouble(valStr));
                    }
                }
                if (pbsColIndexes.length > 2) {
                    if (record.get(pbsColIndexes[2]) == null) {
                        variant.setProperty(groupName + "@SE", Float.valueOf(Float.NaN));
                    } else {
                        valStr = String.valueOf(record.get(pbsColIndexes[2])).trim();
                        if (valStr.equals(missingValueLabel)) {
                            return null;
                        }
                        variant.setProperty(groupName + "@SE", Double.parseDouble(valStr));
                    }
                }
                if (freqA1ColIndex != null && !freqA1ColIndex.isEmpty()) {
                    if (record.get(freqA1ColIndex) == null) {
                        variant.setProperty(groupName + "@A1F", Float.valueOf(Float.NaN));
                    } else {
                        variant.setProperty(groupName + "@A1F", Float.valueOf(record.get(freqA1ColIndex).toFloat()));
                    }
                }
                if (r2ColIndex != null && !r2ColIndex.isEmpty()) {
                    if (record.get(r2ColIndex) == null) {
                        variant.setProperty(groupName + "@R2", Float.valueOf(Float.NaN));
                    } else {
                        variant.setProperty(groupName + "@R2", Float.valueOf(record.get(r2ColIndex).toFloat()));
                    }
                }
                if (sampleSizeColIndex != null && sampleSizeColIndex.length > 0) {
                    DoubleList sampleSizes = new DoubleList();
                    for (String sizeColIndex : sampleSizeColIndex) {
                        if (record.get(sizeColIndex) == null) {
                            sampleSizes.add(Double.NaN);
                            continue;
                        }
                        sampleSizes.add(record.get(sizeColIndex).toDouble());
                    }
                    variant.setProperty(groupName + "@N", sampleSizes);
                }
                return variant;
            }).submit(this.threadNum);
            if (useGeneratedGC) {
                chiSquareList.sort();
                double median = Descriptive.quantile(chiSquareList, 0.5);
                StringBuilder tmpBuffer = new StringBuilder();
                tmpBuffer.append("The inflation factor(\u03bb) is ");
                final double gcFactor = median / 0.4549;
                tmpBuffer.append(String.format("%.4g", gcFactor));
                tmpBuffer.append("\n");
                GTBManager manager = new GTBManager(gwasSummaryGTB);
                GTBInputOption gtbInputOption = new GTBInputOption(new GTBReaderOption(gwasSummaryGTB, false, true));
                Processor.setInput(gtbInputOption).setOutput(new GTBOutputOption(gwasSummaryGTB).addFields(manager.getAllFields()).addMeta(manager.getMeta())).bridge(new ILiteConverter<Variant, Variant>(){

                    @Override
                    public Variant converter(Variant variant) {
                        double p = (Double)variant.getProperty(groupName + "@P");
                        if (!Double.isNaN(p)) {
                            p = Summary.adjustPValueByGC(p, gcFactor);
                            variant.setProperty(groupName + "@P", p);
                        }
                        return variant;
                    }
                }).submit(this.threadNum);
            }
            if (!(sorter = GTBSorter.setInput(gwasSummaryGTB, new String[0]).setMaxRefinedBucketSize(65535).setBufferSize(65535).setListener(new SortListener("Crude Indexed", "Sorted", "variants"))).isOrdered(this.threadNum)) {
                sorter.sort(gwasSummaryGTB, this.threadNum, false);
                GTBIndexer.setInput(gwasSummaryGTB, new String[0]).save(this.threadNum);
            } else if (new GTBManager(gwasSummaryGTB).getIndexer() == null) {
                GTBIndexer.setInput(gwasSummaryGTB, new String[0]).save(this.threadNum);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing failed in " + summaryFile.getPath(), e);
        }
    }

    private Map<String, IRecord> readRSIDCoordMap(LiveFile summaryFile, ISeparator separator, String[] r12ColIndexes) throws IOException {
        TextRecord recordMap;
        List<String> rsIDList = new List<String>();
        TextReader reader = TextReader.setInput(summaryFile).setHeaderParser(IHeaderParser.FIRST_LINE).setSeparator(separator).instance();
        while ((recordMap = reader.read()) != null) {
            String rsID = recordMap.get(r12ColIndexes[0]).toString().toLowerCase();
            if (!rsID.startsWith("rs")) {
                SetupApplication.GlobalLogger.warn("The rsID does not start with rs at line: {}", (Object)recordMap);
            }
            rsIDList.add(rsID);
        }
        reader.close();
        Object dbsnpPath = null;
        LiveFile pathToDatabase = Channel.get("dbsnp", "/dbsnp/dbSNP_157.hg38.gtb");
        if (pathToDatabase == null) {
            throw new RuntimeException("Could not find dbsnp database! Please set the path by -vad dbsnp path=/path/to/gtb/file \n");
        }
        THashSet ids = new THashSet(rsIDList);
        long start = System.nanoTime();
        Query query = new Query((IReaderOption<?>)new ReaderOption(pathToDatabase, new String[0]).addField("ID"), this.threadNum);
        List<TLongObjectEntry<IRecord>> results = query.search(record -> {
            String id = (String)record.get("ID");
            return ids.contains(id);
        }, ids.size());
        ids.clear();
        THashMap<String, IRecord> rsIDCoordiMap = new THashMap<String, IRecord>();
        for (TLongObjectEntry<IRecord> entr : results) {
            IRecord rec = entr.getValue();
            rsIDCoordiMap.put((String)rec.get("ID"), rec);
            rec.set("ID", null);
        }
        return rsIDCoordiMap;
    }

    public void convertTSVSumFile2GTBWithRSID(GwasSumFileOption gwasSumFileOption, File gwasSummaryGTB) {
        boolean useGeneratedGC;
        boolean useCustomizedGC;
        LiveFile summaryFile = gwasSumFileOption.tmpActiveInputFile;
        final String groupName = summaryFile.getName();
        String[] r12ColIndexes = gwasSumFileOption.r12Cols;
        String[] pbsColIndexes = gwasSumFileOption.pbsCols;
        String freqA1ColIndex = gwasSumFileOption.freqA1Col;
        String[] sampleSizeColIndex = gwasSumFileOption.sampleSizeCols;
        ISeparator separator = gwasSumFileOption.separator;
        String missingValueLabel = ".";
        DoubleArrayList chiSquareList = new DoubleArrayList();
        double genomicControl = gwasSumFileOption.genomicControl;
        if (!Double.isNaN(genomicControl) && genomicControl == -1.0) {
            useCustomizedGC = false;
            useGeneratedGC = true;
        } else {
            useGeneratedGC = false;
            useCustomizedGC = !Double.isNaN(genomicControl);
        }
        try {
            GTBSorter sorter;
            boolean excludeVariants;
            Map<String, IRecord> rsIDCoordMap = this.readRSIDCoordMap(summaryFile, separator, r12ColIndexes);
            RefGenomeVersion summaryGenomeVersion = gwasSumFileOption.refG;
            FieldGroupMeta outputFields = new FieldGroupMeta(groupName).addField("RSID", FieldType.string).addField("P", FieldType.float64).addField("Beta", FieldType.float64).addField("SE", FieldType.float64).addField("N", FieldType.float64List).addField("A1F", FieldType.float32);
            Variant.addPropertyKeys(outputFields);
            Map<Chromosome, IntIntervalTree<Void>> excludedRegions = gwasSumFileOption.excludedRegions;
            boolean bl = excludeVariants = excludedRegions != null && !excludedRegions.isEmpty();
            if (excludeVariants) {
                // empty if block
            }
            String[] headStartLine = new String[1];
            boolean hasSign = edu.sysu.pmglab.text.Utility.hasSignLineHead(summaryFile, headStartLine);
            IHeaderParser headerParser = IHeaderParser.FIRST_LINE;
            headerParser = hasSign ? IHeaderParser.BEGIN_WITH_1_NUMBER_SIGN : IHeaderParser.beginWith(headStartLine[0], false);
            Processor.setInput(new TextInputOption(summaryFile).setSeparator(separator).setHeaderParser(headerParser)).setOutput(new GTBOutputOption(gwasSummaryGTB).addFields(outputFields)).bridge(record -> {
                String rsID = record.get(r12ColIndexes[0]).toString().toLowerCase();
                if (!rsID.startsWith("rs")) {
                    return null;
                }
                IRecord rec = (IRecord)rsIDCoordMap.get(rsID);
                if (rec == null) {
                    return null;
                }
                Chromosome chromosome = (Chromosome)rec.get("CHROM");
                if (chromosome.getIndex() > 23) {
                    return null;
                }
                int position = (Integer)rec.get("POS");
                Coordinate coordinate = new Coordinate(chromosome, position);
                if (excludeVariants && excludedRegions.containsKey(chromosome) && ((IntIntervalTree)excludedRegions.get(chromosome)).contains(position)) {
                    return null;
                }
                Variant variant = new Variant(coordinate);
                variant.setProperty(groupName + "@RSID", rsID);
                double p = record.get(pbsColIndexes[0]).toDouble();
                if (Double.isNaN(p)) {
                    return null;
                }
                if (useCustomizedGC) {
                    p = Summary.adjustPValueByGC(p, genomicControl);
                } else if (useGeneratedGC) {
                    chiSquareList.add(Summary.pValue2ChiSquare(p));
                }
                variant.setProperty(groupName + "@P", p);
                String[] alleles = new String[2];
                IndexableSet recAlleles = (IndexableSet)rec.get("ALLELE");
                alleles[1] = r12ColIndexes.length > 1 ? (record.get(r12ColIndexes[1]) == null ? (String)recAlleles.valueOf(1) : record.get(r12ColIndexes[1]).toString()) : (String)recAlleles.valueOf(1);
                alleles[0] = r12ColIndexes.length > 2 ? (record.get(r12ColIndexes[2]) == null ? (String)recAlleles.valueOf(0) : record.get(r12ColIndexes[2]).toString()) : (String)recAlleles.valueOf(0);
                if (r12ColIndexes.length > 2) {
                    variant.addAlleles(alleles);
                }
                if (pbsColIndexes.length > 1) {
                    if (record.get(pbsColIndexes[1]) == null) {
                        variant.setProperty(groupName + "@Beta", Double.NaN);
                    } else {
                        variant.setProperty(groupName + "@Beta", record.get(pbsColIndexes[1]).toDouble());
                    }
                }
                if (pbsColIndexes.length > 2) {
                    if (record.get(pbsColIndexes[2]) == null) {
                        variant.setProperty(groupName + "@SE", Float.valueOf(Float.NaN));
                    } else {
                        variant.setProperty(groupName + "@SE", record.get(pbsColIndexes[2]).toDouble());
                    }
                }
                if (freqA1ColIndex != null && !freqA1ColIndex.isEmpty()) {
                    if (record.get(freqA1ColIndex) == null) {
                        variant.setProperty(groupName + "@A1F", Float.valueOf(Float.NaN));
                    } else {
                        variant.setProperty(groupName + "@A1F", Float.valueOf(record.get(freqA1ColIndex).toFloat()));
                    }
                }
                if (sampleSizeColIndex != null && sampleSizeColIndex.length > 0) {
                    DoubleList sampleSizes = new DoubleList();
                    for (String sizeColIndex : sampleSizeColIndex) {
                        if (record.get(sizeColIndex) == null) {
                            sampleSizes.add(Double.NaN);
                            continue;
                        }
                        sampleSizes.add(record.get(sizeColIndex).toDouble());
                    }
                    variant.setProperty(groupName + "@N", sampleSizes);
                }
                return variant;
            }).submit(this.threadNum);
            if (useGeneratedGC) {
                chiSquareList.sort();
                double median = Descriptive.quantile(chiSquareList, 0.5);
                StringBuilder tmpBuffer = new StringBuilder();
                tmpBuffer.append("The inflation factor(\u03bb) is ");
                final double gcFactor = median / 0.4549;
                tmpBuffer.append(String.format(".4f", gcFactor));
                tmpBuffer.append("\n");
                GTBManager manager = new GTBManager(gwasSummaryGTB);
                GTBInputOption gtbInputOption = new GTBInputOption(new GTBReaderOption(gwasSummaryGTB, false, true));
                Processor.setInput(gtbInputOption).setOutput(new GTBOutputOption(gwasSummaryGTB).addFields(manager.getAllFields()).addMeta(manager.getMeta())).bridge(new ILiteConverter<Variant, Variant>(){

                    @Override
                    public Variant converter(Variant variant) {
                        double p = (Double)variant.getProperty(groupName + "@P");
                        if (!Double.isNaN(p)) {
                            p = Summary.adjustPValueByGC(p, gcFactor);
                            variant.setProperty(groupName + "@P", p);
                        }
                        return variant;
                    }
                }).submit(this.threadNum);
            }
            if (!(sorter = GTBSorter.setInput(gwasSummaryGTB, new String[0]).setMaxRefinedBucketSize(65535).setBufferSize(65535).setListener(new SortListener("Crude Indexed", "Sorted", "variants"))).isOrdered(this.threadNum)) {
                sorter.sort(gwasSummaryGTB, this.threadNum, false);
                GTBIndexer.setInput(gwasSummaryGTB, new String[0]).save(this.threadNum);
            } else if (new GTBManager(gwasSummaryGTB).getIndexer() == null) {
                GTBIndexer.setInput(gwasSummaryGTB, new String[0]).save(this.threadNum);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing failed in " + summaryFile.getPath(), e);
        }
    }

    public void convertVCFSumFile2GTB(GwasSumFileOption gwasSumFileOption, File gwasSummaryGTB) {
        LiveFile summaryFile = gwasSumFileOption.tmpActiveInputFile;
        String groupName = summaryFile.getName();
        String[] pbsStrCols = gwasSumFileOption.pbsCols;
        String freqA1StrCol = gwasSumFileOption.freqA1Col;
        String[] sampleSizeStrCols = gwasSumFileOption.sampleSizeCols;
        RefGenomeVersion summaryGenomeVersion = gwasSumFileOption.refG;
        Map<Chromosome, IntIntervalTree<Void>> excludedRegions = gwasSumFileOption.excludedRegions;
        boolean excludeVariants = excludedRegions != null;
        try {
            LiftOver liftOver = summaryGenomeVersion.to(GlobalAnnotationGenomeVersion.refGenomeVersion);
            String orgChrom = groupName + "@" + (Object)((Object)summaryGenomeVersion) + "_CHROM";
            String orgPos = groupName + "@" + (Object)((Object)summaryGenomeVersion) + "_POS";
            FieldGroupMeta outputFields = new FieldGroupMeta(groupName).addField("P", FieldType.float64).addField("Beta", FieldType.float64).addField("SE", FieldType.float64).addField("N", FieldType.float64List).addField("A1F", FieldType.float32).addField(liftOver == LiftOver.ITSELF ? null : FieldMeta.of(orgChrom, FieldType.chromosome)).addField(liftOver == LiftOver.ITSELF ? null : FieldMeta.of(orgPos, FieldType.varInt32));
            Variant.addPropertyKeys(outputFields);
            Processor.setInput(new TextInputOption(summaryFile)).setOutput(new GTBOutputOption(gwasSummaryGTB).addFields(outputFields).addMeta(CCFMetaItem.of((Object)((Object)summaryGenomeVersion) + "_CHROM", ""))).bridge(record -> {
                Chromosome chromosome = Chromosome.get(record.get("CHROM").toString());
                if (chromosome == Chromosome.UNKNOWN) {
                    return null;
                }
                int position = record.get("POS").toInt();
                if (excludeVariants && excludedRegions.containsKey(chromosome) && ((IntIntervalTree)excludedRegions.get(chromosome)).contains(position)) {
                    return null;
                }
                Coordinate coordinate = liftOver.convert(new Coordinate(chromosome, position));
                if (coordinate == null) {
                    return null;
                }
                List<String> alleleList = new List<String>();
                alleleList.add(record.get("REF").toString());
                Iterator<Bytes> it = record.get("ALT").split((byte)44);
                while (it.hasNext()) {
                    Bytes bytes = it.next();
                    alleleList.add(bytes.toString());
                }
                Variant variant = new Variant(coordinate);
                variant.addAlleles(alleleList);
                if (liftOver != LiftOver.ITSELF) {
                    variant.setProperty(orgChrom, chromosome);
                    variant.setProperty(orgPos, position);
                }
                IndexableSet<String> keys2 = VCFFormatParser.parseFormat(record.get("FORMAT"));
                List<Bytes> values2 = new List<Bytes>();
                record.get(9).splitTo((byte)58, values2);
                int index = keys2.indexOf(pbsStrCols[0]);
                double p = values2.get(index).toDouble();
                if (Double.isNaN(p)) {
                    return null;
                }
                p = Math.pow(10.0, -p);
                variant.setProperty(groupName + "@P", p);
                if (pbsStrCols.length > 1) {
                    index = keys2.indexOf(pbsStrCols[1]);
                    if (index < 0) {
                        variant.setProperty(groupName + "@Beta", Double.NaN);
                    } else {
                        double beta = values2.get(index).toDouble();
                        if (Double.isNaN(beta)) {
                            variant.setProperty(groupName + "@Beta", Double.NaN);
                        } else {
                            variant.setProperty(groupName + "@Beta", beta);
                        }
                    }
                }
                if (pbsStrCols.length > 2) {
                    index = keys2.indexOf(pbsStrCols[2]);
                    if (index < 0) {
                        variant.setProperty(groupName + "@SE", Double.NaN);
                    } else {
                        double se = values2.get(index).toDouble();
                        if (Double.isNaN(se)) {
                            variant.setProperty(groupName + "@SE", Double.NaN);
                        } else {
                            variant.setProperty(groupName + "@SE", se);
                        }
                    }
                }
                if (freqA1StrCol != null) {
                    index = keys2.indexOf(freqA1StrCol);
                    if (index < 0) {
                        variant.setProperty(groupName + "@A1F", Float.valueOf(Float.NaN));
                    } else {
                        float freqA1 = values2.get(index).toFloat();
                        if (Float.isNaN(freqA1)) {
                            variant.setProperty(groupName + "@A1F", Float.valueOf(Float.NaN));
                        } else {
                            variant.setProperty(groupName + "@A1F", Float.valueOf(freqA1));
                        }
                    }
                }
                if (sampleSizeStrCols != null && sampleSizeStrCols.length > 0) {
                    DoubleList sampleSizes = new DoubleList();
                    for (String sampleSizeStrCol : sampleSizeStrCols) {
                        index = keys2.indexOf(sampleSizeStrCol);
                        if (index < 0) {
                            sampleSizes.add(Double.NaN);
                            continue;
                        }
                        double sampleSize = values2.get(index).toDouble();
                        if (Double.isNaN(sampleSize)) {
                            sampleSizes.add(Double.NaN);
                            continue;
                        }
                        sampleSizes.add(sampleSize);
                    }
                    variant.setProperty(groupName + "@N", sampleSizes);
                } else {
                    variant.setProperty(groupName + "@N", new DoubleList());
                }
                return variant;
            }).submit(this.threadNum);
            GTBSorter sorter = GTBSorter.setInput(gwasSummaryGTB, new String[0]);
            if (!sorter.isOrdered(this.threadNum)) {
                sorter.sort(gwasSummaryGTB, this.threadNum, false);
                GTBIndexer.setInput(gwasSummaryGTB, new String[0]).save(this.threadNum);
            } else if (new GTBManager(gwasSummaryGTB).getIndexer() == null) {
                GTBIndexer.setInput(gwasSummaryGTB, new String[0]).save(this.threadNum);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing failed in " + summaryFile.getPath(), e);
        }
    }

    public File convertGTBSumFile2GTB(GwasSumFileOption gwasSumFileOption, File gwasSummaryGTB, List<String> gwasGroupNameList) throws IOException {
        LiveFile summaryFile = gwasSumFileOption.tmpActiveInputFile;
        GTBManager oriGWASGTBManager = new GTBManager(summaryFile);
        HashSet<String> conservedGroupNames = new HashSet<String>(Arrays.asList("SOURCE", "GTY_SUM", "GeneFeature"));
        oriGWASGTBManager.getAllFieldGroupNames().forEach(s -> {
            if (conservedGroupNames.contains(s)) {
                return;
            }
            gwasGroupNameList.add((String)s);
        });
        final RefGenomeVersion summaryGenomeVersion = gwasSumFileOption.refG;
        final Map<Chromosome, IntIntervalTree<Void>> excludedRegions = gwasSumFileOption.excludedRegions;
        final boolean excludeVariants = excludedRegions != null && !excludedRegions.isEmpty();
        try {
            boolean equalRef = summaryGenomeVersion.equals((Object)GlobalAnnotationGenomeVersion.refGenomeVersion);
            if (excludeVariants || !equalRef) {
                GTBInputOption gtbInputOption = new GTBInputOption(new GTBReaderOption(summaryFile, false, false));
                Processor.setInput(gtbInputOption).setOutput(new GTBOutputOption(gwasSummaryGTB).addMeta(CCFMetaItem.of("ORIGINAL_CHROM", "<Type=chromosome,Description=\"Chromosome as to " + (Object)((Object)summaryGenomeVersion) + ".\">")).addMeta(CCFMetaItem.of("ORIGINAL_POS", "<Type=varInt32,Description=\"Physical position on the chromosome as to " + (Object)((Object)summaryGenomeVersion) + " (1-based coordinate).\">"))).bridge(new ILiteConverter<Variant, Variant>(){
                    final LiftOver liftOver;
                    {
                        this.liftOver = summaryGenomeVersion.to(GlobalAnnotationGenomeVersion.refGenomeVersion);
                    }

                    @Override
                    public Variant converter(Variant variant) {
                        Chromosome chromosome = variant.getChromosome();
                        if (chromosome.getIndex() > 24) {
                            return null;
                        }
                        if (excludeVariants && excludedRegions.containsKey(chromosome) && ((IntIntervalTree)excludedRegions.get(chromosome)).contains(variant.getPosition())) {
                            return null;
                        }
                        if (this.liftOver != LiftOver.ITSELF && (variant = this.liftOver.convert(variant)) == null) {
                            return null;
                        }
                        if (variant.getChromosome().getIndex() > 24) {
                            return null;
                        }
                        return variant;
                    }
                }).submit(this.threadNum);
                GTBSorter sorter = GTBSorter.setInput(gwasSummaryGTB, new String[0]);
                if (!sorter.isOrdered(this.threadNum)) {
                    sorter.sort(gwasSummaryGTB, this.threadNum, true);
                    GTBIndexer.setInput(gwasSummaryGTB, new String[0]).save(this.threadNum);
                } else if (new GTBManager(gwasSummaryGTB).getIndexer() == null) {
                    GTBIndexer.setInput(gwasSummaryGTB, new String[0]).save(this.threadNum);
                }
                return gwasSummaryGTB;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing failed in " + summaryFile.getPath(), e);
        }
        return new File(summaryFile.getPath());
    }

    @Override
    public void execute(Status status, Context context) throws Error, IOException {
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        File inputFile = (File)context.cast("AnnotationBaseVariantSet");
        List[] groupNames0 = (List[])context.cast("GWASGroupNames");
        List[] groupNames = new List[this.summaryFiles.size()];
        GTBManager inputManager = new GTBManager(inputFile);
        StringBuilder hashCodes = new StringBuilder();
        hashCodes.append(inputManager.hashCode());
        GTBAnnotator annotator = GTBAnnotator.setInput(new GTBReaderOption(inputManager, false, true)).setOutput(this.outputAnnotFile).addMeta(inputManager.getMeta());
        DatabaseBatch.InputSetting<Variant> batch = DatabaseBatch.init(Variant.class);
        List<String> pFields = new List<String>();
        List<LiveFile> inputFiles = new List<LiveFile>();
        HashSet<String> conservedGroupNames = new HashSet<String>(Arrays.asList("SOURCE", "GTY_SUM", "GeneFeature"));
        List<String> gwasGroupNameList = new List<String>();
        int batchNum = 4;
        for (int metaIndex = 0; metaIndex < this.summaryFiles.size(); ++metaIndex) {
            GwasSumFileOption gwasSumFileOption = this.summaryFiles.get(metaIndex);
            inputFiles.clear();
            if (gwasSumFileOption.tmpActiveInputFile != null) {
                inputFiles.add(gwasSumFileOption.tmpActiveInputFile);
            } else {
                inputFiles.addAll(gwasSumFileOption.inputFiles);
            }
            groupNames[metaIndex] = new List();
            for (LiveFile summaryFile : inputFiles) {
                File gwasSummaryGTB;
                String outputGTBPath = this.outputAnnotFile.getParentFile() + File.separator + summaryFile.getName();
                if (gwasSumFileOption.type != InputType.GTB) {
                    outputGTBPath = outputGTBPath + ".gtb";
                }
                gwasSumFileOption.tmpActiveInputFile = summaryFile;
                TaskTracker.TaskResult completeTaskResult = new TaskTracker.TaskResult(this.getClass().getName(), Utility.MD5File(summaryFile), String.valueOf(gwasSumFileOption.uniqueCode()));
                Optional<File> outputPathOpt = SetupApplication.GlobalTaskTracker.checkTask(completeTaskResult);
                gwasGroupNameList.clear();
                String groupName = summaryFile.getName();
                if (!outputPathOpt.isPresent()) {
                    gwasSummaryGTB = new File(outputGTBPath);
                    if (gwasSumFileOption.type == InputType.TSV) {
                        if (gwasSumFileOption.cp12Cols != null) {
                            this.convertTSVSumFile2GTB(gwasSumFileOption, gwasSummaryGTB);
                        } else if (gwasSumFileOption.r12Cols != null) {
                            this.convertTSVSumFile2GTBWithRSID(gwasSumFileOption, gwasSummaryGTB);
                        }
                        gwasGroupNameList.add(groupName);
                    } else if (gwasSumFileOption.type == InputType.VCF) {
                        this.convertVCFSumFile2GTB(gwasSumFileOption, gwasSummaryGTB);
                        gwasGroupNameList.add(groupName);
                    } else if (gwasSumFileOption.type == InputType.GTB) {
                        gwasSummaryGTB = this.convertGTBSumFile2GTB(gwasSumFileOption, gwasSummaryGTB, gwasGroupNameList);
                    } else {
                        throw new RuntimeException("Unsupported GWAS sum file type: " + (Object)((Object)gwasSumFileOption.type));
                    }
                    completeTaskResult.setOutputPath(gwasSummaryGTB);
                    SetupApplication.GlobalTaskTracker.recordTaskCompletion(completeTaskResult);
                } else {
                    gwasSummaryGTB = outputPathOpt.get();
                    if (gwasSumFileOption.type == InputType.GTB) {
                        GTBManager oriGWASGTBManager = new GTBManager(summaryFile);
                        oriGWASGTBManager.getAllFieldGroupNames().forEach(s -> {
                            if (conservedGroupNames.contains(s)) {
                                return;
                            }
                            gwasGroupNameList.add((String)s);
                        });
                    } else {
                        gwasGroupNameList.add(groupName);
                    }
                }
                hashCodes.append(Utility.MD5File(gwasSummaryGTB)).append(',');
                int betaType = gwasSumFileOption.betaType;
                float prevalence = gwasSumFileOption.prevalence;
                for (String groupNameTmp : gwasGroupNameList) {
                    groupNames[metaIndex].add(groupNameTmp);
                    pFields.add(groupNameTmp + "@P");
                }
                batch.add(new GwasSumDatabase(new GTBManager(gwasSummaryGTB), gwasGroupNameList, betaType, prevalence, summaryFile.getName(), conservedGroupNames));
                if (batch.numOfDatabases() < batchNum) continue;
                annotator.addDatabases(batch.build());
                batch = DatabaseBatch.init(Variant.class);
            }
        }
        if (batch.numOfDatabases() > 0) {
            annotator.addDatabases(batch.build());
        }
        hashCodes.append(this.filterVariantWithAnyNA);
        TaskTracker.TaskResult completeTaskResult = new TaskTracker.TaskResult(this.getClass().getName(), ITrack.digest(hashCodes.toString()), "Append2RootVariant");
        Optional<File> outputPathOpt = SetupApplication.GlobalTaskTracker.checkTask(completeTaskResult);
        if (updatedVariantSet.booleanValue() || !outputPathOpt.isPresent()) {
            annotator.setListener(new AnnotationListener<Variant>());
            annotator.append(this.threadNum);
            GTBManager manager = new GTBManager(this.outputAnnotFile);
            SetupApplication.GlobalLogger.info("{} valid variants are appended with GWAS summary statistics for analysis", (Object)manager.numOfVariants());
            context.put("UpdatedBaseVariantSet", true);
            GTBSorter sorter = GTBSorter.setInput(this.outputAnnotFile, new String[0]);
            if (!sorter.isOrdered(this.threadNum)) {
                sorter.sort(this.outputAnnotFile, this.threadNum, false);
                GTBIndexer.setInput(this.outputAnnotFile, new String[0]).save(this.threadNum);
            } else if (new GTBManager(this.outputAnnotFile).getIndexer() == null) {
                GTBIndexer.setInput(this.outputAnnotFile, new String[0]).save(this.threadNum);
            }
            completeTaskResult.setOutputPath(this.outputAnnotFile);
            SetupApplication.GlobalTaskTracker.recordTaskCompletion(completeTaskResult);
        } else {
            this.outputAnnotFile = outputPathOpt.get();
            context.put("UpdatedBaseVariantSet", false);
        }
        if (groupNames0 != null) {
            List[] groupNames1 = new List[groupNames0.length + this.summaryFiles.size()];
            System.arraycopy(groupNames0, 0, groupNames1, 0, groupNames0.length);
            System.arraycopy(groupNames, 0, groupNames1, groupNames0.length, groupNames.length);
            groupNames = groupNames1;
        }
        context.put("GWASGroupNames", groupNames);
        context.put("AnnotationBaseVariantSet", this.outputAnnotFile);
    }

    public String toString() {
        return "process...";
    }
}

