/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.annotation.database.DatabaseDescription;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.CCFWriter;
import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.indexer.intvalue.CCFIntIndexer;
import edu.sysu.pmglab.ccf.record.Record;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.NamedVarInt64RangeList;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.rangelist.VarInt64RangeList;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.ReaderStream;
import edu.sysu.pmglab.io.text.reader.CustomSeparator;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.Utility;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationOptions;
import edu.sysu.pmglab.kgga.command.setting.OrderSeparator;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Map;

public class AssignVar2GeneTask
implements ITask {
    final File outputFile;
    AnnotationOptions annotationOptions;
    IndexableSet<String> candidateGenes;
    LiveFile candidateGeneFile;
    int threadNum;
    boolean considerRegionType = true;

    public AssignVar2GeneTask(AnnotationOptions annotationOptions, File outputDir, LiveFile candidateGeneFile, boolean considerRegionType, boolean makeDir, int threadNum) throws IOException {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFile = new File(FileUtils.getSubFile(outputDir.getPath(), "genes.annot.hg38.ccf"));
        this.annotationOptions = annotationOptions;
        this.threadNum = threadNum;
        if (candidateGeneFile != null) {
            this.candidateGenes = this.readCandidateGenes(candidateGeneFile);
            this.candidateGeneFile = candidateGeneFile;
        }
        this.considerRegionType = considerRegionType;
    }

    private IndexableSet<String> readCandidateGenes(LiveFile file) throws IOException {
        LinkedSet<String> idSet = new LinkedSet<String>();
        try (ReaderStream fs = file.openAsText();){
            Bytes line;
            CustomSeparator separator = new CustomSeparator(new OrderSeparator());
            while ((line = fs.readline()) != null) {
                List<Bytes> row = separator.accept(line);
                ((AbstractCollection)idSet).add(row.fastGet(0).toString());
            }
        }
        return idSet;
    }

    public AssignVar2GeneTask(AnnotationOptions annotationOptions, File outputDir, boolean makeDir, int threadNum) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFile = new File(FileUtils.getSubFile(outputDir.getPath(), "genes.annot.hg38.ccf"));
        this.annotationOptions = annotationOptions;
        this.threadNum = threadNum;
    }

    @Override
    public void execute(Status lastReturn, Context context) throws Exception, Error {
        ITrack track = context.getTracker();
        File inputFile = (File)context.cast("AnnotationBaseVariantSet");
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        if (updatedVariantSet == null) {
            updatedVariantSet = false;
        }
        String code = this.digest(inputFile, this.outputFile);
        IndexableSet geneSymbolIDMap = null;
        if (updatedVariantSet.booleanValue() || !this.outputFile.exists() || !track.contains(code)) {
            boolean needFilterGene = false;
            if (this.candidateGenes != null) {
                needFilterGene = true;
                geneSymbolIDMap = (IndexableSet)context.cast("geneSymbolIDMap");
            }
            SetupApplication.GlobalLogger.info("Assign variants into genes ...");
            GTBManager manager = new GTBManager(inputFile);
            CCFIntIndexer<Chromosome> chromosomeTree = manager.getIndexer(true, null);
            Map<String, Map<String, NamedVarInt64RangeList>> chromRegions = Utility.assignVariant2GeneRegions(this.threadNum, manager, chromosomeTree, this.considerRegionType);
            IFieldCollection fields = new FieldGroupMetas().addField("Basic@SymbolID", FieldType.varInt32).addField("Basic@GeneSubRegionTypeID", FieldType.varInt32).addField("Basic@Chromosome", FieldType.chromosome).addField("Basic@Start", FieldType.varInt32).addField("Basic@End", FieldType.varInt32).addField("Basic@OutcomeVarPointers", FieldType.varInt64RangeList).addField("Basic@ExplainVarPointers", FieldType.varInt64RangeList).asUnmodifiable();
            CCFWriter writer = CCFWriter.setOutput(this.outputFile).addFields(fields).instance();
            int geneNum = 0;
            VarInt64RangeList empty = new VarInt64RangeList();
            Record iRecord = new Record(fields);
            String delimiter = "#";
            for (String chromName : chromRegions.keySet()) {
                Map<String, NamedVarInt64RangeList> chromRegionsTmp = chromRegions.get(chromName);
                geneNum += chromRegionsTmp.size();
                for (Map.Entry<String, NamedVarInt64RangeList> entry : chromRegionsTmp.entrySet()) {
                    String geneSymbol;
                    VarInt64RangeList gr = entry.getValue();
                    if (gr != null) {
                        iRecord.set("Basic@OutcomeVarPointers", (Object)gr);
                    } else {
                        iRecord.set("Basic@OutcomeVarPointers", (Object)empty);
                    }
                    String[] items = entry.getKey().split("#");
                    if (needFilterGene && !this.candidateGenes.contains(geneSymbol = (String)geneSymbolIDMap.valueOf(Integer.parseInt(items[0])))) continue;
                    iRecord.set("Basic@SymbolID", (Object)Integer.parseInt(items[0]));
                    if (items.length > 1) {
                        iRecord.set("Basic@GeneSubRegionTypeID", (Object)Integer.parseInt(items[1]));
                    } else {
                        iRecord.set("Basic@GeneSubRegionTypeID", (Object)-99999999);
                    }
                    iRecord.set("Basic@Chromosome", (Object)Chromosome.get(chromName));
                    iRecord.set("Basic@Start", (Object)-1);
                    iRecord.set("Basic@End", (Object)-1);
                    iRecord.set("Basic@ExplainVarPointers", (Object)empty);
                    writer.write(iRecord);
                }
            }
            writer.close();
            SetupApplication.GlobalLogger.info("{} gene regions are assigned are generated.", (Object)geneNum);
            track.add(this.getClass().getName(), this.digest(inputFile, this.outputFile));
            context.put("UpdatedBaseGeneSet", true);
        } else {
            Boolean updatedGeneSet = (Boolean)context.cast("UpdatedBaseGeneSet");
            if (updatedGeneSet != null && updatedGeneSet.booleanValue()) {
                context.put("UpdatedBaseGeneSet", true);
            } else {
                context.put("UpdatedBaseGeneSet", false);
            }
        }
    }

    private String digest(File inputFile, File outputFile) throws IOException {
        List<DatabaseDescription> databaseDescriptions = this.annotationOptions.geneDatabase;
        StringBuilder dbCodes = new StringBuilder();
        for (DatabaseDescription dd : databaseDescriptions) {
            dbCodes.append(dd.toString());
            dbCodes.append(";");
        }
        if (this.candidateGeneFile != null) {
            dbCodes.append(this.candidateGeneFile.getPath());
            dbCodes.append(this.candidateGeneFile.lastModifyTime());
            dbCodes.append(this.candidateGeneFile.length());
        }
        dbCodes.append(this.considerRegionType);
        return ITrack.digest(inputFile.getCanonicalPath(), inputFile.length(), inputFile.lastModified(), outputFile.getCanonicalPath(), outputFile.length(), outputFile.lastModified(), this.annotationOptions.upstreamDis, this.annotationOptions.downstreamDis, this.annotationOptions.splicingDis, dbCodes.toString());
    }
}

