/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.annotator.PointerDatabase;
import edu.sysu.pmglab.ccf.toolkit.listener.AnnotationListener;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.interval.FloatInterval;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import edu.sysu.pmglab.gtb.toolkit.GTBAnnotator;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.variant.HardyWeinbergCalculator;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.TaskTracker;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.io.GlobalPedIndividuals;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import edu.sysu.pmglab.progressbar.MultiProgressBar;
import edu.sysu.pmglab.progressbar.TextProgressRenderers;
import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;

public class CaseControlSummaryQCTask
implements ITask {
    File outputFile;
    final FieldMeta RefHomGtyNum_CASE = FieldMeta.of("GTYSUM@RefHomGtyNum_CASE", FieldType.varInt32);
    final FieldMeta HetGtyNum_CASE = FieldMeta.of("GTYSUM@HetGtyNum_CASE", FieldType.varInt32);
    final FieldMeta AltHomGtyNum_CASE = FieldMeta.of("GTYSUM@AltHomGtyNum_CASE", FieldType.varInt32);
    final FieldMeta MissingGtyNum_CASE = FieldMeta.of("GTYSUM@MissingGtyNum_CASE", FieldType.varInt32);
    final FieldMeta RefHomGtyNum_CONTROL = FieldMeta.of("GTYSUM@RefHomGtyNum_CONTROL", FieldType.varInt32);
    final FieldMeta HetGtyNum_CONTROL = FieldMeta.of("GTYSUM@HetGtyNum_CONTROL", FieldType.varInt32);
    final FieldMeta AltHomGtyNum_CONTROL = FieldMeta.of("GTYSUM@AltHomGtyNum_CONTROL", FieldType.varInt32);
    final FieldMeta MissingGtyNum_CONTROL = FieldMeta.of("GTYSUM@MissingGtyNum_CONTROL", FieldType.varInt32);
    GTBManager inputManager;
    GeneralIOOptions inputsOptions;

    public CaseControlSummaryQCTask(GTBManager inputManager, GeneralIOOptions inputsOptions, File outputDir, boolean makeDir) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.inputManager = inputManager;
        this.outputFile = new File(FileUtils.getSubFile(outputDir.getPath(), InputOutputFileSet.getAnnotationFileName()));
        this.inputsOptions = inputsOptions;
    }

    @Override
    public void execute(Status status, Context context) throws Exception {
        String outVFInfo;
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        if (updatedVariantSet == null) {
            updatedVariantSet = false;
        }
        final String[] phenotypeNames = GlobalPedIndividuals.getPhenotypeNames();
        boolean needRedo = !this.outputFile.exists();
        TaskTracker.TaskResult completeTaskResult = new TaskTracker.TaskResult(this.getClass().getName(), this.inputManager.getFile().getPath(), this.digest(phenotypeNames));
        Optional<File> outputPathOpt = SetupApplication.GlobalTaskTracker.checkTask(completeTaskResult);
        outputPathOpt.ifPresent(file -> {
            this.outputFile = file;
        });
        needRedo = needRedo || !outputPathOpt.isPresent();
        final LongAdder countHweCaseFail = new LongAdder();
        final LongAdder countObsCaseFail = new LongAdder();
        final LongAdder countMafCase = new LongAdder();
        final LongAdder countAltCase = new LongAdder();
        final LongAdder countHweControlFail = new LongAdder();
        final LongAdder countObsControlFail = new LongAdder();
        final LongAdder countMafControl = new LongAdder();
        final LongAdder countAltControl = new LongAdder();
        final LongAdder countMafRatio = new LongAdder();
        final LongAdder countAltRatio = new LongAdder();
        if (needRedo) {
            IntList gtbIDofPedSubs = (IntList)context.cast("gtbIDofPedSubs");
            int threadNum = this.inputsOptions.threads;
            final IntList[] caseIDsInPed = new IntList[phenotypeNames.length];
            final IntList[] controlIDsInPed = new IntList[phenotypeNames.length];
            IntList[] otherSubIDsInPed = new IntList[phenotypeNames.length];
            final boolean[] haveCases = new boolean[phenotypeNames.length];
            final boolean[] haveControls = new boolean[phenotypeNames.length];
            final FieldGroupMetas fieldsAll = new FieldGroupMetas();
            for (int phenotypeIndex = 0; phenotypeIndex < phenotypeNames.length; ++phenotypeIndex) {
                boolean isBinaryPhenotype = GlobalPedIndividuals.isBinaryPhenotypes(phenotypeIndex);
                caseIDsInPed[phenotypeIndex] = new IntList();
                controlIDsInPed[phenotypeIndex] = new IntList();
                otherSubIDsInPed[phenotypeIndex] = new IntList();
                int subjectNum = gtbIDofPedSubs.size();
                block5: for (int i = 0; i < subjectNum; ++i) {
                    if (gtbIDofPedSubs.fastGet(i) == -1) continue;
                    double[] phenotypes = (double[])GlobalPedIndividuals.get(i, "phenotype");
                    double phenotype = phenotypes[phenotypeIndex];
                    if (!isBinaryPhenotype) continue;
                    switch ((int)phenotype) {
                        case 0: {
                            controlIDsInPed[phenotypeIndex].add(i);
                            continue block5;
                        }
                        case 1: {
                            caseIDsInPed[phenotypeIndex].add(i);
                            continue block5;
                        }
                        default: {
                            otherSubIDsInPed[phenotypeIndex].add(i);
                        }
                    }
                }
                int allSubjectsSize = caseIDsInPed[phenotypeIndex].size() + controlIDsInPed[phenotypeIndex].size() + otherSubIDsInPed[phenotypeIndex].size();
                SetupApplication.GlobalLogger.info("{} subjects ({} cases, {} controls and {} others) have genotypes for analysis.", allSubjectsSize, caseIDsInPed[phenotypeIndex].size(), controlIDsInPed[phenotypeIndex].size(), otherSubIDsInPed[phenotypeIndex].size());
                if (caseIDsInPed[phenotypeIndex].isEmpty() && controlIDsInPed[phenotypeIndex].isEmpty()) {
                    SetupApplication.GlobalLogger.info("No case/control subjects found. Skipping case/control specific QC.");
                    context.put("AnnotationBaseVariantSet", this.inputManager.getFile().getPath());
                    continue;
                }
                int caseSubjectsSize = caseIDsInPed[phenotypeIndex].size();
                int controlSubjectsSize = controlIDsInPed[phenotypeIndex].size();
                haveCases[phenotypeIndex] = caseSubjectsSize > 0;
                haveControls[phenotypeIndex] = controlSubjectsSize > 0;
                String groupName = phenotypeNames[phenotypeIndex] + "_GTYSUM";
                FieldGroupMeta fields = new FieldGroupMeta(groupName);
                if (haveCases[phenotypeIndex]) {
                    fields.addField(this.RefHomGtyNum_CASE.simpleName(), FieldType.varInt32);
                    fields.addField(this.HetGtyNum_CASE.simpleName(), FieldType.varInt32);
                    fields.addField(this.AltHomGtyNum_CASE.simpleName(), FieldType.varInt32);
                    fields.addField(this.MissingGtyNum_CASE.simpleName(), FieldType.varInt32);
                }
                if (haveControls[phenotypeIndex]) {
                    fields.addField(this.RefHomGtyNum_CONTROL.simpleName(), FieldType.varInt32);
                    fields.addField(this.HetGtyNum_CONTROL.simpleName(), FieldType.varInt32);
                    fields.addField(this.AltHomGtyNum_CONTROL.simpleName(), FieldType.varInt32);
                    fields.addField(this.MissingGtyNum_CONTROL.simpleName(), FieldType.varInt32);
                }
                fieldsAll.addFields((Iterable)fields);
            }
            final boolean needHweCaseFilter = this.inputsOptions.hweCase != null;
            final double hweCaseThreshold = needHweCaseFilter ? this.inputsOptions.hweCase : 0.0;
            final boolean needNonMissingRateCaseFilter = this.inputsOptions.minObsRateCase != null;
            final float nonMissingRateCase = needNonMissingRateCaseFilter ? this.inputsOptions.minObsRateCase.floatValue() : 0.0f;
            final boolean needLocalMafCaseFilter = this.inputsOptions.localMafCase != null;
            final FloatInterval localMafCutCase = needLocalMafCaseFilter ? this.inputsOptions.localMafCase : null;
            final boolean needLocalAltCaseFilter = this.inputsOptions.localAfCase != null;
            final FloatInterval localAltCutCase = needLocalAltCaseFilter ? this.inputsOptions.localAfCase : null;
            final boolean needHweControlFilter = this.inputsOptions.hweControl != null;
            final double hweControlThreshold = needHweControlFilter ? this.inputsOptions.hweControl : 0.0;
            final boolean needNonMissingRateControlFilter = this.inputsOptions.minObsRateControl != null;
            final float nonMissingRateControl = needNonMissingRateControlFilter ? this.inputsOptions.minObsRateControl.floatValue() : 0.0f;
            final boolean needLocalMafControlFilter = this.inputsOptions.localMafControl != null;
            final FloatInterval localMafCutControl = needLocalMafControlFilter ? this.inputsOptions.localMafControl : null;
            final boolean needLocalAltControlFilter = this.inputsOptions.localAfControl != null;
            final FloatInterval localAltCutControl = needLocalAltControlFilter ? this.inputsOptions.localAfControl : null;
            final boolean needMafRatioFilter = this.inputsOptions.minCaseControlMafRatio != null;
            final float minMafRatio = needMafRatioFilter ? this.inputsOptions.minCaseControlMafRatio.floatValue() : 0.0f;
            final boolean needAltRatioFilter = this.inputsOptions.minCaseControlAfRatio != null;
            final float minAltRatio = needAltRatioFilter ? this.inputsOptions.minCaseControlAfRatio.floatValue() : 0.0f;
            final MultiProgressBar bar = new MultiProgressBar.Builder().setRenderers(new TextProgressRenderers().add("Input", "variants").add("Output", "variants")).build();
            final Set<String> filePathIDs = this.inputManager.getMeta().get("SOURCE@FILE_ID").apply(meta -> (String)meta.getValue()).toSet();
            GTBAnnotator annotator = GTBAnnotator.setInput(new GTBReaderOption(this.inputManager, false, true)).setOutput(this.outputFile).addMeta(this.inputManager.getMeta()).addDatabase(new PointerDatabase<Variant>(){
                {
                    for (String filePath : filePathIDs) {
                        GTBManager gtbManager = new GTBManager(filePath);
                        this.addTable(filePath, new GTBReaderOption(gtbManager, true, false));
                    }
                }

                @Override
                public Object getSource(Variant variant) {
                    return variant.getProperty("SOURCE@FILE_ID");
                }

                @Override
                public long getPointer(Variant variant) {
                    return (Long)variant.getProperty("SOURCE@FILE_POINTER");
                }

                @Override
                public IFieldCollection getAllFields() {
                    return fieldsAll;
                }

                @Override
                public boolean annotate(List<BoxRecord> databaseRecords, long pointer, Variant variant) {
                    if (databaseRecords == null || databaseRecords.isEmpty()) {
                        return false;
                    }
                    BoxRecord databaseRecord = databaseRecords.get(0);
                    IGenotypes genotypes = IGenotypes.load((Bytes)databaseRecord.get(null, "GT"));
                    for (int phenotypeIndex = 0; phenotypeIndex < phenotypeNames.length; ++phenotypeIndex) {
                        float maf;
                        int CASE_COUNT_AA = 0;
                        int CASE_COUNT_AB = 0;
                        int CASE_COUNT_BB = 0;
                        int CASE_COUNT_AC = 0;
                        int CASE_COUNT_AN = 0;
                        float CASE_COUNT_AF = 0.0f;
                        int CONTROL_COUNT_AA = 0;
                        int CONTROL_COUNT_AB = 0;
                        int CONTROL_COUNT_BB = 0;
                        int CONTROL_COUNT_AC = 0;
                        int CONTROL_COUNT_AN = 0;
                        float CONTROL_COUNT_AF = 0.0f;
                        int caseSubjectsSize = 0;
                        int controlSubjectsSize = 0;
                        if (haveCases[phenotypeIndex]) {
                            ICounter caseGenotypeCounter = genotypes.subGenotypes(caseIDsInPed[phenotypeIndex]).counter();
                            CASE_COUNT_AA = caseGenotypeCounter.count(Genotype.of(0, 0));
                            CASE_COUNT_AB = caseGenotypeCounter.count(Genotype.of(0, 1)) + caseGenotypeCounter.count(Genotype.of(1, 0));
                            CASE_COUNT_BB = caseGenotypeCounter.count(Genotype.of(1, 1));
                            CASE_COUNT_AC = caseGenotypeCounter.getAC(1);
                            CASE_COUNT_AN = caseGenotypeCounter.getAN();
                            CASE_COUNT_AF = CASE_COUNT_AN == 0 ? 0.0f : (float)CASE_COUNT_AC / (float)CASE_COUNT_AN;
                            caseSubjectsSize = caseGenotypeCounter.getAN();
                            if (needNonMissingRateCaseFilter && 1.0f - (float)caseGenotypeCounter.count(Genotype.of(-1, -1)) / (float)caseSubjectsSize < nonMissingRateCase) {
                                countObsCaseFail.increment();
                                return false;
                            }
                            if (needLocalAltCaseFilter && !localAltCutCase.contains(CASE_COUNT_AF, true)) {
                                return false;
                            }
                            if (needLocalAltCaseFilter) {
                                countAltCase.increment();
                            }
                            if (needLocalMafCaseFilter) {
                                float f = maf = CASE_COUNT_AF > 0.5f ? 1.0f - CASE_COUNT_AF : CASE_COUNT_AF;
                                if (!localMafCutCase.contains(maf, true)) {
                                    return false;
                                }
                                countMafCase.increment();
                            }
                            if (needHweCaseFilter && CASE_COUNT_AN > 0 && CASE_COUNT_AC > 0 && HardyWeinbergCalculator.calculate(CASE_COUNT_AA, CASE_COUNT_AB, CASE_COUNT_BB, true) < hweCaseThreshold) {
                                countHweCaseFail.increment();
                                return false;
                            }
                        }
                        if (haveControls[phenotypeIndex]) {
                            ICounter controlGenotypeCounter = genotypes.subGenotypes(controlIDsInPed[phenotypeIndex]).counter();
                            CONTROL_COUNT_AA = controlGenotypeCounter.count(Genotype.of(0, 0));
                            CONTROL_COUNT_AB = controlGenotypeCounter.count(Genotype.of(0, 1)) + controlGenotypeCounter.count(Genotype.of(1, 0));
                            CONTROL_COUNT_BB = controlGenotypeCounter.count(Genotype.of(1, 1));
                            CONTROL_COUNT_AC = controlGenotypeCounter.getAC(1);
                            CONTROL_COUNT_AN = controlGenotypeCounter.getAN();
                            CONTROL_COUNT_AF = CONTROL_COUNT_AN == 0 ? 0.0f : (float)CONTROL_COUNT_AC / (float)CONTROL_COUNT_AN;
                            controlSubjectsSize = controlGenotypeCounter.getAN();
                            if (needNonMissingRateControlFilter && (float)CONTROL_COUNT_AN / (float)(controlSubjectsSize * 2) < nonMissingRateControl) {
                                countObsControlFail.increment();
                                return false;
                            }
                            if (needLocalAltControlFilter && !localAltCutControl.contains(CONTROL_COUNT_AF, true)) {
                                return false;
                            }
                            if (needLocalAltControlFilter) {
                                countAltControl.increment();
                            }
                            if (needLocalMafControlFilter) {
                                float f = maf = CONTROL_COUNT_AF > 0.5f ? 1.0f - CONTROL_COUNT_AF : CONTROL_COUNT_AF;
                                if (!localMafCutControl.contains(maf, true)) {
                                    return false;
                                }
                                countMafControl.increment();
                            }
                            if (needHweControlFilter && CONTROL_COUNT_AN > 0 && CONTROL_COUNT_AC > 0 && HardyWeinbergCalculator.calculate(CONTROL_COUNT_AA, CONTROL_COUNT_AB, CONTROL_COUNT_BB, true) < hweControlThreshold) {
                                countHweControlFail.increment();
                                return false;
                            }
                        }
                        if (haveCases[phenotypeIndex] && haveControls[phenotypeIndex]) {
                            if (needAltRatioFilter && !(CASE_COUNT_AF >= CONTROL_COUNT_AF * minAltRatio)) {
                                return false;
                            }
                            if (needAltRatioFilter) {
                                countAltRatio.increment();
                            }
                            if (needMafRatioFilter) {
                                float controlMaf;
                                float caseMaf = CASE_COUNT_AF > 0.5f ? 1.0f - CASE_COUNT_AF : CASE_COUNT_AF;
                                float f = controlMaf = CONTROL_COUNT_AF > 0.5f ? 1.0f - CONTROL_COUNT_AF : CONTROL_COUNT_AF;
                                if (!(caseMaf >= controlMaf * minMafRatio)) {
                                    return false;
                                }
                                countMafRatio.increment();
                            }
                        }
                        if (haveCases[phenotypeIndex]) {
                            variant.setProperty(phenotypeNames[phenotypeIndex] + "_" + CaseControlSummaryQCTask.this.RefHomGtyNum_CASE.fullName(), CASE_COUNT_AA);
                            variant.setProperty(phenotypeNames[phenotypeIndex] + "_" + CaseControlSummaryQCTask.this.HetGtyNum_CASE.fullName(), CASE_COUNT_AB);
                            variant.setProperty(phenotypeNames[phenotypeIndex] + "_" + CaseControlSummaryQCTask.this.AltHomGtyNum_CASE.fullName(), CASE_COUNT_BB);
                            variant.setProperty(phenotypeNames[phenotypeIndex] + "_" + CaseControlSummaryQCTask.this.MissingGtyNum_CASE.fullName(), caseSubjectsSize - CASE_COUNT_AA - CASE_COUNT_AB - CASE_COUNT_BB);
                        }
                        if (!haveControls[phenotypeIndex]) continue;
                        variant.setProperty(phenotypeNames[phenotypeIndex] + "_" + CaseControlSummaryQCTask.this.RefHomGtyNum_CONTROL.fullName(), CONTROL_COUNT_AA);
                        variant.setProperty(phenotypeNames[phenotypeIndex] + "_" + CaseControlSummaryQCTask.this.HetGtyNum_CONTROL.fullName(), CONTROL_COUNT_AB);
                        variant.setProperty(phenotypeNames[phenotypeIndex] + "_" + CaseControlSummaryQCTask.this.AltHomGtyNum_CONTROL.fullName(), CONTROL_COUNT_BB);
                        variant.setProperty(phenotypeNames[phenotypeIndex] + "_" + CaseControlSummaryQCTask.this.MissingGtyNum_CONTROL.fullName(), controlSubjectsSize - CONTROL_COUNT_AA - CONTROL_COUNT_AB - CONTROL_COUNT_BB);
                    }
                    bar.step(0L, 1L);
                    return true;
                }
            }).setListener(new AnnotationListener<Variant>());
            annotator.submit(threadNum);
            bar.close();
            completeTaskResult.setOutputPath(this.outputFile);
            SetupApplication.GlobalTaskTracker.recordTaskCompletion(completeTaskResult);
            context.put("UpdatedBaseVariantSet", true);
        } else {
            context.put("UpdatedBaseVariantSet", false);
        }
        context.put("AnnotationBaseVariantSet", this.outputFile);
        GTBManager manager = new GTBManager(this.outputFile);
        StringBuilder outVFInfoBuilder = new StringBuilder();
        if (countObsCaseFail.sum() > 0L) {
            outVFInfoBuilder.append("\n  ").append(countObsCaseFail.sum()).append(" variants in cases with call rate < ").append(this.inputsOptions.minObsRateCase.floatValue() * 100.0f).append("% are excluded.");
        }
        if (countObsControlFail.sum() > 0L) {
            outVFInfoBuilder.append("\n  ").append(countObsControlFail.sum()).append(" variants in controls with call rate < ").append(this.inputsOptions.minObsRateControl.floatValue() * 100.0f).append("% are excluded.");
        }
        if (countHweCaseFail.sum() > 0L) {
            outVFInfoBuilder.append("\n  ").append(countHweCaseFail.sum()).append(" variants in cases with Hardy-Weinberg test P < ").append(this.inputsOptions.hweCase).append(" are excluded.");
        }
        if (countHweControlFail.sum() > 0L) {
            outVFInfoBuilder.append("\n  ").append(countHweControlFail.sum()).append(" variants in controls with Hardy-Weinberg test P < ").append(this.inputsOptions.hweControl).append(" are excluded.");
        }
        if (!(outVFInfo = outVFInfoBuilder.toString()).isEmpty()) {
            SetupApplication.GlobalLogger.info("Case/Control specific filtration summaries for {}: {}", (Object)this.inputManager.getFile().getName(), (Object)outVFInfo);
        }
        SetupApplication.GlobalLogger.info("{} variants passed all filters and are stored in {}.", (Object)manager.numOfVariants(), (Object)manager.getFile().getPath());
        context.put("OutputManager", manager);
    }

    private String digest(String[] phenotypeName) {
        StringBuilder sb = new StringBuilder(256);
        sb.append(Arrays.toString(phenotypeName));
        sb.append('|').append(this.inputsOptions.hweCase).append('|').append(this.inputsOptions.hweControl).append('|').append(this.inputsOptions.minObsRateCase).append('|').append(this.inputsOptions.minObsRateControl).append('|').append(this.inputsOptions.localMafCase).append('|').append(this.inputsOptions.localMafControl).append('|').append(this.inputsOptions.localAfCase).append('|').append(this.inputsOptions.localAfControl).append('|').append(this.inputsOptions.minCaseControlMafRatio).append('|').append(this.inputsOptions.minCaseControlAfRatio);
        return ITrack.digest(sb.toString());
    }
}

