/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.annotation.database.DataBaseFactory;
import edu.sysu.pmglab.annotation.database.DatabaseDescription;
import edu.sysu.pmglab.annotation.database.IntervalDatabaseDescription;
import edu.sysu.pmglab.ccf.toolkit.annotator.Database;
import edu.sysu.pmglab.ccf.toolkit.annotator.DatabaseBatch;
import edu.sysu.pmglab.ccf.toolkit.listener.AnnotationListener;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.toolkit.GTBAnnotator;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.file.FileType;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.TaskTracker;
import edu.sysu.pmglab.kgga.command.Utility;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationOptions;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Optional;

public class CommonDatabaseAnnotationTask
implements ITask {
    File outputFile;
    AnnotationOptions annotationOptions;
    int threadNum;

    public CommonDatabaseAnnotationTask(AnnotationOptions annotationOptions, File outputDir, boolean makeDir, int threadNum) throws IOException {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFile = FileUtils.getSubFile(outputDir, InputOutputFileSet.getAnnotationFileName());
        this.annotationOptions = annotationOptions;
        this.threadNum = threadNum;
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        ITrack track = context.getTracker();
        File inputFile = (File)context.cast("AnnotationBaseVariantSet");
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        if (updatedVariantSet == null) {
            updatedVariantSet = false;
        }
        int usedThreadNum = this.threadNum;
        TaskTracker.TaskResult completeTaskResult = new TaskTracker.TaskResult(this.getClass().getName(), Utility.MD5File(inputFile), this.digest());
        Optional<File> outputPathOpt = SetupApplication.GlobalTaskTracker.checkTask(completeTaskResult);
        outputPathOpt.ifPresent(file -> {
            this.outputFile = file;
        });
        if (updatedVariantSet.booleanValue() || !this.outputFile.exists() || !outputPathOpt.isPresent()) {
            List<DatabaseDescription> databaseDescriptions = this.annotationOptions.varAnnotDatabase;
            List<IntervalDatabaseDescription> epigeneDatabaseDescriptions = this.annotationOptions.epigeneAnnotDatabase;
            if (databaseDescriptions != null && !databaseDescriptions.isEmpty() || epigeneDatabaseDescriptions != null && !epigeneDatabaseDescriptions.isEmpty()) {
                GTBManager input = new GTBManager(inputFile);
                GTBAnnotator annotator = GTBAnnotator.setInput(new GTBReaderOption(input, false, true)).setOutput(this.outputFile).addMeta(input.getMeta());
                DatabaseBatch.InputSetting<Variant> batch = DatabaseBatch.init(Variant.class);
                if (databaseDescriptions != null) {
                    for (DatabaseDescription databaseDescription : databaseDescriptions) {
                        LiveFile orgPath = databaseDescription.getPath();
                        Database<?, Variant> database = DataBaseFactory.instanceOf(databaseDescription);
                        if (databaseDescription.getPath().getFileType() == FileType.HTTP) {
                            usedThreadNum = 1;
                        }
                        databaseDescription.setPath(orgPath);
                        batch.add(database);
                        if (batch.numOfDatabases() <= 10) continue;
                        annotator.addDatabases(batch.build());
                        batch = DatabaseBatch.init(Variant.class);
                    }
                }
                if (epigeneDatabaseDescriptions != null) {
                    for (IntervalDatabaseDescription intervalDatabaseDescription : epigeneDatabaseDescriptions) {
                        Database<?, Variant> database = DataBaseFactory.instanceOfBED(intervalDatabaseDescription);
                        batch.add(database);
                        if (batch.numOfDatabases() <= 10) continue;
                        annotator.addDatabases(batch.build());
                        batch = DatabaseBatch.init(Variant.class);
                    }
                }
                annotator.addDatabases(batch.build());
                annotator.setListener(new AnnotationListener<Variant>()).append(usedThreadNum);
                GTBManager manager = new GTBManager(this.outputFile);
                SetupApplication.GlobalLogger.info("{} variants are annotated with common databases.", (Object)manager.numOfVariants());
            } else {
                if (this.outputFile.exists()) {
                    this.outputFile.delete();
                }
                Files.copy(inputFile.toPath(), this.outputFile.toPath(), new CopyOption[0]);
            }
            context.put("UpdatedBaseVariantSet", true);
            completeTaskResult.setOutputPath(this.outputFile);
            SetupApplication.GlobalTaskTracker.recordTaskCompletion(completeTaskResult);
        } else {
            context.put("UpdatedBaseVariantSet", false);
        }
        context.put("AnnotationBaseVariantSet", this.outputFile);
    }

    private String digest() {
        List<DatabaseDescription> databaseDescriptions = this.annotationOptions.varAnnotDatabase;
        StringBuilder dbCodes = new StringBuilder();
        for (DatabaseDescription dd : databaseDescriptions) {
            dbCodes.append(dd.toString());
            dbCodes.append(";");
        }
        List<IntervalDatabaseDescription> epiDatabaseDescriptions = this.annotationOptions.epigeneAnnotDatabase;
        for (IntervalDatabaseDescription dd : epiDatabaseDescriptions) {
            dbCodes.append(dd.toString());
            dbCodes.append(";");
        }
        return ITrack.digest(dbCodes.toString());
    }
}

