/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.converter.IConverter;
import edu.sysu.pmglab.ccf.toolkit.converter.Variant2Variant;
import edu.sysu.pmglab.ccf.toolkit.input.GTBInputOption;
import edu.sysu.pmglab.ccf.toolkit.input.MAFInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.InputOutputListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.gtb.toolkit.GTBSorter;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.setting.VariantFileMeta;
import edu.sysu.pmglab.kgga.io.InputType;
import java.io.File;
import java.io.IOException;

public class ConvertMAF2GTBTask
implements ITask {
    final VariantFileMeta variantFileMeta;
    final File outputDir;
    boolean directConvert = false;
    GeneralIOOptions generalIOOptions;
    public static final FieldMeta field = FieldMeta.of("GTYSUM@Tumor_Allele_Count", FieldType.varInt32);

    public ConvertMAF2GTBTask(GeneralIOOptions generalIOOptions, VariantFileMeta variantFileMeta, boolean directConvert, File outputDir, boolean makeDir) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.directConvert = directConvert;
        this.variantFileMeta = variantFileMeta;
        this.outputDir = outputDir;
        this.generalIOOptions = generalIOOptions;
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        List<GTBManager> convertedInputFiles = new List<GTBManager>();
        CommandOptions options = (CommandOptions)context.cast(CommandOptions.class);
        ITrack track = context.getTracker();
        boolean isConverted = false;
        if (this.variantFileMeta.type == InputType.GTB) {
            convertedInputFiles.addAll(this.variantFileMeta.inputFiles.apply(file -> {
                try {
                    return new GTBManager((LiveFile)file);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
        } else {
            if (this.variantFileMeta.type == InputType.PLINK_BED) {
                throw new IllegalArgumentException();
            }
            if (this.variantFileMeta.type == InputType.VCF) {
                throw new IllegalArgumentException();
            }
            if (this.variantFileMeta.type == InputType.MAF) {
                // empty if block
            }
        }
        List<LiveFile> inputFiles = this.variantFileMeta.inputFiles;
        for (LiveFile inputFile : inputFiles) {
            VariantFileMeta processedFileSet;
            GTBManager manager;
            if (inputFile.getName().endsWith(".gtb")) {
                manager = new GTBManager(inputFile);
                if (!manager.containsField(field)) {
                    throw new ParameterException("The \"" + field.fullName() + "\" field was not found in the input GTB file. Please consider regenerating it.");
                }
            } else {
                GTBSorter sorter;
                String outputFileName = inputFile.getName();
                outputFileName = outputFileName.replaceAll("19", "38");
                outputFileName = outputFileName.replaceAll("18", "38");
                outputFileName = outputFileName.replaceAll("36", "38");
                outputFileName = outputFileName.replaceAll("37", "38");
                File outputFile = FileUtils.changeExtension(new File(this.outputDir, outputFileName), ".gtb", ".maf", ".gz", ".bgz", ".maf.gz", ".maf.bgz");
                if (outputFile.exists()) {
                    if (track.contains(this.digest(outputFile))) {
                        manager = new GTBManager(outputFile);
                        if (!manager.containsField(field)) {
                            // empty if block
                        }
                    } else {
                        if (this.directConvert) {
                            Processor.setInput(new MAFInputOption(inputFile)).setOutput(new GTBOutputOption(outputFile), (inputs, output) -> {
                                output.addIndividuals(((MAFInputOption)inputs.get(0)).getIndividuals());
                                output.addFields(((MAFInputOption)inputs.get(0)).getAllFields());
                            }).bridge(new IConverter<Variant, MAFInputOption, Variant, GTBOutputOption>(){

                                @Override
                                public Iterable<Variant> converter(Variant variant, MAFInputOption mafInputOption, long l, GTBOutputOption outputOption) throws IOException {
                                    return null;
                                }
                            }).setListener(new InputOutputListener()).submit(6);
                        }
                        if (!(sorter = GTBSorter.setInput(outputFile, new String[0])).isOrdered(this.generalIOOptions.threads)) {
                            sorter.sort(outputFile, this.generalIOOptions.threads, false);
                            GTBIndexer.setInput(outputFile, new String[0]).save(this.generalIOOptions.threads);
                        } else if (new GTBManager(outputFile).getIndexer() == null) {
                            GTBIndexer.setInput(outputFile, new String[0]).save(this.generalIOOptions.threads);
                        }
                        manager = new GTBManager(outputFile);
                        track.add(this.getClass().getName(), this.digest(outputFile));
                    }
                } else {
                    if (this.directConvert) {
                        Processor.setInput(new MAFInputOption(inputFile)).setOutput(new GTBOutputOption(outputFile), (inputs, output) -> {
                            output.addIndividuals(((MAFInputOption)inputs.get(0)).getIndividuals());
                            output.addFields(((MAFInputOption)inputs.get(0)).getAllFields());
                        }).bridge(new IConverter<Variant, MAFInputOption, Variant, GTBOutputOption>(){

                            @Override
                            public Iterable<Variant> converter(Variant variant, MAFInputOption mafInputOption, long l, GTBOutputOption outputOption) throws IOException {
                                return null;
                            }
                        }).setListener(new InputListener()).submit(6);
                    }
                    if (!(sorter = GTBSorter.setInput(outputFile, new String[0])).isOrdered(this.generalIOOptions.threads)) {
                        sorter.sort(outputFile, this.generalIOOptions.threads, false);
                        GTBIndexer.setInput(outputFile, new String[0]).save(this.generalIOOptions.threads);
                    } else if (new GTBManager(outputFile).getIndexer() == null) {
                        GTBIndexer.setInput(outputFile, new String[0]).save(this.generalIOOptions.threads);
                    }
                    manager = new GTBManager(outputFile);
                    track.add(this.getClass().getName(), this.digest(outputFile));
                    isConverted = true;
                }
            }
            convertedInputFiles.add(manager);
            context.put("UpdatedBaseVariantSet", isConverted);
            context.put("CaseMutationCount", "GTYSUM@Tumor_Allele_Count");
            context.put("CaseMutationCountSubID", "GTYSUM@Tumor_Allele_SubID");
            if (convertedInputFiles.size() > 1) {
                File mergedOutput = FileUtils.getSubFile(this.outputDir, this.variantFileMeta.finalFileName);
                Processor.setInputs(convertedInputFiles.apply(GTBInputOption::new)).setOutput(new GTBOutputOption(mergedOutput)).bridge(new Variant2Variant()).setListener(new InputOutputListener()).submit(this.getThreads());
                GTBSorter sorter = GTBSorter.setInput(mergedOutput, new String[0]);
                if (!sorter.isOrdered(this.generalIOOptions.threads)) {
                    sorter.sort(mergedOutput, this.generalIOOptions.threads, false);
                    GTBIndexer.setInput(mergedOutput, new String[0]).save(this.generalIOOptions.threads);
                } else if (new GTBManager(mergedOutput).getIndexer() == null) {
                    GTBIndexer.setInput(mergedOutput, new String[0]).save(this.generalIOOptions.threads);
                }
                GTBManager mergedGTB = new GTBManager(mergedOutput);
                processedFileSet = new VariantFileMeta(mergedGTB, InputType.GTB, this.variantFileMeta.refG);
            } else {
                processedFileSet = new VariantFileMeta((GTBManager)convertedInputFiles.get(0), InputType.GTB, this.generalIOOptions.globalAnnotationGenomeVersion);
            }
            context.put("ConvertedOriginalGTBInputVariantFileSet", processedFileSet);
        }
    }

    private String digest(File outputFile) throws IOException {
        return ITrack.digest(this.variantFileMeta.hashCode(), outputFile.getCanonicalPath(), outputFile.length(), outputFile.lastModified());
    }
}

