/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.converter.Variant2Variant;
import edu.sysu.pmglab.ccf.toolkit.input.GTBInputOption;
import edu.sysu.pmglab.ccf.toolkit.input.VCFInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputOutputListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.interval.FloatInterval;
import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalTree;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.gtb.toolkit.GTBSorter;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.SpecifiedINFOParser;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.StandardVCFGenotypeParser;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype.IGenotypeController;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.variant.IVariantController;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.pipeline.VCFQualityControlOptions;
import edu.sysu.pmglab.kgga.command.setting.VariantFileMeta;
import edu.sysu.pmglab.kgga.io.InputType;
import edu.sysu.pmglab.objectpool.Producer;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;

public class ConvertPGen2GTBTask
implements ITask {
    final VariantFileMeta variantFileMeta;
    final File outputDir;
    boolean showGTY_QCMetrics = false;
    VCFQualityControlOptions vcfOptions;
    GeneralIOOptions generalIOOptions;

    public ConvertPGen2GTBTask(GeneralIOOptions generalIOOptions, VCFQualityControlOptions vcfOptions, VariantFileMeta variantFileMeta, boolean showGTY_QCMetrics, File outputDir, boolean makeDir) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.showGTY_QCMetrics = showGTY_QCMetrics;
        this.variantFileMeta = variantFileMeta;
        this.outputDir = outputDir;
        this.vcfOptions = vcfOptions;
        this.generalIOOptions = generalIOOptions;
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        VariantFileMeta convertedFileSet;
        ITrack track = context.getTracker();
        boolean isConverted = false;
        final Map<String, Producer<IGenotypeController>> genotypeControllers = this.vcfOptions.getGenotypeControllers();
        final Map<String, IVariantController> variantControllers = this.vcfOptions.getVariantController();
        final THashMap gtyFilterCounters = new THashMap(genotypeControllers.size());
        genotypeControllers.keySet().forEach(keyword -> gtyFilterCounters.put(keyword, new LongAdder()));
        THashMap variantFilterCounters = new THashMap(variantControllers.size());
        variantControllers.keySet().forEach(keyword -> variantFilterCounters.put(keyword, new LongAdder()));
        LongAdder totalMissingGTY = new LongAdder();
        LongAdder totalOriginGTY = new LongAdder();
        edu.sysu.pmglab.container.list.List<GTBManager> convertedInputFiles = new edu.sysu.pmglab.container.list.List<GTBManager>();
        for (LiveFile inputFile : this.variantFileMeta.inputFiles) {
            GTBManager manager;
            if (inputFile.getName().endsWith(".gtb")) {
                manager = new GTBManager(inputFile);
            } else {
                String outputFileName = this.replaceFileName(inputFile.getName());
                File outputFile = FileUtils.changeExtension(new File(this.outputDir, outputFileName), ".gtb", ".vcf", ".gz", ".bgz", ".vcf.gz", ".vcf.bgz");
                if (outputFile.exists() && track.contains(this.digestAll(outputFile))) {
                    manager = new GTBManager(outputFile);
                } else {
                    boolean includeVariants;
                    LiftOver liftOver = this.variantFileMeta.refG.to(this.generalIOOptions.globalAnnotationGenomeVersion);
                    FieldMeta originChromosomeField = liftOver == LiftOver.ITSELF ? null : FieldMeta.of("SOURCE", (Object)((Object)this.variantFileMeta.refG) + "_CHROM", FieldType.chromosome);
                    FieldMeta originPosField = liftOver == LiftOver.ITSELF ? null : FieldMeta.of("SOURCE", (Object)((Object)this.variantFileMeta.refG) + "_POS", FieldType.varInt32);
                    List variantControllerInstances = variantControllers.keySet().stream().map(keyword -> new IVariantController((String)keyword, variantFilterCounters){
                        final IVariantController controller;
                        final LongAdder counter;
                        final /* synthetic */ String val$keyword;
                        final /* synthetic */ Map val$variantFilterCounters;
                        {
                            this.val$keyword = string;
                            this.val$variantFilterCounters = map2;
                            this.controller = (IVariantController)variantControllers.get(this.val$keyword);
                            this.counter = (LongAdder)this.val$variantFilterCounters.get(this.val$keyword);
                        }

                        @Override
                        public String getKeyWord() {
                            return this.val$keyword;
                        }

                        @Override
                        public boolean filter(Variant variant) {
                            boolean retain = this.controller.filter(variant);
                            if (!retain) {
                                this.counter.increment();
                            }
                            return retain;
                        }
                    }).collect(Collectors.toList());
                    Map<Chromosome, IntIntervalTree<Void>> excludedRegions = this.variantFileMeta.excludedRegions;
                    boolean excludeVariants = excludedRegions != null;
                    Map<Chromosome, IntIntervalTree<Void>> includedRegions = this.variantFileMeta.includedRegions;
                    boolean bl = includeVariants = includedRegions != null;
                    if (inputFile.isBGZCompressed()) {
                        if (!inputFile.withExtension(".gz", ".bgz")) {
                            SetupApplication.GlobalLogger.warn("The file {} is compressed in blocks but not standard extension name!", (Object)inputFile.getName());
                        }
                    } else if (inputFile.isGZCompressed()) {
                        if (inputFile.withExtension(".bgz")) {
                            SetupApplication.GlobalLogger.warn("The file {} is NOT compressed in blocks and cannot be processed in parallel!", (Object)inputFile.getName());
                        } else if (inputFile.withExtension(".gz")) {
                            SetupApplication.GlobalLogger.warn("The file {} is NOT compressed in blocks and cannot be processed in parallel!", (Object)inputFile.getName());
                        }
                    }
                    Processor.setInput(new VCFInputOption(inputFile).setInfoParser(new SpecifiedINFOParser("MQ")).setGenotypeParser(i -> {
                        StandardVCFGenotypeParser parser = new StandardVCFGenotypeParser(i, false);
                        for (final String keyword : genotypeControllers.keySet()) {
                            parser.setController(new IGenotypeController(){
                                final IGenotypeController controller;
                                final LongAdder counter;
                                {
                                    this.controller = (IGenotypeController)((Producer)genotypeControllers.get(keyword)).offer();
                                    this.counter = (LongAdder)gtyFilterCounters.get(keyword);
                                }

                                @Override
                                public String getKeyWord() {
                                    return keyword;
                                }

                                @Override
                                public boolean execute(Bytes bytes, Genotype genotype) {
                                    boolean retain = this.controller.execute(bytes, genotype);
                                    if (ConvertPGen2GTBTask.this.showGTY_QCMetrics && !retain) {
                                        this.counter.increment();
                                    }
                                    return retain;
                                }
                            });
                        }
                        return parser;
                    })).setOutput(new GTBOutputOption(outputFile).addMeta(CCFMetaItem.of((Object)((Object)this.variantFileMeta.refG) + "_CHROM", "")).addField(liftOver == LiftOver.ITSELF ? null : FieldMeta.of("SOURCE", (Object)((Object)this.variantFileMeta.refG) + "_CHROM", FieldType.chromosome)).addField(liftOver == LiftOver.ITSELF ? null : FieldMeta.of("SOURCE", (Object)((Object)this.variantFileMeta.refG) + "_POS", FieldType.varInt32)), (inputs, output) -> output.addIndividuals(((VCFInputOption)inputs.fastGet(0)).getIndividuals())).bridge((variant, vcfInputOption, l, outputOption) -> {
                        variant.prune();
                        try {
                            Chromosome originChromosome;
                            for (IVariantController controller : variantControllerInstances) {
                                if (controller.filter(variant)) continue;
                                return null;
                            }
                            if (excludeVariants && excludedRegions.containsKey(originChromosome = variant.getChromosome())) {
                                int originPos = variant.getPosition();
                                if (((IntIntervalTree)excludedRegions.get(originChromosome)).contains(originPos)) {
                                    return null;
                                }
                            }
                            if (includeVariants) {
                                originChromosome = variant.getChromosome();
                                if (includedRegions.containsKey(originChromosome)) {
                                    int originPos = variant.getPosition();
                                    if (!((IntIntervalTree)includedRegions.get(originChromosome)).contains(originPos)) {
                                        return null;
                                    }
                                } else {
                                    return null;
                                }
                            }
                            if (liftOver != LiftOver.ITSELF) {
                                originChromosome = variant.getChromosome();
                                int originPos = variant.getPosition();
                                if ((variant = liftOver.convert((Variant)variant)) == null) {
                                    return null;
                                }
                                variant.setProperty(originChromosomeField.fullName(), originChromosome);
                                variant.setProperty(originPosField.fullName(), originPos);
                            }
                            totalMissingGTY.add(variant.getGenotypes().counter().getAC(-1));
                            totalOriginGTY.add((long)variant.getGenotypes().size() * 2L);
                            return variant.biallelic(Variant.BiallelicMode.SET_TO_MISSING);
                        }
                        catch (Error | Exception e) {
                            throw new RuntimeException(e);
                        }
                    }).setListener(new InputOutputListener()).submit(this.generalIOOptions.threads);
                    GTBSorter sorter = GTBSorter.setInput(outputFile, new String[0]);
                    if (!sorter.isOrdered(this.generalIOOptions.threads)) {
                        sorter.sort(outputFile, this.generalIOOptions.threads, false);
                        GTBIndexer.setInput(outputFile, new String[0]).save(this.generalIOOptions.threads);
                    } else if (new GTBManager(outputFile).getIndexer() == null) {
                        GTBIndexer.setInput(outputFile, new String[0]).save(this.generalIOOptions.threads);
                    }
                    manager = new GTBManager(outputFile);
                    track.add(this.getClass().getName(), this.digestAll(outputFile));
                    isConverted = true;
                    SetupApplication.GlobalLogger.info("{} variants of {} subjects that passed QC are stored in {} with {} coordinates.\n", new Object[]{manager.numOfVariants(), manager.numOfIndividuals(), manager.getFile(), this.generalIOOptions.globalAnnotationGenomeVersion});
                }
            }
            String outQCInfo = "";
            if (!this.vcfOptions.disableQC) {
                Object value;
                if (totalOriginGTY.sum() > 0L) {
                    outQCInfo = outQCInfo + "\n  " + totalMissingGTY + "/" + totalOriginGTY + "(" + new DecimalFormat("#.##%").format((double)totalMissingGTY.sum() / (double)totalOriginGTY.sum()) + ") genotypes with low quality are changed to non-call";
                }
                if (this.showGTY_QCMetrics) {
                    if (((LongAdder)gtyFilterCounters.get("GQ")).sum() > 0L) {
                        outQCInfo = outQCInfo + "\n  " + ((LongAdder)gtyFilterCounters.get("GQ")).sum() + " genotypes with low quality (Phred Quality Score < " + this.vcfOptions.gtyGq + ") are changed to non-call";
                    }
                    if (((LongAdder)gtyFilterCounters.get("DP")).sum() > 0L) {
                        outQCInfo = outQCInfo + "\n  " + ((LongAdder)gtyFilterCounters.get("DP")).sum() + " genotypes with read depth < " + this.vcfOptions.gtyDp + " are changed to non-call";
                    }
                    if (((LongAdder)gtyFilterCounters.get("PL")).sum() > 0L) {
                        outQCInfo = outQCInfo + "\n  " + ((LongAdder)gtyFilterCounters.get("PL")).sum() + " genotypes with high probability to be confusing (Phred-scaled likelihoods < " + this.vcfOptions.gtyPl + ") are changed to non-call";
                    }
                    if (((LongAdder)gtyFilterCounters.get("AD")).sum() > 0L) {
                        outQCInfo = outQCInfo + "\n  " + ((LongAdder)gtyFilterCounters.get("AD")).sum() + " genotypes with the fraction of the reads carrying alternative allele > " + this.vcfOptions.gtyAdHomRef + " at a reference-allele homozygous genotype or < " + this.vcfOptions.gtyAdHomAlt + " at an alternative-allele homozygous genotype or < " + this.vcfOptions.gtyAdHet + " at a heterozygous genotype are changed to non-call";
                    }
                }
                if (variantFilterCounters.containsKey("MQ") && ((LongAdder)variantFilterCounters.get("MQ")).sum() > 0L) {
                    outQCInfo = outQCInfo + "\n  " + variantFilterCounters.get("MQ") + " variants with low mapping quality (mapping quality score < " + this.vcfOptions.mq + ") are excluded";
                }
                if (variantFilterCounters.containsKey("QUAL") && ((LongAdder)variantFilterCounters.get("QUAL")).sum() > 0L) {
                    outQCInfo = outQCInfo + "\n  " + variantFilterCounters.get("QUAL") + " variants with low sequencing quality (Phred Quality Score < " + this.vcfOptions.qual + ") are excluded";
                }
                if (variantFilterCounters.containsKey("FS") && ((LongAdder)variantFilterCounters.get("FS")).sum() > 0L) {
                    outQCInfo = outQCInfo + "\n  " + variantFilterCounters.get("FS") + " variants with the overall strand bias Phred-scaled p-value (using Fisher's exact test) over " + this.vcfOptions.fs + " are excluded";
                }
                if (variantFilterCounters.containsKey("ALLELE_NUM") && ((LongAdder)variantFilterCounters.get("ALLELE_NUM")).sum() > 0L) {
                    value = this.vcfOptions.rangeOfAlleleNum;
                    outQCInfo = outQCInfo + "\n  " + variantFilterCounters.get("ALLELE_NUM") + " variants with the alternative allele number outside the range [" + ((IntInterval)value).start() + "," + ((IntInterval)value).end() + "] are excluded";
                }
                if (variantFilterCounters.containsKey("AF") && ((LongAdder)variantFilterCounters.get("AF")).sum() > 0L) {
                    value = this.vcfOptions.af;
                    outQCInfo = outQCInfo + "\n  " + variantFilterCounters.get("AF") + " variants with the alternative allele frequency (AF) outside the range [" + ((FloatInterval)value).start() + "," + ((FloatInterval)value).end() + "] are excluded";
                }
                if (variantFilterCounters.containsKey("AC") && ((LongAdder)variantFilterCounters.get("AC")).sum() > 0L) {
                    value = this.vcfOptions.ac;
                    outQCInfo = outQCInfo + "\n  " + variantFilterCounters.get("AC") + " variants with the alternative allele count (AC) outside the range [" + ((IntInterval)value).start() + "," + ((IntInterval)value).end() + "] are excluded";
                }
                if (variantFilterCounters.containsKey("AN") && ((LongAdder)variantFilterCounters.get("AN")).sum() > 0L) {
                    value = this.vcfOptions.an;
                    outQCInfo = outQCInfo + "\n  " + variantFilterCounters.get("AN") + " variants with the non-missing allele number (AN) outside the range [" + ((IntInterval)value).start() + "," + ((IntInterval)value).end() + "] are excluded";
                }
                if (variantFilterCounters.containsKey("FILTER") && ((LongAdder)variantFilterCounters.get("FILTER")).sum() > 0L) {
                    value = this.vcfOptions.seqFilter;
                    outQCInfo = outQCInfo + "\n  " + variantFilterCounters.get("FILTER") + " variants NOT with the filter label [" + ((edu.sysu.pmglab.container.list.List)value).toString(",") + "] are excluded";
                }
                if (!outQCInfo.isEmpty()) {
                    SetupApplication.GlobalLogger.info("Quality Control Summaries: {}", (Object)outQCInfo);
                }
            }
            convertedInputFiles.add(manager);
        }
        context.put("UpdatedBaseVariantSet", isConverted);
        if (convertedInputFiles.size() > 1) {
            GTBManager mergedGTB;
            File mergedOutput = FileUtils.getSubFile(this.outputDir, this.variantFileMeta.finalFileName);
            String code = this.digest(mergedOutput);
            if (!mergedOutput.exists() || !track.contains(code)) {
                Processor.setInputs(convertedInputFiles.apply(GTBInputOption::new)).setOutput(new GTBOutputOption(mergedOutput), (inputs, output) -> {
                    output.addFields(((GTBInputOption)inputs.fastGet(0)).getAllFields());
                    output.addMeta(((GTBInputOption)inputs.fastGet(0)).getMeta());
                    output.addIndividuals(((GTBInputOption)inputs.fastGet(0)).getIndividuals());
                }).bridge(new Variant2Variant()).setListener(new InputOutputListener()).submit(this.generalIOOptions.threads);
                GTBSorter sorter = GTBSorter.setInput(mergedOutput, new String[0]);
                if (!sorter.isOrdered(this.generalIOOptions.threads)) {
                    sorter.sort(mergedOutput, this.generalIOOptions.threads, false);
                    GTBIndexer.setInput(mergedOutput, new String[0]).save(this.generalIOOptions.threads);
                } else if (new GTBManager(mergedOutput).getIndexer() == null) {
                    GTBIndexer.setInput(mergedOutput, new String[0]).save(this.generalIOOptions.threads);
                }
                mergedGTB = new GTBManager(mergedOutput);
                track.add(this.getClass().getName(), this.digest(mergedOutput));
            } else {
                mergedGTB = new GTBManager(mergedOutput);
            }
            convertedFileSet = new VariantFileMeta(mergedGTB, InputType.GTB, this.generalIOOptions.globalAnnotationGenomeVersion);
        } else {
            convertedFileSet = new VariantFileMeta((GTBManager)convertedInputFiles.get(0), InputType.GTB, this.generalIOOptions.globalAnnotationGenomeVersion);
        }
        context.put("ConvertedOriginalGTBInputVariantFileSet", convertedFileSet);
    }

    private String replaceFileName(String fileName) {
        return fileName.replaceAll("hg19", "hg38").replaceAll("hg18", "hg38").replaceAll("hg36", "hg38").replaceAll("GRCh37", "hg38");
    }

    private String digest(File outputFile) throws IOException {
        return outputFile.getCanonicalPath() + outputFile.length() + outputFile.lastModified() + this.vcfOptions.disableQC + this.vcfOptions.gtyGq + this.vcfOptions.gtyDp + this.vcfOptions.gtyAdHomRef + this.vcfOptions.gtyAdHomAlt + this.vcfOptions.gtyAdHet + this.vcfOptions.gtyPl + this.vcfOptions.af + this.vcfOptions.ac + this.vcfOptions.an + this.vcfOptions.infoQC + this.vcfOptions.mq + this.vcfOptions.fs + this.vcfOptions.qual + this.vcfOptions.rangeOfAlleleNum + this.vcfOptions.seqFilter;
    }

    private String digestAll(File outputFile) throws IOException {
        return this.variantFileMeta.hashCode() + "|" + outputFile.getCanonicalPath() + "|" + outputFile.length() + "|" + outputFile.lastModified() + "|" + this.vcfOptions.disableQC + "|" + this.vcfOptions.gtyGq + "|" + this.vcfOptions.gtyDp + "|" + this.vcfOptions.gtyAdHomRef + "|" + this.vcfOptions.gtyAdHomAlt + "|" + this.vcfOptions.gtyAdHet + "|" + this.vcfOptions.gtyPl + "|" + this.vcfOptions.af + "|" + this.vcfOptions.ac + "|" + this.vcfOptions.an + "|" + this.vcfOptions.infoQC + "|" + this.vcfOptions.mq + "|" + this.vcfOptions.fs + "|" + this.vcfOptions.qual + "|" + this.vcfOptions.rangeOfAlleleNum + "|" + this.vcfOptions.seqFilter;
    }
}

