/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.annotation.database.DataBaseFactory;
import edu.sysu.pmglab.annotation.database.DatabaseDescription;
import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.annotator.Database;
import edu.sysu.pmglab.ccf.toolkit.annotator.SequentialDatabase;
import edu.sysu.pmglab.container.interval.FloatInterval;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.toolkit.GTBAnnotator;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.file.FileType;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.TaskTracker;
import edu.sysu.pmglab.kgga.command.Utility;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationOptions;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import java.io.File;
import java.io.IOException;
import java.util.Optional;

public class ExpDBAnnotationTask
implements ITask {
    File outputFile;
    AnnotationOptions annotationOptions;
    int threadNum;

    public ExpDBAnnotationTask(AnnotationOptions annotationOptions, File outputDir, boolean makeDir, int threadNum) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFile = FileUtils.getSubFile(outputDir, InputOutputFileSet.getAnnotationFileName());
        this.annotationOptions = annotationOptions;
        this.threadNum = threadNum;
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        ITrack track = context.getTracker();
        File inputFile = (File)context.cast("AnnotationBaseVariantSet");
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        if (updatedVariantSet == null) {
            updatedVariantSet = false;
        }
        TaskTracker.TaskResult completeTaskResult = new TaskTracker.TaskResult(this.getClass().getName(), Utility.MD5File(inputFile), this.digest());
        Optional<File> outputPathOpt = SetupApplication.GlobalTaskTracker.checkTask(completeTaskResult);
        outputPathOpt.ifPresent(file -> {
            this.outputFile = file;
        });
        if (updatedVariantSet.booleanValue() || !this.outputFile.exists() || !outputPathOpt.isPresent()) {
            final FloatInterval expCut = this.annotationOptions.expRange;
            final boolean[] considerFreqCutZero = new boolean[]{false};
            if (expCut != null && expCut.start() == 0.0f) {
                considerFreqCutZero[0] = true;
            }
            GTBManager inputManager = new GTBManager(inputFile);
            GTBAnnotator annotator = GTBAnnotator.setInput(new GTBReaderOption(inputManager, false, true)).setOutput(this.outputFile).addMeta(inputManager.getMeta());
            List<DatabaseDescription> databaseDescriptions = this.annotationOptions.expDatabase;
            final FieldGroupMetas annotatedFreqFields = new FieldGroupMetas();
            int usedThreadNum = this.threadNum;
            for (DatabaseDescription databaseDescription : databaseDescriptions) {
                LiveFile orgPath = databaseDescription.getPath();
                Database<?, Variant> database = DataBaseFactory.instanceOf(databaseDescription);
                if (databaseDescription.getPath().getFileType() == FileType.HTTP) {
                    usedThreadNum = 1;
                }
                databaseDescription.setPath(orgPath);
                annotator.addDatabase(database);
                annotatedFreqFields.addFields((Iterable)database.getAllFields());
            }
            annotator.addDatabase(new SequentialDatabase<Variant>(){

                @Override
                public boolean annotate(List<BoxRecord> resources, long pointer, Variant variant) {
                    if (expCut == null) {
                        return true;
                    }
                    for (FieldMeta ccfField : annotatedFreqFields) {
                        if (variant.getProperty(ccfField.fullName()) == null) continue;
                        float variantAF = ((Float)variant.getProperty(ccfField.fullName())).floatValue();
                        if (Float.isNaN(variantAF) && considerFreqCutZero[0]) {
                            return true;
                        }
                        if (expCut.contains(Math.min(variantAF, 1.0f - variantAF), true)) continue;
                        return false;
                    }
                    return true;
                }
            });
            annotator.submit(usedThreadNum);
            inputManager = new GTBManager(inputFile);
            GTBManager outputManager = new GTBManager(this.outputFile);
            if (expCut != null) {
                SetupApplication.GlobalLogger.info("{} out of {} variants with expression values {} are retained and annotated.", outputManager.numOfVariants(), inputManager.numOfVariants(), expCut);
            } else {
                SetupApplication.GlobalLogger.info("{} variants are annotated with expression values.", (Object)outputManager.numOfVariants());
            }
            completeTaskResult.setOutputPath(this.outputFile);
            SetupApplication.GlobalTaskTracker.recordTaskCompletion(completeTaskResult);
            context.put("UpdatedBaseVariantSet", true);
        } else {
            context.put("UpdatedBaseVariantSet", false);
        }
        context.put("AnnotationBaseVariantSet", this.outputFile);
    }

    public String digest() throws IOException {
        List<DatabaseDescription> databaseDescriptions = this.annotationOptions.expDatabase;
        StringBuilder dbCodes = new StringBuilder();
        for (DatabaseDescription dd : databaseDescriptions) {
            dbCodes.append(dd.toString());
            dbCodes.append(";");
        }
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)dbCodes).append("|");
        sb.append(this.annotationOptions.expRange == null ? "." : this.annotationOptions.expRange.toString());
        return ITrack.digest(sb.toString());
    }
}

