/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.annotation.Var2RegionMapper;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.ReaderStream;
import edu.sysu.pmglab.io.text.reader.CustomSeparator;
import edu.sysu.pmglab.io.writer.WriterStream;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.TaskTracker;
import edu.sysu.pmglab.kgga.command.Utility;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationOptions;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.pipeline.SimulationOptions;
import edu.sysu.pmglab.kgga.command.setting.OrderSeparator;
import edu.sysu.pmglab.kgga.command.setting.PhenotypeGeneSetting;
import edu.sysu.pmglab.kgga.command.setting.SamplingGroupSetting;
import edu.sysu.pmglab.kgga.command.setting.SamplingSetting;
import edu.sysu.pmglab.kgga.command.setting.SpatialGeneSetting;
import edu.sysu.pmglab.kgga.command.setting.TimingGeneModelSetting;
import edu.sysu.pmglab.kgga.command.setting.TimingGeneSetting;
import edu.sysu.pmglab.kgga.command.setting.XqtlGeneSetting;
import edu.sysu.pmglab.kgga.io.GlobalPedIndividuals;
import edu.sysu.pmglab.simulation.GeneExpressionLiabilitySimulator;
import edu.sysu.pmglab.simulation.SpatialTranscriptomicsSimulator;
import edu.sysu.pmglab.simulation.SpatialTranscriptomicsSimulatorMaternKernel;
import edu.sysu.pmglab.stat.Summary;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.math3.random.MersenneTwister;

public class ExpressionPhenotypeSimulateTask
implements ITask {
    final File outputFolder;
    SimulationOptions simulationOptions;
    AnnotationOptions annotationOptions;
    GeneralIOOptions generalIOOptions;

    public ExpressionPhenotypeSimulateTask(GeneralIOOptions generalIOOptions, AnnotationOptions annotationOptions, SimulationOptions simulationOptions, File outputDir, boolean makeDir) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFolder = outputDir;
        this.simulationOptions = simulationOptions;
        this.annotationOptions = annotationOptions;
        this.generalIOOptions = generalIOOptions;
    }

    private IndexableSet<String> readCandidateGenes(LiveFile file, int topGeneNum) throws IOException {
        LinkedSet<String> idSet = new LinkedSet<String>();
        try (ReaderStream fs = file.openAsText();){
            CustomSeparator separator = new CustomSeparator(new OrderSeparator());
            int count = 0;
            do {
                Bytes line;
                if ((line = fs.readline()) == null) {
                    break;
                }
                edu.sysu.pmglab.container.list.List<Bytes> row = separator.accept(line);
                ((AbstractCollection)idSet).add(row.fastGet(0).toString());
            } while (++count < topGeneNum);
        }
        return idSet;
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        ITrack track = context.getTracker();
        File inputFile = (File)context.cast("AnnotationBaseVariantSet");
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        if (updatedVariantSet == null) {
            updatedVariantSet = false;
        }
        Boolean updatedGeneSet = (Boolean)context.cast("UpdatedBaseGeneSet");
        long randomSeed = this.generalIOOptions.randomSeed;
        if (randomSeed == 0L) {
            randomSeed = System.nanoTime();
        }
        Random random = new Random(randomSeed);
        XqtlGeneSetting xqtlGenes = this.simulationOptions.xqtlGeneSetting;
        int maxQTLPerGene = xqtlGenes.getMaxNum();
        PhenotypeGeneSetting phenotypeGenes = this.simulationOptions.phenotypeGeneSetting;
        IndexableSet geneSymbMap = (IndexableSet)context.cast("geneSymbolIDMap");
        Var2RegionMapper var2RegionMapper = new Var2RegionMapper();
        var2RegionMapper.setGeneSymbolMap(geneSymbMap);
        IndexableSet<String> subjectsIDs = GlobalPedIndividuals.uniqueIDs();
        File outputFileLiability = new File(this.outputFolder + File.separator + "phenotype.ped");
        int threadNum = this.generalIOOptions.threads;
        TimingGeneModelSetting timingGeneModel = this.simulationOptions.timingGeneModelSetting;
        if (phenotypeGenes != null && (updatedVariantSet.booleanValue() || updatedGeneSet.booleanValue() || !outputFileLiability.exists() || !track.contains(this.digestPhenotype(inputFile, outputFileLiability)))) {
            int susceptibilityGeneNum = phenotypeGenes.getMaxDrivers();
            double prevalence = phenotypeGenes.getPrevalence();
            if (xqtlGenes.getHeritability() < phenotypeGenes.getHeritability()) {
                SetupApplication.GlobalLogger.error("The heritability defined by '--xqtl-gene' must be >= that defined by  '--phenotype-gene!'");
                System.exit(-1);
            }
            GeneExpressionLiabilitySimulator simulator = new GeneExpressionLiabilitySimulator(xqtlGenes.getEffectScale(), xqtlGenes.getHeritability(), phenotypeGenes.getHeritability(), 1.0, random);
            var2RegionMapper.cleanAllGeneRegions();
            IndexableSet<String> susceptibilityGenes = this.readCandidateGenes(this.simulationOptions.xqtlGeneFile, susceptibilityGeneNum);
            edu.sysu.pmglab.container.list.List<byte[][]> genotypeCodes = var2RegionMapper.sampleGenotypesGenes(inputFile, susceptibilityGenes, threadNum, maxQTLPerGene);
            float[] liabilities = simulator.simuLiability(genotypeCodes);
            IntList caseIDs = new IntList();
            IntList controlIDs = new IntList();
            this.outputPhenotypes(subjectsIDs, liabilities, prevalence, outputFileLiability, caseIDs, controlIDs);
            track.add(this.getClass().getName(), this.digestPhenotype(inputFile, outputFileLiability));
            SetupApplication.GlobalLogger.info("{} subjects phenotypes according to {} susceptibility genes are generated and saved in {}.", subjectsIDs.size(), genotypeCodes.size(), outputFileLiability.getCanonicalPath());
            edu.sysu.pmglab.container.list.List<SamplingSetting> ccSizes = this.simulationOptions.samplingSetting;
            SamplingGroupSetting samplingGroupSetting = this.simulationOptions.samplingGroupSetting;
            if (ccSizes != null) {
                String outputPath;
                int caseSize;
                int groupNum = samplingGroupSetting.getGroupNum();
                if (Double.isNaN(prevalence)) {
                    for (int i = 0; i < groupNum; ++i) {
                        caseIDs.shuffle(randomSeed * (long)(4 + i));
                        caseSize = ccSizes.get(0).getSampleSize();
                        outputPath = outputFileLiability.getCanonicalPath() + "." + i;
                        this.outputPhenotypes(subjectsIDs, liabilities, outputPath, caseIDs.subList(0, caseSize));
                    }
                } else {
                    for (int i = 0; i < groupNum; ++i) {
                        caseIDs.shuffle(randomSeed * (long)(4 + i));
                        controlIDs.shuffle(randomSeed * (long)(4 + i));
                        int controlSize = ccSizes.get(0).getControlSampleSize();
                        caseSize = ccSizes.get(0).getCaseSampleSize();
                        if (caseSize > caseIDs.size()) {
                            caseSize = caseIDs.size();
                        }
                        if (controlSize > controlIDs.size()) {
                            controlSize = controlIDs.size();
                        }
                        outputPath = outputFileLiability.getCanonicalPath() + "." + i;
                        this.outputPhenotypes(subjectsIDs, outputPath, caseIDs.subList(0, caseSize), controlIDs.subList(0, controlSize));
                    }
                }
            }
        } else {
            SetupApplication.GlobalLogger.info("{} is not regenerated!", (Object)outputFileLiability);
        }
        TimingGeneSetting timingGenes = this.simulationOptions.timingGeneSetting;
        if (timingGenes != null) {
            double startAge = timingGenes.getStartAge();
            double endAge = timingGenes.getEndAge();
            double ageInterval = timingGenes.getAgeInterval();
            GeneExpressionLiabilitySimulator simulator = new GeneExpressionLiabilitySimulator(xqtlGenes.getEffectScale(), xqtlGenes.getHeritability(), phenotypeGenes.getHeritability(), 1.0, random);
            simulator.setTimingGeneModel(timingGeneModel);
            var2RegionMapper.cleanAllGeneRegions();
            IndexableSet<String> eQTLGenes = this.readCandidateGenes(this.simulationOptions.xqtlGeneFile, timingGenes.getMaxTimeGenes());
            int pointSampleSize = timingGenes.getSampleSizePerAge();
            int sampleNum = timingGenes.getSampleNum();
            int ageNum = (int)((endAge - startAge) / ageInterval + 1.0);
            THashMap<String, float[]> geneMeanSEMap = new THashMap<String, float[]>();
            int batchNum = 0;
            for (int sampleID = 0; sampleID < sampleNum; ++sampleID) {
                LinkedSet<String> nonEQTLGenes = new LinkedSet<String>();
                LinkedSet<String> collectedEQTLGenes = new LinkedSet<String>();
                edu.sysu.pmglab.container.list.List<byte[][]> genotypeCodes = var2RegionMapper.sampleGenotypesGenes(inputFile, eQTLGenes, threadNum, maxQTLPerGene, collectedEQTLGenes, nonEQTLGenes);
                int collectedEQTLGenesNum = ((AbstractCollection)collectedEQTLGenes).size();
                int nonEQTLGenesNum = ((AbstractCollection)nonEQTLGenes).size();
                startAge = timingGenes.getStartAge();
                batchNum = 0;
                AtomicReference<File> outputFileTimingExpression = new AtomicReference<File>(new File(this.outputFolder + File.separator + "gene.timing.expression.txt." + sampleID));
                TaskTracker.TaskResult completeTaskResult = new TaskTracker.TaskResult(this.getClass().getName(), Utility.MD5File(inputFile), this.digestTimingExpression());
                Optional<File> outputPathOpt = SetupApplication.GlobalTaskTracker.checkTask(completeTaskResult);
                if (!updatedVariantSet.booleanValue() && !updatedGeneSet.booleanValue() && outputPathOpt.isPresent() && outputFileTimingExpression.get().exists()) continue;
                edu.sysu.pmglab.container.list.List<String> ageLabels = new edu.sysu.pmglab.container.list.List<String>();
                while (startAge <= endAge) {
                    double SE;
                    float[] expressionMeanSE;
                    String gene;
                    float[][] qtlGeneExpression = simulator.simuGeneExpression(genotypeCodes, batchNum * pointSampleSize, batchNum * pointSampleSize + pointSampleSize, startAge);
                    for (int i = 0; i < collectedEQTLGenesNum; ++i) {
                        gene = (String)((IndexableSet)collectedEQTLGenes).valueOf(i);
                        expressionMeanSE = geneMeanSEMap.computeIfAbsent(gene, k -> new float[ageNum * 2]);
                        double mean = Summary.mean(qtlGeneExpression[i]);
                        SE = Summary.stddev(qtlGeneExpression[i], mean);
                        expressionMeanSE[batchNum * 2] = (float)mean;
                        expressionMeanSE[batchNum * 2 + 1] = (float)SE;
                    }
                    float[][] nonQtlGeneExpression = simulator.simuGeneExpressionTotal(qtlGeneExpression, ((AbstractCollection)nonEQTLGenes).size(), true);
                    for (int i = 0; i < nonEQTLGenesNum; ++i) {
                        gene = (String)((IndexableSet)nonEQTLGenes).valueOf(i);
                        expressionMeanSE = geneMeanSEMap.computeIfAbsent(gene, k -> new float[ageNum * 2]);
                        double mean = Summary.mean(nonQtlGeneExpression[i]);
                        SE = Summary.stddev(nonQtlGeneExpression[i], mean);
                        expressionMeanSE[batchNum * 2] = (float)mean;
                        expressionMeanSE[batchNum * 2 + 1] = (float)SE;
                    }
                    ageLabels.add(String.valueOf(startAge));
                    startAge += ageInterval;
                    ++batchNum;
                }
                this.outputTimingGeneExpression(geneMeanSEMap, ageLabels, collectedEQTLGenes, nonEQTLGenes, outputFileTimingExpression.get(), false);
                completeTaskResult.setOutputPath(outputFileTimingExpression.get());
                SetupApplication.GlobalTaskTracker.recordTaskCompletion(completeTaskResult);
                SetupApplication.GlobalLogger.info("{} temporal-specific and {} other genes expression at {} ages are assigned and saved in {}.", collectedEQTLGenesNum, nonEQTLGenesNum, ageLabels.size(), outputFileTimingExpression.get().getCanonicalPath());
            }
        }
        AtomicReference<File> outputFileSpatialExpression = new AtomicReference<File>(new File(this.outputFolder + File.separator + "gene.spatial.expression.0.txt"));
        SpatialGeneSetting spatialGene = this.simulationOptions.spatialGeneSetting;
        TaskTracker.TaskResult completeTaskResult = new TaskTracker.TaskResult(this.getClass().getName(), Utility.MD5File(inputFile), this.digestSpatialExpression());
        Optional<File> outputPathOpt = SetupApplication.GlobalTaskTracker.checkTask(completeTaskResult);
        outputPathOpt.ifPresent(outputFileSpatialExpression::set);
        if (spatialGene != null && (updatedVariantSet.booleanValue() || updatedGeneSet.booleanValue() || !outputFileSpatialExpression.get().exists() || !outputPathOpt.isPresent())) {
            int gridSize = spatialGene.getChipSize();
            int[] hotSpots = null;
            if (spatialGene.getHotLocations().indexOf(58) >= 0) {
                String[] hotSpotStr = spatialGene.getHotLocations().split(",");
                hotSpots = new int[hotSpotStr.length * 2];
                for (int i = 0; i < hotSpotStr.length; ++i) {
                    String[] locations = hotSpotStr[i].split(":");
                    hotSpots[i * 2] = Integer.parseInt(locations[0]);
                    hotSpots[i * 2 + 1] = Integer.parseInt(locations[1]);
                    if (hotSpots[i * 2] <= gridSize && hotSpots[i * 2 + 1] <= gridSize) continue;
                    SetupApplication.GlobalLogger.error("The hot expression region {} is out of the chip size {}!", (Object)hotSpotStr[i], (Object)gridSize);
                }
            }
            int specificGeneNum = spatialGene.getMaxHotExpressionGenes();
            double spatialSparsity = spatialGene.getDropoutRate();
            int chipNum = spatialGene.getNumChips();
            var2RegionMapper.cleanAllGeneRegions();
            LinkedSet<String> nonEQTLGenes = new LinkedSet<String>();
            LinkedSet<String> collectedEQTLGenes = new LinkedSet<String>();
            IndexableSet<String> eQTLGenes = this.readCandidateGenes(this.simulationOptions.xqtlGeneFile, specificGeneNum);
            var2RegionMapper.sampleGenotypesGenes(inputFile, eQTLGenes, threadNum, maxQTLPerGene, collectedEQTLGenes, nonEQTLGenes);
            int collectedEQTLGenesNum = ((AbstractCollection)collectedEQTLGenes).size();
            int nonEQTLGenesNum = ((AbstractCollection)nonEQTLGenes).size();
            ArrayList<int[]> locations = new ArrayList<int[]>();
            for (int i = 0; i < gridSize; ++i) {
                int j = 0;
                while (j < gridSize) {
                    locations.add(new int[]{i, j++});
                }
            }
            int numGenes = collectedEQTLGenesNum + nonEQTLGenesNum;
            ArrayList<List<int[]>> hotspotsPerGene = new ArrayList<List<int[]>>();
            for (int g = 0; g < numGenes; ++g) {
                hotspotsPerGene.add(new ArrayList());
            }
            if (hotSpots != null) {
                int hotSpotsNum = hotSpots.length / 2;
                for (int g = 0; g < collectedEQTLGenesNum; ++g) {
                    for (int i = 0; i < hotSpotsNum; ++i) {
                        ((List)hotspotsPerGene.get(g)).add(new int[]{hotSpots[i * 2], hotSpots[i * 2 + 1]});
                    }
                }
            }
            for (int n = 0; n < chipNum; ++n) {
                outputFileSpatialExpression.set(new File(this.outputFolder + File.separator + "gene.spatial.expression.txt." + n));
                int[][] counts = this.generateSpatialArrayMaternKernel(gridSize, spatialSparsity, hotspotsPerGene, randomSeed * (long)(n + 1));
                this.outputSpatialGeneExpression(counts, collectedEQTLGenes, nonEQTLGenes, outputFileSpatialExpression.get());
                completeTaskResult.setOutputPath(outputFileSpatialExpression.get());
                SetupApplication.GlobalTaskTracker.recordTaskCompletion(completeTaskResult);
                SetupApplication.GlobalLogger.info("{} spatial-specific and {} other genes expression at {} chips are assigned and saved in {}.", collectedEQTLGenesNum, nonEQTLGenesNum, chipNum, outputFileSpatialExpression.get().getCanonicalPath());
            }
        }
    }

    int[][] generateSpatialArrayGP(int gridSize, List<int[]> locations, int numGenes, double spatialSparsity, List<List<int[]>> hotspotsPerGene) {
        SpatialTranscriptomicsSimulator simulatorS = new SpatialTranscriptomicsSimulator();
        double baseBeta0 = -0.5;
        double alpha = 4.0;
        double l = 5.0;
        double sigma2 = 0.5;
        double r = 5.0;
        MersenneTwister random1 = new MersenneTwister(42);
        int[][] counts = simulatorS.generateDataWithFFT(gridSize, gridSize, locations, numGenes, r, l, sigma2, alpha, baseBeta0, spatialSparsity, hotspotsPerGene, random1);
        return counts;
    }

    int[][] generateSpatialArrayMaternKernel(int gridSize, double spatialSparsity, List<List<int[]>> hotspotsPerGene, long seed) {
        int threads = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
        int W = gridSize;
        int H = gridSize;
        double baseline = 1.0;
        double dropout = spatialSparsity;
        double[] ellCands = new double[]{1.5};
        double[] nuCands = new double[]{2.5};
        double hotspotAmplitude = 4.0;
        double kernelCutoff = 0.001;
        SpatialTranscriptomicsSimulatorMaternKernel sim = new SpatialTranscriptomicsSimulatorMaternKernel(W, H, baseline, dropout, ellCands, nuCands, threads, seed, kernelCutoff);
        MersenneTwister random1 = new MersenneTwister(seed);
        int numGenes = hotspotsPerGene.size();
        int[][] counts = new int[gridSize * gridSize][numGenes];
        for (int i = 0; i < numGenes; ++i) {
            int[][] countsPerGene = sim.generateSingleGeneExpression(hotspotsPerGene.get(i), hotspotAmplitude, ellCands[0], nuCands[0], random1);
            for (int j = 0; j < countsPerGene.length; ++j) {
                for (int k = 0; k < countsPerGene[j].length; ++k) {
                    counts[j * countsPerGene[j].length + k][i] = countsPerGene[j][k];
                }
            }
        }
        return counts;
    }

    public void outputSpatialGeneExpression(int[][] counts, IndexableSet<String> collectedEQTLGenes, IndexableSet<String> nonEQTLGenes, File outputFile) throws IOException {
        WriterStream fs = new WriterStream(outputFile, WriterStream.Option.DEFAULT);
        fs.writeChar("gene");
        int spotNum = (int)Math.sqrt(counts.length);
        for (int i = 0; i < spotNum; ++i) {
            for (int j = 0; j < spotNum; ++j) {
                fs.write(9);
                fs.writeChar(i + ":" + j);
            }
        }
        fs.write(10);
        int geneNum = collectedEQTLGenes.size();
        for (int g = 0; g < geneNum; ++g) {
            String gene = collectedEQTLGenes.valueOf(g);
            fs.writeChar(gene);
            for (int i = 0; i < spotNum; ++i) {
                for (int j = 0; j < spotNum; ++j) {
                    fs.write(9);
                    fs.writeChar(counts[i * spotNum + j][g]);
                }
            }
            fs.write(10);
        }
        int nonEQTLGeneNum = nonEQTLGenes.size();
        for (int g = 0; g < nonEQTLGeneNum; ++g) {
            String gene = nonEQTLGenes.valueOf(g);
            fs.writeChar(gene);
            for (int i = 0; i < spotNum; ++i) {
                for (int j = 0; j < spotNum; ++j) {
                    fs.write(9);
                    fs.writeChar(counts[i * spotNum + j][g + geneNum]);
                }
            }
            fs.write(10);
        }
        fs.close();
    }

    public void outputTimingGeneExpression(Map<String, float[]> geneMeanSEMap, edu.sysu.pmglab.container.list.List<String> ageLabels, IndexableSet<String> collectedEQTLGenes, IndexableSet<String> nonEQTLGenes, File outputFile, boolean outputSE) throws IOException {
        int i;
        WriterStream fs = new WriterStream(outputFile, WriterStream.Option.DEFAULT);
        fs.writeChar("gene");
        int ageNum = ageLabels.size();
        for (int i2 = 0; i2 < ageNum; ++i2) {
            fs.write(9);
            fs.writeChar(ageLabels.get(i2));
            if (!outputSE) continue;
            fs.write(9);
            fs.writeChar(ageLabels.get(i2));
            fs.writeChar(".SE");
        }
        fs.write(10);
        for (String gene : collectedEQTLGenes) {
            fs.writeChar(gene);
            float[] expressionMeanSE = geneMeanSEMap.get(gene);
            for (i = 0; i < ageNum; ++i) {
                fs.write(9);
                fs.writeChar(expressionMeanSE[i * 2]);
                if (!outputSE) continue;
                fs.write(9);
                fs.writeChar(expressionMeanSE[i * 2 + 1]);
            }
            fs.write(10);
        }
        for (String gene : nonEQTLGenes) {
            fs.writeChar(gene);
            float[] expressionMeanSE = geneMeanSEMap.get(gene);
            for (i = 0; i < ageNum; ++i) {
                fs.write(9);
                fs.writeChar(expressionMeanSE[i * 2]);
                if (!outputSE) continue;
                fs.write(9);
                fs.writeChar(expressionMeanSE[i * 2 + 1]);
            }
            fs.write(10);
        }
        fs.close();
    }

    public void outputPhenotypes(IndexableSet<String> subjectsIDs, String outputFilePath, IntList caseIDs, IntList controlIDs) throws IOException {
        int index;
        int i;
        WriterStream fs = new WriterStream(new File(outputFilePath), WriterStream.Option.DEFAULT);
        fs.writeChar("fid\tiid\tpid\tmid\tsex\tdisease\n");
        int caseSize = caseIDs.size();
        int controlSize = controlIDs.size();
        for (i = 0; i < caseSize; ++i) {
            index = caseIDs.get(i);
            fs.writeChar(subjectsIDs.valueOf(index));
            fs.write(9);
            fs.writeChar(subjectsIDs.valueOf(index));
            fs.writeChar("\t0\t0\t1\t2\n");
        }
        for (i = 0; i < controlSize; ++i) {
            index = controlIDs.get(i);
            fs.writeChar(subjectsIDs.valueOf(index));
            fs.write(9);
            fs.writeChar(subjectsIDs.valueOf(index));
            fs.writeChar("\t0\t0\t1\t1\n");
        }
        fs.close();
    }

    public void outputPhenotypes(IndexableSet<String> subjectsIDs, float[] liabilities, String outputFilePath, IntList sampleIDs) throws IOException {
        int sampleSize = sampleIDs.size();
        WriterStream fs = new WriterStream(new File(outputFilePath), WriterStream.Option.DEFAULT);
        fs.writeChar("fid\tiid\tpid\tmid\tsex\ttrait\n");
        for (int i = 0; i < sampleSize; ++i) {
            int index = sampleIDs.get(i);
            fs.writeChar(subjectsIDs.valueOf(index));
            fs.write(9);
            fs.writeChar(subjectsIDs.valueOf(index));
            fs.writeChar("\t0\t0\t1\t");
            fs.writeChar(liabilities[index]);
            fs.write(10);
        }
        fs.close();
    }

    public void outputPhenotypes(IndexableSet<String> subjectsIDs, float[] liabilities, double prevalence, File outputFile, IntList caseIDs, IntList controlIDs) throws IOException {
        float[] liabilitiesSorted = (float[])liabilities.clone();
        Arrays.sort(liabilitiesSorted);
        float cut = Float.NaN;
        boolean hasCut = false;
        if (!Double.isNaN(prevalence)) {
            cut = liabilitiesSorted[(int)((1.0 - prevalence) * (double)liabilitiesSorted.length)];
            hasCut = true;
        }
        WriterStream fs = null;
        fs = new WriterStream(outputFile, WriterStream.Option.DEFAULT);
        fs.writeChar("fid\tiid\tpid\tmid\tsex\tdisease\n");
        for (int i = 0; i < liabilities.length; ++i) {
            fs.writeChar(subjectsIDs.valueOf(i));
            fs.write(9);
            fs.writeChar(subjectsIDs.valueOf(i));
            fs.writeChar("\t0\t0\t1\t");
            if (hasCut) {
                if (liabilities[i] <= cut) {
                    fs.writeChar(1);
                    controlIDs.add(i);
                } else {
                    fs.writeChar(2);
                    caseIDs.add(i);
                }
            } else {
                fs.writeChar(liabilities[i]);
                caseIDs.add(i);
            }
            fs.write(10);
        }
        fs.close();
    }

    public String digestPhenotype(File inputFile, File outputFile) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(inputFile.getCanonicalPath()).append("|").append(inputFile.length()).append("|").append(inputFile.lastModified()).append("|").append(outputFile.getCanonicalPath()).append("|").append(outputFile.length()).append("|").append(outputFile.lastModified()).append("|");
        sb.append(this.simulationOptions.timingGeneModelSetting == null ? "" : this.simulationOptions.timingGeneModelSetting.toString()).append("|");
        sb.append(this.simulationOptions.spatialGeneSetting == null ? "" : this.simulationOptions.spatialGeneSetting.toString()).append("|");
        sb.append(this.simulationOptions.xqtlGeneFile.hashCode()).append("|");
        sb.append(this.simulationOptions.phenotypeGeneSetting.toString()).append("|");
        sb.append(this.simulationOptions.samplingSetting.toString()).append("|");
        return ITrack.digest(sb.toString());
    }

    public String digestTimingExpression() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.simulationOptions.timingGeneModelSetting == null ? "." : this.simulationOptions.timingGeneModelSetting.toString()).append("|");
        sb.append(this.simulationOptions.xqtlGeneFile.hashCode()).append("|");
        sb.append(this.simulationOptions.timingGeneSetting == null ? "." : this.simulationOptions.timingGeneSetting.toString()).append("|");
        return ITrack.digest(sb.toString());
    }

    public String digestSpatialExpression() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.simulationOptions.timingGeneModelSetting == null ? "." : this.simulationOptions.timingGeneModelSetting.toString()).append("|");
        sb.append(this.simulationOptions.xqtlGeneFile.hashCode()).append("|");
        sb.append(this.simulationOptions.spatialGeneSetting == null ? "." : this.simulationOptions.spatialGeneSetting).append("|");
        return ITrack.digest(sb.toString());
    }
}

