/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.annotation.database.DataBaseFactory;
import edu.sysu.pmglab.annotation.database.DatabaseDescription;
import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.annotator.Database;
import edu.sysu.pmglab.ccf.toolkit.annotator.SequentialDatabase;
import edu.sysu.pmglab.container.interval.FloatInterval;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.toolkit.GTBAnnotator;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.file.FileType;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.TaskTracker;
import edu.sysu.pmglab.kgga.command.Utility;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationOptions;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import java.io.File;
import java.io.IOException;
import java.util.Optional;

public class FreqDBAnnotationTask
implements ITask {
    File outputFile;
    boolean forceNotFilterByFreq;
    AnnotationOptions annotationOptions;
    int threadNum;

    public FreqDBAnnotationTask(AnnotationOptions annotationOptions, File outputDir, boolean forceNotFilterByFreq, boolean makeDir, int threadNum) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFile = FileUtils.getSubFile(outputDir, InputOutputFileSet.getAnnotationFileName());
        this.forceNotFilterByFreq = forceNotFilterByFreq;
        this.annotationOptions = annotationOptions;
        this.threadNum = threadNum;
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        File inputFile = (File)context.cast("AnnotationBaseVariantSet");
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        if (updatedVariantSet == null) {
            updatedVariantSet = false;
        }
        TaskTracker.TaskResult completeTaskResult = new TaskTracker.TaskResult(this.getClass().getName(), Utility.MD5File(inputFile), this.digest());
        Optional<File> outputPathOpt = SetupApplication.GlobalTaskTracker.checkTask(completeTaskResult);
        outputPathOpt.ifPresent(file -> {
            this.outputFile = file;
        });
        if (updatedVariantSet.booleanValue() || !this.outputFile.exists() || !outputPathOpt.isPresent()) {
            boolean doAltFreqCut;
            boolean doMafCut;
            final FloatInterval mafCut = this.annotationOptions.dbMaf;
            final FloatInterval altFreqCut = this.annotationOptions.dbAf;
            final boolean[] includeFreqCutZero = new boolean[]{false, false};
            if (mafCut != null) {
                if (mafCut.start() == 0.0f) {
                    includeFreqCutZero[0] = true;
                }
                doMafCut = mafCut.start() > 0.0f || mafCut.end() < 1.0f;
            } else {
                doMafCut = false;
            }
            if (altFreqCut != null) {
                if (altFreqCut.start() == 0.0f) {
                    includeFreqCutZero[1] = true;
                }
                doAltFreqCut = altFreqCut.start() > 0.0f || altFreqCut.end() < 1.0f;
            } else {
                doAltFreqCut = false;
            }
            GTBManager inputManager = new GTBManager(inputFile);
            GTBAnnotator annotator = GTBAnnotator.setInput(new GTBReaderOption(inputManager, false, true)).setOutput(this.outputFile).addMeta(inputManager.getMeta());
            List<DatabaseDescription> databaseDescriptions = this.annotationOptions.freqDatabase;
            int usedThreadNum = this.threadNum;
            final FieldGroupMetas annotatedFreqFields = new FieldGroupMetas();
            for (DatabaseDescription databaseDescription : databaseDescriptions) {
                LiveFile orgPath = databaseDescription.getPath();
                Database<?, Variant> database = DataBaseFactory.instanceOf(databaseDescription);
                if (databaseDescription.getPath().getFileType() == FileType.HTTP) {
                    usedThreadNum = 1;
                }
                databaseDescription.setPath(orgPath);
                annotator.addDatabase(database);
                assert (database != null);
                annotatedFreqFields.addFields((Iterable)database.getAllFields());
            }
            if (!this.forceNotFilterByFreq) {
                annotator.addDatabase(new SequentialDatabase<Variant>(){

                    @Override
                    public boolean annotate(List<BoxRecord> resources, long pointer, Variant variant) {
                        if (mafCut == null && altFreqCut == null) {
                            return true;
                        }
                        for (FieldMeta ccfField : annotatedFreqFields) {
                            if (variant.getProperty(ccfField.fullName()) == null) continue;
                            float variantAF = ((Float)variant.getProperty(ccfField.fullName())).floatValue();
                            if (Float.isNaN(variantAF) && (includeFreqCutZero[0] || includeFreqCutZero[1])) {
                                return true;
                            }
                            if (altFreqCut != null && !altFreqCut.contains(variantAF, true)) {
                                return false;
                            }
                            if (mafCut == null || mafCut.contains(Math.min(variantAF, 1.0f - variantAF), true)) continue;
                            return false;
                        }
                        return true;
                    }
                });
            }
            if (!this.forceNotFilterByFreq && (doMafCut || doAltFreqCut)) {
                annotator.submit(usedThreadNum);
            } else {
                annotator.append(usedThreadNum);
            }
            GTBManager manager = new GTBManager(this.outputFile);
            if (!this.forceNotFilterByFreq) {
                if (doMafCut) {
                    SetupApplication.GlobalLogger.info("{} out of {} variants with minor allele frequencies {} are retained and annotated.", manager.numOfVariants(), new GTBManager(inputFile).numOfVariants(), mafCut);
                }
                if (doAltFreqCut) {
                    SetupApplication.GlobalLogger.info("{} out of {} variants with alternative allele frequencies {} are retained and annotated.", manager.numOfVariants(), new GTBManager(inputFile).numOfVariants(), altFreqCut);
                }
            } else {
                SetupApplication.GlobalLogger.info("{} variants are annotated with allele frequencies.", (Object)manager.numOfVariants());
            }
            completeTaskResult.setOutputPath(this.outputFile);
            SetupApplication.GlobalTaskTracker.recordTaskCompletion(completeTaskResult);
            context.put("UpdatedBaseVariantSet", true);
        } else {
            context.put("UpdatedBaseVariantSet", false);
        }
        context.put("AnnotationBaseVariantSet", this.outputFile);
    }

    public String digest() throws IOException {
        List<DatabaseDescription> databaseDescriptions = this.annotationOptions.freqDatabase;
        StringBuilder dbCodes = new StringBuilder();
        for (DatabaseDescription dd : databaseDescriptions) {
            dbCodes.append(dd.toString());
            dbCodes.append(";");
        }
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)dbCodes).append("|");
        sb.append(this.annotationOptions.dbAf.toString()).append("|");
        sb.append(this.annotationOptions.dbMaf.toString());
        return ITrack.digest(sb.toString());
    }
}

