/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.annotation.database.DatabaseDescription;
import edu.sysu.pmglab.annotation.database.GeneFeatureDBUtility;
import edu.sysu.pmglab.ccf.meta.ICCFOptions;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.rangelist.VarInt32RangeList;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.TaskTracker;
import edu.sysu.pmglab.kgga.command.Utility;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationOptions;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;

public class GeneFeatureAnnotationTask
implements ITask {
    File outputFile;
    AnnotationOptions annotationOptions;
    int threadNum;

    public GeneFeatureAnnotationTask(AnnotationOptions annotationOptions, int threadNum, File outputDir, boolean makeDir) throws IOException {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFile = FileUtils.getSubFile(outputDir, InputOutputFileSet.getAnnotationFileName());
        this.annotationOptions = annotationOptions;
        this.threadNum = threadNum;
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        TIntSet canonicalTranscriptIDSet;
        IndexableSet transcriptIDMap;
        IndexableSet geneIDMap;
        LinkedSet<String> geneSymbolIDMap;
        boolean needUpdate;
        ITrack track = context.getTracker();
        File inputFile = (File)context.cast("AnnotationBaseVariantSet");
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        if (updatedVariantSet == null) {
            updatedVariantSet = false;
        }
        GeneFeatureDBUtility.INSTANCE.fillPathWithDefaultDatabases(this.annotationOptions.geneDatabase);
        TaskTracker.TaskResult completeTaskResult = new TaskTracker.TaskResult(this.getClass().getName(), Utility.MD5File(inputFile), this.digest());
        Optional<File> outputPathOpt = SetupApplication.GlobalTaskTracker.checkTask(completeTaskResult);
        boolean bl = needUpdate = updatedVariantSet != false || !this.outputFile.exists() || !outputPathOpt.isPresent();
        if (needUpdate) {
            geneSymbolIDMap = new LinkedSet();
            geneIDMap = new LinkedSet<String>();
            transcriptIDMap = new LinkedSet<String>();
            canonicalTranscriptIDSet = new TIntHashSet();
            GeneFeatureDBUtility.INSTANCE.getUnifiedIDs(this.annotationOptions.geneDatabase, geneSymbolIDMap, geneIDMap, transcriptIDMap, canonicalTranscriptIDSet);
            GeneFeatureDBUtility.INSTANCE.annotateTo(inputFile, this.outputFile, geneSymbolIDMap, geneIDMap, transcriptIDMap, canonicalTranscriptIDSet, this.annotationOptions, this.threadNum);
            completeTaskResult.setOutputPath(this.outputFile);
            SetupApplication.GlobalTaskTracker.recordTaskCompletion(completeTaskResult);
            context.put("UpdatedBaseVariantSet", true);
        } else {
            this.outputFile = outputPathOpt.get();
            GTBManager manager = new GTBManager(this.outputFile);
            ICCFOptions meta = manager.getOptions();
            geneSymbolIDMap = (IndexableSet)meta.get("$GeneSymbolIDMap");
            geneIDMap = (IndexableSet)meta.get("$GeneIDMap");
            transcriptIDMap = (IndexableSet)meta.get("$TranscriptIDMap");
            canonicalTranscriptIDSet = (TIntSet)meta.get("$CanonicalTranscriptIDSet");
            context.put("UpdatedBaseVariantSet", false);
        }
        context.put("AnnotationBaseVariantSet", this.outputFile);
        context.put("geneSymbolIDMap", geneSymbolIDMap);
        context.put("geneIDMap", geneIDMap);
        context.put("transcriptIDMap", transcriptIDMap);
        context.put("canonicalTranscriptIDSet", canonicalTranscriptIDSet);
    }

    private String digest() throws IOException {
        List<DatabaseDescription> databaseDescriptions = this.annotationOptions.geneDatabase;
        StringBuilder dbCodes = new StringBuilder();
        for (DatabaseDescription dd : databaseDescriptions) {
            dbCodes.append(dd.toString());
            dbCodes.append(";");
        }
        VarInt32RangeList featureIDDs = this.annotationOptions.geneFeatureIn;
        TIntIterator ids = featureIDDs.iterator();
        while (ids.hasNext()) {
            dbCodes.append(ids.next());
            dbCodes.append(";");
        }
        Set<String> excludedGenes = this.annotationOptions.geneExcluded;
        if (excludedGenes != null) {
            for (String gene : excludedGenes) {
                dbCodes.append(gene);
                dbCodes.append(";");
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.annotationOptions.downstreamDis).append("|").append(this.annotationOptions.upstreamDis).append("|").append(this.annotationOptions.splicingDis).append("|").append((CharSequence)dbCodes);
        return ITrack.digest(sb.toString());
    }
}

