/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.analysis.DriverType;
import edu.sysu.pmglab.analysis.GeneNetworkExplorer;
import edu.sysu.pmglab.annotation.Var2RegionMapper;
import edu.sysu.pmglab.annotation.database.DataBaseFactory;
import edu.sysu.pmglab.annotation.database.DatabaseDescription;
import edu.sysu.pmglab.ccf.toolkit.annotator.Database;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.rangelist.VarInt32RangeList;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationOptions;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.pipeline.MutationCountAnalysisOptions;
import edu.sysu.pmglab.kgga.command.setting.GeneSetAssocSetting;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class GeneSetAssocTask
implements ITask {
    final File outputFolder;
    AnnotationOptions annotationOptions;
    MutationCountAnalysisOptions mutationCountAnalysisOptions;
    GeneralIOOptions generalIOOptions;

    public GeneSetAssocTask(GeneralIOOptions generalIOOptions, AnnotationOptions annotationOptions, MutationCountAnalysisOptions mutationCountAnalysisOptions, File outputDir, boolean makeDir) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFolder = outputDir;
        this.mutationCountAnalysisOptions = mutationCountAnalysisOptions;
        this.annotationOptions = annotationOptions;
        this.generalIOOptions = generalIOOptions;
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        ITrack track = context.getTracker();
        File inputFile = (File)context.cast("AnnotationBaseVariantSet");
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        if (updatedVariantSet == null) {
            updatedVariantSet = false;
        }
        List freqFields = new List();
        String adjustedACMeta = (String)context.cast("AdjustedAC");
        String caseACMeta = (String)context.cast("CaseMutationCount");
        List<DatabaseDescription> databaseDescriptions = this.annotationOptions.freqDatabase;
        if (databaseDescriptions == null || databaseDescriptions.isEmpty()) {
            throw new RuntimeException("No background allelic frequency reference databases are set!");
        }
        for (DatabaseDescription databaseDescription : databaseDescriptions) {
            Database<?, Variant> database = DataBaseFactory.instanceOf(databaseDescription);
            freqFields.addAll(List.wrap(database.getAllFieldNames()));
        }
        Boolean updatedGeneSet = (Boolean)context.cast("UpdatedBaseGeneSet");
        GeneSetAssocSetting geneSetAssocSetting = this.mutationCountAnalysisOptions.geneSetAssocSetting;
        String[] mergedScoreNameArray = (String[])context.cast("mergedScoreNameArray");
        if (mergedScoreNameArray == null && ((mergedScoreNameArray = geneSetAssocSetting.getWeightFields()) == null || mergedScoreNameArray.length == 0)) {
            mergedScoreNameArray = new String[]{null};
        }
        for (String countWeightingScore : mergedScoreNameArray) {
            String outputPrefix = this.outputFolder.toString() + File.separator + countWeightingScore + ".geneset.assoc.txt";
            File outputFile = new File(outputPrefix);
            if (updatedVariantSet.booleanValue() || updatedGeneSet.booleanValue() || !outputFile.exists() || !track.contains(this.digest(inputFile, outputFile))) {
                boolean considerFunVar;
                String mutationSubjectField = (String)context.cast("CaseMutationCountSubID");
                String mutationCountField = (String)context.cast("CaseMutationCount");
                Map geneSubRegionLength = (Map)context.cast("geneSubRegionLength");
                IndexableSet geneSymbMap = (IndexableSet)context.cast("geneSymbolIDMap");
                List varFeatureNames = new List();
                Var2RegionMapper var2RegionMapper = new Var2RegionMapper();
                var2RegionMapper.setGeneSymbolMap(geneSymbMap);
                TIntHashSet selectedFeatures = new TIntHashSet();
                VarInt32RangeList featureIDDs = this.annotationOptions.geneFeatureIn;
                TIntIterator ids = featureIDDs.iterator();
                while (ids.hasNext()) {
                    selectedFeatures.add(ids.next());
                }
                var2RegionMapper.setResponseGeneFeature(selectedFeatures);
                DriverType driverType = DriverType.GENE;
                List<String> runningVarFeatureNames = new List<String>();
                runningVarFeatureNames.addAll(varFeatureNames);
                var2RegionMapper.cleanAllGeneRegions();
                int threadNum = this.generalIOOptions.threads;
                String mutationSubjectControlField = (String)context.cast("ControlMutationCountSubID");
                String mutationCountControlField = (String)context.cast("ControlMutationCount");
                var2RegionMapper.assignVars2GenesWithPredictors(adjustedACMeta, caseACMeta, inputFile, mutationSubjectField, mutationCountField, mutationSubjectControlField, mutationCountControlField, countWeightingScore, runningVarFeatureNames, geneSymbMap, geneSubRegionLength, true, threadNum, Double.NaN, freqFields.toArray((T1[])new String[0]));
                boolean bl = considerFunVar = countWeightingScore != null;
                if (considerFunVar) {
                    var2RegionMapper.newStandardizeVariantScoresWithThread(threadNum);
                }
                var2RegionMapper.generateCalcGeneRegionSet(geneSetAssocSetting, (IndexableSet<String>)geneSymbMap);
                GeneNetworkExplorer geneNetworkExplorer = new GeneNetworkExplorer(this.mutationCountAnalysisOptions.rServer);
                geneNetworkExplorer.compareMutationFreq(var2RegionMapper.getCalcRegionSetList(), outputFile, threadNum, geneSymbMap);
                track.add(this.getClass().getName(), this.digest(inputFile, outputFile));
                continue;
            }
            SetupApplication.GlobalLogger.info(outputPrefix + " is not regenerated!");
        }
    }

    public String digest(File inputFile, File outputFile) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(inputFile.getCanonicalPath()).append("|").append(inputFile.length()).append("|").append(inputFile.lastModified()).append("|").append(outputFile.getCanonicalPath()).append("|").append(outputFile.length()).append("|").append(outputFile.lastModified()).append("|").append(this.mutationCountAnalysisOptions.countRegressionRunnerSetting == null ? "." : this.mutationCountAnalysisOptions.countRegressionRunnerSetting.toString()).append("|").append(this.mutationCountAnalysisOptions.countRegressionVSRSetting == null ? "." : this.mutationCountAnalysisOptions.countRegressionVSRSetting.toString()).append("|").append(this.mutationCountAnalysisOptions.interactionSetting == null ? "." : this.mutationCountAnalysisOptions.interactionSetting.toString());
        return sb.toString();
    }
}

