/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.converter.IConverter;
import edu.sysu.pmglab.ccf.toolkit.converter.Variant2Variant;
import edu.sysu.pmglab.ccf.toolkit.input.GTBInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputOutputListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.RefGenomeVersion;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.gtb.toolkit.GTBSorter;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.TaskTracker;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.pipeline.VCFQualityControlOptions;
import edu.sysu.pmglab.kgga.command.setting.VariantFileMeta;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.LongAdder;

public class GenerateAnnotationBaseNoGtyTask
implements ITask {
    File outputFile;
    List<FieldMeta> fields;
    RefGenomeVersion fromGenomeVersion;
    GeneralIOOptions inputsOptions;
    VCFQualityControlOptions vcfQualityControlOptions;

    public GenerateAnnotationBaseNoGtyTask(GeneralIOOptions inputsOptions, VCFQualityControlOptions vcfQualityControlOptions, File outputDir, List<FieldMeta> fields, RefGenomeVersion fromGenomeVersion, boolean makeDir, int fileID) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFile = new File(FileUtils.getSubFile(outputDir.getPath(), InputOutputFileSet.getAnnotationFileName() + "." + fileID));
        this.fields = fields;
        this.fromGenomeVersion = fromGenomeVersion;
        this.inputsOptions = inputsOptions;
        this.vcfQualityControlOptions = vcfQualityControlOptions;
    }

    public GenerateAnnotationBaseNoGtyTask(GeneralIOOptions inputsOptions, VCFQualityControlOptions vcfQualityControlOptions, File outputDir, List<FieldMeta> fields, RefGenomeVersion fromGenomeVersion, boolean makeDir) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, "GenerateAnnotationBaseTask0");
            outputDir.mkdirs();
        }
        this.outputFile = new File(FileUtils.getSubFile(outputDir.getPath(), InputOutputFileSet.getAnnotationFileName()));
        this.fields = fields;
        this.fromGenomeVersion = fromGenomeVersion;
        this.inputsOptions = inputsOptions;
        this.vcfQualityControlOptions = vcfQualityControlOptions;
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        boolean needRedo;
        final IntInterval alleleNumbers = this.vcfQualityControlOptions.rangeOfAlleleNum;
        VariantFileMeta processedFileSet = (VariantFileMeta)context.cast("ConvertedOriginalGTBInputVariantFileSet");
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        if (updatedVariantSet == null) {
            updatedVariantSet = false;
        }
        needRedo = (needRedo = updatedVariantSet.booleanValue()) || !this.outputFile.exists();
        TaskTracker.TaskResult completeTaskResult = new TaskTracker.TaskResult(this.getClass().getName(), String.valueOf(processedFileSet.hashCode()), this.digest());
        Optional<File> outputPathOpt = SetupApplication.GlobalTaskTracker.checkTask(completeTaskResult);
        outputPathOpt.ifPresent(file -> {
            this.outputFile = file;
        });
        needRedo = needRedo || !outputPathOpt.isPresent();
        final LongAdder countSnp = new LongAdder();
        final LongAdder countIndel = new LongAdder();
        LongAdder countAlleleNumbers = new LongAdder();
        if (needRedo) {
            final boolean isOnlySNP = this.inputsOptions.onlySnp;
            final boolean isOnlyIndel = this.inputsOptions.onlyIndel;
            int threadNum = this.inputsOptions.threads;
            GTBManager manger = processedFileSet.getGTB();
            GTBInputOption gtbInputOption = new GTBInputOption(new GTBReaderOption(manger, false, false));
            final LiftOver liftOver = processedFileSet.refG.to(this.inputsOptions.globalAnnotationGenomeVersion);
            boolean needUpdate = false;
            if (liftOver != LiftOver.ITSELF || isOnlySNP || isOnlyIndel) {
                needUpdate = true;
            }
            Processor.OutputSetting<Variant, GTBInputOption, Variant, GTBOutputOption> outputOption = Processor.setInput(gtbInputOption).setOutput(new GTBOutputOption(this.outputFile).addMeta(CCFMetaItem.of("ORIGINAL_CHROM", "<Type=chromosome,Description=\"Chromosome as to " + (Object)((Object)processedFileSet.refG) + ".\">")).addMeta(CCFMetaItem.of("ORIGINAL_POS", "<Type=varInt32,Description=\"Physical position on the chromosome as to " + (Object)((Object)processedFileSet.refG) + " (1-based coordinate).\">")));
            if (needUpdate) {
                class MyConvert
                implements IConverter<Variant, GTBInputOption, Variant, GTBOutputOption> {
                    MyConvert() {
                    }

                    @Override
                    public Iterable<Variant> converter(Variant variant, GTBInputOption gtbInputOption, long l, GTBOutputOption outputOption) throws IOException {
                        if (variant.getChromosome().getIndex() > 24) {
                            return null;
                        }
                        if (alleleNumbers != null) {
                            boolean alleleNumInvalid;
                            IndexableSet<String> alleles = variant.getAlleles();
                            if (alleles == null) {
                                return null;
                            }
                            boolean bl = alleleNumInvalid = !alleleNumbers.contains(alleles.size(), true);
                            if (alleleNumInvalid) {
                                return null;
                            }
                        }
                        if (liftOver != LiftOver.ITSELF && (variant = liftOver.convert(variant)) == null) {
                            return null;
                        }
                        List<Variant> returns = variant.biallelic(Variant.BiallelicMode.SET_TO_MISSING).filter(v -> {
                            if (isOnlySNP) {
                                for (String allele : v.getAlleles()) {
                                    if (allele.length() <= 1 && Variant.isStandardAllele(allele)) continue;
                                    return false;
                                }
                                countSnp.increment();
                            }
                            if (isOnlyIndel) {
                                if (v.alleleOfIndex(0).length() == v.alleleOfIndex(1).length()) {
                                    return false;
                                }
                                for (String allele : v.getAlleles()) {
                                    if (!Variant.isStandardAllele(allele)) {
                                        return false;
                                    }
                                    if (allele.length() > 1 && allele.length() <= 50) continue;
                                    return false;
                                }
                                countIndel.increment();
                            }
                            return true;
                        });
                        if (returns.isEmpty()) {
                            return null;
                        }
                        return returns.isEmpty() ? null : returns;
                    }
                }
                outputOption.bridge(new MyConvert()).setListener(new InputOutputListener()).submit(threadNum);
            } else {
                outputOption.bridge(new Variant2Variant()).setListener(new InputOutputListener()).submit(threadNum);
            }
            GTBSorter sorter = GTBSorter.setInput(this.outputFile, new String[0]);
            if (!sorter.isOrdered(threadNum)) {
                sorter.sort(this.outputFile, threadNum, false);
                GTBIndexer.setInput(this.outputFile, new String[0]).save(threadNum);
            } else if (new GTBManager(this.outputFile).getIndexer() == null) {
                GTBIndexer.setInput(this.outputFile, new String[0]).save(threadNum);
            }
            completeTaskResult.setOutputPath(this.outputFile);
            SetupApplication.GlobalTaskTracker.recordTaskCompletion(completeTaskResult);
            context.put("UpdatedBaseVariantSet", true);
            String outVFInfo = "";
            if (countSnp.sum() > 0L) {
                outVFInfo = outVFInfo + "\n  " + countSnp.sum() + " SNP variants are retained.";
            }
            if (countIndel.sum() > 0L) {
                outVFInfo = outVFInfo + "\n  " + countIndel.sum() + " InDel variants are retained.";
            }
            if (outVFInfo.length() > 0) {
                SetupApplication.GlobalLogger.info("Variant Filtration Summaries: {}", (Object)outVFInfo);
            }
            context.put("UpdatedBaseVariantSet", true);
        } else {
            context.put("UpdatedBaseVariantSet", false);
        }
        GTBManager manager = new GTBManager(this.outputFile);
        context.put("OutputManager", manager);
    }

    private String digest() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.vcfQualityControlOptions.rangeOfAlleleNum).append("|");
        sb.append(this.inputsOptions.onlySnp).append("|");
        sb.append(this.inputsOptions.onlyIndel);
        return ITrack.digest(sb.toString());
    }
}

