/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.converter.IConverter;
import edu.sysu.pmglab.ccf.toolkit.input.GTBInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputOutputListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.interval.FloatInterval;
import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalTree;
import edu.sysu.pmglab.container.iterator.SingletonIterable;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.gtb.toolkit.GTBSorter;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.variant.HardyWeinbergCalculator;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.TaskTracker;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.pipeline.VCFQualityControlOptions;
import edu.sysu.pmglab.kgga.command.setting.VariantFileMeta;
import edu.sysu.pmglab.kgga.io.GlobalPedIndividuals;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import edu.sysu.pmglab.kgga.io.InputPhenotypeFileSet;
import edu.sysu.pmglab.progressbar.MultiProgressBar;
import edu.sysu.pmglab.progressbar.TextProgressRenderers;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;

public class GenerateAnnotationBaseTask
implements ITask {
    File outputFile;
    File outputGTYFile;
    boolean needGTY = false;
    final FieldMeta RefHomGtyNum_ALL = FieldMeta.of("GTYSUM@RefHomGtyNum_ALL", FieldType.varInt32);
    final FieldMeta HetGtyNum_ALL = FieldMeta.of("GTYSUM@HetGtyNum_ALL", FieldType.varInt32);
    final FieldMeta AltHomGtyNum_ALL = FieldMeta.of("GTYSUM@AltHomGtyNum_ALL", FieldType.varInt32);
    final FieldMeta MissingGtyNum_ALL = FieldMeta.of("GTYSUM@MissingGtyNum_ALL", FieldType.varInt32);
    AtomicInteger newlyGeneratedBaseFileNum;
    GeneralIOOptions inputsOptions;
    VCFQualityControlOptions vcfQualityControlOptions;

    public GenerateAnnotationBaseTask(GeneralIOOptions inputsOptions, VCFQualityControlOptions vcfQualityControlOptions, File outputDir, boolean needGTY, boolean makeDir, int fileID, AtomicInteger newlyGeneratedBaseFileNum) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFile = new File(FileUtils.getSubFile(outputDir.getPath(), InputOutputFileSet.getAnnotationFileName()) + "." + fileID);
        this.needGTY = needGTY;
        if (needGTY) {
            this.outputGTYFile = new File(FileUtils.getSubFile(outputDir.getPath(), InputOutputFileSet.getAnnotationGtyFileName()) + "." + fileID);
        }
        this.newlyGeneratedBaseFileNum = newlyGeneratedBaseFileNum;
        this.inputsOptions = inputsOptions;
        this.vcfQualityControlOptions = vcfQualityControlOptions;
    }

    public GenerateAnnotationBaseTask(GeneralIOOptions inputsOptions, VCFQualityControlOptions vcfQualityControlOptions, File outputDir, boolean needGTY, boolean makeDir, AtomicInteger newlyGeneratedBaseFileNum) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFile = new File(FileUtils.getSubFile(outputDir.getPath(), InputOutputFileSet.getAnnotationFileName()));
        this.needGTY = needGTY;
        if (needGTY) {
            this.outputGTYFile = new File(FileUtils.getSubFile(outputDir.getPath(), InputOutputFileSet.getAnnotationGtyFileName()));
        }
        this.newlyGeneratedBaseFileNum = newlyGeneratedBaseFileNum;
        this.inputsOptions = inputsOptions;
        this.vcfQualityControlOptions = vcfQualityControlOptions;
    }

    @Override
    public void execute(Status status, Context context) throws Exception {
        String outVFInfo;
        int allSubjectsSize;
        IntList gtbIDofPedSubs;
        final VariantFileMeta convertedInputVariantFileSet = (VariantFileMeta)context.cast("ConvertedOriginalGTBInputVariantFileSet");
        boolean noPedFile = false;
        InputPhenotypeFileSet pedPhenoFileSet = this.inputsOptions.phenoFileSet;
        if (pedPhenoFileSet != null) {
            GlobalPedIndividuals.append(pedPhenoFileSet);
            Set<String> subjectWithNas = GlobalPedIndividuals.getSubjectWithNas();
            if (!subjectWithNas.isEmpty()) {
                SetupApplication.GlobalLogger.warn("The following {} subject IDs are ignored due to missing phenotype or covariable values: {}", (Object)subjectWithNas.size(), (Object)subjectWithNas);
            }
            gtbIDofPedSubs = GlobalPedIndividuals.getIndividuals().getUIDs().findIndicesIn(convertedInputVariantFileSet.getIndividualUIDs());
            int subjectNum = GlobalPedIndividuals.size();
            if (gtbIDofPedSubs == null) {
                gtbIDofPedSubs = new IntList();
                for (int i = 0; i < subjectNum; ++i) {
                    gtbIDofPedSubs.add(i);
                }
            } else {
                IntList unavailableIDs = new IntList(gtbIDofPedSubs.where(value -> value == -1));
                if (unavailableIDs.size() == subjectNum) {
                    SetupApplication.GlobalLogger.error("All subject IDs in the ped-file are unavailable in GTB/VCF file. Aborting.");
                    System.exit(-1);
                }
                if (!unavailableIDs.isEmpty()) {
                    String names = unavailableIDs.apply(index -> GlobalPedIndividuals.getIndividuals().getUIDs().valueOf(index)).toString(", ");
                    SetupApplication.GlobalLogger.warn("The following {} subject IDs are unavailable in GTB or VCF file:\n{}", (Object)unavailableIDs.size(), (Object)names);
                }
            }
            IntList sampleIDsInPed = new IntList();
            for (int i = 0; i < subjectNum; ++i) {
                if (gtbIDofPedSubs.fastGet(i) == -1) continue;
                sampleIDsInPed.add(i);
            }
            allSubjectsSize = sampleIDsInPed.size();
            SetupApplication.GlobalLogger.info("{} subjects are available for analysis.", (Object)allSubjectsSize);
            context.put("gtbIDofPedSubs", gtbIDofPedSubs);
        } else {
            noPedFile = true;
            gtbIDofPedSubs = null;
            allSubjectsSize = convertedInputVariantFileSet.getIndividualUIDs().size();
            GlobalPedIndividuals.appendUniqueIDs(convertedInputVariantFileSet.getIndividualUIDs());
            SetupApplication.GlobalLogger.info("{} subjects are available in the genotype file(s).", (Object)allSubjectsSize);
        }
        context.put("allSubjectsSize", allSubjectsSize);
        context.put("noPedFile", noPedFile);
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        if (updatedVariantSet == null) {
            updatedVariantSet = false;
        }
        boolean needRedo = updatedVariantSet != false || !this.outputFile.exists();
        TaskTracker.TaskResult completeTaskResult = new TaskTracker.TaskResult(this.getClass().getName(), String.valueOf(convertedInputVariantFileSet.hashCode()), this.digest());
        Optional<File> outputPathOpt = SetupApplication.GlobalTaskTracker.checkTask(completeTaskResult);
        outputPathOpt.ifPresent(file -> {
            this.outputFile = file;
        });
        needRedo = needRedo || !outputPathOpt.isPresent();
        final LongAdder countSnp = new LongAdder();
        final LongAdder countIndel = new LongAdder();
        final LongAdder countAlleleNum = new LongAdder();
        final LongAdder countHweFail = new LongAdder();
        final LongAdder countObsFail = new LongAdder();
        final LongAdder countMaf = new LongAdder();
        final LongAdder countAlt = new LongAdder();
        final LongAdder countMinAC = new LongAdder();
        if (needRedo) {
            this.newlyGeneratedBaseFileNum.addAndGet(1);
            List<FieldMeta> fieldMetasToAdd = new List<FieldMeta>();
            fieldMetasToAdd.add(this.RefHomGtyNum_ALL);
            fieldMetasToAdd.add(this.HetGtyNum_ALL);
            fieldMetasToAdd.add(this.AltHomGtyNum_ALL);
            fieldMetasToAdd.add(this.MissingGtyNum_ALL);
            final boolean needHweFilter = this.inputsOptions.hwe != null && allSubjectsSize > 0;
            final double hweThreshold = needHweFilter ? this.inputsOptions.hwe : 0.0;
            final boolean needNonMissingRateFilter = this.inputsOptions.minObsRate != null && allSubjectsSize > 0;
            final float nonMissingRate = needNonMissingRateFilter ? this.inputsOptions.minObsRate.floatValue() : 0.0f;
            final boolean needLocalMafFilter = this.inputsOptions.localMaf != null && allSubjectsSize > 0;
            final FloatInterval localMafCut = needLocalMafFilter ? this.inputsOptions.localMaf : null;
            final boolean needLocalAltFilter = this.inputsOptions.localAf != null && allSubjectsSize > 0;
            final FloatInterval localAltCut = needLocalAltFilter ? this.inputsOptions.localAf : null;
            final boolean isOnlySNP = this.inputsOptions.onlySnp;
            final boolean isOnlyIndel = this.inputsOptions.onlyIndel;
            final IntInterval alleleNumbers = this.vcfQualityControlOptions.rangeOfAlleleNum;
            final int minAC = this.inputsOptions.localAltCount;
            int threadNum = this.inputsOptions.threads;
            final Map<Chromosome, IntIntervalTree<Void>> excludedRegions = convertedInputVariantFileSet.excludedRegions;
            final boolean excludeVariants = excludedRegions != null;
            final Map<Chromosome, IntIntervalTree<Void>> includedRegions = convertedInputVariantFileSet.includedRegions;
            final boolean includeVariants = includedRegions != null;
            String sourceGtyFilePath = this.needGTY ? this.outputGTYFile.getCanonicalPath() : null;
            GTBReaderOption inputGTBOption = new GTBReaderOption(convertedInputVariantFileSet.getGTB(), true, false);
            GTBOutputOption outputGTBOption = new GTBOutputOption(this.outputFile).setIndividuals(this.needGTY ? GlobalPedIndividuals.getIndividuals().getUIDs() : null);
            FieldGroupMeta sources = convertedInputVariantFileSet.getGTB().getFieldGroup("SOURCE");
            if (sources != null && sources.numOfFields() > 0) {
                inputGTBOption.addFields(sources);
                outputGTBOption.addFields(sources);
            }
            final MultiProgressBar bar = new MultiProgressBar.Builder().setRenderers(new TextProgressRenderers().add("Input", "variants").add("Output", "variants")).build();
            final String SOURCE_FILE_ID = inputGTBOption.getFile().getPath();
            CCFMetaItem fileIDs = CCFMetaItem.of("SOURCE@FILE_ID", this.needGTY ? sourceGtyFilePath : SOURCE_FILE_ID);
            final String finalSourceGtyFilePath = sourceGtyFilePath;
            final IntList finalGtbIDofPedSubs = gtbIDofPedSubs;
            final int finalAllSubjectsSize = allSubjectsSize;
            Processor.setInput(new GTBInputOption(inputGTBOption)).setOutput(outputGTBOption.addField(FieldMeta.of("SOURCE@FILE_ID", FieldType.string)).addField(FieldMeta.of("SOURCE@FILE_POINTER", FieldType.varInt64)).addFields(fieldMetasToAdd).addMeta(fileIDs).addMeta(CCFMetaItem.of("ORIGINAL_CHROM", "<Type=chromosome,Description=\"Chromosome as to " + (Object)((Object)convertedInputVariantFileSet.refG) + ".\">")).addMeta(CCFMetaItem.of("ORIGINAL_POS", "<Type=varInt32,Description=\"Physical position on the chromosome as to " + (Object)((Object)convertedInputVariantFileSet.refG) + " (1-based coordinate).\">")), (inputs, output) -> {
                if (this.needGTY && GlobalPedIndividuals.getIndividuals().isEmpty()) {
                    output.addIndividuals(((GTBInputOption)inputs.get(0)).getIndividuals());
                    output.addFields(((GTBInputOption)inputs.get(0)).getAllFields());
                }
            }).bridge(new IConverter<Variant, GTBInputOption, Variant, GTBOutputOption>(){
                final LiftOver liftOver;
                {
                    this.liftOver = convertedInputVariantFileSet.refG.to(GenerateAnnotationBaseTask.this.inputsOptions.globalAnnotationGenomeVersion);
                }

                @Override
                public Iterable<Variant> converter(Variant variant, GTBInputOption gtbInputOption, long pointer, GTBOutputOption outputOption) throws IOException {
                    IndexableSet<String> alleles;
                    variant.prune();
                    if (variant.getChromosome().getIndex() > 24) {
                        return null;
                    }
                    if (excludeVariants && excludedRegions.containsKey(variant.getChromosome()) && ((IntIntervalTree)excludedRegions.get(variant.getChromosome())).contains(variant.getPosition())) {
                        return null;
                    }
                    if (!(!includeVariants || includedRegions.containsKey(variant.getChromosome()) && ((IntIntervalTree)includedRegions.get(variant.getChromosome())).contains(variant.getPosition()))) {
                        return null;
                    }
                    if (!(alleleNumbers == null || (alleles = variant.getAlleles()) != null && alleleNumbers.contains(alleles.size(), true))) {
                        countAlleleNum.increment();
                        return null;
                    }
                    if (this.liftOver != LiftOver.ITSELF && ((variant = this.liftOver.convert(variant)) == null || variant.getChromosome().getIndex() > 24)) {
                        return null;
                    }
                    variant.setProperty("SOURCE@FILE_ID", GenerateAnnotationBaseTask.this.needGTY ? finalSourceGtyFilePath : SOURCE_FILE_ID);
                    variant.setProperty("SOURCE@FILE_POINTER", GenerateAnnotationBaseTask.this.needGTY ? -1L : pointer);
                    if (finalGtbIDofPedSubs != null) {
                        IGenotypes gty = variant.getGenotypes().subGenotypes(finalGtbIDofPedSubs);
                        variant.setGenotypes(gty);
                    }
                    bar.step(Math.max(1, variant.numOfAlleles() - 1), 0L);
                    List<Variant> returns = variant.biallelic(Variant.BiallelicMode.SET_TO_MISSING).filter(v -> {
                        float ALL_COUNT_AF;
                        if (isOnlySNP) {
                            for (String allele : v.getAlleles()) {
                                if (allele.length() <= 1 && Variant.isStandardAllele(allele)) continue;
                                return false;
                            }
                            countSnp.increment();
                        }
                        if (isOnlyIndel) {
                            if (v.alleleOfIndex(0).length() == v.alleleOfIndex(1).length()) {
                                return false;
                            }
                            for (String allele : v.getAlleles()) {
                                if (Variant.isStandardAllele(allele) && allele.length() > 1 && allele.length() <= 50) continue;
                                return false;
                            }
                            countIndel.increment();
                        }
                        ICounter genotypeCounter = v.getGenotypes().counter();
                        int ALL_COUNT_AA = genotypeCounter.count(Genotype.of(0, 0));
                        int ALL_COUNT_AB = genotypeCounter.count(Genotype.of(0, 1)) + genotypeCounter.count(Genotype.of(1, 0));
                        int ALL_COUNT_BB = genotypeCounter.count(Genotype.of(1, 1));
                        int ALL_COUNT_AC = genotypeCounter.getAC(1);
                        int ALL_COUNT_AN = genotypeCounter.getAN();
                        if (ALL_COUNT_AC < minAC) {
                            countMinAC.increment();
                            return false;
                        }
                        float f = ALL_COUNT_AF = ALL_COUNT_AN == 0 ? 0.0f : (float)ALL_COUNT_AC / (float)ALL_COUNT_AN;
                        if (needNonMissingRateFilter && (float)((double)ALL_COUNT_AN / ((double)finalAllSubjectsSize * 2.0)) < nonMissingRate) {
                            countObsFail.increment();
                            return false;
                        }
                        if (needLocalAltFilter && !localAltCut.contains(ALL_COUNT_AF, true)) {
                            return false;
                        }
                        if (needLocalAltFilter) {
                            countAlt.increment();
                        }
                        if (needLocalMafFilter) {
                            float variantMaf;
                            float f2 = variantMaf = (double)ALL_COUNT_AF > 0.5 ? 1.0f - ALL_COUNT_AF : ALL_COUNT_AF;
                            if (!localMafCut.contains(variantMaf, true)) {
                                return false;
                            }
                            countMaf.increment();
                        }
                        if (needHweFilter && ALL_COUNT_AN > 0 && ALL_COUNT_AC > 0 && HardyWeinbergCalculator.calculate(ALL_COUNT_AA, ALL_COUNT_AB, ALL_COUNT_BB, true) < hweThreshold) {
                            countHweFail.increment();
                            return false;
                        }
                        v.setProperty(GenerateAnnotationBaseTask.this.RefHomGtyNum_ALL.fullName(), ALL_COUNT_AA);
                        v.setProperty(GenerateAnnotationBaseTask.this.HetGtyNum_ALL.fullName(), ALL_COUNT_AB);
                        v.setProperty(GenerateAnnotationBaseTask.this.AltHomGtyNum_ALL.fullName(), ALL_COUNT_BB);
                        v.setProperty(GenerateAnnotationBaseTask.this.MissingGtyNum_ALL.fullName(), finalAllSubjectsSize - ALL_COUNT_AA - ALL_COUNT_AB - ALL_COUNT_BB);
                        return true;
                    });
                    if (returns.isEmpty()) {
                        return null;
                    }
                    bar.step(0L, returns.size());
                    return returns;
                }
            }).setListener(new InputOutputListener()).submit(threadNum);
            GTBSorter sorter = GTBSorter.setInput(this.outputFile, new String[0]);
            if (!sorter.isOrdered(threadNum)) {
                sorter.sort(this.outputFile, threadNum, true);
                GTBIndexer.setInput(this.outputFile, new String[0]).save(threadNum);
            } else if (new GTBManager(this.outputFile).getIndexer() == null) {
                GTBIndexer.setInput(this.outputFile, new String[0]).save(threadNum);
            }
            bar.close();
            context.put("UpdatedBaseVariantSet", true);
            if (this.needGTY) {
                FileUtils.rename(this.outputFile, this.outputGTYFile);
                context.put("OutputGTYFile", this.outputGTYFile);
                Processor.setInput(new GTBInputOption(new GTBReaderOption(new GTBManager(this.outputGTYFile), false, true))).setOutput(new GTBOutputOption(this.outputFile), (inputs, output) -> {
                    output.addFields(((GTBInputOption)inputs.fastGet(0)).getAllFields());
                    output.addMeta(((GTBInputOption)inputs.fastGet(0)).getMeta());
                }).bridge((variant, gtbInputOption, pointer, outputOption) -> {
                    variant.setProperty("SOURCE@FILE_POINTER", pointer);
                    return new SingletonIterable<Variant>((Variant)variant);
                }).setListener(new InputOutputListener()).submit(threadNum);
            }
            completeTaskResult.setOutputPath(this.outputFile);
            SetupApplication.GlobalTaskTracker.recordTaskCompletion(completeTaskResult);
        } else {
            context.put("UpdatedBaseVariantSet", false);
        }
        GTBManager manager = new GTBManager(this.outputFile);
        StringBuilder outVFInfoBuilder = new StringBuilder();
        if (countSnp.sum() > 0L) {
            outVFInfoBuilder.append("\n  ").append(countSnp.sum()).append(" SNP variants are retained.");
        }
        if (countIndel.sum() > 0L) {
            outVFInfoBuilder.append("\n  ").append(countIndel.sum()).append(" InDel variants are retained.");
        }
        if (countAlleleNum.sum() > 0L) {
            outVFInfoBuilder.append("\n  ").append(countAlleleNum.sum()).append(" variants with alleles numbers beyond the range <").append(this.vcfQualityControlOptions.rangeOfAlleleNum).append("> are excluded.");
        }
        if (countMinAC.sum() > 0L) {
            outVFInfoBuilder.append("\n  ").append(countMinAC.sum()).append(" variants with alternate allele count < ").append(this.inputsOptions.localAltCount).append(" are excluded.");
        }
        if (countObsFail.sum() > 0L) {
            outVFInfoBuilder.append("\n  ").append(countObsFail.sum()).append(" variants with call rate < ").append(this.inputsOptions.minObsRate.floatValue() * 100.0f).append("% are excluded.");
        }
        if (countHweFail.sum() > 0L) {
            outVFInfoBuilder.append("\n  ").append(countHweFail.sum()).append(" variants with Hardy-Weinberg test P < ").append(this.inputsOptions.hwe).append(" are excluded.");
        }
        if (countAlt.sum() > 0L) {
            outVFInfoBuilder.append("\n  ").append(countAlt.sum()).append(" variants with alternate allele frequency in ").append(this.inputsOptions.localAf).append(" are retained.");
        }
        if (countMaf.sum() > 0L) {
            outVFInfoBuilder.append("\n  ").append(countMaf.sum()).append(" variants with minor allele frequency in ").append(this.inputsOptions.localMaf).append(" are retained.");
        }
        if (!(outVFInfo = outVFInfoBuilder.toString()).isEmpty()) {
            SetupApplication.GlobalLogger.info("General variant filtration summaries for {}: {}", (Object)convertedInputVariantFileSet.finalGTBManager.getFile().getName(), (Object)outVFInfo);
        }
        context.put("OutputManager", manager);
        if (this.needGTY) {
            context.put("OutputGTYFile", this.outputGTYFile);
        }
    }

    private String digest() {
        StringBuilder sb = new StringBuilder(256);
        sb.append('|').append(this.inputsOptions.phenoFileSet == null ? "," : Integer.valueOf(this.inputsOptions.phenoFileSet.hashCode())).append('|').append(this.inputsOptions.onlySnp).append('|').append(this.inputsOptions.onlyIndel).append('|').append(this.inputsOptions.hwe).append('|').append(this.inputsOptions.minObsRate).append('|').append(this.inputsOptions.localMaf).append('|').append(this.inputsOptions.localAf).append('|').append(this.inputsOptions.localAltCount).append('|').append(this.vcfQualityControlOptions.rangeOfAlleleNum);
        return ITrack.digest(sb.toString());
    }
}

