/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.converter.IConverter;
import edu.sysu.pmglab.ccf.toolkit.input.GTBInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputOutputListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.interval.FloatInterval;
import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalTree;
import edu.sysu.pmglab.container.iterator.SingletonIterable;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.gtb.toolkit.GTBSorter;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.variant.HardyWeinbergCalculator;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.TaskTracker;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.pipeline.VCFQualityControlOptions;
import edu.sysu.pmglab.kgga.command.setting.VariantFileMeta;
import edu.sysu.pmglab.kgga.io.GlobalPedIndividuals;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import edu.sysu.pmglab.kgga.io.InputPhenotypeFileSet;
import edu.sysu.pmglab.progressbar.MultiProgressBar;
import edu.sysu.pmglab.progressbar.TextProgressRenderers;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;

public class GenerateAnnotationBaseTask0
implements ITask {
    File outputFile;
    File outputGTYFile;
    boolean needGTY = false;
    final FieldMeta RefHomGtyNum_CASE = FieldMeta.of("GTYSUM@RefHomGtyNum_CASE", FieldType.varInt32);
    final FieldMeta HetGtyNum_CASE = FieldMeta.of("GTYSUM@HetGtyNum_CASE", FieldType.varInt32);
    final FieldMeta AltHomGtyNum_CASE = FieldMeta.of("GTYSUM@AltHomGtyNum_CASE", FieldType.varInt32);
    final FieldMeta MissingGtyNum_CASE = FieldMeta.of("GTYSUM@MissingGtyNum_CASE", FieldType.varInt32);
    final FieldMeta RefHomGtyNum_CONTROL = FieldMeta.of("GTYSUM@RefHomGtyNum_CONTROL", FieldType.varInt32);
    final FieldMeta HetGtyNum_CONTROL = FieldMeta.of("GTYSUM@HetGtyNum_CONTROL", FieldType.varInt32);
    final FieldMeta AltHomGtyNum_CONTROL = FieldMeta.of("GTYSUM@AltHomGtyNum_CONTROL", FieldType.varInt32);
    final FieldMeta MissingGtyNum_CONTROL = FieldMeta.of("GTYSUM@MissingGtyNum_CONTROL", FieldType.varInt32);
    final FieldMeta RefHomGtyNum_ALL = FieldMeta.of("GTYSUM@RefHomGtyNum_ALL", FieldType.varInt32);
    final FieldMeta HetGtyNum_ALL = FieldMeta.of("GTYSUM@HetGtyNum_ALL", FieldType.varInt32);
    final FieldMeta AltHomGtyNum_ALL = FieldMeta.of("GTYSUM@AltHomGtyNum_ALL", FieldType.varInt32);
    final FieldMeta MissingGtyNum_ALL = FieldMeta.of("GTYSUM@MissingGtyNum_ALL", FieldType.varInt32);
    AtomicInteger newlyGeneratedBaseFileNum;
    GeneralIOOptions inputsOptions;
    VCFQualityControlOptions vcfQualityControlOptions;

    public GenerateAnnotationBaseTask0(GeneralIOOptions inputsOptions, VCFQualityControlOptions vcfQualityControlOptions, File outputDir, boolean needGTY, boolean makeDir, int fileID, AtomicInteger newlyGeneratedBaseFileNum) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFile = new File(FileUtils.getSubFile(outputDir.getPath(), InputOutputFileSet.getAnnotationFileName()) + "." + fileID);
        this.needGTY = needGTY;
        if (needGTY) {
            this.outputGTYFile = new File(FileUtils.getSubFile(outputDir.getPath(), InputOutputFileSet.getAnnotationGtyFileName()) + "." + fileID);
        }
        this.newlyGeneratedBaseFileNum = newlyGeneratedBaseFileNum;
        this.inputsOptions = inputsOptions;
        this.vcfQualityControlOptions = vcfQualityControlOptions;
    }

    public GenerateAnnotationBaseTask0(GeneralIOOptions inputsOptions, VCFQualityControlOptions vcfQualityControlOptions, File outputDir, boolean needGTY, boolean makeDir, AtomicInteger newlyGeneratedBaseFileNum) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFile = new File(FileUtils.getSubFile(outputDir.getPath(), InputOutputFileSet.getAnnotationFileName()));
        this.needGTY = needGTY;
        if (needGTY) {
            this.outputGTYFile = new File(FileUtils.getSubFile(outputDir.getPath(), InputOutputFileSet.getAnnotationGtyFileName()));
        }
        this.newlyGeneratedBaseFileNum = newlyGeneratedBaseFileNum;
        this.inputsOptions = inputsOptions;
        this.vcfQualityControlOptions = vcfQualityControlOptions;
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        boolean needRedo;
        int allSubjectsSize;
        IntList gtbIDofPedSubs;
        final VariantFileMeta convertedInputVariantFileSet = (VariantFileMeta)context.cast("ConvertedOriginalGTBInputVariantFileSet");
        final IntList caseIDsInPed = new IntList();
        final IntList controlIDsInPed = new IntList();
        final IntList otherSubIDsInPed = new IntList();
        boolean noPedFile = false;
        InputPhenotypeFileSet pedPhenoFileSet = this.inputsOptions.phenoFileSet;
        if (pedPhenoFileSet != null) {
            GlobalPedIndividuals.append(pedPhenoFileSet);
            Set<String> subjectWithNas = GlobalPedIndividuals.getSubjectWithNas();
            if (!subjectWithNas.isEmpty()) {
                SetupApplication.GlobalLogger.warn("The following {} subject IDs are ignored due to missing phenotype or covariable values in the file {}:\n{}", subjectWithNas.size(), pedPhenoFileSet.getFile().getName(), subjectWithNas);
            }
            gtbIDofPedSubs = GlobalPedIndividuals.getIndividuals().getUIDs().findIndicesIn(convertedInputVariantFileSet.getIndividualUIDs());
            int subjectNum = GlobalPedIndividuals.size();
            if (gtbIDofPedSubs == null) {
                gtbIDofPedSubs = new IntList();
                for (int i = 0; i < subjectNum; ++i) {
                    gtbIDofPedSubs.add(i);
                }
            } else {
                IntList unavailableIDs = new IntList(gtbIDofPedSubs.where(value -> value == -1));
                if (unavailableIDs.size() == subjectNum) {
                    SetupApplication.GlobalLogger.warn("All subject IDs in the ped-file are unavailable in GTB or VCF file! The program aborts.");
                    System.exit(-1);
                }
                if (!unavailableIDs.isEmpty()) {
                    String names = unavailableIDs.apply(index -> GlobalPedIndividuals.getIndividuals().getUIDs().valueOf(index)).toString(", ");
                    SetupApplication.GlobalLogger.warn("The following {} subject IDs are unavailable in GTB or VCF file:\n{}", (Object)unavailableIDs.size(), (Object)names);
                    context.put("unavailableIDs", unavailableIDs);
                }
            }
            controlIDsInPed.clear();
            caseIDsInPed.clear();
            otherSubIDsInPed.clear();
            boolean isBinaryPhenotype = GlobalPedIndividuals.isBinaryPhenotypes(0);
            for (int i = 0; i < subjectNum; ++i) {
                if (gtbIDofPedSubs.fastGet(i) == -1) continue;
                double phenotype = (Double)GlobalPedIndividuals.get(i, "phenotype");
                if (isBinaryPhenotype) {
                    int affectedStatus = (int)phenotype;
                    switch (affectedStatus) {
                        case 1: {
                            controlIDsInPed.add(i);
                            break;
                        }
                        case 2: {
                            caseIDsInPed.add(i);
                            break;
                        }
                        default: {
                            otherSubIDsInPed.add(i);
                            break;
                        }
                    }
                    continue;
                }
                caseIDsInPed.add(i);
            }
            if (caseIDsInPed.isEmpty() && controlIDsInPed.isEmpty() && otherSubIDsInPed.isEmpty()) {
                SetupApplication.GlobalLogger.error("No subject IDs are available in GTB or VCF file for analysis. The program is aborted");
                System.exit(-1);
            }
            context.put("CaseSubjectNum", caseIDsInPed.size());
            allSubjectsSize = controlIDsInPed.size() + caseIDsInPed.size() + otherSubIDsInPed.size();
        } else {
            noPedFile = true;
            gtbIDofPedSubs = null;
            IndexableSet<String> allUIDs = convertedInputVariantFileSet.getIndividualUIDs();
            allSubjectsSize = allUIDs.size();
            GlobalPedIndividuals.appendUniqueIDs(allUIDs);
        }
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        if (updatedVariantSet == null) {
            updatedVariantSet = false;
        }
        needRedo = (needRedo = updatedVariantSet.booleanValue()) || !this.outputFile.exists();
        TaskTracker.TaskResult completeTaskResult = new TaskTracker.TaskResult(this.getClass().getName(), String.valueOf(convertedInputVariantFileSet.hashCode()), this.digest());
        Optional<File> outputPathOpt = SetupApplication.GlobalTaskTracker.checkTask(completeTaskResult);
        outputPathOpt.ifPresent(file -> {
            this.outputFile = file;
        });
        needRedo = needRedo || !outputPathOpt.isPresent();
        final LongAdder countSnp = new LongAdder();
        final LongAdder countIndel = new LongAdder();
        final LongAdder countAlleleNum = new LongAdder();
        final LongAdder countHweFail = new LongAdder();
        final LongAdder countObsFail = new LongAdder();
        final LongAdder countMaf = new LongAdder();
        final LongAdder countAlt = new LongAdder();
        final LongAdder countMinAC = new LongAdder();
        final LongAdder countHweCaseFail = new LongAdder();
        final LongAdder countObsCaseFail = new LongAdder();
        final LongAdder countMafCase = new LongAdder();
        final LongAdder countAltCase = new LongAdder();
        final LongAdder countHweControlFail = new LongAdder();
        final LongAdder countObsControlFail = new LongAdder();
        final LongAdder countMafControl = new LongAdder();
        final LongAdder countAltControl = new LongAdder();
        final LongAdder countMafRatio = new LongAdder();
        final LongAdder countAltRatio = new LongAdder();
        if (needRedo) {
            float minAltRatio;
            boolean needAltRatioFilter;
            float minMafRatio;
            boolean needMafRatioFilter;
            FloatInterval localAltCutControl;
            boolean needLocalAltControlFilter;
            FloatInterval localAltCutCase;
            boolean needLocalAltCaseFilter;
            FloatInterval localAltCut;
            boolean needLocalAltFilter;
            FloatInterval localMafCutControl;
            boolean needLocalMafControlFilter;
            FloatInterval localMafCutCase;
            boolean needLocalMafCaseFilter;
            FloatInterval localMafCut;
            boolean needLocalMafFilter;
            float nonMissingRateControl;
            boolean needNonMissingRateControlFilter;
            float nonMissingRateCase;
            boolean needNonMissingRateCaseFilter;
            float nonMissingRate;
            boolean needNonMissingRateFilter;
            double hweControlThreshold;
            boolean needHweControlFilter;
            double hweCaseThreshold;
            boolean needHweCaseFilter;
            double hweThreshold;
            boolean needHweFilter;
            this.newlyGeneratedBaseFileNum.addAndGet(1);
            final int caseSubjectsSize = caseIDsInPed.size();
            int caseSubjectsSize1 = 0;
            for (int i = 0; i < caseSubjectsSize; ++i) {
                if (caseIDsInPed.get(i) == -1) continue;
                ++caseSubjectsSize1;
            }
            final int controlSubjectsSize = controlIDsInPed.size();
            if (noPedFile) {
                SetupApplication.GlobalLogger.info("{} subjects are available in the genotype file(s) in GTB format.", (Object)allSubjectsSize);
            } else {
                SetupApplication.GlobalLogger.info("{} subjects ({} cases, {} controls and {} others) are available in both genotype and phenotype files.", allSubjectsSize, caseSubjectsSize, controlSubjectsSize, otherSubIDsInPed.size());
            }
            final boolean haveCases = caseSubjectsSize > 0;
            final boolean haveControls = controlSubjectsSize > 0;
            final boolean haveOthers = !otherSubIDsInPed.isEmpty();
            List<FieldMeta> fieldMetasToAdd = new List<FieldMeta>();
            fieldMetasToAdd.add(this.RefHomGtyNum_ALL);
            fieldMetasToAdd.add(this.HetGtyNum_ALL);
            fieldMetasToAdd.add(this.AltHomGtyNum_ALL);
            fieldMetasToAdd.add(this.MissingGtyNum_ALL);
            if (haveCases) {
                fieldMetasToAdd.add(this.RefHomGtyNum_CASE);
                fieldMetasToAdd.add(this.HetGtyNum_CASE);
                fieldMetasToAdd.add(this.AltHomGtyNum_CASE);
                fieldMetasToAdd.add(this.MissingGtyNum_CASE);
            }
            if (haveControls) {
                fieldMetasToAdd.add(this.RefHomGtyNum_CONTROL);
                fieldMetasToAdd.add(this.HetGtyNum_CONTROL);
                fieldMetasToAdd.add(this.AltHomGtyNum_CONTROL);
                fieldMetasToAdd.add(this.MissingGtyNum_CONTROL);
            }
            if (this.inputsOptions.hwe != null && allSubjectsSize > 0) {
                needHweFilter = true;
                hweThreshold = this.inputsOptions.hwe;
            } else {
                needHweFilter = false;
                hweThreshold = 0.0;
            }
            if (this.inputsOptions.hweCase != null && haveCases) {
                needHweCaseFilter = true;
                hweCaseThreshold = this.inputsOptions.hweCase;
            } else {
                hweCaseThreshold = 0.0;
                needHweCaseFilter = false;
            }
            if (this.inputsOptions.hweControl != null && haveControls) {
                needHweControlFilter = true;
                hweControlThreshold = this.inputsOptions.hweControl;
            } else {
                hweControlThreshold = 0.0;
                needHweControlFilter = false;
            }
            if (this.inputsOptions.minObsRate != null && allSubjectsSize > 0) {
                needNonMissingRateFilter = true;
                nonMissingRate = this.inputsOptions.minObsRate.floatValue();
            } else {
                needNonMissingRateFilter = false;
                nonMissingRate = 0.0f;
            }
            if (this.inputsOptions.minObsRateCase != null && haveCases) {
                needNonMissingRateCaseFilter = true;
                nonMissingRateCase = this.inputsOptions.minObsRateCase.floatValue();
            } else {
                needNonMissingRateCaseFilter = false;
                nonMissingRateCase = 0.0f;
            }
            if (this.inputsOptions.minObsRateControl != null && haveControls) {
                needNonMissingRateControlFilter = true;
                nonMissingRateControl = this.inputsOptions.minObsRateControl.floatValue();
            } else {
                nonMissingRateControl = 0.0f;
                needNonMissingRateControlFilter = false;
            }
            if (this.inputsOptions.localMaf != null && allSubjectsSize > 0) {
                needLocalMafFilter = true;
                localMafCut = this.inputsOptions.localMaf;
            } else {
                needLocalMafFilter = false;
                localMafCut = null;
            }
            if (this.inputsOptions.localMafCase != null && haveCases) {
                needLocalMafCaseFilter = true;
                localMafCutCase = this.inputsOptions.localMafCase;
            } else {
                needLocalMafCaseFilter = false;
                localMafCutCase = null;
            }
            if (this.inputsOptions.localMafControl != null && haveControls) {
                needLocalMafControlFilter = true;
                localMafCutControl = this.inputsOptions.localMafControl;
            } else {
                needLocalMafControlFilter = false;
                localMafCutControl = null;
            }
            if (this.inputsOptions.localAf != null && allSubjectsSize > 0) {
                needLocalAltFilter = true;
                localAltCut = this.inputsOptions.localAf;
            } else {
                needLocalAltFilter = false;
                localAltCut = null;
            }
            if (this.inputsOptions.localAfCase != null && haveCases) {
                needLocalAltCaseFilter = true;
                localAltCutCase = this.inputsOptions.localAfCase;
            } else {
                needLocalAltCaseFilter = false;
                localAltCutCase = null;
            }
            if (this.inputsOptions.localAfControl != null && haveControls) {
                needLocalAltControlFilter = true;
                localAltCutControl = this.inputsOptions.localAfControl;
            } else {
                needLocalAltControlFilter = false;
                localAltCutControl = null;
            }
            if (this.inputsOptions.minCaseControlMafRatio != null && haveCases && haveControls) {
                needMafRatioFilter = true;
                minMafRatio = this.inputsOptions.minCaseControlMafRatio.floatValue();
            } else {
                needMafRatioFilter = false;
                minMafRatio = 0.0f;
            }
            if (this.inputsOptions.minCaseControlAfRatio != null && haveCases && haveControls) {
                needAltRatioFilter = true;
                minAltRatio = this.inputsOptions.minCaseControlAfRatio.floatValue();
            } else {
                needAltRatioFilter = false;
                minAltRatio = 0.0f;
            }
            final boolean isOnlySNP = this.inputsOptions.onlySnp;
            final boolean isOnlyIndel = this.inputsOptions.onlyIndel;
            final IntInterval alleleNumbers = this.vcfQualityControlOptions.rangeOfAlleleNum;
            final int minAC = this.inputsOptions.localAltCount;
            int threadNum = this.inputsOptions.threads;
            final Map<Chromosome, IntIntervalTree<Void>> excludedRegions = convertedInputVariantFileSet.excludedRegions;
            final boolean excludeVariants = excludedRegions != null;
            final Map<Chromosome, IntIntervalTree<Void>> includedRegions = convertedInputVariantFileSet.includedRegions;
            final boolean includeVariants = includedRegions != null;
            String sourceGtyFilePath = null;
            if (this.needGTY) {
                sourceGtyFilePath = this.outputGTYFile.getCanonicalPath();
            }
            FieldGroupMeta sources = convertedInputVariantFileSet.getGTB().getFieldGroup("SOURCE");
            GTBReaderOption inputGTBOption = new GTBReaderOption(convertedInputVariantFileSet.getGTB(), true, false);
            GTBOutputOption outputGTBOption = new GTBOutputOption(this.outputFile).setIndividuals(this.needGTY ? GlobalPedIndividuals.getIndividuals().getUIDs() : null);
            if (sources != null && sources.numOfFields() > 0) {
                inputGTBOption.addFields(sources);
                outputGTBOption.addFields(sources);
            }
            final MultiProgressBar bar = new MultiProgressBar.Builder().setRenderers(new TextProgressRenderers().add("Input", "variants").add("Output", "variants")).build();
            final boolean finalNoPedFile = noPedFile;
            final String SOURCE_FILE_ID = inputGTBOption.getFile().getPath();
            CCFMetaItem fileIDs = this.needGTY ? CCFMetaItem.of("SOURCE@FILE_ID", sourceGtyFilePath) : CCFMetaItem.of("SOURCE@FILE_ID", SOURCE_FILE_ID);
            final String finalSourceGtyFilePath = sourceGtyFilePath;
            final IntList finalGtbIDofPedSubs = gtbIDofPedSubs;
            Processor.setInput(new GTBInputOption(inputGTBOption)).setOutput(outputGTBOption.addField(FieldMeta.of("SOURCE@FILE_ID", FieldType.string)).addField(FieldMeta.of("SOURCE@FILE_POINTER", FieldType.varInt64)).addFields(fieldMetasToAdd).addMeta(fileIDs).addMeta(CCFMetaItem.of("ORIGINAL_CHROM", "<Type=chromosome,Description=\"Chromosome as to " + (Object)((Object)convertedInputVariantFileSet.refG) + ".\">")).addMeta(CCFMetaItem.of("ORIGINAL_POS", "<Type=varInt32,Description=\"Physical position on the chromosome as to " + (Object)((Object)convertedInputVariantFileSet.refG) + " (1-based coordinate).\">")), (inputs, output) -> {
                if (this.needGTY && GlobalPedIndividuals.getIndividuals().isEmpty()) {
                    output.addIndividuals(((GTBInputOption)inputs.get(0)).getIndividuals());
                    output.addFields(((GTBInputOption)inputs.get(0)).getAllFields());
                }
            }).bridge(new IConverter<Variant, GTBInputOption, Variant, GTBOutputOption>(){
                final LiftOver liftOver;
                {
                    this.liftOver = convertedInputVariantFileSet.refG.to(GenerateAnnotationBaseTask0.this.inputsOptions.globalAnnotationGenomeVersion);
                }

                @Override
                public Iterable<Variant> converter(Variant variant, GTBInputOption gtbInputOption, long pointer, GTBOutputOption outputOption) throws IOException {
                    int originPos;
                    Chromosome originChromosome;
                    variant.prune();
                    if (variant.getChromosome().getIndex() > 24) {
                        return null;
                    }
                    if (excludeVariants && excludedRegions.containsKey(originChromosome = variant.getChromosome())) {
                        originPos = variant.getPosition();
                        if (((IntIntervalTree)excludedRegions.get(originChromosome)).contains(originPos)) {
                            return null;
                        }
                    }
                    if (includeVariants) {
                        originChromosome = variant.getChromosome();
                        if (includedRegions.containsKey(originChromosome)) {
                            originPos = variant.getPosition();
                            if (!((IntIntervalTree)includedRegions.get(originChromosome)).contains(originPos)) {
                                return null;
                            }
                        } else {
                            return null;
                        }
                    }
                    if (alleleNumbers != null) {
                        boolean alleleNumInvalid;
                        IndexableSet<String> alleles = variant.getAlleles();
                        if (alleles == null) {
                            countAlleleNum.increment();
                            return null;
                        }
                        boolean bl = alleleNumInvalid = !alleleNumbers.contains(alleles.size(), true);
                        if (alleleNumInvalid) {
                            countAlleleNum.increment();
                            return null;
                        }
                    }
                    if (this.liftOver != LiftOver.ITSELF) {
                        if ((variant = this.liftOver.convert(variant)) == null) {
                            return null;
                        }
                        if (variant.getChromosome().getIndex() > 24) {
                            return null;
                        }
                    }
                    if (GenerateAnnotationBaseTask0.this.needGTY) {
                        variant.setProperty("SOURCE@FILE_ID", finalSourceGtyFilePath);
                        variant.setProperty("SOURCE@FILE_POINTER", -1);
                    } else {
                        variant.setProperty("SOURCE@FILE_ID", SOURCE_FILE_ID);
                        variant.setProperty("SOURCE@FILE_POINTER", pointer);
                    }
                    IGenotypes gty = variant.getGenotypes().subGenotypes(finalGtbIDofPedSubs);
                    variant.setGenotypes(gty);
                    bar.step(Math.max(1, variant.numOfAlleles() - 1), 0L);
                    List<Variant> returns = variant.biallelic(Variant.BiallelicMode.SET_TO_MISSING).filter(v -> {
                        double testHWp;
                        double testHWpControl;
                        double testHWpCase;
                        float variantObsRate;
                        float ALL_COUNT_AF;
                        int ALL_COUNT_AN;
                        int ALL_COUNT_AC;
                        int ALL_COUNT_BB;
                        int ALL_COUNT_AB;
                        int ALL_COUNT_AA;
                        if (isOnlySNP) {
                            for (String allele : v.getAlleles()) {
                                if (allele.length() <= 1 && Variant.isStandardAllele(allele)) continue;
                                return false;
                            }
                            countSnp.increment();
                        }
                        if (isOnlyIndel) {
                            if (v.alleleOfIndex(0).length() == v.alleleOfIndex(1).length()) {
                                return false;
                            }
                            for (String allele : v.getAlleles()) {
                                if (!Variant.isStandardAllele(allele)) {
                                    return false;
                                }
                                if (allele.length() > 1 && allele.length() <= 50) continue;
                                return false;
                            }
                            countIndel.increment();
                        }
                        int CASE_COUNT_AA = 0;
                        int CASE_COUNT_AB = 0;
                        int CASE_COUNT_BB = 0;
                        int CASE_COUNT_AC = 0;
                        int CASE_COUNT_AN = 0;
                        float CASE_COUNT_AF = 0.0f;
                        int CONTROL_COUNT_AA = 0;
                        int CONTROL_COUNT_AB = 0;
                        int CONTROL_COUNT_BB = 0;
                        int CONTROL_COUNT_AC = 0;
                        int CONTROL_COUNT_AN = 0;
                        float CONTROL_COUNT_AF = 0.0f;
                        IGenotypes genotypes = v.getGenotypes();
                        if (finalNoPedFile) {
                            ICounter genotypeCounter = genotypes.counter();
                            ALL_COUNT_AA = genotypeCounter.count(Genotype.of(0, 0));
                            ALL_COUNT_AB = genotypeCounter.count(Genotype.of(0, 1)) + genotypeCounter.count(Genotype.of(1, 0));
                            ALL_COUNT_BB = genotypeCounter.count(Genotype.of(1, 1));
                            ALL_COUNT_AC = genotypeCounter.getAC(1);
                            ALL_COUNT_AN = genotypeCounter.getAN();
                        } else {
                            float variantMafCase;
                            if (!caseIDsInPed.isEmpty()) {
                                ICounter caseGenotypeCounter = genotypes.subGenotypes(caseIDsInPed).counter();
                                CASE_COUNT_AA = caseGenotypeCounter.count(Genotype.of(0, 0));
                                CASE_COUNT_AB = caseGenotypeCounter.count(Genotype.of(0, 1)) + caseGenotypeCounter.count(Genotype.of(1, 0));
                                CASE_COUNT_BB = caseGenotypeCounter.count(Genotype.of(1, 1));
                                CASE_COUNT_AC = caseGenotypeCounter.getAC(1);
                                CASE_COUNT_AN = caseGenotypeCounter.getAN();
                                float f = CASE_COUNT_AF = CASE_COUNT_AN == 0 ? 0.0f : (float)CASE_COUNT_AC / (float)CASE_COUNT_AN;
                                if (needNonMissingRateCaseFilter) {
                                    float variantObsRateCase;
                                    float f2 = variantObsRateCase = caseSubjectsSize == 0 ? 0.0f : 1.0f - (float)caseGenotypeCounter.count(Genotype.of(-1, -1)) / (float)caseSubjectsSize;
                                    if (variantObsRateCase < nonMissingRateCase) {
                                        countObsCaseFail.increment();
                                        return false;
                                    }
                                }
                                if (needLocalAltCaseFilter) {
                                    if (localAltCutCase.contains(CASE_COUNT_AF, true)) {
                                        countAltCase.increment();
                                    } else {
                                        return false;
                                    }
                                }
                                if (needLocalMafCaseFilter) {
                                    float f3 = variantMafCase = (double)CASE_COUNT_AF > 0.5 ? 1.0f - CASE_COUNT_AF : CASE_COUNT_AF;
                                    if (localMafCutCase.contains(variantMafCase, true)) {
                                        countMafCase.increment();
                                    } else {
                                        return false;
                                    }
                                }
                            }
                            if (!controlIDsInPed.isEmpty()) {
                                ICounter controlGenotypeCounter = genotypes.subGenotypes(controlIDsInPed).counter();
                                CONTROL_COUNT_AA = controlGenotypeCounter.count(Genotype.of(0, 0));
                                CONTROL_COUNT_AB = controlGenotypeCounter.count(Genotype.of(0, 1)) + controlGenotypeCounter.count(Genotype.of(1, 0));
                                CONTROL_COUNT_BB = controlGenotypeCounter.count(Genotype.of(1, 1));
                                CONTROL_COUNT_AC = controlGenotypeCounter.getAC(1);
                                CONTROL_COUNT_AN = controlGenotypeCounter.getAN();
                                float f = CONTROL_COUNT_AF = CONTROL_COUNT_AN == 0 ? 0.0f : (float)CONTROL_COUNT_AC / (float)CONTROL_COUNT_AN;
                                if (needNonMissingRateControlFilter) {
                                    float variantObsRateControl;
                                    float f4 = variantObsRateControl = controlSubjectsSize == 0 ? 0.0f : (float)CONTROL_COUNT_AN / (float)(controlSubjectsSize * 2);
                                    if (variantObsRateControl < nonMissingRateControl) {
                                        countObsControlFail.increment();
                                        return false;
                                    }
                                }
                                if (needLocalAltControlFilter) {
                                    if (localAltCutControl.contains(CONTROL_COUNT_AF, true)) {
                                        countAltControl.increment();
                                    } else {
                                        return false;
                                    }
                                }
                                if (needLocalMafControlFilter) {
                                    float variantMafControl;
                                    float f5 = variantMafControl = (double)CONTROL_COUNT_AF > 0.5 ? 1.0f - CONTROL_COUNT_AF : CONTROL_COUNT_AF;
                                    if (localMafCutControl.contains(variantMafControl, true)) {
                                        countMafControl.increment();
                                    } else {
                                        return false;
                                    }
                                }
                                if (needAltRatioFilter) {
                                    if (CASE_COUNT_AF >= CONTROL_COUNT_AF * minAltRatio) {
                                        countAltRatio.increment();
                                    } else {
                                        return false;
                                    }
                                }
                                if (needMafRatioFilter) {
                                    float variantMafControl;
                                    variantMafCase = (double)CASE_COUNT_AF > 0.5 ? 1.0f - CASE_COUNT_AF : CASE_COUNT_AF;
                                    float f6 = variantMafControl = (double)CONTROL_COUNT_AF > 0.5 ? 1.0f - CONTROL_COUNT_AF : CONTROL_COUNT_AF;
                                    if (variantMafCase >= variantMafControl * minMafRatio) {
                                        countMafRatio.increment();
                                    } else {
                                        return false;
                                    }
                                }
                            }
                            int OTHER_COUNT_AA = 0;
                            int OTHER_COUNT_AB = 0;
                            int OTHER_COUNT_BB = 0;
                            int OTHER_COUNT_AC = 0;
                            int OTHER_COUNT_AN = 0;
                            if (haveOthers) {
                                ICounter otherGenotypeCounter = genotypes.subGenotypes(otherSubIDsInPed).counter();
                                OTHER_COUNT_AA = otherGenotypeCounter.count(Genotype.of(0, 0));
                                OTHER_COUNT_AB = otherGenotypeCounter.count(Genotype.of(0, 1)) + otherGenotypeCounter.count(Genotype.of(1, 0));
                                OTHER_COUNT_BB = otherGenotypeCounter.count(Genotype.of(1, 1));
                                OTHER_COUNT_AC = otherGenotypeCounter.getAC(1);
                                OTHER_COUNT_AN = otherGenotypeCounter.getAN();
                            }
                            ALL_COUNT_AA = CASE_COUNT_AA + CONTROL_COUNT_AA + OTHER_COUNT_AA;
                            ALL_COUNT_AB = CASE_COUNT_AB + CONTROL_COUNT_AB + OTHER_COUNT_AB;
                            ALL_COUNT_BB = CASE_COUNT_BB + CONTROL_COUNT_BB + OTHER_COUNT_BB;
                            ALL_COUNT_AC = CASE_COUNT_AC + CONTROL_COUNT_AC + OTHER_COUNT_AC;
                            ALL_COUNT_AN = CASE_COUNT_AN + CONTROL_COUNT_AN + OTHER_COUNT_AN;
                        }
                        if (ALL_COUNT_AC < minAC) {
                            countMinAC.increment();
                            return false;
                        }
                        float f = ALL_COUNT_AF = ALL_COUNT_AN == 0 ? 0.0f : (float)ALL_COUNT_AC / (float)ALL_COUNT_AN;
                        if (needNonMissingRateFilter && (variantObsRate = (float)((double)ALL_COUNT_AN / ((double)allSubjectsSize * 2.0))) < nonMissingRate) {
                            countObsFail.increment();
                            return false;
                        }
                        if (needLocalAltFilter) {
                            if (localAltCut.contains(ALL_COUNT_AF, true)) {
                                countAlt.increment();
                            } else {
                                return false;
                            }
                        }
                        if (needLocalMafFilter) {
                            float variantMaf;
                            float f7 = variantMaf = (double)ALL_COUNT_AF > 0.5 ? 1.0f - ALL_COUNT_AF : ALL_COUNT_AF;
                            if (localMafCut.contains(variantMaf, true)) {
                                countMaf.increment();
                            } else {
                                return false;
                            }
                        }
                        if (needHweCaseFilter && CASE_COUNT_AN > 0 && CASE_COUNT_AC > 0 && (testHWpCase = HardyWeinbergCalculator.calculate(CASE_COUNT_AA, CASE_COUNT_AB, CASE_COUNT_BB, true)) < hweCaseThreshold) {
                            countHweCaseFail.increment();
                            return false;
                        }
                        if (needHweControlFilter && CONTROL_COUNT_AN > 0 && CONTROL_COUNT_AC > 0 && (testHWpControl = HardyWeinbergCalculator.calculate(ALL_COUNT_AA, ALL_COUNT_AB, ALL_COUNT_BB, true)) < hweControlThreshold) {
                            countHweControlFail.increment();
                            return false;
                        }
                        if (needHweFilter && ALL_COUNT_AN > 0 && ALL_COUNT_AC > 0 && (testHWp = HardyWeinbergCalculator.calculate(ALL_COUNT_AA, ALL_COUNT_AB, ALL_COUNT_BB, true)) < hweThreshold) {
                            countHweFail.increment();
                            return false;
                        }
                        if (haveCases) {
                            v.setProperty(GenerateAnnotationBaseTask0.this.RefHomGtyNum_CASE.fullName(), CASE_COUNT_AA);
                            v.setProperty(GenerateAnnotationBaseTask0.this.HetGtyNum_CASE.fullName(), CASE_COUNT_AB);
                            v.setProperty(GenerateAnnotationBaseTask0.this.AltHomGtyNum_CASE.fullName(), CASE_COUNT_BB);
                            v.setProperty(GenerateAnnotationBaseTask0.this.MissingGtyNum_CASE.fullName(), caseSubjectsSize - CASE_COUNT_AA - CASE_COUNT_AB - CASE_COUNT_BB);
                        }
                        if (haveControls) {
                            v.setProperty(GenerateAnnotationBaseTask0.this.RefHomGtyNum_CONTROL.fullName(), CONTROL_COUNT_AA);
                            v.setProperty(GenerateAnnotationBaseTask0.this.HetGtyNum_CONTROL.fullName(), CONTROL_COUNT_AB);
                            v.setProperty(GenerateAnnotationBaseTask0.this.AltHomGtyNum_CONTROL.fullName(), CONTROL_COUNT_BB);
                            v.setProperty(GenerateAnnotationBaseTask0.this.MissingGtyNum_CONTROL.fullName(), controlSubjectsSize - CONTROL_COUNT_AA - CONTROL_COUNT_AB - CONTROL_COUNT_BB);
                        }
                        if (haveOthers) {
                            // empty if block
                        }
                        v.setProperty(GenerateAnnotationBaseTask0.this.RefHomGtyNum_ALL.fullName(), ALL_COUNT_AA);
                        v.setProperty(GenerateAnnotationBaseTask0.this.HetGtyNum_ALL.fullName(), ALL_COUNT_AB);
                        v.setProperty(GenerateAnnotationBaseTask0.this.AltHomGtyNum_ALL.fullName(), ALL_COUNT_BB);
                        v.setProperty(GenerateAnnotationBaseTask0.this.MissingGtyNum_ALL.fullName(), allSubjectsSize - ALL_COUNT_AA - ALL_COUNT_AB - ALL_COUNT_BB);
                        return true;
                    });
                    if (returns.isEmpty()) {
                        return null;
                    }
                    bar.step(0L, returns.size());
                    return returns;
                }
            }).setListener(new InputOutputListener()).submit(threadNum);
            GTBSorter sorter = GTBSorter.setInput(this.outputFile, new String[0]);
            if (!sorter.isOrdered(threadNum)) {
                sorter.sort(this.outputFile, threadNum, true);
                GTBIndexer.setInput(this.outputFile, new String[0]).save(threadNum);
            } else if (new GTBManager(this.outputFile).getIndexer() == null) {
                GTBIndexer.setInput(this.outputFile, new String[0]).save(threadNum);
            }
            bar.close();
            context.put("UpdatedBaseVariantSet", true);
            if (this.needGTY) {
                FileUtils.rename(this.outputFile, this.outputGTYFile);
                context.put("OutputGTYFile", this.outputGTYFile);
                Processor.setInput(new GTBInputOption(new GTBReaderOption(new GTBManager(this.outputGTYFile), false, true))).setOutput(new GTBOutputOption(this.outputFile), (inputs, output) -> {
                    output.addFields(((GTBInputOption)inputs.fastGet(0)).getAllFields());
                    output.addMeta(((GTBInputOption)inputs.fastGet(0)).getMeta());
                }).bridge((variant, gtbInputOption, pointer, outputOption) -> {
                    variant.setProperty("SOURCE@FILE_POINTER", pointer);
                    return new SingletonIterable<Variant>((Variant)variant);
                }).setListener(new InputOutputListener()).submit(threadNum);
            }
            completeTaskResult.setOutputPath(this.outputFile);
            SetupApplication.GlobalTaskTracker.recordTaskCompletion(completeTaskResult);
        } else {
            context.put("UpdatedBaseVariantSet", false);
        }
        GTBManager manager = new GTBManager(this.outputFile);
        String outVFInfo = "";
        if (countSnp.sum() > 0L) {
            outVFInfo = outVFInfo + "\n  " + countSnp.sum() + " SNP variants are retained.";
        }
        if (countIndel.sum() > 0L) {
            outVFInfo = outVFInfo + "\n  " + countIndel.sum() + " InDel variants are retained.";
        }
        if (countAlleleNum.sum() > 0L) {
            outVFInfo = outVFInfo + "\n  " + countAlleleNum.sum() + " variants with alleles numbers beyond the range  < " + this.vcfQualityControlOptions.rangeOfAlleleNum + "% are excluded.";
        }
        if (countMinAC.sum() > 0L) {
            outVFInfo = outVFInfo + "\n  " + countMinAC.sum() + " variants with the observed non-reference alleles count in the ped-file sample < " + this.inputsOptions.localAltCount + " are excluded.";
        }
        if (countObsFail.sum() > 0L) {
            outVFInfo = outVFInfo + "\n  " + countObsFail.sum() + " variants with the observed rate of non-missing genotypes < " + this.inputsOptions.minObsRate.floatValue() * 100.0f + "% are excluded.";
        }
        if (countObsCaseFail.sum() > 0L) {
            outVFInfo = outVFInfo + "\n  " + countObsCaseFail.sum() + " variants in cases with the observed rate of non-missing genotypes < " + this.inputsOptions.minObsRateCase.floatValue() * 100.0f + "% are excluded.";
        }
        if (countObsControlFail.sum() > 0L) {
            outVFInfo = outVFInfo + "\n  " + countObsControlFail.sum() + " variants in controls with the observed rate of non-missing genotypes < " + this.inputsOptions.minObsRateControl.floatValue() * 100.0f + "% are excluded.";
        }
        if (countHweFail.sum() > 0L) {
            outVFInfo = outVFInfo + "\n  " + countHweFail.sum() + " variants with the Hardy-Weinberg test P value < " + this.inputsOptions.hwe + " are excluded.";
        }
        if (countHweCaseFail.sum() > 0L) {
            outVFInfo = outVFInfo + "\n  " + countHweCaseFail.sum() + " variants in cases with the Hardy-Weinberg test P value < " + this.inputsOptions.hweCase + " are excluded.";
        }
        if (countHweControlFail.sum() > 0L) {
            outVFInfo = outVFInfo + "\n  " + countHweControlFail.sum() + " variants in controls with the Hardy-Weinberg test P value < " + this.inputsOptions.hweControl + " are excluded.";
        }
        if (countAlt.sum() > 0L) {
            FloatInterval values2 = this.inputsOptions.localAf;
            outVFInfo = outVFInfo + "\n  " + countAlt.sum() + " variants with alternative allele frequency " + values2.start() + "-" + values2.end() + " are retained.";
        }
        if (countAltCase.sum() > 0L) {
            FloatInterval values3 = this.inputsOptions.localAfCase;
            outVFInfo = outVFInfo + "\n  " + countAltCase.sum() + " variants in cases with alternative allele frequency " + values3.start() + "-" + values3.end() + " are retained.";
        }
        if (countAltControl.sum() > 0L) {
            FloatInterval values4 = this.inputsOptions.localAfControl;
            outVFInfo = outVFInfo + "\n  " + countAltControl.sum() + " variants in controls with alternative allele frequency " + values4.start() + "-" + values4.end() + " are retained.";
        }
        if (countMaf.sum() > 0L) {
            FloatInterval values5 = this.inputsOptions.localMaf;
            outVFInfo = outVFInfo + "\n  " + countMaf.sum() + " variants with minor allele frequency " + values5.start() + "-" + values5.end() + " are retained";
        }
        if (countMafCase.sum() > 0L) {
            FloatInterval values6 = this.inputsOptions.localMafCase;
            outVFInfo = outVFInfo + "\n  " + countMafCase.sum() + " variants in cases with minor allele frequency " + values6.start() + "-" + values6.end() + " are retained";
        }
        if (countMafControl.sum() > 0L) {
            FloatInterval values7 = this.inputsOptions.localMafControl;
            outVFInfo = outVFInfo + "\n  " + countMafControl.sum() + " variants in controls with minor allele frequency " + values7.start() + "-" + values7.end() + " are retained";
        }
        if (countAltRatio.sum() > 0L) {
            outVFInfo = outVFInfo + "\n  " + countAltRatio.sum() + " variants with alternative allele frequency in cases is " + this.inputsOptions.minCaseControlAfRatio + " times higher than that of in controls are retained";
        }
        if (countMafRatio.sum() > 0L) {
            outVFInfo = outVFInfo + "\n  " + countMafRatio.sum() + " variants with minor allele frequency in cases is " + this.inputsOptions.minCaseControlMafRatio + " times higher than that of in controls are retained";
        }
        if (!outVFInfo.isEmpty()) {
            SetupApplication.GlobalLogger.info("Variant filtration summaries in {}: {}\n", (Object)convertedInputVariantFileSet.finalGTBManager.getFile().getName(), (Object)outVFInfo);
        }
        context.put("OutputManager", manager);
        if (this.needGTY) {
            context.put("OutputGTYFile", this.outputGTYFile);
        }
    }

    private String digest() {
        InputPhenotypeFileSet pedPhenoFileSet = this.inputsOptions.phenoFileSet;
        StringBuilder sb = new StringBuilder(512);
        sb.append('|').append(pedPhenoFileSet == null ? "," : Integer.valueOf(pedPhenoFileSet.hashCode())).append('|').append(this.inputsOptions.onlySnp).append('|').append(this.inputsOptions.onlyIndel).append('|').append(this.inputsOptions.hwe).append('|').append(this.inputsOptions.hweCase).append('|').append(this.inputsOptions.hweControl).append('|').append(this.inputsOptions.minObsRate).append('|').append(this.inputsOptions.minObsRateCase).append('|').append(this.inputsOptions.minObsRateControl).append('|').append(this.inputsOptions.localMaf).append('|').append(this.inputsOptions.localMafCase).append('|').append(this.inputsOptions.localMafControl).append('|').append(this.inputsOptions.localAf).append('|').append(this.inputsOptions.localAfCase).append('|').append(this.inputsOptions.localAfControl).append('|').append(this.inputsOptions.minCaseControlMafRatio).append('|').append(this.inputsOptions.minCaseControlAfRatio).append('|').append((Object)this.inputsOptions.outputGtyFormat).append('|').append(this.vcfQualityControlOptions.rangeOfAlleleNum);
        return ITrack.digest(sb.toString());
    }
}

