/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.analysis.GeneMutationFuncImpactFreqCalcuThread;
import edu.sysu.pmglab.analysis.GenomeRegion;
import edu.sysu.pmglab.annotation.Var2RegionMapper;
import edu.sysu.pmglab.annotation.VarGeneFeatureType;
import edu.sysu.pmglab.annotation.database.gene.IGeneFeature;
import edu.sysu.pmglab.ccf.CCFWriter;
import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IEditableFieldCollection;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.ccf.type.basic.VarInt32Box;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.list.LongList;
import edu.sysu.pmglab.container.rangelist.VarInt64RangeList;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.ThreadQueue;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReader;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.TaskTracker;
import edu.sysu.pmglab.kgga.command.Utility;
import edu.sysu.pmglab.kgga.command.pipeline.MutationCountAnalysisOptions;
import edu.sysu.pmglab.kgga.command.setting.AFGRESetting;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class GenerateReferenceAFGRETask
implements ITask {
    File outputFile;
    String[] scoreFieldNames;
    String[] freqFieldNames;
    MutationCountAnalysisOptions mutationCountAnalysisOptions;
    int threadNum;

    public GenerateReferenceAFGRETask(MutationCountAnalysisOptions mutationCountAnalysisOptions, File outputDir, String[] scoreFieldNames, String[] freqFieldNames, boolean makeDir, int threadNum) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFile = new File(FileUtils.getSubFile(outputDir.getPath(), "gene.mutation.score.freq.weight.hg38.ccf"));
        this.scoreFieldNames = scoreFieldNames;
        this.freqFieldNames = freqFieldNames;
        this.mutationCountAnalysisOptions = mutationCountAnalysisOptions;
        this.threadNum = threadNum;
    }

    @Override
    public void execute(Status lastReturn, Context context) throws Exception, Error {
        ITrack track = context.getTracker();
        File inputFile = (File)context.cast("AnnotationBaseVariantSet");
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        if (updatedVariantSet == null) {
            updatedVariantSet = false;
        }
        Boolean updatedGeneSet = (Boolean)context.cast("UpdatedBaseGeneSet");
        TaskTracker.TaskResult completeTaskResult = new TaskTracker.TaskResult(this.getClass().getName(), Utility.MD5File(inputFile), this.digest());
        Optional<File> outputPathOpt = SetupApplication.GlobalTaskTracker.checkTask(completeTaskResult);
        outputPathOpt.ifPresent(file -> {
            this.outputFile = file;
        });
        boolean needRedo = updatedVariantSet != false || updatedGeneSet != false || !outputPathOpt.isPresent();
        boolean bl = needRedo = needRedo || !this.outputFile.exists();
        if (needRedo) {
            FieldMeta field;
            SetupApplication.GlobalLogger.info("Generate AFGRE with background variants ...");
            List<String> neededFields = new List<String>();
            GTBManager manager = new GTBManager(inputFile);
            for (String fieldName : this.scoreFieldNames) {
                field = manager.getField(fieldName);
                neededFields.add(field.fullName());
            }
            for (String fieldName : this.freqFieldNames) {
                field = manager.getField(fieldName);
                neededFields.add(field.fullName());
            }
            neededFields.add("SOURCE@FILE_ID");
            neededFields.add("SOURCE@FILE_POINTER");
            GTBReader annotReader = new GTBReader((GTBReaderOption)new GTBReaderOption(manager, false, false).addFields(neededFields));
            List<GenomeRegion> geneRegions = new List<GenomeRegion>();
            File geneAnnotationFile = FileUtils.getSubFile(inputFile.getParentFile().getParentFile(), "/AssignVar2GeneTask/genes.annot.hg38.ccf");
            Var2RegionMapper var2RegionMapper = new Var2RegionMapper();
            Map<String, GenomeRegion> geneRegionMap = var2RegionMapper.readAssignedVarPointersOfGenes(geneAnnotationFile);
            for (Map.Entry<String, GenomeRegion> entry : geneRegionMap.entrySet()) {
                geneRegions.add(entry.getValue());
            }
            geneRegions.sort(Comparator.comparingLong(GenomeRegion::getStartPointer).thenComparingLong(GenomeRegion::getEndPointer));
            LongList pointersAnnotFile = new LongList();
            THashMap geneResults = new THashMap();
            IEditableFieldCollection outputFields = new FieldGroupMetas().addField("Basic@SymbolID", FieldType.varInt32).addField("Basic@GeneSubRegionTypeID", FieldType.varInt32).addField("Basic@Chromosome", FieldType.chromosome).addField("Basic@Start", FieldType.varInt32).addField("Basic@End", FieldType.varInt32).addFields(new List<FieldMeta>(){
                {
                    for (String scoreFieldName : GenerateReferenceAFGRETask.this.scoreFieldNames) {
                        this.add(FieldMeta.of(scoreFieldName, FieldType.float32Array));
                    }
                }
            });
            CCFWriter writer = CCFWriter.setOutput(this.outputFile).addFields(outputFields).instance();
            Map geneRegionLengthMap = (Map)context.cast("geneSubRegionLength");
            ThreadQueue threadPool = new ThreadQueue(this.threadNum);
            threadPool.setParam(GeneMutationFuncImpactFreqCalcuThread.class, geneResults);
            GeneMutationFuncImpactFreqCalcuThread[] geneMutationFuncImpactCalcus = new GeneMutationFuncImpactFreqCalcuThread[this.threadNum];
            AFGRESetting afgreOptions = this.mutationCountAnalysisOptions.afgre;
            for (int i = 0; i < geneMutationFuncImpactCalcus.length; ++i) {
                geneMutationFuncImpactCalcus[i] = new GeneMutationFuncImpactFreqCalcuThread(this.freqFieldNames, this.scoreFieldNames, (FieldGroupMetas)outputFields, geneRegionLengthMap);
                geneMutationFuncImpactCalcus[i].setParameters(afgreOptions.getCs());
            }
            int geneNum = geneRegions.size();
            IndexableSet geneSymbolMap = (IndexableSet)context.cast("geneSymbolIDMap");
            int workingThreadNum = 0;
            int effectiveRegionNum = 0;
            for (int i = 0; i < geneNum; ++i) {
                GenomeRegion gene = (GenomeRegion)geneRegions.get(i);
                VarInt64RangeList pb = gene.getOutcomeVarPointers();
                pointersAnnotFile.clear();
                if (pb == null) continue;
                TLongIterator pbIters = pb.iterator();
                while (pbIters.hasNext()) {
                    long pointer = pbIters.next();
                    pointersAnnotFile.add(pointer);
                }
                if (pointersAnnotFile.isEmpty()) continue;
                pointersAnnotFile.sort();
                int size = pointersAnnotFile.size();
                List<Variant> variantsTmp = new List<Variant>();
                for (int m = 0; m < size; ++m) {
                    annotReader.seek(pointersAnnotFile.get(m));
                    Variant annotVariant = annotReader.read();
                    variantsTmp.add(annotVariant);
                }
                geneMutationFuncImpactCalcus[workingThreadNum].setGeneProperties(gene.getLabel(), gene.getType(), gene.getChromID(), variantsTmp);
                geneMutationFuncImpactCalcus[workingThreadNum].setGeneSymbolMap(geneSymbolMap);
                threadPool.addTask(geneMutationFuncImpactCalcus[workingThreadNum]);
                if (++workingThreadNum < geneMutationFuncImpactCalcus.length) continue;
                threadPool.await();
                for (int j = 0; j < workingThreadNum; ++j) {
                    IRecord iRecord = geneMutationFuncImpactCalcus[j].getiRecord();
                    if (iRecord == null) continue;
                    writer.write(iRecord);
                    ++effectiveRegionNum;
                }
                workingThreadNum = 0;
            }
            if (workingThreadNum > 0) {
                threadPool.await();
                for (int j = 0; j < workingThreadNum; ++j) {
                    IRecord iRecord = geneMutationFuncImpactCalcus[j].getiRecord();
                    if (iRecord == null) continue;
                    writer.write(iRecord);
                    ++effectiveRegionNum;
                }
            }
            threadPool.close();
            annotReader.close();
            writer.close();
            GTBIndexer.setInput(this.outputFile, "Basic@Chromosome", "Basic@Start").getChromosomeFrom(record -> (Chromosome)record.get(0)).getPositionFrom(record -> {
                VarInt32Box box = (VarInt32Box)record.getBox(1);
                return box.intValue();
            }).save(this.threadNum);
            SetupApplication.GlobalLogger.info("{} background gene regions are obtained AFGREs for {} score(s).", (Object)effectiveRegionNum, (Object)this.scoreFieldNames.length);
            completeTaskResult.setOutputPath(this.outputFile);
            SetupApplication.GlobalTaskTracker.recordTaskCompletion(completeTaskResult);
            context.put("UpdatedBaseGeneSet", true);
        } else {
            context.put("UpdatedBaseGeneSet", false);
        }
        context.put(GenerateReferenceAFGRETask.class, this.outputFile);
    }

    private void extractAllGeneFeatures(Variant var, Map<Integer, Set<Integer>> geneVarIDMap, boolean needSubIntron, int dependentSubIntron) {
        Object feature = null;
        List geneFeatureAnnots = new List();
        geneFeatureAnnots.addAll(IGeneFeature.instancesOf((List)var.getProperty("GeneFeature@RefGene")));
        geneFeatureAnnots.addAll(IGeneFeature.instancesOf((List)var.getProperty("GeneFeature@GENCODE")));
        geneFeatureAnnots.addAll(IGeneFeature.instancesOf((List)var.getProperty("GeneFeature@KnownGene")));
        for (IGeneFeature item : geneFeatureAnnots) {
            int geneSymbIndex = item.getGeneSymbolID();
            byte featureID = item.getTypeID();
            if (featureID == VarGeneFeatureType.INTRONIC.getFeatureID() && needSubIntron && item.getSubRegionID() > dependentSubIntron) continue;
            Set varType = geneVarIDMap.computeIfAbsent(geneSymbIndex, k -> new HashSet());
            varType.add(Integer.valueOf(featureID));
        }
    }

    private String digest() {
        AFGRESetting afgreOptions = this.mutationCountAnalysisOptions.afgre;
        return ITrack.digest(afgreOptions.toString());
    }
}

