/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.ccf.CCFWriter;
import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IEditableFieldCollection;
import edu.sysu.pmglab.ccf.indexer.intvalue.CCFIntIndexer;
import edu.sysu.pmglab.ccf.indexer.intvalue.RefinedIntBuckets;
import edu.sysu.pmglab.ccf.record.Record;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.NamedVarInt64RangeList;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.interval.FloatInterval;
import edu.sysu.pmglab.container.list.FloatList;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.list.LongList;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.ThreadQueue;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReader;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.Utility;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationOptions;
import edu.sysu.pmglab.kgga.command.pipeline.MutationCountAnalysisOptions;
import edu.sysu.pmglab.kgga.command.setting.AFGRESetting;
import edu.sysu.pmglab.kgga.command.setting.CountRegressionRunnerSetting;
import edu.sysu.pmglab.progressbar.ProgressBar;
import gnu.trove.iterator.TLongIterator;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class GenerateReferenceGeneFreqScoreTask
implements ITask {
    File outputFile;
    String[] scoreFieldNames;
    String[] freqFieldNames;
    AnnotationOptions annotationOptions;
    MutationCountAnalysisOptions mutationCountAnalysisOptions;
    int threadNum;

    public GenerateReferenceGeneFreqScoreTask(AnnotationOptions annotationOptions, MutationCountAnalysisOptions mutationCountAnalysisOptions, File outputDir, String[] scoreFieldNames, String[] freqFieldNames, boolean makeDir, int threadNum) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFile = new File(FileUtils.getSubFile(outputDir.getPath(), "gene.mutation.freq.score.hg38.ccf"));
        this.scoreFieldNames = scoreFieldNames;
        this.freqFieldNames = freqFieldNames;
        this.annotationOptions = annotationOptions;
        this.mutationCountAnalysisOptions = mutationCountAnalysisOptions;
        this.threadNum = threadNum;
    }

    private boolean collectFreqScores(Variant var, FloatList[] freqScores, FloatInterval mafCut, FloatInterval altFreqCut, float[] freqs, float[] vals) {
        int i;
        int freqNum = this.freqFieldNames.length;
        int scoreNum = this.scoreFieldNames == null ? 0 : this.scoreFieldNames.length;
        Arrays.fill(freqs, 0.0f);
        Arrays.fill(vals, Float.NaN);
        boolean valid = true;
        int zeroFreqNum = 0;
        for (int i2 = 0; i2 < freqNum; ++i2) {
            float tmpFreq = ((Float)var.getProperty(this.freqFieldNames[i2])).floatValue();
            if (Float.isNaN(tmpFreq)) {
                tmpFreq = 0.0f;
            }
            freqs[i2] = tmpFreq;
            if (tmpFreq == 0.0f) {
                ++zeroFreqNum;
            }
            if (mafCut != null && !mafCut.contains(tmpFreq, true)) {
                valid = false;
                break;
            }
            if (altFreqCut == null || altFreqCut.contains(tmpFreq, true)) continue;
            valid = false;
            break;
        }
        if (!valid) {
            return false;
        }
        if (zeroFreqNum == freqNum) {
            return false;
        }
        int naNum = 0;
        for (i = 0; i < scoreNum; ++i) {
            float tmpScore;
            vals[i] = tmpScore = ((Float)var.getProperty(this.scoreFieldNames[i])).floatValue();
            if (!Float.isNaN(tmpScore)) continue;
            ++naNum;
        }
        if (scoreNum > 0 && naNum >= scoreNum) {
            return false;
        }
        for (i = 0; i < freqNum; ++i) {
            freqScores[i].add(freqs[i]);
        }
        for (i = 0; i < scoreNum; ++i) {
            freqScores[i + freqNum].add(vals[i]);
        }
        return true;
    }

    @Override
    public void execute(Status lastReturn, Context context) throws Exception, Error {
        boolean needRedo;
        ITrack track = context.getTracker();
        File inputFile = (File)context.cast("AnnotationBaseVariantSet");
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        if (updatedVariantSet == null) {
            updatedVariantSet = false;
        }
        boolean bl = needRedo = updatedVariantSet != false || !this.outputFile.exists() || !track.contains(this.digest(inputFile, this.outputFile));
        if (needRedo) {
            FieldMeta field;
            SetupApplication.GlobalLogger.info("Generate mutation frequency score at genes ...");
            LinkedSet neededFields = new LinkedSet();
            FloatInterval mafCut = this.annotationOptions.dbMaf;
            FloatInterval altFreqCut = this.annotationOptions.dbAf;
            if (this.threadNum > 10) {
                this.threadNum = 10;
            }
            GTBManager manager = new GTBManager(inputFile);
            CCFIntIndexer<Chromosome> chromosomeTree = manager.getIndexer(true, null);
            for (String fieldName : this.scoreFieldNames) {
                field = manager.getField(fieldName);
                ((AbstractCollection)neededFields).add(field.fullName());
            }
            for (String fieldName : this.freqFieldNames) {
                field = manager.getField(fieldName);
                ((AbstractCollection)neededFields).add(field.fullName());
            }
            IEditableFieldCollection outputFields = new FieldGroupMetas().addField("Basic@SymbolID", FieldType.varInt32).addField("Basic@GeneSubRegionTypeID", FieldType.varInt32).addField("Basic@Chromosome", FieldType.chromosome).addFields(new List<FieldMeta>(){
                {
                    for (String freqFieldName : GenerateReferenceGeneFreqScoreTask.this.freqFieldNames) {
                        this.add(FieldMeta.of(freqFieldName, FieldType.float32List));
                    }
                    for (String scoreFieldName : GenerateReferenceGeneFreqScoreTask.this.scoreFieldNames) {
                        this.add(FieldMeta.of(scoreFieldName, FieldType.float32List));
                    }
                }
            });
            CCFWriter writers = CCFWriter.setOutput(this.outputFile).addFields(outputFields).instance(this.threadNum);
            int freqScoreNum = ((AbstractCollection)neededFields).size();
            Map<String, Map<String, NamedVarInt64RangeList>> chromRegions = Utility.assignVariant2GeneRegions(this.threadNum, manager, chromosomeTree, true);
            AtomicInteger totalRegionNum = new AtomicInteger(0);
            ThreadQueue threadPool = new ThreadQueue(this.threadNum);
            int totalRegions = 0;
            for (Map.Entry<String, Map<String, NamedVarInt64RangeList>> entry : chromRegions.entrySet()) {
                totalRegions += entry.getValue().size();
            }
            ProgressBar progressBar = new ProgressBar.Builder().setTextRenderer("Processed", "regions").setInitialMax(totalRegions).build();
            IntList writerIDs = IntList.range(0, this.threadNum - 1);
            for (Chromosome curChromosome : chromosomeTree.getTags()) {
                threadPool.addTask((arg_0, arg_1) -> this.lambda$execute$2(writerIDs, chromosomeTree, curChromosome, manager, neededFields, chromRegions, (FieldGroupMetas)outputFields, progressBar, freqScoreNum, mafCut, altFreqCut, writers, totalRegionNum, arg_0, arg_1));
            }
            threadPool.close();
            writers.close();
            progressBar.close();
            SetupApplication.GlobalLogger.info(" {} gene regions are obtained frequencies and scores.", (Object)totalRegionNum);
            track.add(this.getClass().getName(), this.digest(inputFile, this.outputFile));
            context.put("UpdatedBaseGeneSet", true);
        } else {
            context.put("UpdatedBaseGeneSet", false);
        }
        context.put(GenerateReferenceGeneFreqScoreTask.class, this.outputFile);
    }

    private String digest(File inputFile, File outputFile) throws IOException {
        AFGRESetting afgreOptions = this.mutationCountAnalysisOptions.afgre;
        CountRegressionRunnerSetting countRegressionRunnerSetting = this.mutationCountAnalysisOptions.countRegressionRunnerSetting;
        StringBuilder sb = new StringBuilder();
        sb.append(inputFile.getCanonicalPath()).append("|").append(inputFile.length()).append("|").append(inputFile.lastModified()).append("|").append(outputFile.getCanonicalPath()).append("|").append(outputFile.length()).append("|").append(outputFile.lastModified()).append("|").append(countRegressionRunnerSetting == null ? "" : Arrays.toString(countRegressionRunnerSetting.getWeightFields())).append("|").append(afgreOptions == null ? "" : afgreOptions.getAllFields());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$execute$2(IntList writerIDs, CCFIntIndexer chromosomeTree, Chromosome curChromosome, GTBManager manager, IndexableSet neededFields, Map chromRegions, FieldGroupMetas outputFields, ProgressBar progressBar, int freqScoreNum, FloatInterval mafCut, FloatInterval altFreqCut, CCFWriter writers, AtomicInteger totalRegionNum, Status status1, Context context1) throws Exception, Error {
        int writerID;
        IntList intList = writerIDs;
        synchronized (intList) {
            writerID = writerIDs.popFirst();
        }
        RefinedIntBuckets buckets = chromosomeTree.getTag(curChromosome);
        if (buckets == null) {
            return;
        }
        GTBReader annotReader = new GTBReader((GTBReaderOption)new GTBReaderOption(manager, false, false).addFields(neededFields));
        annotReader.limit(buckets.getRecordIndexRange());
        annotReader.seek(0L);
        float[] freqs = new float[this.freqFieldNames.length];
        float[] vals = new float[this.scoreFieldNames.length];
        Map currentChromRegions = (Map)chromRegions.get(curChromosome.getName());
        List geneRegions = new List(currentChromRegions.values());
        geneRegions.sort(Comparator.comparingLong(o -> o.get(0L)).thenComparingLong(o -> o.get(o.size() - 1L)));
        int geneNum = geneRegions.size();
        LongList pointersAnnotFile = new LongList();
        List<Variant> variantsTmp = new List<Variant>();
        Record iRecord = new Record(outputFields);
        String tab = "#";
        int freqNum = this.freqFieldNames.length;
        int scoreNum = this.scoreFieldNames.length;
        int addedValue = 0;
        for (int geneIndex = 0; geneIndex < geneNum; ++geneIndex) {
            int i;
            progressBar.step(1L);
            NamedVarInt64RangeList pb = (NamedVarInt64RangeList)geneRegions.get(geneIndex);
            pointersAnnotFile.clear();
            if (pb == null) continue;
            TLongIterator pbIters = pb.iterator();
            while (pbIters.hasNext()) {
                long pointer = pbIters.next();
                pointersAnnotFile.add(pointer);
            }
            if (pointersAnnotFile.isEmpty()) continue;
            pointersAnnotFile.sort();
            int size = pointersAnnotFile.size();
            variantsTmp.clear();
            for (int m = 0; m < size; ++m) {
                annotReader.seek(pointersAnnotFile.get(m));
                Variant annotVariant = annotReader.read();
                variantsTmp.add(annotVariant);
            }
            if (variantsTmp.isEmpty()) continue;
            FloatList[] freqScores = new FloatList[freqScoreNum];
            for (int k = 0; k < freqScoreNum; ++k) {
                freqScores[k] = new FloatList();
            }
            addedValue = 0;
            for (Variant var1 : variantsTmp) {
                boolean isAdded = this.collectFreqScores(var1, freqScores, mafCut, altFreqCut, freqs, vals);
                if (!isAdded) continue;
                ++addedValue;
            }
            if (addedValue == 0) continue;
            String label = pb.getName();
            String[] items = label.split(tab);
            iRecord.set("Basic@SymbolID", (Object)Integer.parseInt(items[0]));
            iRecord.set("Basic@GeneSubRegionTypeID", (Object)Integer.parseInt(items[1]));
            iRecord.set("Basic@Chromosome", (Object)curChromosome);
            for (i = 0; i < freqNum; ++i) {
                iRecord.set(this.freqFieldNames[i], (Object)freqScores[i]);
            }
            for (i = 0; i < scoreNum; ++i) {
                iRecord.set(this.scoreFieldNames[i], (Object)freqScores[i + freqNum]);
            }
            writers.write(writerID, iRecord);
            totalRegionNum.incrementAndGet();
        }
        IntList intList2 = writerIDs;
        synchronized (intList2) {
            writerIDs.add(writerID);
        }
        annotReader.close();
    }
}

