/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.ccf.indexer.intvalue.CCFIntIndexer;
import edu.sysu.pmglab.ccf.indexer.intvalue.RefinedIntBuckets;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.converter.Variant2Variant;
import edu.sysu.pmglab.ccf.toolkit.input.GTBInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputOutputListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.container.LDPairs;
import edu.sysu.pmglab.container.LDPruner;
import edu.sysu.pmglab.container.array.StringArray;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.ThreadQueue;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReader;
import edu.sysu.pmglab.gtb.GTBWriter;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.linkagedisequilibrium.LDProperty;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.gtb.toolkit.GTBSorter;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.TaskTracker;
import edu.sysu.pmglab.kgga.command.Utility;
import edu.sysu.pmglab.kgga.command.pipeline.LDPruneOptions;
import edu.sysu.pmglab.kgga.io.GlobalPedIndividuals;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import edu.sysu.pmglab.objectpool.GenericObjectPool;
import edu.sysu.pmglab.progressbar.MultiProgressBar;
import edu.sysu.pmglab.progressbar.TextProgressRenderers;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;

public class LDPruningTask
implements ITask {
    File outputFile;
    LDPruneOptions ldPruneOptions;
    int threadNum;
    String[] pFieldLabels;
    Comparator<LDPairs> ldPairsComparator = (t0, t1) -> {
        int size = t0.scores.length;
        double interval = 0.0;
        for (int i = 0; i < size; ++i) {
            boolean isNaN1;
            double s0 = t0.scores[i];
            double s1 = t1.scores[i];
            boolean isNaN0 = Double.isNaN(s0);
            if (isNaN0 != (isNaN1 = Double.isNaN(s1))) {
                return isNaN0 ? -1 : 1;
            }
            if (isNaN0) continue;
            if (interval > 0.0 && i == 0) {
                long key1;
                long key0 = (long)Math.floor(s0 / interval);
                int comp = Long.compare(key0, key1 = (long)Math.floor(s1 / interval));
                if (comp == 0) continue;
                return comp;
            }
            int comp = Double.compare(s0, s1);
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    };
    Comparator<Variant> varFileIDComparator = (o1, o2) -> {
        int cmp = o1.getProperty("SOURCE@FILE_ID").toString().compareTo(o2.getProperty("SOURCE@FILE_ID").toString());
        if (cmp == 0) {
            long p1 = (Long)o1.getProperty("SOURCE@FILE_POINTER");
            long p2 = (Long)o2.getProperty("SOURCE@FILE_POINTER");
            cmp = Long.compare(p1, p2);
        }
        return cmp;
    };

    public LDPruningTask(LDPruneOptions ldPruneOptions, String[] pFieldLabels, File outputDir, boolean makeDir, int threadNum) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFile = FileUtils.getSubFile(outputDir, InputOutputFileSet.getAnnotationFileName());
        this.ldPruneOptions = ldPruneOptions;
        this.threadNum = threadNum;
        this.pFieldLabels = pFieldLabels;
    }

    @Override
    public void execute(Status lastReturn, Context context) throws Exception, Error {
        File inputFile = (File)context.cast("AnnotationBaseVariantSet");
        TaskTracker.TaskResult completeTaskResult = new TaskTracker.TaskResult(this.getClass().getName(), Utility.MD5File(inputFile), this.digest());
        Optional<File> outputPathOpt = SetupApplication.GlobalTaskTracker.checkTask(completeTaskResult);
        outputPathOpt.ifPresent(file -> {
            this.outputFile = file;
        });
        if (!this.outputFile.exists() || !outputPathOpt.isPresent()) {
            GTBManager manager = new GTBManager(inputFile);
            CCFIntIndexer<Chromosome> chromosomeTree = manager.getIndexer(true, null);
            SetupApplication.GlobalLogger.info("Pruning variants ...");
            long initialVarNum = manager.numOfVariants();
            MultiProgressBar progressBar = new MultiProgressBar.Builder().setRenderers(new TextProgressRenderers().add("ReadIn", "variants").add("Retained", "variants")).build();
            GenericObjectPool<LDProperty> ldPropertyObjectPool = new GenericObjectPool<LDProperty>(() -> new LDProperty(GlobalPedIndividuals.size()));
            ICCFMeta meta = manager.getMeta();
            int chromNum = chromosomeTree.getTags().size();
            List<GTBManager> convertedInputFiles = new List<GTBManager>();
            for (Chromosome chromosome : chromosomeTree.getTags()) {
                RefinedIntBuckets buckets = chromosomeTree.getTag(chromosome);
                GTBReader annotVariantReader = new GTBReader(manager);
                annotVariantReader.limit(buckets.getRecordIndexRange());
                List<GTBReader> partReaders = annotVariantReader.part(this.threadNum);
                int threadNum0 = partReaders.size();
                File chromFile = chromNum > 1 ? new File(this.outputFile + "." + chromosome.getName()) : this.outputFile;
                GTBWriter writers = GTBWriter.setOutput(chromFile).addFields(manager.getAllFields()).addIndividuals(GlobalPedIndividuals.getIndividuals().getUIDs()).instance(threadNum0);
                writers.addMeta(meta);
                ThreadQueue threadPool = new ThreadQueue(threadNum0);
                int[][] breakIntervals = new int[threadNum0][2];
                for (int index = 0; index < threadNum0; ++index) {
                    int writerIndex = index % threadNum0;
                    threadPool.addTask((status1, context1) -> {
                        Arrays.fill(breakIntervals[writerIndex], -1);
                        this.pruningInBlocks((GTBReader)partReaders.get(writerIndex), progressBar, writers, writerIndex, breakIntervals[writerIndex], ldPropertyObjectPool);
                    });
                }
                threadPool.close();
                for (GTBReader gtbReader : partReaders) {
                    gtbReader.close();
                }
                partReaders.clear();
                writers.close();
                List<int[]> nonEmptyIntervals = new List<int[]>();
                for (int index = 0; index < threadNum0; ++index) {
                    if (breakIntervals[index][1] < 0) continue;
                    nonEmptyIntervals.add(breakIntervals[index]);
                }
                if (!nonEmptyIntervals.isEmpty()) {
                    this.pruningBetweenBlocks(chromFile, (int[][])nonEmptyIntervals.toArray((T1[])new int[0][0]), ldPropertyObjectPool);
                }
                convertedInputFiles.add(new GTBManager(chromFile));
                ldPropertyObjectPool.clear();
            }
            progressBar.close();
            ldPropertyObjectPool.clear();
            if (chromNum > 1) {
                Processor.setInputs(convertedInputFiles.apply(GTBInputOption::new)).setOutput(new GTBOutputOption(this.outputFile), (inputs, output) -> {
                    output.addFields(((GTBInputOption)inputs.fastGet(0)).getAllFields());
                    output.addMeta(((GTBInputOption)inputs.fastGet(0)).getMeta());
                    output.addIndividuals(((GTBInputOption)inputs.fastGet(0)).getIndividuals());
                }).bridge(new Variant2Variant()).setListener(new InputOutputListener()).submit(this.threadNum);
                for (GTBManager gtb : convertedInputFiles) {
                    gtb.getFile().deleteOnExit();
                }
            }
            manager = new GTBManager(this.outputFile);
            SetupApplication.GlobalLogger.info("{} out of {} variants are retained after LD clumping with r^2 cutoff {}. ", manager.numOfVariants(), initialVarNum, Float.valueOf(this.ldPruneOptions.pruneR2));
            GTBSorter sorter = GTBSorter.setInput(this.outputFile, new String[0]);
            if (!sorter.isOrdered(this.threadNum)) {
                sorter.sort(this.outputFile, this.threadNum, true);
                GTBIndexer.setInput(this.outputFile, new String[0]).save(this.threadNum);
            } else if (new GTBManager(this.outputFile).getIndexer() == null) {
                GTBIndexer.setInput(this.outputFile, new String[0]).save(this.threadNum);
            }
            completeTaskResult.setOutputPath(this.outputFile);
            SetupApplication.GlobalTaskTracker.recordTaskCompletion(completeTaskResult);
        }
        context.put("AnnotationBaseVariantSet", this.outputFile);
    }

    private void pruningInBlocks(GTBReader annotVariantReader, MultiProgressBar progressBar, GTBWriter writers, int writerIndex, int[] startEndPos, GenericObjectPool<LDProperty> ldPropertyObjectPool) throws IOException {
        List<Variant> tmpPrunedVariants;
        Variant variant;
        double thresholdP = this.ldPruneOptions.pruneP;
        float ldR2Cutoff = this.ldPruneOptions.pruneR2;
        int windowSize = this.ldPruneOptions.pruneWindow * 1000;
        StringArray fieldsPrioritization = this.ldPruneOptions.pruneScoreField;
        int checkingNum = 1000;
        THashMap<String, GTBReader> gtyReaders = new THashMap<String, GTBReader>();
        List retainedVariants = new List();
        List<Variant> preprunedVariants = new List<Variant>();
        List<Variant> unprunedVariants = new List<Variant>();
        int firstPos = 0;
        TIntObjectHashMap<TIntHashSet> simplifiedLDUpper = new TIntObjectHashMap<TIntHashSet>();
        TIntObjectHashMap<TIntHashSet> simplifiedLDLower = new TIntObjectHashMap<TIntHashSet>();
        while ((variant = annotVariantReader.read()) != null) {
            int t;
            progressBar.step(1L, 0L);
            if (variant.numOfAlleles() <= 1) continue;
            if (this.pFieldLabels != null) {
                boolean isLess = false;
                for (Iterator<Object> iterator2 : this.pFieldLabels) {
                    double p = (Double)variant.getProperty((String)((Object)iterator2));
                    if (!(p <= thresholdP)) continue;
                    isLess = true;
                    break;
                }
                if (!isLess) continue;
            }
            if (preprunedVariants.isEmpty()) {
                firstPos = variant.getPosition();
            }
            if (variant.getPosition() - firstPos <= windowSize) {
                unprunedVariants.add(variant);
                if (unprunedVariants.size() < checkingNum) continue;
                tmpPrunedVariants = LDPruner.ldPruning(unprunedVariants, gtyReaders, fieldsPrioritization, ldR2Cutoff, this.varFileIDComparator, this.ldPairsComparator, simplifiedLDUpper, simplifiedLDLower, ldPropertyObjectPool);
                unprunedVariants.clear();
                preprunedVariants.addAll(tmpPrunedVariants);
                firstPos = preprunedVariants.get(0).getPosition();
                continue;
            }
            unprunedVariants.add(variant);
            tmpPrunedVariants = LDPruner.ldPruning(unprunedVariants, gtyReaders, fieldsPrioritization, ldR2Cutoff, this.varFileIDComparator, this.ldPairsComparator, simplifiedLDUpper, simplifiedLDLower, ldPropertyObjectPool);
            unprunedVariants.clear();
            preprunedVariants.addAll(tmpPrunedVariants);
            tmpPrunedVariants = LDPruner.ldPruning(preprunedVariants, gtyReaders, fieldsPrioritization, ldR2Cutoff, this.varFileIDComparator, this.ldPairsComparator, simplifiedLDUpper, simplifiedLDLower, ldPropertyObjectPool);
            preprunedVariants.clear();
            preprunedVariants.addAll(tmpPrunedVariants);
            int size = preprunedVariants.size();
            for (t = 0; t < size && variant.getPosition() - preprunedVariants.get(t).getPosition() > windowSize; ++t) {
            }
            if (t > 0) {
                int i;
                for (i = 0; i < t; ++i) {
                    LDProperty property = (LDProperty)preprunedVariants.get(i).getProperty(LDProperty.class.getName());
                    if (property == null) continue;
                    ldPropertyObjectPool.returnObject(property);
                }
                if (startEndPos[0] < 0) {
                    startEndPos[0] = preprunedVariants.get(0).getPosition();
                }
                for (i = 0; i < t; ++i) {
                    variant = preprunedVariants.get(i);
                    simplifiedLDUpper.remove(variant.getPosition());
                    simplifiedLDLower.remove(variant.getPosition());
                    LDProperty property = (LDProperty)variant.getProperty(LDProperty.class.getName());
                    if (property != null) {
                        ldPropertyObjectPool.returnObject(property);
                    }
                    variant.setGenotypes(null);
                    writers.write(writerIndex, variant);
                    progressBar.step(1L, 1L);
                }
                if (startEndPos[1] < variant.getPosition()) {
                    startEndPos[1] = variant.getPosition();
                }
                retainedVariants.clear();
                retainedVariants.addAll(preprunedVariants.subList(t, preprunedVariants.size()));
                preprunedVariants.clear();
                preprunedVariants.addAll(retainedVariants);
                retainedVariants.clear();
            }
            if (preprunedVariants.isEmpty()) continue;
            firstPos = preprunedVariants.get(0).getPosition();
        }
        if (!unprunedVariants.isEmpty()) {
            tmpPrunedVariants = LDPruner.ldPruning(unprunedVariants, gtyReaders, fieldsPrioritization, ldR2Cutoff, this.varFileIDComparator, this.ldPairsComparator, simplifiedLDUpper, simplifiedLDLower, ldPropertyObjectPool);
            unprunedVariants.clear();
            preprunedVariants.addAll(tmpPrunedVariants);
        }
        if (!preprunedVariants.isEmpty()) {
            List<Variant> prunedVariants = LDPruner.ldPruning(preprunedVariants, gtyReaders, fieldsPrioritization, ldR2Cutoff, this.varFileIDComparator, this.ldPairsComparator, simplifiedLDUpper, simplifiedLDLower, ldPropertyObjectPool);
            retainedVariants.addAll(prunedVariants);
            preprunedVariants.clear();
        }
        for (Variant variant1 : retainedVariants) {
            LDProperty property = (LDProperty)variant1.getProperty(LDProperty.class.getName());
            if (property != null) {
                ldPropertyObjectPool.returnObject(property);
            }
            variant1.setGenotypes(null);
            writers.write(writerIndex, variant1);
            progressBar.step(1L, 1L);
        }
        if (!retainedVariants.isEmpty()) {
            if (startEndPos[0] < 0) {
                startEndPos[0] = ((Variant)retainedVariants.get(0)).getPosition();
            }
            if (startEndPos[1] < (variant = (Variant)retainedVariants.get(retainedVariants.size() - 1)).getPosition()) {
                startEndPos[1] = variant.getPosition();
            }
            retainedVariants.clear();
        }
        annotVariantReader.close();
        for (GTBReader gtyReader : gtyReaders.values()) {
            gtyReader.close();
        }
    }

    private void pruningBetweenBlocks(File inputFile, int[][] breakIntervals, GenericObjectPool<LDProperty> ldPropertyObjectPool) throws IOException {
        Variant variant;
        double thresholdP = this.ldPruneOptions.pruneP;
        float ldR2Cutoff = this.ldPruneOptions.pruneR2;
        int windowSize = this.ldPruneOptions.pruneWindow * 1000;
        StringArray fieldsPrioritization = this.ldPruneOptions.pruneScoreField;
        GTBManager manager = new GTBManager(inputFile);
        GTBReader annotVariantReader = new GTBReader(inputFile);
        GTBWriter writer = GTBWriter.setOutput(inputFile).addFields(manager.getAllFields()).instance(breakIntervals.length);
        writer.addMeta(manager.getMeta());
        List<Variant> unprunedVariants = new List<Variant>();
        for (int i = 0; i < breakIntervals.length; ++i) {
            int[] nArray = breakIntervals[i];
            nArray[0] = nArray[0] + windowSize;
            int[] nArray2 = breakIntervals[i];
            nArray2[1] = nArray2[1] - windowSize;
        }
        boolean firstPos = false;
        int steppedIntervalIndex = 0;
        ThreadQueue threadPool = new ThreadQueue(writer.numOfParts());
        while ((variant = annotVariantReader.read()) != null) {
            if (variant.numOfAlleles() <= 1) continue;
            if (this.pFieldLabels != null) {
                boolean isLess = false;
                for (String pFieldLabel : this.pFieldLabels) {
                    double p = (Double)variant.getProperty(pFieldLabel);
                    if (!(p <= thresholdP)) continue;
                    isLess = true;
                    break;
                }
                if (!isLess) continue;
            }
            if (variant.getPosition() < breakIntervals[steppedIntervalIndex][1] || steppedIntervalIndex == breakIntervals.length - 1) {
                writer.write(steppedIntervalIndex, variant);
                continue;
            }
            if (variant.getPosition() > breakIntervals[steppedIntervalIndex + 1][0]) {
                int finalSteppedIntervalIndex = steppedIntervalIndex++;
                threadPool.addTask(new WriteIntervalTask(unprunedVariants, fieldsPrioritization, ldR2Cutoff, writer, finalSteppedIntervalIndex, ldPropertyObjectPool));
                unprunedVariants.clear();
                writer.write(steppedIntervalIndex, variant);
                continue;
            }
            unprunedVariants.add(variant);
        }
        threadPool.close();
        for (Variant variant1 : unprunedVariants) {
            LDProperty property = (LDProperty)variant1.getProperty(LDProperty.class.getName());
            if (property != null) {
                ldPropertyObjectPool.returnObject(property);
            }
            variant1.setGenotypes(null);
            writer.write(steppedIntervalIndex, variant1);
        }
        annotVariantReader.close();
        writer.close();
    }

    private String digest() {
        StringBuilder sb = new StringBuilder(512);
        sb.append(this.ldPruneOptions.pruneP).append('|').append(this.ldPruneOptions.pruneWindow).append('|').append(this.ldPruneOptions.pruneR2).append('|').append(this.ldPruneOptions.associationOptionSet == null ? "." : Integer.valueOf(this.ldPruneOptions.associationOptionSet.hashCode())).append('|').append(this.ldPruneOptions.pruneScoreField == null ? "." : this.ldPruneOptions.pruneScoreField.toString());
        return ITrack.digest(sb.toString());
    }

    private class WriteIntervalTask
    implements ITask {
        List<Variant> unprunedVariants;
        StringArray fieldsPrioritization;
        float ldR2Cutoff;
        GTBWriter writer;
        int finalSteppedIntervalIndex;
        GenericObjectPool<LDProperty> ldPropertyObjectPool;

        public WriteIntervalTask(List<Variant> unprunedVariants, StringArray fieldsPrioritization, float ldR2Cutoff, GTBWriter writer, int finalSteppedIntervalIndex, GenericObjectPool<LDProperty> ldPropertyObjectPool) {
            this.unprunedVariants = new List<Variant>(unprunedVariants);
            this.fieldsPrioritization = fieldsPrioritization;
            this.ldR2Cutoff = ldR2Cutoff;
            this.writer = writer;
            this.finalSteppedIntervalIndex = finalSteppedIntervalIndex;
            this.ldPropertyObjectPool = ldPropertyObjectPool;
        }

        @Override
        public void execute(Status status, Context context) throws Exception, Error {
            TIntObjectHashMap<TIntHashSet> simplifiedLDUpper = new TIntObjectHashMap<TIntHashSet>();
            TIntObjectHashMap<TIntHashSet> simplifiedLDLower = new TIntObjectHashMap<TIntHashSet>();
            THashMap<String, GTBReader> gtyReaders = new THashMap<String, GTBReader>();
            List<Variant> tmpPrunedVariants = LDPruner.ldPruning(this.unprunedVariants, gtyReaders, this.fieldsPrioritization, this.ldR2Cutoff, LDPruningTask.this.varFileIDComparator, LDPruningTask.this.ldPairsComparator, simplifiedLDUpper, simplifiedLDLower, this.ldPropertyObjectPool);
            for (GTBReader gtyReader : gtyReaders.values()) {
                gtyReader.close();
            }
            for (Variant variant1 : tmpPrunedVariants) {
                LDProperty property = (LDProperty)variant1.getProperty(LDProperty.class.getName());
                if (property != null) {
                    this.ldPropertyObjectPool.returnObject(property);
                }
                variant1.setGenotypes(null);
                this.writer.write(this.finalSteppedIntervalIndex, variant1);
            }
        }
    }
}

