/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.annotator.SequentialDatabase;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.list.DoubleList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.toolkit.GTBAnnotator;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.TaskTracker;
import edu.sysu.pmglab.kgga.command.Utility;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;

public class MergeVariantScoresTask
implements ITask {
    File outputFile;
    Map<String, String[]> groupsFieldsForMerge;
    int threadNum;

    public MergeVariantScoresTask(File outputDir, Map<String, String[]> groupsFieldsForMerge, boolean makeDir, int threadNum) {
        this.groupsFieldsForMerge = groupsFieldsForMerge;
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFile = FileUtils.getSubFile(outputDir, InputOutputFileSet.getAnnotationFileName());
        this.threadNum = threadNum;
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        File inputFile = (File)context.cast("AnnotationBaseVariantSet");
        GTBManager inputManager = new GTBManager(inputFile);
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        if (updatedVariantSet == null) {
            updatedVariantSet = false;
        }
        final FieldGroupMetas fieldMetasToAdd = new FieldGroupMetas();
        List<String> mergedScoreNames = new List<String>();
        for (Map.Entry<String, String[]> entry : this.groupsFieldsForMerge.entrySet()) {
            String mergedName = entry.getKey();
            FieldMeta mergedField = FieldMeta.of("Combined@" + mergedName, FieldType.float32);
            fieldMetasToAdd.addField(mergedField);
            mergedScoreNames.add(mergedField.fullName());
        }
        boolean mergeScore = false;
        if (!mergedScoreNames.isEmpty()) {
            String[] mergedScoreNameArray = mergedScoreNames.toArray((T1[])new String[0]);
            context.put("mergedScoreNameArray", mergedScoreNameArray);
            mergeScore = true;
        }
        TaskTracker.TaskResult completeTaskResult = new TaskTracker.TaskResult(this.getClass().getName(), Utility.MD5File(inputFile), this.digest());
        Optional<File> outputPathOpt = SetupApplication.GlobalTaskTracker.checkTask(completeTaskResult);
        outputPathOpt.ifPresent(file -> {
            this.outputFile = file;
        });
        boolean contain = outputPathOpt.isPresent();
        if (updatedVariantSet.booleanValue() || !this.outputFile.exists() || !contain) {
            final DoubleMatrix2D[] corMatrixs = new DoubleMatrix2D[this.groupsFieldsForMerge.size()];
            final DoubleList[][] allSortedScores = new DoubleList[this.groupsFieldsForMerge.size()][];
            final String[][] groupsFieldsNamesForMerge = new String[this.groupsFieldsForMerge.size()][];
            int inc = 0;
            boolean containGroup = false;
            for (Map.Entry<String, String[]> entry : this.groupsFieldsForMerge.entrySet()) {
                if (inputManager.containsFieldGroup(entry.getKey())) {
                    containGroup = true;
                }
                String[] toBeMergedScores = entry.getValue();
                corMatrixs[inc] = new DenseDoubleMatrix2D(toBeMergedScores.length, toBeMergedScores.length);
                allSortedScores[inc] = Utility.collectVariantScoreList(inputManager, toBeMergedScores, corMatrixs[inc], this.threadNum, 100000, mergeScore);
                groupsFieldsNamesForMerge[inc] = toBeMergedScores;
                ++inc;
            }
            GTBAnnotator annotator = GTBAnnotator.setInput(new GTBReaderOption(inputManager)).setOutput(this.outputFile).addMeta(inputManager.getMeta()).addDatabase(new SequentialDatabase<Variant>(){

                @Override
                public IFieldCollection getAllFields() {
                    return fieldMetasToAdd;
                }

                @Override
                public boolean annotate(List<BoxRecord> resources, long pointer, Variant variant) {
                    boolean hasNNA = false;
                    for (int j = 0; j < groupsFieldsNamesForMerge.length; ++j) {
                        float varScore;
                        String[] toBeMergedScores = groupsFieldsNamesForMerge[j];
                        float[] tmpValues = new float[toBeMergedScores.length];
                        hasNNA = false;
                        for (int i = 0; i < toBeMergedScores.length; ++i) {
                            tmpValues[i] = varScore = ((Float)variant.getProperty(toBeMergedScores[i])).floatValue();
                            if (Float.isNaN(varScore)) continue;
                            hasNNA = true;
                        }
                        varScore = hasNNA ? Utility.standardizeEffectivelyIndependentAverageScores(tmpValues, allSortedScores[j], corMatrixs[j], true) : Float.NaN;
                        variant.setProperty(fieldMetasToAdd.getField(j).fullName(), Float.valueOf(varScore));
                    }
                    return true;
                }

                @Override
                public String toString() {
                    return super.toString();
                }
            });
            if (containGroup) {
                annotator.submit(this.threadNum);
            } else {
                annotator.append(this.threadNum);
            }
            completeTaskResult.setOutputPath(this.outputFile);
            SetupApplication.GlobalTaskTracker.recordTaskCompletion(completeTaskResult);
            GTBManager outputManager = new GTBManager(this.outputFile);
            SetupApplication.GlobalLogger.info("{} variants are obtained the combined scores.", (Object)outputManager.numOfVariants());
            context.put("UpdatedBaseVariantSet", true);
        } else {
            context.put("UpdatedBaseVariantSet", false);
        }
        context.put("AnnotationBaseVariantSet", this.outputFile);
    }

    private String digest() throws IOException {
        StringBuilder scores = new StringBuilder();
        for (Map.Entry<String, String[]> entry : this.groupsFieldsForMerge.entrySet()) {
            scores.append(entry.getKey());
            if (entry.getValue().length <= 0) continue;
            scores.append(",");
            scores.append(List.wrap(entry.getValue()).toString(","));
        }
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)scores).append("|");
        String code = ITrack.digest(sb.toString());
        return code;
    }
}

