/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.analysis.DriverType;
import edu.sysu.pmglab.analysis.GenomeRegion;
import edu.sysu.pmglab.analysis.TNBRegression;
import edu.sysu.pmglab.annotation.Var2RegionMapper;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.rangelist.VarInt32RangeList;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationOptions;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.pipeline.MutationCountAnalysisOptions;
import edu.sysu.pmglab.kgga.command.setting.CountRegressionMCVSSetting;
import edu.sysu.pmglab.kgga.command.setting.CountRegressionRunnerSetting;
import edu.sysu.pmglab.kgga.command.setting.InteractionSetting;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class MutationCountRegressionTask
implements ITask {
    final File outputFolder;
    String[] regressionFeatureNames;
    String[] countWeightingScores;
    String[] freqFieldNames;
    File geneScoreFreqDBPath;
    AnnotationOptions annotationOptions;
    MutationCountAnalysisOptions mutationCountAnalysisOptions;
    GeneralIOOptions generalIOOptions;
    InteractionSetting interactionSetting;

    public MutationCountRegressionTask(GeneralIOOptions generalIOOptions, AnnotationOptions annotationOptions, MutationCountAnalysisOptions mutationCountAnalysisOptions, File outputDir, String[] regressionFeatureNames, List<String> countWeightingScores, List<String> freqFieldNames, File geneScoreFreqDBPath, boolean stepwise, boolean makeDir, boolean adjustAF) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFolder = outputDir;
        this.regressionFeatureNames = regressionFeatureNames;
        this.countWeightingScores = countWeightingScores == null ? new String[]{null} : countWeightingScores.toArray((T1[])new String[0]);
        this.geneScoreFreqDBPath = geneScoreFreqDBPath;
        this.freqFieldNames = freqFieldNames.toArray((T1[])new String[0]);
        this.mutationCountAnalysisOptions = mutationCountAnalysisOptions;
        this.annotationOptions = annotationOptions;
        this.generalIOOptions = generalIOOptions;
        if (adjustAF) {
            FileUtils.getSubFile(this.outputFolder, "CodingExon").mkdirs();
            FileUtils.getSubFile(this.outputFolder, "UTR5").mkdirs();
            FileUtils.getSubFile(this.outputFolder, "UTR3").mkdirs();
            FileUtils.getSubFile(this.outputFolder, "UpStream").mkdirs();
            FileUtils.getSubFile(this.outputFolder, "DownStream").mkdirs();
            FileUtils.getSubFile(this.outputFolder, "OtherRegions").mkdirs();
            FileUtils.getSubFile(this.outputFolder, "Intron").mkdirs();
        }
    }

    public MutationCountRegressionTask(GeneralIOOptions generalIOOptions, AnnotationOptions annotationOptions, MutationCountAnalysisOptions mutationCountAnalysisOptions, InteractionSetting interactionSetting, File outputDir, String[] regressionFeatureNames, List<String> countWeightingScores, List<String> freqFieldNames, File geneScoreFreqDBPath, boolean stepwise, boolean makeDir) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFolder = outputDir;
        this.regressionFeatureNames = regressionFeatureNames;
        this.countWeightingScores = countWeightingScores == null ? new String[]{null} : countWeightingScores.toArray((T1[])new String[0]);
        this.interactionSetting = interactionSetting;
        this.geneScoreFreqDBPath = geneScoreFreqDBPath;
        this.freqFieldNames = freqFieldNames.toArray((T1[])new String[0]);
        this.mutationCountAnalysisOptions = mutationCountAnalysisOptions;
        this.annotationOptions = annotationOptions;
        this.generalIOOptions = generalIOOptions;
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        ITrack track = context.getTracker();
        File inputFile = (File)context.cast("AnnotationBaseVariantSet");
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        if (updatedVariantSet == null) {
            updatedVariantSet = false;
        }
        Boolean updatedGeneSet = (Boolean)context.cast("UpdatedBaseGeneSet");
        int caseNum = (Integer)context.cast("CaseSubjectNum");
        boolean countOnce = false;
        boolean iRunner = false;
        boolean useDynamicRegions = false;
        boolean runner = false;
        boolean controlPredictor = false;
        CountRegressionRunnerSetting regressionRunnerSetting = this.mutationCountAnalysisOptions.countRegressionRunnerSetting;
        CountRegressionMCVSSetting countRegressionMCVSSetting = this.mutationCountAnalysisOptions.countRegressionVSRSetting;
        InteractionSetting interactionSetting = this.mutationCountAnalysisOptions.interactionSetting;
        if (regressionRunnerSetting != null) {
            runner = true;
            countOnce = regressionRunnerSetting.isCountOnce();
            controlPredictor = regressionRunnerSetting.isControlPredictor();
        }
        if (countRegressionMCVSSetting != null) {
            countOnce = countRegressionMCVSSetting.isCountOnce();
            useDynamicRegions = true;
        }
        if (interactionSetting != null) {
            iRunner = true;
        }
        List<File> resultFiles = new List<File>();
        for (String countWeightingScore : this.countWeightingScores) {
            String outputPrefix = this.outputFolder.toString() + File.separator + countWeightingScore + ".regression.prioritized.genes";
            File outputFile = new File(outputPrefix + ".txt");
            if (updatedVariantSet.booleanValue() || updatedGeneSet.booleanValue() || !outputFile.exists() || !track.contains(this.digest(inputFile, outputFile))) {
                String mutationSubjectField = (String)context.cast("CaseMutationCountSubID");
                String mutationCountField = (String)context.cast("CaseMutationCount");
                Map geneSubRegionLength = (Map)context.cast("geneSubRegionLength");
                GTBManager annoManager = new GTBManager(inputFile);
                IndexableSet geneSymbMap = (IndexableSet)context.cast("geneSymbolIDMap");
                String residualType = "pearson";
                List<String> unavailableRegressionFeatures = new List<String>();
                List<String> varFeatureNames = new List<String>();
                for (String name : this.regressionFeatureNames) {
                    if (name.isEmpty()) continue;
                    if (annoManager.containsField(name)) {
                        varFeatureNames.add(name);
                        continue;
                    }
                    unavailableRegressionFeatures.add(name);
                }
                if (!unavailableRegressionFeatures.isEmpty()) {
                    SetupApplication.GlobalLogger.info("{} features {} are unavailable in {} for regression analysis as predictors!", unavailableRegressionFeatures.size(), unavailableRegressionFeatures, annoManager.getFile());
                }
                Var2RegionMapper var2RegionMapper = new Var2RegionMapper();
                var2RegionMapper.setGeneSymbolMap(geneSymbMap);
                TIntHashSet selectedFeatures = new TIntHashSet();
                VarInt32RangeList featureIDDs = this.annotationOptions.geneFeatureIn;
                TIntIterator ids = featureIDDs.iterator();
                while (ids.hasNext()) {
                    selectedFeatures.add(ids.next());
                }
                var2RegionMapper.setResponseGeneFeature(selectedFeatures);
                int minSampleSize = 200;
                DriverType driverType = DriverType.GENE;
                List<String> runningVarFeatureNames = new List<String>();
                runningVarFeatureNames.addAll(varFeatureNames);
                var2RegionMapper.cleanAllGeneRegions();
                int threadNum = this.generalIOOptions.threads;
                String adjustedACMeta = (String)context.cast("AdjustedAC");
                String caseACMeta = (String)context.cast("CaseMutationCount");
                String mutationSubjectControlField = (String)context.cast("ControlMutationCountSubID");
                String mutationCountControlField = (String)context.cast("ControlMutationCount");
                int controlSubjectNum = (Integer)context.cast("ControlSubjectNum");
                int caseSubjectNum = (Integer)context.cast("CaseSubjectNum");
                double caseControlRatio = Double.NaN;
                if (controlSubjectNum > 10) {
                    caseControlRatio = (double)caseSubjectNum / (double)controlSubjectNum;
                }
                if (useDynamicRegions) {
                    var2RegionMapper.assignVars2GenesWithThreadPool(adjustedACMeta, caseACMeta, inputFile, mutationSubjectField, mutationCountField, countWeightingScore, mutationSubjectControlField, mutationCountControlField, runningVarFeatureNames, geneSymbMap, geneSubRegionLength, countOnce, threadNum, countRegressionMCVSSetting.scanBySize, countRegressionMCVSSetting.pValueInRegion);
                } else if (runner || iRunner) {
                    var2RegionMapper.assignVars2GenesWithPredictors(adjustedACMeta, caseACMeta, inputFile, mutationSubjectField, mutationCountField, mutationSubjectControlField, mutationCountControlField, countWeightingScore, runningVarFeatureNames, geneSymbMap, geneSubRegionLength, countOnce, threadNum, regressionRunnerSetting.getFreqRatio(), this.freqFieldNames);
                    runningVarFeatureNames.add("RefCount");
                    runningVarFeatureNames.add("RegionLength_RefCount");
                    if (controlPredictor) {
                        runningVarFeatureNames.add("ControlCount");
                    }
                }
                boolean considerFunVar = countWeightingScore != null;
                int weightCountAdjustModel = 0;
                if (regressionRunnerSetting != null) {
                    weightCountAdjustModel = regressionRunnerSetting.getAdjustMethod().equalsIgnoreCase("full") ? 0 : 1;
                } else if (countRegressionMCVSSetting != null) {
                    int n = weightCountAdjustModel = countRegressionMCVSSetting.getAdjustMethod().equalsIgnoreCase("full") ? 0 : 1;
                }
                if (useDynamicRegions) {
                    var2RegionMapper.removeDuplicateRegionSet();
                    var2RegionMapper.separateRegions();
                    for (Map.Entry<String, List<GenomeRegion>> separateRegions : var2RegionMapper.getSeparateRegionMap().entrySet()) {
                        if (considerFunVar) {
                            var2RegionMapper.cleanAllGeneRegions();
                            var2RegionMapper.setBaseRegions(separateRegions.getValue());
                            var2RegionMapper.standardizeRegionFeatureScores();
                            var2RegionMapper.newStandardizeVariantScoresWithThread(threadNum);
                            var2RegionMapper.generateCalcGeneRegionSet();
                        }
                        TNBRegression tnbRegressor = new TNBRegression().setRServer(this.mutationCountAnalysisOptions.rServer).setThreads(this.generalIOOptions.threads).setRunStepwise(false).setMinMutCount(this.mutationCountAnalysisOptions.minCount).setMinSampleSize(minSampleSize);
                        residualType = "deviance";
                        tnbRegressor.setResidualType(residualType);
                        tnbRegressor.setFieldLabels(runningVarFeatureNames);
                        String regionType = separateRegions.getKey();
                        tnbRegressor.setRegions(var2RegionMapper.getCalcRegionSetList());
                        tnbRegressor.setMinSampleSize(var2RegionMapper.getCalcRegionSetList().size() / 10);
                        tnbRegressor.setUseControlMutPredictor(countOnce);
                        outputPrefix = this.outputFolder + File.separator + regionType + File.separator + countWeightingScore + ".regression.prioritized.genes";
                        outputFile = new File(outputPrefix + ".txt");
                        SetupApplication.GlobalLogger.info("Running truncated negative binomial regression in the {} ...", (Object)regionType);
                        tnbRegressor.setAdjustAF(useDynamicRegions);
                        tnbRegressor.produceRegionPValues(geneSymbMap, considerFunVar, outputPrefix, weightCountAdjustModel, caseControlRatio);
                        track.add(this.getClass().getName(), this.digest(inputFile, outputFile));
                        resultFiles.add(outputFile);
                    }
                    continue;
                }
                if (regressionRunnerSetting == null) continue;
                if (considerFunVar) {
                    var2RegionMapper.newStandardizeVariantScoresWithThread(threadNum);
                }
                if (iRunner) {
                    var2RegionMapper.generateCalcGeneRegionSet(interactionSetting, (IndexableSet<String>)geneSymbMap);
                } else {
                    var2RegionMapper.generateCalcGeneRegionSet();
                }
                TNBRegression tnbRegressor = new TNBRegression().setRServer(this.mutationCountAnalysisOptions.rServer).setThreads(this.generalIOOptions.threads).setRunStepwise(false).setMinMutCount(this.mutationCountAnalysisOptions.minCount).setMinSampleSize(minSampleSize).setDriverType(driverType);
                residualType = "deviance";
                tnbRegressor.setResidualType(residualType);
                tnbRegressor.setRegions(var2RegionMapper.getCalcRegionSetList());
                tnbRegressor.setFieldLabels(runningVarFeatureNames);
                tnbRegressor.setUseControlMutPredictor(controlPredictor);
                tnbRegressor.setIsIRunner(iRunner);
                SetupApplication.GlobalLogger.info("Running truncated negative binomial regression ...");
                tnbRegressor.produceRegionPValues(geneSymbMap, considerFunVar, outputPrefix, weightCountAdjustModel, caseControlRatio);
                track.add(this.getClass().getName(), this.digest(inputFile, outputFile));
                resultFiles.add(outputFile);
                continue;
            }
            resultFiles.add(outputFile);
            SetupApplication.GlobalLogger.info("{}.txt is not regenerated!", (Object)outputPrefix);
        }
        context.put("MutationCountRegressionTaskOutput", resultFiles);
    }

    public String digest(File inputFile, File outputFile) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(inputFile.getCanonicalPath()).append("|");
        sb.append(inputFile.length()).append("|");
        sb.append(inputFile.lastModified()).append("|");
        sb.append(outputFile.getCanonicalPath()).append("|");
        sb.append(outputFile.length()).append("|");
        sb.append(outputFile.lastModified()).append("|");
        sb.append(this.mutationCountAnalysisOptions.countRegressionRunnerSetting == null ? "." : this.mutationCountAnalysisOptions.countRegressionRunnerSetting.toString()).append("|");
        sb.append(this.mutationCountAnalysisOptions.countRegressionVSRSetting == null ? "." : this.mutationCountAnalysisOptions.countRegressionVSRSetting.toString()).append("|");
        sb.append(this.mutationCountAnalysisOptions.interactionSetting == null ? "." : this.mutationCountAnalysisOptions.interactionSetting.toString());
        return sb.toString();
    }
}

