/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.ccf.toolkit.input.GTBInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputOutputListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.toolkit.output.PLINKOutputOption;
import edu.sysu.pmglab.ccf.toolkit.output.VCFOutputOption;
import edu.sysu.pmglab.container.Individuals;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReader;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.gtb.toolkit.GTBSorter;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKType;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.TaskTracker;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.io.GlobalPedIndividuals;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import edu.sysu.pmglab.kgga.io.InputType;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class OutputGenotypes2OtherTask
implements ITask {
    File outputFile;
    InputType format;
    String[] otherOutputFields;
    GeneralIOOptions inputsOptions;

    public OutputGenotypes2OtherTask(GeneralIOOptions inputsOptions, File workSpace) {
        this.outputFile = FileUtils.getSubFile(workSpace, InputOutputFileSet.getAnnotationFileName());
        this.format = inputsOptions.outputGtyFormat;
        this.inputsOptions = inputsOptions;
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        GTBManager inputManager = new GTBManager((File)context.cast("AnnotationBaseVariantSet"));
        String outputPath = this.outputFile.getCanonicalPath();
        outputPath = outputPath.substring(0, outputPath.length() - 4);
        TaskTracker.TaskResult completeTaskResult = new TaskTracker.TaskResult(this.getClass().getName(), String.valueOf(inputManager.hashCode()), this.digest());
        Optional<File> outputPathOpt = SetupApplication.GlobalTaskTracker.checkTask(completeTaskResult);
        outputPathOpt.ifPresent(file -> {
            this.outputFile = file;
        });
        String outputFormatedFilePath = outputPath;
        switch (this.format) {
            case GTB: {
                outputFormatedFilePath = outputPath + ".gtb";
                break;
            }
            case VCF: {
                outputFormatedFilePath = outputPath + ".vcf.gz";
                break;
            }
            case PLINK_BED: {
                outputFormatedFilePath = outputPath + ".bed";
                break;
            }
            case PLINK_PGEN: {
                outputFormatedFilePath = outputPath + ".pgen";
            }
        }
        if (!this.outputFile.exists() || !outputPathOpt.isPresent()) {
            if (inputManager.numOfVariants() == 0L) {
                SetupApplication.GlobalLogger.info("No variants are retained for output finally!");
                return;
            }
            Individuals allIndividuals = GlobalPedIndividuals.getIndividuals();
            final TLongObjectHashMap<ThreadReader> gtyReaders = new TLongObjectHashMap<ThreadReader>();
            switch (this.format) {
                case GTB: {
                    outputPath = outputPath + ".gtb";
                    Processor.setInput(new GTBInputOption((GTBReaderOption)((GTBReaderOption)new GTBReaderOption(inputManager, false, true).addFields("SOURCE@FILE_ID")).addFields("SOURCE@FILE_POINTER"))).setOutput(new GTBOutputOption(outputPath).setIndividuals(allIndividuals.getUIDs()), (inputs, output) -> {
                        output.addFields(((GTBInputOption)inputs.fastGet(0)).getAllFields());
                        output.addMeta(((GTBInputOption)inputs.fastGet(0)).getMeta());
                        output.addIndividuals(((GTBInputOption)inputs.fastGet(0)).getIndividuals());
                    }).bridge(new ILiteConverter<Variant, Variant>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Variant converter(Variant variant) throws IOException {
                            long threadId = Thread.currentThread().getId();
                            String filePath = (String)variant.getProperty("SOURCE@FILE_ID");
                            long pointer = (Long)variant.getProperty("SOURCE@FILE_POINTER");
                            ThreadReader readerMap = (ThreadReader)gtyReaders.get(threadId);
                            if (readerMap == null) {
                                TLongObjectHashMap tLongObjectHashMap = gtyReaders;
                                synchronized (tLongObjectHashMap) {
                                    readerMap = (ThreadReader)gtyReaders.get(threadId);
                                    if (readerMap == null) {
                                        readerMap = new ThreadReader();
                                        gtyReaders.put(threadId, readerMap);
                                    }
                                }
                            }
                            GTBReader gtyReader = readerMap.init(filePath);
                            try {
                                gtyReader.seek(pointer);
                                variant.setGenotypes(gtyReader.read().getGenotypes());
                            }
                            catch (IOException e) {
                                return null;
                            }
                            return variant;
                        }
                    }).setListener(new InputOutputListener()).submit(this.inputsOptions.threads);
                    gtyReaders.forEachValue(ThreadReader::close);
                    GTBSorter sorter = GTBSorter.setInput(outputPath, new String[0]);
                    if (!sorter.isOrdered(this.inputsOptions.threads)) {
                        sorter.sort(outputPath, this.inputsOptions.threads, false);
                        GTBIndexer.setInput(outputPath, new String[0]).save(this.inputsOptions.threads);
                        break;
                    }
                    if (new GTBManager(outputPath).getIndexer() != null) break;
                    GTBIndexer.setInput(outputPath, new String[0]).save(this.inputsOptions.threads);
                    break;
                }
                case VCF: {
                    outputPath = outputPath + ".vcf.gz";
                    Processor.setInput(new GTBInputOption((GTBReaderOption)((GTBReaderOption)new GTBReaderOption(inputManager, true, false).addFields("SOURCE@FILE_ID")).addFields("SOURCE@FILE_POINTER"))).setOutput(new VCFOutputOption(outputPath).setIndividuals(allIndividuals.getUIDs())).bridge(new ILiteConverter<Variant, Variant>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Variant converter(Variant variant) throws IOException {
                            long threadId = Thread.currentThread().getId();
                            String filePath = (String)variant.getProperty("SOURCE@FILE_ID");
                            long pointer = (Long)variant.getProperty("SOURCE@FILE_POINTER");
                            ThreadReader readerMap = (ThreadReader)gtyReaders.get(threadId);
                            if (readerMap == null) {
                                TLongObjectHashMap tLongObjectHashMap = gtyReaders;
                                synchronized (tLongObjectHashMap) {
                                    readerMap = (ThreadReader)gtyReaders.get(threadId);
                                    if (readerMap == null) {
                                        readerMap = new ThreadReader();
                                        gtyReaders.put(threadId, readerMap);
                                    }
                                }
                            }
                            GTBReader gtyReader = readerMap.init(filePath);
                            try {
                                gtyReader.seek(pointer);
                                variant.setGenotypes(gtyReader.read().getGenotypes());
                            }
                            catch (IOException e) {
                                return null;
                            }
                            return variant;
                        }
                    }).setListener(new InputOutputListener()).submit(this.inputsOptions.threads);
                    gtyReaders.forEachValue(ThreadReader::close);
                    break;
                }
                case PLINK_BED: {
                    TLongObjectHashMap bedReaders = new TLongObjectHashMap();
                    Processor.setInput(new GTBInputOption((GTBReaderOption)((GTBReaderOption)new GTBReaderOption(inputManager, true, false).addFields("SOURCE@FILE_ID")).addFields("SOURCE@FILE_POINTER"))).setOutput(new PLINKOutputOption(outputPath, PLINKType.BED).setIndividuals(allIndividuals.getUIDs())).bridge(new ILiteConverter<Variant, Variant>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Variant converter(Variant variant) throws IOException {
                            long threadId = Thread.currentThread().getId();
                            String filePath = (String)variant.getProperty("SOURCE@FILE_ID");
                            long pointer = (Long)variant.getProperty("SOURCE@FILE_POINTER");
                            ThreadReader readerMap = (ThreadReader)gtyReaders.get(threadId);
                            if (readerMap == null) {
                                TLongObjectHashMap tLongObjectHashMap = gtyReaders;
                                synchronized (tLongObjectHashMap) {
                                    readerMap = (ThreadReader)gtyReaders.get(threadId);
                                    if (readerMap == null) {
                                        readerMap = new ThreadReader();
                                        gtyReaders.put(threadId, readerMap);
                                    }
                                }
                            }
                            GTBReader gtyReader = readerMap.init(filePath);
                            try {
                                gtyReader.seek(pointer);
                                variant.setGenotypes(gtyReader.read().getGenotypes());
                            }
                            catch (IOException e) {
                                return null;
                            }
                            return variant;
                        }
                    }).setListener(new InputOutputListener()).submit(this.inputsOptions.threads);
                    gtyReaders.forEachValue(ThreadReader::close);
                    break;
                }
                case PLINK_PGEN: {
                    TLongObjectHashMap pgenReaders = new TLongObjectHashMap();
                    Processor.setInput(new GTBInputOption((GTBReaderOption)((GTBReaderOption)new GTBReaderOption(inputManager, true, false).addFields("SOURCE@FILE_ID")).addFields("SOURCE@FILE_POINTER"))).setOutput(new PLINKOutputOption(outputPath, PLINKType.PGEN).setIndividuals(allIndividuals.getUIDs())).bridge(new ILiteConverter<Variant, Variant>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Variant converter(Variant variant) throws IOException {
                            long threadId = Thread.currentThread().getId();
                            String filePath = (String)variant.getProperty("SOURCE@FILE_ID");
                            long pointer = (Long)variant.getProperty("SOURCE@FILE_POINTER");
                            ThreadReader readerMap = (ThreadReader)gtyReaders.get(threadId);
                            if (readerMap == null) {
                                TLongObjectHashMap tLongObjectHashMap = gtyReaders;
                                synchronized (tLongObjectHashMap) {
                                    readerMap = (ThreadReader)gtyReaders.get(threadId);
                                    if (readerMap == null) {
                                        readerMap = new ThreadReader();
                                        gtyReaders.put(threadId, readerMap);
                                    }
                                }
                            }
                            GTBReader gtyReader = readerMap.init(filePath);
                            try {
                                gtyReader.seek(pointer);
                                variant.setGenotypes(gtyReader.read().getGenotypes());
                            }
                            catch (IOException e) {
                                return null;
                            }
                            return variant;
                        }
                    }).setListener(new InputOutputListener()).submit(this.inputsOptions.threads);
                    gtyReaders.forEachValue(ThreadReader::close);
                }
            }
            completeTaskResult.setOutputPath(new File(outputFormatedFilePath));
            SetupApplication.GlobalTaskTracker.recordTaskCompletion(completeTaskResult);
            SetupApplication.GlobalLogger.info("{} retained variants' genotypes of {} subjects are saved in {} with {} format.", new Object[]{inputManager.numOfVariants(), allIndividuals.getUIDs().size(), outputPath, this.format});
        }
    }

    private String digest() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Output2OtherFormat").append("|");
        return stringBuilder.toString();
    }

    static class ThreadReader {
        Map<String, GTBReader> readers = new HashMap<String, GTBReader>();

        ThreadReader() {
        }

        public GTBReader init(String path) throws IOException {
            if (!this.readers.containsKey(path)) {
                this.readers.put(path, new GTBReader(new GTBReaderOption(path, true, false)));
            }
            return this.readers.get(path);
        }

        public boolean close() {
            try {
                for (String path : this.readers.keySet()) {
                    this.readers.get(path).close();
                }
                this.readers.clear();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
    }
}

